/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.swing;

import com.klg.jclass.util.swing.JCElastic;
import com.klg.jclass.util.swing.resources.LocaleBundle;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager2;
import java.io.Serializable;
import java.util.HashMap;

public class JCElasticLayout
implements LayoutManager2,
Serializable {
    public static final int HORIZONTAL = 0;
    public static final int VERTICAL = 1;
    public static final JCElastic HORIZONTALLY_ELASTIC_CONSTRAINT = new Elastic(1, 0);
    public static final JCElastic VERTICALLY_ELASTIC_CONSTRAINT = new Elastic(0, 1);
    public static final JCElastic COMPLETELY_ELASTIC_CONSTRAINT = new Elastic(1, 1);
    public static final String HORIZONTALLY_ELASTIC_TAG = "HorizontallyElastic";
    public static final String VERTICALLY_ELASTIC_TAG = "VerticallyElastic";
    public static final String COMPLETELY_ELASTIC_TAG = "CompletelyElastic";
    protected static final int NOT_ELASTIC = 0;
    protected static final int VERTICALLY_ELASTIC = 1;
    protected static final int HORIZONTALLY_ELASTIC = 2;
    protected int alignment;
    protected int orientation;
    protected HashMap<Component, Object> constraintMap = new HashMap();
    protected static HashMap<JCElastic, JCElastic> constraintCache = null;

    public static JCElastic createElasticConstraint(int n2, int n3) {
        Elastic elastic;
        if (constraintCache == null) {
            constraintCache = new HashMap();
        }
        if (constraintCache.containsKey(elastic = new Elastic(n2, n3))) {
            return constraintCache.get(elastic);
        }
        constraintCache.put(elastic, elastic);
        return elastic;
    }

    public JCElasticLayout(int n2) {
        this(n2, n2 == 1 ? 2 : 1);
    }

    public JCElasticLayout(int n2, int n3) {
        this.orientation = n2;
        if (n3 != 2 && n3 != 1 && n3 != 0 && n3 != 3 && n3 != 4) {
            throw new IllegalArgumentException(LocaleBundle.string("Incorrect value; use one of: SwingConstants.LEFT, SwingConstants.TOP, SwingConstants.CENTER, SwingConstants.BOTTOM, SwingConstants.RIGHT"));
        }
        this.alignment = n3;
    }

    public void addLayoutComponent(String string, Component component) {
        if (HORIZONTALLY_ELASTIC_TAG.equals(string)) {
            this.addLayoutComponent(component, HORIZONTALLY_ELASTIC_CONSTRAINT);
        } else if (VERTICALLY_ELASTIC_TAG.equals(string)) {
            this.addLayoutComponent(component, VERTICALLY_ELASTIC_CONSTRAINT);
        } else if (COMPLETELY_ELASTIC_TAG.equals(string)) {
            this.addLayoutComponent(component, COMPLETELY_ELASTIC_CONSTRAINT);
        } else {
            throw new IllegalArgumentException("Name must be one of: HorizontallyElastic, VerticallyElastic, or CompletelyElastic");
        }
    }

    public void removeLayoutComponent(Component component) {
        if (this.constraintMap.containsKey(component)) {
            this.constraintMap.remove(component);
        }
    }

    public Dimension preferredLayoutSize(Container container) {
        Dimension dimension = new Dimension();
        this.getPreferredLayoutSize(container, dimension);
        return dimension;
    }

    protected int getPreferredLayoutSize(Container container, Dimension dimension) {
        int n2;
        int n3 = container.getComponentCount();
        int n4 = 0;
        int n5 = 0;
        int n6 = 0;
        if (this.orientation == 1) {
            for (n2 = 0; n2 < n3; ++n2) {
                Component component = container.getComponent(n2);
                Dimension dimension2 = component.getPreferredSize();
                n4 = Math.max(n4, dimension2.width);
                n5 += dimension2.height;
                int n7 = this.getElasticity(component);
                if (n7 == 0) continue;
                n6 += n7;
            }
        } else {
            for (n2 = 0; n2 < n3; ++n2) {
                Component component = container.getComponent(n2);
                Dimension dimension3 = component.getPreferredSize();
                n5 = Math.max(n5, dimension3.height);
                n4 += dimension3.width;
                int n8 = this.getElasticity(component);
                if (n8 == 0) continue;
                n6 += n8;
            }
        }
        Insets insets = container.getInsets();
        n4 = n4 + insets.right + insets.left;
        n5 = n5 + insets.top + insets.bottom;
        if (dimension != null) {
            dimension.width = n4;
            dimension.height = n5;
        }
        return n6;
    }

    public Dimension minimumLayoutSize(Container container) {
        int n2 = container.getComponentCount();
        int n3 = 0;
        int n4 = 0;
        if (this.orientation == 1) {
            for (int i2 = 0; i2 < n2; ++i2) {
                Component component = container.getComponent(i2);
                Dimension dimension = component.getMinimumSize();
                n3 = Math.max(n3, dimension.width);
                n4 += dimension.height;
            }
        } else {
            for (int i3 = 0; i3 < n2; ++i3) {
                Component component = container.getComponent(i3);
                Dimension dimension = component.getMinimumSize();
                n4 = Math.max(n4, dimension.height);
                n3 += dimension.width;
            }
        }
        return new Dimension(n3, n4);
    }

    public void layoutContainer(Container container) {
        int n2;
        int n3;
        int n4;
        Dimension dimension = new Dimension();
        int n5 = this.getPreferredLayoutSize(container, dimension);
        Dimension dimension2 = container.getSize();
        Insets insets = container.getInsets();
        dimension2.height -= insets.bottom;
        dimension2.width -= insets.right;
        dimension.height -= insets.bottom;
        dimension.width -= insets.right;
        if (this.orientation == 1) {
            n4 = dimension2.height - dimension.height;
            n3 = insets.left;
            n2 = insets.top;
        } else {
            n4 = dimension2.width - dimension.width;
            n3 = insets.top;
            n2 = insets.left;
        }
        int n6 = 0;
        int n7 = 0;
        if (n5 > 0) {
            n6 = n4 / n5;
            n7 = n4 % n5;
        }
        String string = container.getName();
        String string2 = container.getClass().getName();
        int n8 = container.getComponentCount();
        int n9 = n2;
        int n10 = 0;
        for (int i2 = 0; i2 < n8; ++i2) {
            String string3;
            int n11;
            int n12;
            int n13;
            Component component = container.getComponent(i2);
            if (this.orientation == 1) {
                n13 = dimension2.width - n3;
                n12 = component.getMaximumSize().width;
                if (n12 < 0) {
                    n12 = component.getPreferredSize().width;
                }
                n11 = component.getPreferredSize().height;
            } else {
                n13 = dimension2.height - n3;
                n12 = component.getMaximumSize().height;
                if (n12 < 0) {
                    n12 = component.getPreferredSize().height;
                }
                n11 = component.getPreferredSize().width;
            }
            int n14 = Math.min(n13, n12);
            int n15 = n3;
            if (n14 != n13) {
                if (this.isDim1Elastic(component)) {
                    n15 = 0;
                    n14 = n13;
                } else if (this.alignment == 2 || this.alignment == 1) {
                    n15 = 0;
                } else if (this.alignment == 0) {
                    n15 = (n13 - n14) / 2;
                } else if (this.alignment == 4 || this.alignment == 3) {
                    n15 = n13 - n14;
                }
            }
            int n16 = this.getElasticity(component);
            String string4 = string3 = component.getName() != null ? component.getName() : component.getClass().getName();
            if (n16 > 0) {
                int n17 = this.calcStretch(n6, n16, n10, n7);
                if (this.orientation == 1) {
                    component.setBounds(n15, n9, n14, n11 + n17);
                } else {
                    component.setBounds(n9, n15, n11 + n17, n14);
                }
                n10 += n16;
                n9 += n11 + n17;
                continue;
            }
            if (this.orientation == 1) {
                component.setBounds(n15, n9, n14, n11);
            } else {
                component.setBounds(n9, n15, n11, n14);
            }
            n9 += n11;
        }
    }

    protected int calcStretch(int n2, int n3, int n4, int n5) {
        int n6 = 0;
        for (int i2 = n4; i2 < n4 + n3; ++i2) {
            n6 += n2 + (i2 < n5 ? 1 : 0);
        }
        return n6;
    }

    protected boolean isDim1Elastic(Component component) {
        if (this.orientation == 1) {
            return this.isHorizontallyElastic(component);
        }
        return this.isVerticallyElastic(component);
    }

    protected JCElastic getElastic(Component component) {
        JCElastic jCElastic = null;
        if (component instanceof JCElastic) {
            jCElastic = (JCElastic)((Object)component);
        } else {
            Object object = this.constraintMap.get(component);
            if (object != null && object instanceof JCElastic) {
                jCElastic = (JCElastic)object;
            }
        }
        return jCElastic;
    }

    protected boolean isVerticallyElastic(Component component) {
        JCElastic jCElastic = this.getElastic(component);
        return jCElastic != null && jCElastic.getVerticalElasticity() != 0;
    }

    protected boolean isHorizontallyElastic(Component component) {
        JCElastic jCElastic = this.getElastic(component);
        return jCElastic != null && jCElastic.getHorizontalElasticity() != 0;
    }

    protected int getElasticity(Component component) {
        int n2 = 0;
        JCElastic jCElastic = this.getElastic(component);
        if (jCElastic != null) {
            if (this.orientation == 0) {
                n2 = jCElastic.getHorizontalElasticity();
            } else if (this.orientation == 1) {
                n2 = jCElastic.getVerticalElasticity();
            }
        }
        return n2;
    }

    public void addLayoutComponent(Component component, Object object) {
        if (object != null && !(object instanceof JCElastic)) {
            throw new IllegalArgumentException("constraint must be null or an instance of JCElastic");
        }
        this.constraintMap.put(component, object);
    }

    public Dimension maximumLayoutSize(Container container) {
        int n2 = container.getComponentCount();
        int n3 = 0;
        int n4 = 0;
        for (int i2 = 0; i2 < n2; ++i2) {
            Component component = container.getComponent(i2);
            Dimension dimension = component.getMaximumSize();
            if (this.orientation == 1) {
                n3 = Math.max(n3, dimension.width);
                n4 += dimension.height;
                continue;
            }
            n4 = Math.max(n4, dimension.height);
            n3 += dimension.width;
        }
        return new Dimension(n3, n4);
    }

    public float getLayoutAlignmentX(Container container) {
        return 0.0f;
    }

    public float getLayoutAlignmentY(Container container) {
        return 0.0f;
    }

    public int getAlignment() {
        return this.alignment;
    }

    public void setAlignment(int n2) {
        this.alignment = n2;
    }

    public void invalidateLayout(Container container) {
    }

    static class Elastic
    implements JCElastic,
    Serializable {
        protected int horizontal;
        protected int vertical;

        public Elastic(int n2, int n3) {
            this.horizontal = n2;
            this.vertical = n3;
        }

        public int getHorizontalElasticity() {
            return this.horizontal;
        }

        public int getVerticalElasticity() {
            return this.vertical;
        }
    }
}

