/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.graphics;

import com.klg.jclass.util.RenderProperties;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Toolkit;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.io.Serializable;
import javax.swing.JComponent;

public class GraphicsUtil
implements Serializable {
    public static GeneralPath traceArcPath(double d2, double d3, double d4, double d5, double d6, double d7) {
        double d8;
        double d9;
        double d10;
        double d11;
        double d12;
        GeneralPath generalPath = new GeneralPath();
        double d13 = d7 < 0.0 ? Math.toRadians(d6 + d7) : Math.toRadians(d6);
        double d14 = d2 + d4 * Math.cos(d13);
        double d15 = d3 + d5 * Math.sin(d13);
        generalPath.moveTo((float)d14, (float)d15);
        if (d7 < 0.0) {
            d6 += d7;
            d7 = -d7;
        }
        double d16 = GraphicsUtil.computeControlPointFactor(90.0);
        double d17 = d16 * d4;
        double d18 = d16 * d5;
        d13 = Math.toRadians(d6);
        d14 = d2 + d4 * Math.cos(d13);
        d15 = d3 + d5 * Math.sin(d13);
        double d19 = (int)d6 / 90 * 90;
        double d20 = 0.0;
        double d21 = 0.0;
        double d22 = 0.0;
        double d23 = 0.0;
        if (Math.abs(d19 - d6) > 0.001) {
            if (d6 > 0.0) {
                d19 += 90.0;
            }
            if ((d12 = d6 + d7) > d19) {
                d12 = d19;
            }
            d13 = Math.toRadians(d12);
            d11 = d2 + d4 * Math.cos(d13);
            d10 = d3 + d5 * Math.sin(d13);
            d9 = d12 - d6;
            d8 = GraphicsUtil.computeControlPointFactor(d9);
            d20 = d14 - d8 * (d15 - d3);
            d22 = d15 + d8 * (d14 - d2);
            d21 = d11 + d8 * (d10 - d3);
            d23 = d10 - d8 * (d11 - d2);
            generalPath.curveTo((float)d20, (float)d22, (float)d21, (float)d23, (float)d11, (float)d10);
            d14 = d11;
            d15 = d10;
        }
        d12 = d6 + d7;
        while (d19 + 90.0 <= d12) {
            int n2 = (int)d19 % 360;
            if (n2 == 0) {
                d20 = 0.0;
                d22 = d18;
                d21 = d17;
                d23 = 0.0;
            } else if (n2 == 90 || n2 == -270) {
                d20 = -d17;
                d22 = 0.0;
                d21 = 0.0;
                d23 = d18;
            } else if (n2 == 180 || n2 == -180) {
                d20 = 0.0;
                d22 = -d18;
                d21 = -d17;
                d23 = 0.0;
            } else if (n2 == 270 || n2 == -90) {
                d20 = d17;
                d22 = 0.0;
                d21 = 0.0;
                d23 = -d18;
            }
            d13 = Math.toRadians(d19 += 90.0);
            d11 = d2 + d4 * Math.cos(d13);
            d10 = d3 + d5 * Math.sin(d13);
            generalPath.curveTo((float)(d20 += d14), (float)(d22 += d15), (float)(d21 += d11), (float)(d23 += d10), (float)d11, (float)d10);
            d14 = d11;
            d15 = d10;
        }
        if (d19 < d12 && Math.abs(d19 - d12) > 0.001) {
            d13 = Math.toRadians(d12);
            d11 = d2 + d4 * Math.cos(d13);
            d10 = d3 + d5 * Math.sin(d13);
            d9 = d12 - d19;
            d8 = GraphicsUtil.computeControlPointFactor(d9);
            d20 = d14 - d8 * (d15 - d3);
            d22 = d15 + d8 * (d14 - d2);
            d21 = d11 + d8 * (d10 - d3);
            d23 = d10 - d8 * (d11 - d2);
            generalPath.curveTo((float)d20, (float)d22, (float)d21, (float)d23, (float)d11, (float)d10);
        }
        return generalPath;
    }

    private static double computeControlPointFactor(double d2) {
        double d3 = Math.toRadians(d2 / 2.0);
        return 4.0 * (1.0 - Math.cos(d3)) / (3.0 * Math.sin(d3));
    }

    public static Rectangle getScreenBounds(Component component) {
        if (component == null) {
            return null;
        }
        Toolkit toolkit = Toolkit.getDefaultToolkit();
        GraphicsConfiguration graphicsConfiguration = component.getGraphicsConfiguration();
        return graphicsConfiguration != null ? graphicsConfiguration.getBounds() : new Rectangle(toolkit.getScreenSize());
    }

    public static RenderProperties getRenderPropertiesParent(Component component) {
        while (component != null) {
            if (component instanceof RenderProperties) {
                return (RenderProperties)((Object)component);
            }
            component = component.getParent();
        }
        return null;
    }

    public static Object setAntiAliasing(Graphics2D graphics2D, int n2) {
        Object object = graphics2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
        if (n2 != 0) {
            Object object2 = RenderingHints.VALUE_ANTIALIAS_OFF;
            if (n2 == 1) {
                object2 = RenderingHints.VALUE_ANTIALIAS_ON;
            }
            if (object2 != object) {
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object2);
            }
        }
        return object;
    }

    public static Rectangle getDrawingArea(JComponent jComponent, Rectangle rectangle) {
        if (jComponent == null) {
            return rectangle;
        }
        rectangle = rectangle == null ? new Rectangle(0, 0, jComponent.getWidth(), jComponent.getHeight()) : new Rectangle(rectangle);
        Insets insets = jComponent.getInsets();
        rectangle.translate(insets.left, insets.top);
        rectangle.width -= insets.left + insets.right;
        rectangle.height -= insets.top + insets.bottom;
        return rectangle;
    }

    public static Polygon getPolygonFromPathIterator(PathIterator pathIterator) {
        double d2 = Double.MAX_VALUE;
        double d3 = Double.MAX_VALUE;
        Polygon polygon = new Polygon();
        while (!pathIterator.isDone()) {
            float[] fArray = new float[6];
            switch (pathIterator.currentSegment(fArray)) {
                case 0: {
                    polygon.addPoint((int)fArray[0], (int)fArray[1]);
                    d2 = fArray[0];
                    d3 = fArray[1];
                    break;
                }
                case 1: {
                    polygon.addPoint((int)fArray[0], (int)fArray[1]);
                    break;
                }
                case 3: {
                    polygon.addPoint((int)fArray[4], (int)fArray[5]);
                    break;
                }
                case 2: {
                    polygon.addPoint((int)fArray[2], (int)fArray[3]);
                    break;
                }
                case 4: {
                    if (d2 == Double.MAX_VALUE || d3 == Double.MAX_VALUE) break;
                    polygon.addPoint((int)d2, (int)d3);
                    break;
                }
            }
            pathIterator.next();
        }
        return polygon;
    }
}

