/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.formulae;

import com.klg.jclass.util.formulae.Count;
import com.klg.jclass.util.formulae.Divide;
import com.klg.jclass.util.formulae.Expression;
import com.klg.jclass.util.formulae.MathScalar;
import com.klg.jclass.util.formulae.Min;
import com.klg.jclass.util.formulae.Operation;
import com.klg.jclass.util.formulae.Power;
import com.klg.jclass.util.formulae.Product;
import com.klg.jclass.util.formulae.Result;

public class GeometricMean
extends Operation {
    public GeometricMean(Expression expression) {
        super(expression);
    }

    public GeometricMean(Expression expression, Expression expression2) {
        super(expression, expression2);
    }

    public GeometricMean(Expression expression, Number number) {
        super(expression, number);
    }

    public GeometricMean(Number number, Expression expression) {
        super(number, expression);
    }

    public GeometricMean(Number number, Number number2) {
        super(number, number2);
    }

    public Result evaluate() {
        Count count = new Count(this.leftOperand, this.rightOperand);
        MathScalar mathScalar = (MathScalar)((Operation)count).evaluate();
        if (mathScalar.realValue.intValue() == 0) {
            throw new IllegalArgumentException("Must have at least 1 element to compute the geometric mean");
        }
        Min min2 = new Min(this.leftOperand, this.rightOperand);
        MathScalar mathScalar2 = (MathScalar)((Operation)min2).evaluate();
        if (mathScalar2.realValue.doubleValue() <= 0.0) {
            throw new IllegalArgumentException("Geometric mean:  Cannot use negative or zero values");
        }
        Product product = new Product(this.leftOperand, this.rightOperand);
        Power power = new Power((Expression)product, (Expression)new Divide((Expression)new MathScalar(1.0), (Expression)mathScalar));
        return ((Operation)power).evaluate();
    }
}

