/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util.calendar;

import com.klg.jclass.util.calendar.CalendarComponent;
import com.klg.jclass.util.calendar.CalendarContainer;
import com.klg.jclass.util.calendar.DateActionEvent;
import com.klg.jclass.util.calendar.JCDateChooser;
import com.klg.jclass.util.calendar.TimeLabel;
import com.klg.jclass.util.calendar.TimeSpin;
import com.klg.jclass.util.swing.JCBrace;
import com.klg.jclass.util.swing.JCColumnLayout;
import com.klg.jclass.util.value.CalendarValueModel;
import com.klg.jclass.util.value.JCValueModel;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.JButton;
import javax.swing.JComponent;

public class DateTimeEditor
extends CalendarContainer {
    protected JCDateChooser dateChooser = null;
    protected CalendarComponent timeComponent = null;
    protected CalendarContainer timeContainer = null;
    protected JButton applyButton = null;
    protected boolean showTimeComponent = true;
    protected boolean showApplyButton = false;
    protected boolean hidePopupOnDayTableClick = false;

    public DateTimeEditor() {
        this(2, true, false, null, null, null, null, null);
    }

    public DateTimeEditor(int n2, boolean bl, boolean bl2, Locale locale, Calendar calendar) {
        this(n2, bl, bl2, locale, calendar, null, null, null);
    }

    public DateTimeEditor(int n2, boolean bl, boolean bl2, Locale locale, Calendar calendar, String[] stringArray, String[] stringArray2, String[] stringArray3) {
        if (locale == null) {
            locale = Locale.getDefault();
        }
        this.setLocale(locale);
        if (calendar == null) {
            calendar = Calendar.getInstance(this.getLocale());
        }
        CalendarValueModel calendarValueModel = new CalendarValueModel(calendar);
        this.setLayout(new JCColumnLayout(0));
        this.dateChooser = new DateChooser(calendarValueModel, this.getLocale(), n2, stringArray, stringArray2, stringArray3);
        this.showTimeComponent = bl;
        if (bl) {
            this.timeContainer = this.createTimeContainer(calendar);
        }
        this.showApplyButton = bl2;
        if (bl2) {
            this.applyButton = this.createApplyButton();
        }
        this.setCalendarModel(calendarValueModel);
        this.updateLayout(false);
    }

    protected CalendarComponent createTimeComponent(int n2, Calendar calendar) {
        JComponent jComponent;
        if (n2 == 4) {
            jComponent = new TimeLabel((JCValueModel)new CalendarValueModel(calendar), this.getLocale());
        } else {
            TimeSpin timeSpin = new TimeSpin(calendar.getTime(), this.getLocale());
            timeSpin.setMinimumDate(this.dateChooser.getMinimumDate());
            timeSpin.setMaximumDate(this.dateChooser.getMaximumDate());
            jComponent = timeSpin;
        }
        if (this.userFont != null) {
            ((Component)jComponent).setFont(this.userFont);
        }
        return jComponent;
    }

    protected void updateTimeComponent(int n2) {
        if (this.timeContainer == null || this.timeComponent == null) {
            return;
        }
        if (n2 == 4 ^ this.timeComponent instanceof TimeLabel) {
            this.timeContainer.remove((Component)((Object)this.timeComponent));
            Calendar calendar = (Calendar)this.model.getValue();
            this.timeComponent = this.createTimeComponent(n2, calendar);
            this.timeContainer.add((Component)((Object)this.timeComponent));
            this.updateLayout(true);
        }
    }

    protected CalendarContainer createTimeContainer(Calendar calendar) {
        CalendarContainer calendarContainer = new CalendarContainer();
        this.timeComponent = this.createTimeComponent(this.dateChooser.getChooserType(), calendar);
        calendarContainer.add((Component)((Object)this.timeComponent));
        return calendarContainer;
    }

    public CalendarComponent getTimeComponent() {
        return this.timeComponent;
    }

    protected void firePopupEvent() {
    }

    protected JButton createApplyButton() {
        JButton jButton = new JButton("Apply");
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                DateTimeEditor.this.firePopupEvent();
            }
        });
        return jButton;
    }

    public JButton getApplyButton() {
        return this.applyButton;
    }

    protected void updateLayout(boolean bl) {
        this.removeAll();
        this.add(this.dateChooser);
        if (this.timeContainer != null && this.showTimeComponent) {
            this.add(this.timeContainer);
        }
        if (this.applyButton != null && this.showApplyButton) {
            this.add(this.applyButton);
            this.add(JCBrace.createVerticalBrace(3));
        }
        if (bl) {
            this.doLayout();
        }
    }

    public void setChooserType(int n2) {
        if (this.getChooserType() == n2) {
            return;
        }
        this.dateChooser.setChooserType(n2);
        if (this.timeComponent != null) {
            this.updateTimeComponent(n2);
        }
    }

    public int getChooserType() {
        return this.dateChooser.getChooserType();
    }

    public void setShowTimeComponent(boolean bl) {
        if (this.showTimeComponent == bl) {
            return;
        }
        if (this.timeContainer == null) {
            Calendar calendar = (Calendar)this.model.getValue();
            this.timeContainer = this.createTimeContainer(calendar);
        }
        this.showTimeComponent = bl;
        this.updateLayout(true);
    }

    public boolean getShowTimeComponent() {
        return this.showTimeComponent;
    }

    public boolean getShowApplyButton() {
        return this.showApplyButton;
    }

    public void setShowApplyButton(boolean bl) {
        if (this.showApplyButton == bl) {
            return;
        }
        if (this.applyButton == null) {
            this.applyButton = this.createApplyButton();
        }
        this.showApplyButton = bl;
        this.updateLayout(true);
    }

    public boolean getHidePopupOnDayTableClick() {
        return this.hidePopupOnDayTableClick;
    }

    public void setHidePopupOnDayTableClick(boolean bl) {
        this.hidePopupOnDayTableClick = bl;
    }

    public Object getValue() {
        return this.model.getValue();
    }

    public void setValue(Object object) {
        this.model.setValue(object);
    }

    public Calendar getMinimumDate() {
        return this.dateChooser.getMinimumDate();
    }

    public void setMinimumDate(Calendar calendar) {
        this.dateChooser.setMinimumDate(calendar);
        if (this.timeComponent instanceof TimeSpin) {
            ((TimeSpin)this.timeComponent).setMinimumDate(calendar);
        }
    }

    public Calendar getMaximumDate() {
        return this.dateChooser.getMaximumDate();
    }

    public void setMaximumDate(Calendar calendar) {
        this.dateChooser.setMaximumDate(calendar);
        if (this.timeComponent instanceof TimeSpin) {
            ((TimeSpin)this.timeComponent).setMaximumDate(calendar);
        }
    }

    public JCDateChooser getDateChooser() {
        return this.dateChooser;
    }

    protected class DateChooser
    extends JCDateChooser {
        public DateChooser(JCValueModel jCValueModel, Locale locale, int n2) {
            super(jCValueModel, locale, n2 == 3 ? 2 : n2);
        }

        public DateChooser(JCValueModel jCValueModel, Locale locale, int n2, String[] stringArray, String[] stringArray2, String[] stringArray3) {
            super(jCValueModel, locale, n2 == 3 ? 2 : n2, stringArray, stringArray2, stringArray3);
        }

        public void setChooserType(int n2) {
            if (n2 == 3) {
                n2 = 2;
            }
            super.setChooserType(n2);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (actionEvent.getSource() == this.getDayComponent() && actionEvent instanceof DateActionEvent) {
                DateActionEvent dateActionEvent = (DateActionEvent)actionEvent;
                if (DateTimeEditor.this.getHidePopupOnDayTableClick() || dateActionEvent.getHidePopup()) {
                    DateTimeEditor.this.firePopupEvent();
                }
            }
        }
    }
}

