/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util;

import com.klg.jclass.util.RenderProperties;
import com.klg.jclass.util.ServerJPanel;
import com.klg.jclass.util.ServerRenderable;
import com.klg.jclass.util.graphics.Graphics2DBase;
import com.klg.jclass.util.swing.encode.EncoderException;
import com.klg.jclass.util.swing.encode.JCEncodeComponent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.OutputStream;

public class ServerRenderer {
    public static void paintComponent(Graphics graphics, Component component) {
        if (!(component instanceof ServerRenderable)) {
            return;
        }
        ServerRenderable serverRenderable = (ServerRenderable)((Object)component);
        serverRenderable.setGraphics(graphics);
        ServerRenderer.paintComponentAndChildren(graphics, component);
        serverRenderable.setGraphics(null);
    }

    protected static void paintComponentAndChildren(Graphics graphics, Component component) {
        component.doLayout();
        component.paint(graphics);
        if (component instanceof Container) {
            int n2;
            Object object;
            Container container = (Container)component;
            Object object2 = null;
            Object object3 = null;
            if (component instanceof RenderProperties) {
                object = (RenderProperties)((Object)component);
                n2 = object.getAntiAliasing();
                if (n2 == 1) {
                    object3 = RenderingHints.VALUE_ANTIALIAS_ON;
                } else if (n2 == 2) {
                    object3 = RenderingHints.VALUE_ANTIALIAS_OFF;
                }
            }
            if (object3 != null && object3 != (object2 = ((Graphics2D)(object = (Graphics2D)graphics)).getRenderingHint(RenderingHints.KEY_ANTIALIASING))) {
                ((Graphics2D)object).setRenderingHint(RenderingHints.KEY_ANTIALIASING, object3);
            }
            object = graphics.getClipBounds();
            for (n2 = container.getComponentCount() - 1; n2 >= 0; --n2) {
                Component component2 = container.getComponent(n2);
                if (!component2.isVisible()) continue;
                Rectangle rectangle = component2.getBounds();
                int n3 = rectangle.x + rectangle.width <= ((Rectangle)object).width ? rectangle.width : ((Rectangle)object).x + ((Rectangle)object).width - rectangle.x;
                int n4 = rectangle.y + rectangle.height <= ((Rectangle)object).height ? rectangle.height : ((Rectangle)object).y + ((Rectangle)object).height - rectangle.y;
                if (n3 <= 0 || n4 <= 0) continue;
                graphics.translate(rectangle.x, rectangle.y);
                graphics.setClip(0, 0, n3, n4);
                if (graphics instanceof Graphics2DBase) {
                    ((Graphics2DBase)graphics).setComponent(component2);
                }
                ServerRenderer.paintComponentAndChildren(graphics, component2);
                if (graphics instanceof Graphics2DBase) {
                    ((Graphics2DBase)graphics).setComponent(null);
                }
                graphics.translate(-rectangle.x, -rectangle.y);
            }
            graphics.setClip(((Rectangle)object).x, ((Rectangle)object).y, ((Rectangle)object).width, ((Rectangle)object).height);
            if (object2 != null && object2 != object3) {
                Graphics2D graphics2D = (Graphics2D)graphics;
                graphics2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, object2);
            }
        }
    }

    public static Image snapshot(Component component) {
        Image image = ServerRenderer.createNewImage(component, 2);
        ServerRenderer.snapshot(component, image);
        return image;
    }

    public static Image createNewImage(Component component, int n2) {
        if (component == null) {
            throw new IllegalArgumentException("Passed in component is null.");
        }
        Dimension dimension = component.getSize();
        if (dimension.width == 0 || dimension.height == 0) {
            throw new IllegalArgumentException("Size of component is zero.");
        }
        return ServerRenderer.createNewImage(dimension.width, dimension.height, n2);
    }

    public static Image createNewImage(int n2, int n3, int n4) {
        if (n2 == 0 || n3 == 0) {
            throw new IllegalArgumentException("Width and height must be positive");
        }
        return new BufferedImage(n2, n3, n4);
    }

    public static boolean snapshot(Component component, Image image) {
        if (!(component instanceof ServerRenderable)) {
            return false;
        }
        ServerRenderable serverRenderable = (ServerRenderable)((Object)component);
        if (image != null) {
            Graphics graphics = image.getGraphics();
            Dimension dimension = component.getSize();
            graphics.setClip(0, 0, dimension.width, dimension.height);
            serverRenderable.serverPaint(graphics);
        }
        return true;
    }

    public static void encode(ServerRenderable serverRenderable, JCEncodeComponent.Encoding encoding, OutputStream outputStream) throws EncoderException, IOException {
        if (JCEncodeComponent.isImageBasedEncoding(encoding)) {
            Image image = ServerRenderer.snapshot((Component)((Object)serverRenderable));
            ServerRenderer.encodeImage(encoding, image, outputStream);
        } else {
            Dimension dimension = ((Component)((Object)serverRenderable)).getSize();
            if (dimension.width == 0 || dimension.height == 0) {
                throw new IllegalArgumentException("Cannot encode, size of component is zero.");
            }
            JCEncodeComponent.encode(encoding, (Component)((Object)serverRenderable), outputStream);
        }
    }

    public static void encodeImage(JCEncodeComponent.Encoding encoding, Image image, OutputStream outputStream) throws EncoderException, IOException {
        JCEncodeComponent.encode(encoding, image, outputStream);
    }

    public static void paintContainer(Graphics graphics, Container container) {
        if (!(container instanceof ServerRenderable)) {
            return;
        }
        ServerRenderable serverRenderable = (ServerRenderable)((Object)container);
        serverRenderable.setGraphics(graphics);
        ServerRenderer.paintContainerAndChildren(graphics, container);
        serverRenderable.setGraphics(null);
    }

    protected static void paintContainerAndChildren(Graphics graphics, Container container) {
        container.doLayout();
        container.paint(graphics);
        Rectangle rectangle = graphics.getClipBounds();
        for (int i2 = container.getComponentCount() - 1; i2 >= 0; --i2) {
            Component component = container.getComponent(i2);
            if (!component.isVisible()) continue;
            Rectangle rectangle2 = component.getBounds();
            graphics.translate(rectangle2.x, rectangle2.y);
            graphics.setClip(0, 0, rectangle2.width, rectangle2.height);
            if (component instanceof Container) {
                ServerRenderer.paintContainerAndChildren(graphics, (Container)component);
            } else {
                component.paint(graphics);
            }
            graphics.translate(-rectangle2.x, -rectangle2.y);
        }
        graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
    }

    public static void paintTopLevelContainer(Graphics graphics, ServerJPanel serverJPanel) {
        if (serverJPanel == null) {
            return;
        }
        serverJPanel.setGraphics(graphics);
        serverJPanel.doLayout();
        serverJPanel.paint(graphics);
        Rectangle rectangle = graphics.getClipBounds();
        for (int i2 = serverJPanel.getComponentCount() - 1; i2 >= 0; --i2) {
            Component component = serverJPanel.getComponent(i2);
            if (!component.isVisible()) continue;
            Rectangle rectangle2 = component.getBounds();
            graphics.translate(rectangle2.x, rectangle2.y);
            graphics.setClip(0, 0, rectangle2.width, rectangle2.height);
            if (component instanceof Container) {
                ServerRenderer.paintContainer(graphics, (Container)component);
            } else {
                component.paint(graphics);
            }
            graphics.translate(-rectangle2.x, -rectangle2.y);
        }
        graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        serverJPanel.setGraphics(null);
    }
}

