/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util;

import java.util.List;
import java.util.Vector;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeqRangeCollector {
    public static final int RANGE_INCREASING_BY_1 = 0;
    public static final int RANGE_SAME_VALUE = 1;
    public static final int RANGE_BREAK_NORMAL = 0;
    public static final int RANGE_BREAK_HEX_BOUNDARY = 1;
    protected int rangeType = 0;
    protected int rangeBreak = 0;
    protected int emptyValue = -1;
    protected int startOfCurrentRange;
    protected int lastItemInCurrentRange;
    protected int sizeOfCurrentRange;
    protected Vector<Range> ranges = null;

    public SeqRangeCollector() {
        this.reset();
    }

    public void reset() {
        this.startOfCurrentRange = this.emptyValue;
        this.lastItemInCurrentRange = this.emptyValue;
        this.sizeOfCurrentRange = 0;
        this.ranges = new Vector();
    }

    public void addItem(int n2) {
        if (this.startOfCurrentRange == this.emptyValue) {
            this.startOfCurrentRange = n2;
            this.lastItemInCurrentRange = n2;
            ++this.sizeOfCurrentRange;
        } else if (this.rangeBreak == 1 && this.lastItemInCurrentRange % 256 == 255 && n2 % 256 == 0) {
            this.flushRange(n2);
        } else if (this.rangeType == 0 && n2 == this.lastItemInCurrentRange + 1) {
            this.lastItemInCurrentRange = n2;
            ++this.sizeOfCurrentRange;
        } else {
            this.flushRange(n2);
        }
    }

    public void done() {
        this.flushRange(this.emptyValue);
    }

    protected void flushRange(int n2) {
        if (this.startOfCurrentRange == this.emptyValue) {
            return;
        }
        Range range = new Range();
        if (this.rangeType == 0) {
            range.start = this.startOfCurrentRange;
            range.end = this.lastItemInCurrentRange;
            range.size = this.sizeOfCurrentRange;
        }
        this.ranges.add(range);
        this.startOfCurrentRange = n2;
        this.lastItemInCurrentRange = n2;
        this.sizeOfCurrentRange = n2 == this.emptyValue ? 0 : 1;
    }

    public List<Range> getRanges() {
        return this.ranges;
    }

    public void setRangeType(int n2) {
        this.rangeType = n2;
    }

    public int getRangeType() {
        return this.rangeType;
    }

    public void setRangeBreak(int n2) {
        this.rangeBreak = n2;
    }

    public int getRangeBreak() {
        return this.rangeBreak;
    }

    public void setEmptyValue(int n2) {
        this.emptyValue = n2;
    }

    public int getEmptyValue() {
        return this.emptyValue;
    }

    public class Range {
        public int start;
        public int end;
        public int size;

        public Range() {
            this.start = SeqRangeCollector.this.emptyValue;
            this.end = SeqRangeCollector.this.emptyValue;
            this.size = 0;
        }

        public Range(int n2, int n3, int n4) {
            this.start = n2;
            this.end = n3;
            this.size = n4;
        }

        public String toString() {
            return "Range: from " + Integer.toHexString(this.start) + " to " + Integer.toHexString(this.end) + " (" + this.size + " items)";
        }

        public boolean equals(Object object) {
            if (!(object instanceof Range)) {
                return false;
            }
            Range range = (Range)object;
            return this.start == range.start && this.end == range.end && this.size == range.size;
        }

        public int hashCode() {
            int n2 = 17;
            n2 = 37 * n2 + this.start;
            n2 = 37 * n2 + this.end;
            n2 = 37 * n2 + this.size;
            return n2;
        }
    }
}

