/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.util;

import com.klg.jclass.util.Circle;
import com.klg.jclass.util.ImageMapInfo;
import com.klg.jclass.util.TagGenerator;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.Shape;
import java.awt.geom.PathIterator;
import java.io.Serializable;

public class HTMLTagGenerator
implements TagGenerator,
Serializable {
    public String convertShapeToImageMapTag(Object object, ImageMapInfo imageMapInfo) {
        if (object == null) {
            return null;
        }
        StringBuffer stringBuffer = new StringBuffer();
        if (object instanceof Rectangle) {
            Rectangle rectangle = (Rectangle)object;
            stringBuffer.append("<area shape=\"rect\" coords=\"");
            stringBuffer.append(rectangle.x);
            stringBuffer.append(",");
            stringBuffer.append(rectangle.y);
            stringBuffer.append(",");
            stringBuffer.append(rectangle.x + rectangle.width);
            stringBuffer.append(",");
            stringBuffer.append(rectangle.y + rectangle.height);
            stringBuffer.append("\"");
            this.addImageMapInfo(stringBuffer, imageMapInfo);
            stringBuffer.append(">");
        } else if (object instanceof Polygon) {
            Polygon polygon = (Polygon)object;
            stringBuffer.append("<area shape=\"poly\" coords=\"");
            for (int i2 = 0; i2 < polygon.npoints; ++i2) {
                if (i2 > 0) {
                    stringBuffer.append(",");
                }
                stringBuffer.append(polygon.xpoints[i2]);
                stringBuffer.append(",");
                stringBuffer.append(polygon.ypoints[i2]);
            }
            stringBuffer.append("\"");
            this.addImageMapInfo(stringBuffer, imageMapInfo);
            stringBuffer.append(">");
        } else if (object instanceof Circle) {
            Circle circle = (Circle)object;
            stringBuffer.append("<area shape=\"circle\" coords=\"");
            stringBuffer.append(circle.x);
            stringBuffer.append(",");
            stringBuffer.append(circle.y);
            stringBuffer.append(",");
            stringBuffer.append(circle.radius);
            stringBuffer.append("\"");
            this.addImageMapInfo(stringBuffer, imageMapInfo);
            stringBuffer.append(">");
        } else if (object instanceof Shape) {
            stringBuffer.append("<area shape=\"poly\" coords=\"");
            PathIterator pathIterator = ((Shape)object).getPathIterator(null);
            double[] dArray = new double[6];
            while (!pathIterator.isDone()) {
                int n2 = pathIterator.currentSegment(dArray);
                int n3 = (int)dArray[0];
                int n4 = (int)dArray[1];
                switch (n2) {
                    case 0: {
                        stringBuffer.append("" + n3 + "," + n4);
                        break;
                    }
                    case 1: {
                        stringBuffer.append("," + n3 + "," + n4);
                        break;
                    }
                }
                pathIterator.next();
            }
            stringBuffer.append("\"");
            this.addImageMapInfo(stringBuffer, imageMapInfo);
            stringBuffer.append(">");
        }
        return stringBuffer.toString();
    }

    protected void addImageMapInfo(StringBuffer stringBuffer, ImageMapInfo imageMapInfo) {
        String string;
        if (stringBuffer == null) {
            return;
        }
        String string2 = imageMapInfo == null ? null : imageMapInfo.getUrl();
        String string3 = string = imageMapInfo == null ? null : imageMapInfo.getExtra();
        if (string2 != null) {
            stringBuffer.append(" href=\"");
            stringBuffer.append(string2);
            stringBuffer.append("\" ");
        }
        if (string != null) {
            stringBuffer.append(string);
        }
    }

    public String getBeginTag(String string) {
        String string2 = "<MAP>";
        if (string != null) {
            string2 = "<MAP NAME=\"" + string + "\">";
        }
        return string2;
    }

    public String getEndTag() {
        return "</MAP>";
    }
}

