/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table.data;

import com.klg.jclass.table.JCTableDataEvent;
import com.klg.jclass.table.data.AbstractVectorDataSource;
import java.io.Serializable;
import java.util.Vector;

public class JCVectorDataSource
extends AbstractVectorDataSource
implements Serializable {
    protected Vector cells = JCVectorDataSource.createVector();
    protected Vector column_labels = JCVectorDataSource.createVector();
    protected Vector row_labels = JCVectorDataSource.createVector();
    protected int columns = 5;
    protected int rows = 10;
    protected boolean is_moving = false;

    public JCVectorDataSource() {
    }

    public JCVectorDataSource(int n2, int n3, Vector vector, Vector vector2, Vector vector3) {
        this.columns = n3;
        this.rows = n2;
        this.cells = vector3;
        if (vector != null) {
            this.row_labels = vector;
        }
        if (vector2 != null) {
            this.column_labels = vector2;
        }
    }

    public int getNumColumns() {
        return this.columns;
    }

    public void setNumColumns(int n2) {
        this.columns = n2;
        this.setDataChanged(0, 0, 0, 0, 13);
    }

    public int getNumRows() {
        return this.rows;
    }

    public void setNumRows(int n2) {
        this.rows = n2;
        this.setDataChanged(0, 0, 0, 0, 12);
    }

    public Object getTableColumnLabel(int n2) {
        if (n2 >= 0 && n2 < this.column_labels.size()) {
            return this.column_labels.elementAt(n2);
        }
        return null;
    }

    public Object getTableRowLabel(int n2) {
        if (n2 >= 0 && n2 < this.row_labels.size()) {
            return this.row_labels.elementAt(n2);
        }
        return null;
    }

    public Object getTableDataItem(int n2, int n3) {
        Object var3_3 = null;
        if (this.isValidCell(n2, n3)) {
            var3_3 = ((Vector)this.cells.elementAt(n2)).elementAt(n3);
        }
        return var3_3;
    }

    public void clearCells() {
        this.setCells((Vector)null);
    }

    public Vector getCells() {
        return this.cells;
    }

    public Vector getColumnLabels() {
        return this.column_labels;
    }

    public Vector getRowLabels() {
        return this.row_labels;
    }

    public static final boolean isCell(int n2, int n3) {
        return n2 >= 0 && n3 >= 0;
    }

    public static final boolean isColumnLabel(int n2, int n3) {
        return n3 >= 0 && n2 == -1;
    }

    public static final boolean isLabel(int n2, int n3) {
        return n2 == -1 ? n3 >= 0 : (n3 == -1 ? n2 >= 0 : false);
    }

    public static final boolean isRowLabel(int n2, int n3) {
        return n2 >= 0 && n3 == -1;
    }

    public final boolean isValidCell(int n2, int n3) {
        return n2 >= 0 && n2 < this.cells.size() && this.cells.elementAt(n2) != null && n3 >= 0 && n3 < ((Vector)this.cells.elementAt(n2)).size();
    }

    public final boolean isValidLabel(int n2, int n3) {
        int n4 = -1;
        return n3 == n4 ? n2 < this.row_labels.size() : (n2 == n4 ? n3 < this.column_labels.size() : false);
    }

    public void setColumnLabel(int n2, Object object) {
        this.setLabelValue(-1, n2, object);
    }

    public void setColumnLabels(String[] stringArray) {
        this.setColumnLabels(JCVectorDataSource.createVector(stringArray));
    }

    public void setColumnLabels(Vector vector) {
        this.column_labels = vector == null ? JCVectorDataSource.createVector() : vector;
        this.setDataChanged(-998, -998, 0, 0, 14);
    }

    public void setRowLabel(int n2, Object object) {
        this.setLabelValue(n2, -1, object);
    }

    public void setRowLabels(String[] stringArray) {
        this.setRowLabels(JCVectorDataSource.createVector(stringArray));
    }

    public void setRowLabels(Vector vector) {
        this.row_labels = vector == null ? JCVectorDataSource.createVector() : vector;
        this.setDataChanged(-998, -998, 0, 0, 14);
    }

    public void setCell(int n2, int n3, Object object) {
        if (!(n2 != -998 && n2 != -997 && n2 < 0 || n3 != -998 && n3 != -997 && n3 < 0)) {
            this.setCellValue(n2, n3, object);
        }
    }

    public void setCells(String[][] stringArray) {
        if (stringArray == null) {
            this.setCells(JCVectorDataSource.createVector());
        } else {
            Vector vector = JCVectorDataSource.createVector(stringArray.length);
            for (int i2 = 0; i2 < stringArray.length; ++i2) {
                JCVectorDataSource.setElementAt(vector, i2, JCVectorDataSource.createVector(stringArray[i2]));
            }
            this.setCells(vector);
        }
    }

    public void setCells(Vector vector) {
        this.cells = vector == null ? JCVectorDataSource.createVector() : (vector instanceof Vector ? vector : JCVectorDataSource.createVector(vector));
        this.setDataChanged(-998, -998, 0, 0, 14);
    }

    protected Object getLabelValue(int n2, int n3) {
        if (n2 >= 0 && n3 == -1 && n2 < this.row_labels.size()) {
            return this.row_labels.elementAt(n2);
        }
        if (n3 >= 0 && n2 == -1 && n3 < this.column_labels.size()) {
            return this.column_labels.elementAt(n3);
        }
        return null;
    }

    protected void setLabelValue(int n2, int n3, Object object) {
        if (!JCVectorDataSource.isLabel(n2, n3)) {
            return;
        }
        if (n2 == -1) {
            if (this.setLabelValue(this.column_labels, n3, object)) {
                this.setDataChanged(-1, n3, 1, 0, 9);
            }
        } else if (this.setLabelValue(this.row_labels, n2, object)) {
            this.setDataChanged(n2, -1, 1, 0, 8);
        }
    }

    private boolean setLabelValue(Vector vector, int n2, Object object) {
        Object e2;
        if (n2 < 0) {
            return false;
        }
        if (n2 < vector.size() && (e2 = vector.elementAt(n2)) != null && object != null && e2.equals(object)) {
            return false;
        }
        JCVectorDataSource.setElementAt(vector, n2, object);
        if (object == null && n2 == vector.size() - 1) {
            JCVectorDataSource.strip(vector);
        }
        return true;
    }

    private void setCellValue(int n2, int n3, Object object) {
        int n4 = 0;
        int n5 = this.rows - 1;
        int n6 = 0;
        int n7 = this.columns - 1;
        if (n2 >= 0 && n3 >= 0) {
            n4 = n5 = n2;
            n6 = n7 = n3;
        } else {
            if (n2 == -997) {
                n2 = -998;
            }
            if (n3 == -997) {
                n3 = -998;
            }
            if (n2 == -998) {
                if (n3 != -998) {
                    n6 = n7 = n3;
                }
                n4 = 0;
                n5 = this.rows - 1;
            }
            if (n3 == -998) {
                if (n2 != -998) {
                    n4 = n5 = n2;
                }
                n6 = 0;
                n7 = this.columns - 1;
            }
            if (n2 != -998 && n3 != -998) {
                n4 = n5 = n2;
                n6 = n7 = n3;
            }
            if (n4 < 0 || n6 < 0) {
                return;
            }
        }
        for (int i2 = n4; i2 <= n5; ++i2) {
            int n8;
            for (n8 = n6; n8 <= n7; ++n8) {
                Object object2;
                Object object3 = object2 = this.isValidCell(n2, n3) ? (Object)((Vector)this.cells.elementAt(n2)).elementAt(n3) : null;
                if (object2 != null) {
                    if (object2.equals(object)) continue;
                    if (this.isValidCell(i2, n8)) {
                        JCVectorDataSource.setElementAt((Vector)this.cells.elementAt(i2), n8, null);
                    }
                }
                if (this.cells.size() < i2 + 1 || this.cells.elementAt(i2) == null) {
                    JCVectorDataSource.setElementAt(this.cells, i2, JCVectorDataSource.createVector(n8 + 1));
                }
                JCVectorDataSource.setElementAt((Vector)this.cells.elementAt(i2), n8, object);
                this.setDataChanged(i2, n8, 1, 0, 1);
            }
            if (object != null || !this.isValidCell(i2, n8) || n7 != this.cells.size() - 1) continue;
            JCVectorDataSource.strip((Vector)this.cells.elementAt(i2));
            JCVectorDataSource.strip(this.cells);
        }
    }

    public void setDataChanged(int n2, int n3, int n4, int n5, int n6) {
        if (this.is_moving || !this.hasListeners()) {
            return;
        }
        JCTableDataEvent jCTableDataEvent = new JCTableDataEvent(this, n2, n3, n4, n5, n6);
        this.fireTableDataEvent(jCTableDataEvent);
    }

    public boolean addColumn(int n2, Object object, Vector vector) {
        if (n2 == Integer.MAX_VALUE) {
            n2 = this.columns;
        } else if (n2 < 0 || n2 > this.columns) {
            return false;
        }
        return this.addColumn(n2, object, vector, true);
    }

    protected boolean addColumn(int n2, Object object, Vector vector, boolean bl) {
        if (vector != null && this.cells.size() < vector.size()) {
            JCVectorDataSource.setElementAt(this.cells, vector.size() - 1, JCVectorDataSource.createVector());
        }
        int n3 = 0;
        int n4 = 0;
        while (n3 < this.cells.size()) {
            Vector vector2;
            Vector vector3 = (Vector)this.cells.elementAt(n3);
            if (vector3 == null) {
                vector2 = JCVectorDataSource.createVector();
                JCVectorDataSource.setElementAt(this.cells, n3, vector2);
            } else {
                vector2 = vector3;
            }
            if (n2 < vector2.size()) {
                vector2.insertElementAt(null, n2);
            }
            Object var9_9 = vector != null && n4 < vector.size() ? vector.elementAt(n4) : null;
            JCVectorDataSource.setElementAt(vector2, n2, var9_9);
            ++n3;
            ++n4;
        }
        if (bl && this.column_labels.size() != 0 && n2 < this.column_labels.size()) {
            this.column_labels.insertElementAt(null, n2);
        }
        this.setNumColumns(this.columns + 1);
        if (object != null && bl) {
            this.setColumnLabel(n2, object);
        }
        this.setDataChanged(-1, n2, 1, n2, 6);
        return true;
    }

    public boolean addRow(int n2, Object object, Vector vector) {
        Vector vector2 = vector;
        if (vector != null) {
            vector2 = JCVectorDataSource.createVector(vector);
        }
        if (n2 == Integer.MAX_VALUE) {
            n2 = this.rows;
        } else if (n2 < 0 || n2 > this.rows) {
            return false;
        }
        return this.addRow(n2, object, vector2, true);
    }

    protected boolean addRow(int n2, Object object, Vector vector, boolean bl) {
        if (n2 < this.cells.size()) {
            this.cells.insertElementAt(null, n2);
        }
        if (vector != null) {
            JCVectorDataSource.setElementAt(this.cells, n2, vector);
        }
        if (bl && this.row_labels.size() != 0 && n2 < this.row_labels.size()) {
            this.row_labels.insertElementAt(null, n2);
        }
        this.setNumRows(this.rows + 1);
        if (object != null && bl) {
            this.setRowLabel(n2, object);
        }
        this.setDataChanged(n2, -1, 1, n2, 3);
        return true;
    }

    public boolean deleteColumns(int n2, int n3) {
        return this.deleteColumns(n2, n3, true);
    }

    protected boolean deleteColumns(int n2, int n3, boolean bl) {
        if (n3 <= 0) {
            return false;
        }
        if (n2 < 0 || n2 + n3 > this.columns) {
            return false;
        }
        if (bl && this.column_labels.size() != 0 && n2 < this.column_labels.size()) {
            JCVectorDataSource.removeElementsAt(this.column_labels, n2, n3);
        }
        for (int i2 = 0; i2 < this.cells.size(); ++i2) {
            Vector vector = (Vector)this.cells.elementAt(i2);
            if (vector == null) continue;
            JCVectorDataSource.removeElementsAt(vector, n2, n3);
        }
        this.setNumColumns(this.columns - n3);
        this.setDataChanged(-1, n2, n3, 0, 7);
        return true;
    }

    public boolean deleteRows(int n2, int n3) {
        return this.deleteRows(n2, n3, true);
    }

    protected boolean deleteRows(int n2, int n3, boolean bl) {
        if (n3 <= 0) {
            return false;
        }
        if (n2 < 0 || n2 + n3 > this.rows) {
            return false;
        }
        if (bl && this.row_labels.size() != 0 && n2 < this.row_labels.size()) {
            JCVectorDataSource.removeElementsAt(this.row_labels, n2, n3);
        }
        JCVectorDataSource.removeElementsAt(this.cells, n2, n3);
        this.setNumRows(this.rows - n3);
        this.setDataChanged(n2, -1, n3, 0, 4);
        return true;
    }

    public boolean moveColumns(int n2, int n3, int n4) {
        if (n3 <= 0) {
            return false;
        }
        if (n2 < 0 || n2 + n3 > this.columns && n4 != Integer.MAX_VALUE) {
            return false;
        }
        if (n4 < 0 || n4 > this.columns && n4 != Integer.MAX_VALUE || n2 <= n4 && n4 < n2 + n3) {
            return false;
        }
        if (n2 + n3 == n4) {
            return true;
        }
        return this.moveColumns(n2, n3, n4, true);
    }

    protected boolean moveColumns(int n2, int n3, int n4, boolean bl) {
        int n5;
        this.is_moving = true;
        if (n4 == Integer.MAX_VALUE) {
            n4 = this.columns;
        }
        Vector vector = JCVectorDataSource.createVector(n3);
        Vector vector2 = JCVectorDataSource.createVector(n3);
        for (n5 = 0; n5 < n3; ++n5) {
            Vector vector3 = JCVectorDataSource.createVector();
            for (int i2 = 0; i2 < this.rows; ++i2) {
                try {
                    Vector vector4 = (Vector)this.cells.elementAt(i2);
                    vector3.addElement(vector4.elementAt(n2 + n5));
                    continue;
                }
                catch (Exception exception) {
                    vector3 = null;
                    i2 = this.rows;
                }
            }
            vector.addElement(vector3);
            vector2.addElement(this.getTableColumnLabel(n2 + n5));
        }
        if (!this.deleteColumns(n2, n3, bl)) {
            return false;
        }
        if (n2 < n4) {
            for (n5 = 0; n5 < n3; ++n5) {
                if (this.addColumn(n4 + n5 - n3, vector2.elementAt(n5), (Vector)vector.elementAt(n5), bl)) continue;
                return false;
            }
        } else {
            for (n5 = 0; n5 < n3; ++n5) {
                if (this.addColumn(n4 + n5, vector2.elementAt(n5), (Vector)vector.elementAt(n5), bl)) continue;
                return false;
            }
        }
        vector = null;
        vector2 = null;
        this.is_moving = false;
        this.setDataChanged(-998, n2, n3, n4, 11);
        return true;
    }

    public boolean moveRows(int n2, int n3, int n4) {
        if (n3 <= 0) {
            return false;
        }
        if (n2 < 0 || n2 + n3 > this.rows) {
            return false;
        }
        if (n4 < 0 || n4 > this.rows || n2 <= n4 && n4 < n2 + n3) {
            return false;
        }
        if (n2 + n3 == n4) {
            return true;
        }
        return this.moveRows(n2, n3, n4, true);
    }

    protected boolean moveRows(int n2, int n3, int n4, boolean bl) {
        Vector vector;
        int n5;
        this.is_moving = true;
        Vector vector2 = JCVectorDataSource.createVector(n3);
        Vector vector3 = JCVectorDataSource.createVector(n3);
        boolean bl2 = true;
        boolean bl3 = true;
        for (n5 = 0; n5 < n3; ++n5) {
            try {
                vector2.addElement(this.cells.elementAt(n2 + n5));
            }
            catch (Exception exception) {
                bl2 = false;
            }
            try {
                vector3.addElement(this.getTableRowLabel(n2 + n5));
                continue;
            }
            catch (Exception exception) {
                bl3 = false;
            }
        }
        if (!bl2 && !bl3) {
            return false;
        }
        if (!this.deleteRows(n2, n3, bl)) {
            return false;
        }
        if (n2 < n4) {
            for (n5 = 0; n5 < n3; ++n5) {
                vector = null;
                if (bl2) {
                    vector = (Vector)vector2.elementAt(n5);
                }
                if (this.addRow(n4 + n5 - n3, vector3.elementAt(n5), vector, bl)) continue;
                return false;
            }
        } else {
            for (n5 = 0; n5 < n3; ++n5) {
                vector = null;
                if (bl2) {
                    vector = (Vector)vector2.elementAt(n5);
                }
                if (this.addRow(n4 + n5, vector3.elementAt(n5), vector, bl)) continue;
                return false;
            }
        }
        vector2 = null;
        vector3 = null;
        this.is_moving = false;
        this.setDataChanged(n2, -998, n3, n4, 10);
        return true;
    }
}

