/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table.data;

import com.klg.jclass.table.data.JCFileFormatParser;
import com.klg.jclass.table.data.JCVectorDataSource;
import com.klg.jclass.util.JCFormatParserUtil;
import java.io.IOException;
import java.io.Reader;
import java.io.StreamTokenizer;
import java.util.Vector;

public class JCStandardFormatParser
implements JCFileFormatParser {
    protected StreamTokenizer tokenizer;
    public static final int PARSE_ERR_DATA_STYLE = 1;
    public static final int PARSE_ERR_VALUE = 2;
    public static final int PARSE_ERR_COLUMN_LABEL = 3;
    public static final int PARSE_ERR_ROW_LABEL = 4;
    protected boolean isDebug = false;
    protected boolean isLabels = false;

    protected void initTokenizer(Reader reader) {
        this.tokenizer = new StreamTokenizer(reader);
        this.tokenizer.commentChar(35);
        this.tokenizer.quoteChar(39);
        this.tokenizer.slashSlashComments(false);
        this.tokenizer.slashStarComments(false);
        this.tokenizer.eolIsSignificant(false);
        this.tokenizer.lowerCaseMode(false);
        this.tokenizer.parseNumbers();
        this.tokenizer.whitespaceChars(43, 43);
    }

    public void readAndParse(Reader reader, JCVectorDataSource jCVectorDataSource) throws IOException {
        boolean bl = false;
        int n2 = 0;
        int n3 = 0;
        this.initTokenizer(reader);
        if (this.tokenizer.nextToken() != -3) {
            bl = true;
        } else if (this.tokenizer.sval.equalsIgnoreCase("debug")) {
            this.isDebug = true;
            if (this.tokenizer.nextToken() != -3) {
                bl = true;
            }
        }
        if (bl || !this.tokenizer.sval.equalsIgnoreCase("table")) {
            JCStandardFormatParser.displayErrorMessage(this.tokenizer, 1);
            throw new IOException("Data must start with TABLE");
        }
        n2 = (int)JCStandardFormatParser.getNextDouble(this.tokenizer);
        n3 = (int)JCStandardFormatParser.getNextDouble(this.tokenizer);
        if (this.tokenizer.nextToken() == -3 && this.tokenizer.sval.equalsIgnoreCase("nolabel")) {
            this.isLabels = false;
        } else {
            this.isLabels = true;
            this.tokenizer.pushBack();
        }
        if (this.isDebug) {
            System.out.println("Reading in TABLE format with " + n2 + " rows and " + n3 + " columns with " + (this.isLabels ? "labels" : "no labels"));
        }
        this.readArrayData(n2, n3, jCVectorDataSource);
        this.tokenizer = null;
    }

    private void readArrayData(int n2, int n3, JCVectorDataSource jCVectorDataSource) throws IOException {
        int n4;
        Object object = null;
        Vector<Object> vector = null;
        if (this.isLabels) {
            for (n4 = 0; n4 < n3; ++n4) {
                object = JCFormatParserUtil.getNextToken(this.tokenizer);
                jCVectorDataSource.getColumnLabels().addElement(object);
                if (!this.isDebug) continue;
                System.out.println("Column Label " + n4 + " is " + object);
            }
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            if (this.isLabels) {
                object = JCFormatParserUtil.getNextToken(this.tokenizer);
                jCVectorDataSource.getRowLabels().addElement(object);
                if (this.isDebug) {
                    System.out.println("Row Label " + i2 + " is " + object);
                }
            }
            vector = new Vector<Object>();
            for (n4 = 0; n4 < n3; ++n4) {
                object = JCFormatParserUtil.getNextToken(this.tokenizer);
                vector.addElement(object);
                if (!this.isDebug) continue;
                System.out.println("Value at row " + i2 + " col " + n4 + " is " + object);
            }
            jCVectorDataSource.getCells().addElement(vector);
        }
        jCVectorDataSource.setNumRows(n2);
        jCVectorDataSource.setNumColumns(n3);
    }

    protected static double getNextDouble(StreamTokenizer streamTokenizer) throws IOException {
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype != -2) {
            JCStandardFormatParser.displayErrorMessage(streamTokenizer, 2);
            throw new IOException("Error in data file format - " + streamTokenizer);
        }
        double d2 = streamTokenizer.nval;
        streamTokenizer.nextToken();
        if (streamTokenizer.ttype == -3 && streamTokenizer.sval != null && (streamTokenizer.sval.charAt(0) == 'e' || streamTokenizer.sval.charAt(0) == 'E')) {
            if (streamTokenizer.sval.length() == 1) {
                streamTokenizer.nextToken();
                if (streamTokenizer.ttype == -2) {
                    d2 *= Math.pow(10.0, streamTokenizer.nval);
                }
            } else {
                String string = streamTokenizer.sval;
                int n2 = Integer.valueOf(string.substring(1));
                d2 *= Math.pow(10.0, n2);
            }
        } else {
            streamTokenizer.pushBack();
        }
        return d2;
    }

    protected static void displayErrorMessage(StreamTokenizer streamTokenizer, int n2) {
        String string = new String("");
        switch (n2) {
            case 1: {
                string = string + "Expect data type TABLE and not ";
                break;
            }
            case 2: {
                string = string + "Expect data value and not ";
                break;
            }
            case 3: {
                string = string + "Expect a column label and not ";
                break;
            }
            case 4: {
                string = string + "Expect a row label and not ";
                break;
            }
            default: {
                return;
            }
        }
        JCFormatParserUtil.displayErrorMessage(streamTokenizer, string);
    }
}

