/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table.data;

import com.klg.jclass.table.data.JCVectorDataSource;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;

public class JCResultSetDataSource
extends JCVectorDataSource {
    protected Connection dbcon;
    protected String query;
    protected int column_count;
    protected int[] column_type;

    public JCResultSetDataSource() {
        this.dbcon = null;
        this.query = null;
    }

    public JCResultSetDataSource(Connection connection, String string) {
        this.dbcon = connection;
        this.query = string;
    }

    public boolean executeQuery() throws SQLException {
        int n2;
        boolean bl = false;
        int n3 = -1;
        if (this.dbcon == null) {
            return bl;
        }
        Statement statement = this.dbcon.createStatement();
        ResultSet resultSet = statement.executeQuery(this.query);
        ResultSetMetaData resultSetMetaData = resultSet.getMetaData();
        this.column_count = resultSetMetaData.getColumnCount();
        this.setNumColumns(this.column_count);
        this.column_type = new int[this.column_count];
        for (n2 = 0; n2 < this.column_count; ++n2) {
            this.setColumnLabel(n2, resultSetMetaData.getColumnName(n2 + 1));
            this.column_type[n2] = resultSetMetaData.getColumnType(n2 + 1);
        }
        while (resultSet.next()) {
            ++n3;
            for (n2 = 0; n2 < this.column_count; ++n2) {
                this.setCell(n3, n2, resultSet.getObject(n2 + 1));
            }
        }
        bl = true;
        resultSet.close();
        statement.close();
        this.setNumRows(n3 + 1);
        return bl;
    }

    public Connection getConnection() {
        return this.dbcon;
    }

    public void setConnection(Connection connection) {
        this.dbcon = connection;
    }

    public String getQuery() {
        return this.query;
    }

    public void setQuery(String string) {
        this.query = string;
    }

    public int[] getColumnTypes() {
        return this.column_type;
    }

    public int getColumnType(int n2) {
        if (n2 < 0 || n2 >= this.columns) {
            return -1;
        }
        return this.column_type[n2];
    }

    public int getColumnDatatype(int n2) {
        int n3 = 5;
        if (n2 < 0 || n2 >= this.columns) {
            return n3;
        }
        switch (this.column_type[n2]) {
            case -7: 
            case -6: 
            case 4: 
            case 5: {
                n3 = 4;
                break;
            }
            case -5: 
            case 8: {
                n3 = 2;
                break;
            }
            case -1: 
            case 1: 
            case 12: {
                n3 = 5;
                break;
            }
            case 2: 
            case 3: 
            case 6: 
            case 7: {
                n3 = 3;
                break;
            }
            case 91: 
            case 92: 
            case 93: {
                n3 = 1;
                break;
            }
            default: {
                n3 = 5;
            }
        }
        return n3;
    }

    public boolean connect(String string, String string2, Properties properties) throws SQLException {
        boolean bl = false;
        try {
            Class.forName(string).newInstance();
            this.dbcon = DriverManager.getConnection(string2, properties);
            bl = true;
        }
        catch (SQLException sQLException) {
            throw sQLException;
        }
        catch (Exception exception) {
            System.out.println("Unable to load driver: " + exception.getMessage());
        }
        return bl;
    }
}

