/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table.beans;

import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.beans.EnumString;
import com.klg.jclass.table.beans.JCLiveCellStyle;
import com.klg.jclass.table.beans.PropertyEditorTable;
import com.klg.jclass.table.beans.StyleWrapper;
import com.klg.jclass.table.beans.TablePropertyEditor;
import com.klg.jclass.table.data.JCVectorDataSource;
import com.klg.jclass.util.swing.JCFontChooserBar;
import com.klg.jclass.util.swing.JCFontEvent;
import com.klg.jclass.util.swing.JCFontListener;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.EventObject;
import javax.accessibility.AccessibleContext;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JColorChooser;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class StyleEditor
extends TablePropertyEditor
implements ActionListener,
ItemListener,
JCFontListener {
    protected JCFontChooserBar fontBar;
    protected JButton fgButton;
    protected JButton bgButton;
    protected JButton borderColorBtn;
    protected JComboBox horizontalAlignment;
    protected JComboBox verticalAlignment;
    protected JComboBox borderSides;
    protected JComboBox borderType;
    protected JComboBox borderColorModeCB;
    protected JComboBox clipHints;
    protected JCheckBox editable;
    protected JCheckBox traversable;
    protected PropertyEditorTable sampleTable;
    protected static final String BOTTOM = "Bottom";
    protected static final String CENTER = "Center";
    protected static final String LEFT = "Left";
    protected static final String RIGHT = "Right";
    protected static final String TOP = "Top";
    protected static EnumString[] EnumAlignment = new EnumString[]{new EnumString(3, "Bottom"), new EnumString(0, "Center"), new EnumString(2, "Left"), new EnumString(4, "Right"), new EnumString(1, "Top")};
    protected static final String BORDER_ETCHED_IN = "Etched in";
    protected static final String BORDER_ETCHED_OUT = "Etched out";
    protected static final String BORDER_FRAME_IN = "Frame in";
    protected static final String BORDER_FRAME_OUT = "Frame out";
    protected static final String BORDER_IN = "Border in";
    protected static final String BORDER_OUT = "Border out";
    protected static final String BORDER_PLAIN = "Plain";
    protected static final String BORDER_NONE = "None";
    protected static final String BORDER_THIN = "Thin";
    protected static final String BEVEL_BORDER = "Bevel";
    protected static final String SOFT_BEVEL_BORDER = "Soft bevel";
    protected static EnumString[] EnumBorderType = new EnumString[]{new EnumString(1, "Etched in"), new EnumString(2, "Etched out"), new EnumString(6, "Frame in"), new EnumString(7, "Frame out"), new EnumString(3, "Border in"), new EnumString(4, "Border out"), new EnumString(5, "Plain"), new EnumString(0, "None"), new EnumString(8, "Thin"), new EnumString(9, "Bevel"), new EnumString(10, "Soft bevel")};
    protected static final String BORDERSIDE_ALL = "All";
    protected static final String BORDERSIDE_BOTTOM = "Bottom";
    protected static final String BORDERSIDE_LEFT = "Left";
    protected static final String BORDERSIDE_NONE = "None";
    protected static final String BORDERSIDE_RIGHT = "Right";
    protected static final String BORDERSIDE_TOP = "Top";
    protected static EnumString[] EnumBorderSides = new EnumString[]{new EnumString(15, "All"), new EnumString(4, "Bottom"), new EnumString(1, "Left"), new EnumString(0, "None"), new EnumString(8, "Right"), new EnumString(2, "Top")};
    protected static final String BASE_ON_BACKGROUND = "Cell background";
    protected static final String BASE_ON_FOREGROUND = "Cell foreground";
    protected static final String USE_CELL_BORDER_COLOR = "Cell border";
    protected static EnumString[] EnumBorderColorMode = new EnumString[]{new EnumString(1, "Cell background"), new EnumString(2, "Cell foreground"), new EnumString(0, "Cell border")};
    protected static final String SHOW_NONE = "None";
    protected static final String SHOW_HORIZONTAL = "Horizontal";
    protected static final String SHOW_VERTICAL = "Vertical";
    protected static final String SHOW_ALL = "All";
    protected static EnumString[] EnumClipHints = new EnumString[]{new EnumString(0, "None"), new EnumString(1, "Horizontal"), new EnumString(2, "Vertical"), new EnumString(3, "All")};
    private static final int sampleColumns = 2;
    private static final int sampleRows = 3;

    public StyleEditor() {
        super(1);
    }

    public void setValue(Object object) {
        if (object == null) {
            return;
        }
        this.tableView.setStyles((StyleWrapper)object);
        this.updateStyle();
        super.setValue(object);
    }

    public Object getValue() {
        return this.tableView.getStyles();
    }

    public String getAsText() {
        return this.tableView.getStyles().toString();
    }

    public String getJavaInitializationString() {
        return this.tableView.getStyles().getJavaInitializationString();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (!this.updateComponents) {
            return;
        }
        super.actionPerformed(actionEvent);
        this.setStyleProperty(actionEvent);
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (!this.updateComponents) {
            return;
        }
        super.itemStateChanged(itemEvent);
        this.setStyleProperty(itemEvent);
    }

    public void fontChanging(JCFontEvent jCFontEvent) {
    }

    public void fontChanged(JCFontEvent jCFontEvent) {
        if (!this.updateComponents) {
            return;
        }
        this.setStyleProperty(jCFontEvent);
    }

    protected JComponent makePropertyPanel() {
        this.tableView.setTraversable(true);
        this.fgButton = new JButton("Foreground...");
        AccessibleContext accessibleContext = this.fgButton.getAccessibleContext();
        accessibleContext.setAccessibleName("Foreground color");
        accessibleContext.setAccessibleDescription("Choose a foreground color");
        this.bgButton = new JButton("Background...");
        accessibleContext = this.bgButton.getAccessibleContext();
        accessibleContext.setAccessibleName("Background color");
        accessibleContext.setAccessibleDescription("Choose a background color");
        this.fontBar = new JCFontChooserBar();
        this.fontBar.setStyleControls(3);
        this.editable = new JCheckBox("Editable");
        this.traversable = new JCheckBox("Traversable");
        this.sampleTable = new SampleTable();
        this.horizontalAlignment = new JComboBox();
        this.horizontalAlignment.addItem("Left");
        this.horizontalAlignment.addItem(CENTER);
        this.horizontalAlignment.addItem("Right");
        this.verticalAlignment = new JComboBox();
        this.verticalAlignment.addItem("Top");
        this.verticalAlignment.addItem(CENTER);
        this.verticalAlignment.addItem("Bottom");
        this.borderSides = new JComboBox();
        StyleEditor.initComboBox(this.borderSides, EnumBorderSides);
        this.borderType = new JComboBox();
        StyleEditor.initComboBox(this.borderType, EnumBorderType);
        this.clipHints = new JComboBox();
        StyleEditor.initComboBox(this.clipHints, EnumClipHints);
        this.borderColorModeCB = new JComboBox();
        StyleEditor.initComboBox(this.borderColorModeCB, EnumBorderColorMode);
        this.borderColorBtn = new JButton("Color...");
        accessibleContext = this.borderColorBtn.getAccessibleContext();
        accessibleContext.setAccessibleName("Border color");
        accessibleContext.setAccessibleDescription("Choose a border color");
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 1;
        gridBagConstraints.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints.anchor = 18;
        JPanel jPanel2 = new JPanel();
        jPanel2.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(2, 2, 2, 2);
        gridBagConstraints2.anchor = 18;
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        TablePropertyEditor.GroupPanel groupPanel = new TablePropertyEditor.GroupPanel("Color");
        groupPanel.add(this.fgButton);
        groupPanel.add(this.bgButton);
        jPanel2.add((Component)groupPanel, gridBagConstraints2);
        TablePropertyEditor.GroupPanel groupPanel2 = new TablePropertyEditor.GroupPanel("Font");
        groupPanel2.add(this.fontBar);
        ++gridBagConstraints2.gridy;
        jPanel2.add((Component)groupPanel2, gridBagConstraints2);
        TablePropertyEditor.GroupPanel groupPanel3 = new TablePropertyEditor.GroupPanel("Alignment");
        groupPanel3.setLayout(new GridBagLayout());
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        gridBagConstraints2.anchor = 18;
        groupPanel3.add((Component)new JLabel(SHOW_VERTICAL), gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        groupPanel3.add((Component)this.verticalAlignment, gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        groupPanel3.add((Component)new JLabel("  Horizontal"), gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        groupPanel3.add((Component)this.horizontalAlignment, gridBagConstraints2);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        jPanel2.add((Component)groupPanel3, gridBagConstraints2);
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)jPanel2, gridBagConstraints);
        TablePropertyEditor.GroupPanel groupPanel4 = new TablePropertyEditor.GroupPanel("Borders");
        groupPanel4.setLayout(new GridBagLayout());
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 0;
        groupPanel4.add((Component)new JLabel("Sides"), gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        groupPanel4.add((Component)this.borderSides, gridBagConstraints2);
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        groupPanel4.add((Component)new JLabel("Type"), gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        groupPanel4.add((Component)this.borderType, gridBagConstraints2);
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        groupPanel4.add((Component)new JLabel("Clip hints"), gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        groupPanel4.add((Component)this.clipHints, gridBagConstraints2);
        gridBagConstraints2.gridx = 0;
        ++gridBagConstraints2.gridy;
        groupPanel4.add((Component)new JLabel("Color mode"), gridBagConstraints2);
        ++gridBagConstraints2.gridx;
        groupPanel4.add((Component)this.borderColorModeCB, gridBagConstraints2);
        ++gridBagConstraints2.gridy;
        groupPanel4.add((Component)this.borderColorBtn, gridBagConstraints2);
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)groupPanel4, gridBagConstraints);
        TablePropertyEditor.GroupPanel groupPanel5 = new TablePropertyEditor.GroupPanel("Interaction");
        groupPanel5.add(this.editable);
        groupPanel5.add(this.traversable);
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 0;
        jPanel.add((Component)groupPanel5, gridBagConstraints);
        TablePropertyEditor.GroupPanel groupPanel6 = new TablePropertyEditor.GroupPanel("Sample");
        groupPanel6.setLayout(new GridBagLayout());
        groupPanel6.add((Component)this.sampleTable, gridBagConstraints2);
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        jPanel.add((Component)groupPanel6, gridBagConstraints);
        this.fgButton.addActionListener(this);
        this.bgButton.addActionListener(this);
        this.borderColorBtn.addActionListener(this);
        this.fontBar.addJCFontListener(this);
        this.editable.addActionListener(this);
        this.traversable.addActionListener(this);
        this.horizontalAlignment.addItemListener(this);
        this.verticalAlignment.addItemListener(this);
        this.borderSides.addItemListener(this);
        this.borderType.addItemListener(this);
        this.clipHints.addItemListener(this);
        this.borderColorModeCB.addItemListener(this);
        return jPanel;
    }

    protected void updatePropertyPanel(JCCellRange jCCellRange) {
        this.updateStyle();
        this.support.firePropertyChange("styles", null, this.getValue());
    }

    protected synchronized void updateStyle() {
        JCCellRange jCCellRange = this.tableView.getSelectedRange();
        if (jCCellRange == null) {
            this.setEnabledAll(false);
            return;
        }
        this.setEnabledAll(true);
        JCLiveCellStyle jCLiveCellStyle = (JCLiveCellStyle)this.tableView.getCellStyle(jCCellRange.start_row, jCCellRange.start_column);
        this.updateComponents = false;
        this.updateSampleTable(jCCellRange);
        this.fontBar.setSelectedFont(jCLiveCellStyle.getFont());
        StyleEditor.setSelected(this.editable, jCLiveCellStyle.isEditable());
        StyleEditor.setSelected(this.traversable, jCLiveCellStyle.isTraversable());
        StyleEditor.setSelectedItem(this.horizontalAlignment, StyleEditor.toString(EnumAlignment, jCLiveCellStyle.getHorizontalAlignment()));
        StyleEditor.setSelectedItem(this.verticalAlignment, StyleEditor.toString(EnumAlignment, jCLiveCellStyle.getVerticalAlignment()));
        StyleEditor.setSelectedItem(this.borderSides, StyleEditor.toString(EnumBorderSides, jCLiveCellStyle.getCellBorderSides()));
        StyleEditor.setSelectedItem(this.borderType, StyleEditor.toString(EnumBorderType, jCLiveCellStyle.getCellBorderType()));
        StyleEditor.setSelectedItem(this.clipHints, StyleEditor.toString(EnumClipHints, jCLiveCellStyle.getClipHints()));
        StyleEditor.setSelectedItem(this.borderColorModeCB, StyleEditor.toString(EnumBorderColorMode, jCLiveCellStyle.getCellBorderColorMode()));
        this.updateComponents = true;
    }

    protected void setEnabledAll(boolean bl) {
        this.fontBar.setEnabled(bl);
        this.editable.setEnabled(bl);
        this.traversable.setEnabled(bl);
        this.horizontalAlignment.setEnabled(bl);
        this.verticalAlignment.setEnabled(bl);
        this.borderSides.setEnabled(bl);
        this.borderType.setEnabled(bl);
        this.clipHints.setEnabled(bl);
        this.borderColorModeCB.setEnabled(bl);
    }

    protected void updateSampleTable(JCCellRange jCCellRange) {
        JCLiveCellStyle jCLiveCellStyle = (JCLiveCellStyle)this.tableView.getCellStyle(-1, jCCellRange.start_column).clone();
        this.sampleTable.setCellStyle(new JCCellRange(-1, 0, -1, Integer.MAX_VALUE), jCLiveCellStyle);
        jCLiveCellStyle = (JCLiveCellStyle)this.tableView.getCellStyle(jCCellRange.start_row, -1).clone();
        this.sampleTable.setCellStyle(new JCCellRange(0, -1, Integer.MAX_VALUE, -1), jCLiveCellStyle);
        if (jCCellRange.start_row != -1 && jCCellRange.start_column != -1) {
            jCLiveCellStyle = (JCLiveCellStyle)this.tableView.getCellStyle(jCCellRange.start_row, jCCellRange.start_column).clone();
            this.sampleTable.setCellStyle(new JCCellRange(0, 0, Integer.MAX_VALUE, Integer.MAX_VALUE), jCLiveCellStyle);
        }
    }

    private void setStyleProperty(EventObject eventObject) {
        JCCellRange jCCellRange = this.tableView.getSelectedRange();
        if (jCCellRange == null) {
            return;
        }
        Object object = eventObject.getSource();
        int n2 = StyleEditor.getFirstCell(jCCellRange.start_row);
        int n3 = StyleEditor.getFirstCell(jCCellRange.start_column);
        JCLiveCellStyle jCLiveCellStyle = (JCLiveCellStyle)this.tableView.getCellStyle(n2, n3).clone();
        if (object.equals(this.fgButton)) {
            Color color = jCLiveCellStyle.getForeground();
            Color color2 = this.selectColor(true, color);
            if (color2 == null || color2 == color) {
                return;
            }
            jCLiveCellStyle.setForeground(color2);
        } else if (object.equals(this.bgButton)) {
            Color color = jCLiveCellStyle.getBackground();
            Color color3 = this.selectColor(false, color);
            if (color3 == null || color3 == color) {
                return;
            }
            jCLiveCellStyle.setBackground(color3);
        } else if (object.equals(this.borderColorBtn)) {
            Color color = jCLiveCellStyle.getBackground();
            Color color4 = this.selectColor(false, color);
            if (color4 == null || color4 == color) {
                return;
            }
            jCLiveCellStyle.setCellBorderColor(color4);
        } else if (object.equals(this.fontBar)) {
            Font font = ((JCFontEvent)eventObject).getFont();
            jCLiveCellStyle.setFont(font);
        } else if (object.equals(this.editable)) {
            jCLiveCellStyle.setEditable(this.editable.isSelected());
        } else if (object.equals(this.traversable)) {
            jCLiveCellStyle.setTraversable(this.traversable.isSelected());
        } else if (object.equals(this.horizontalAlignment)) {
            String string = (String)this.horizontalAlignment.getSelectedItem();
            int n4 = StyleEditor.toIntValue(EnumAlignment, string);
            jCLiveCellStyle.setHorizontalAlignment(n4);
        } else if (object.equals(this.verticalAlignment)) {
            String string = (String)this.verticalAlignment.getSelectedItem();
            int n5 = StyleEditor.toIntValue(EnumAlignment, string);
            jCLiveCellStyle.setVerticalAlignment(n5);
        } else if (object.equals(this.borderSides)) {
            String string = (String)this.borderSides.getSelectedItem();
            jCLiveCellStyle.setCellBorderSides(StyleEditor.toIntValue(EnumBorderSides, string));
        } else if (object.equals(this.borderType)) {
            String string = (String)this.borderType.getSelectedItem();
            jCLiveCellStyle.setCellBorderType(StyleEditor.toIntValue(EnumBorderType, string));
        } else if (object.equals(this.clipHints)) {
            String string = (String)this.clipHints.getSelectedItem();
            jCLiveCellStyle.setClipHints(StyleEditor.toIntValue(EnumClipHints, string));
        } else if (object.equals(this.borderColorModeCB)) {
            String string = (String)this.borderColorModeCB.getSelectedItem();
            jCLiveCellStyle.setCellBorderColorMode(StyleEditor.toIntValue(EnumBorderColorMode, string));
        } else {
            return;
        }
        this.tableView.setCellStyle(this.tableView.getRangedSelection(), jCLiveCellStyle);
        this.updateSampleTable(jCCellRange);
        this.support.firePropertyChange("styles", null, this.getValue());
    }

    protected Color selectColor(boolean bl, Color color) {
        String string = (bl ? "Foreground" : "Background") + " Color";
        return JColorChooser.showDialog(this.findParent(), string, color);
    }

    class SampleTable
    extends PropertyEditorTable {
        SampleTable() {
            super(false);
            this.setSelectionPolicy(0);
            this.clearSelectedCells();
            this.setAllowCellResize(0);
            this.setFocusIndicator(0);
            this.setColumnLabelDisplay(true);
            this.setRowLabelDisplay(true);
            this.setPixelWidth(-998, 33001);
            this.setPixelHeight(-998, 33001);
        }

        protected void makeDataSource(boolean bl) {
            int n2;
            JCVectorDataSource jCVectorDataSource = new JCVectorDataSource();
            jCVectorDataSource.setNumRows(3);
            jCVectorDataSource.setNumColumns(2);
            this.setVisibleRows(3);
            this.setVisibleColumns(2);
            for (n2 = 0; n2 < jCVectorDataSource.getNumColumns(); ++n2) {
                jCVectorDataSource.setColumnLabel(n2, "Column: " + n2);
            }
            for (n2 = 0; n2 < jCVectorDataSource.getNumRows(); ++n2) {
                jCVectorDataSource.setRowLabel(n2, "Row: " + n2);
                for (int i2 = 0; i2 < jCVectorDataSource.getNumColumns(); ++i2) {
                    jCVectorDataSource.setCell(n2, i2, "Cell");
                }
            }
            this.setDataSource(jCVectorDataSource);
        }
    }
}

