/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table.beans;

import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.beans.SpannedCellsWrapper;
import com.klg.jclass.table.beans.TablePropertyEditor;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JComponent;

public class SpannedCellsEditor
extends TablePropertyEditor
implements ActionListener {
    private JButton buttonSpan;
    private JButton buttonUnspan;

    public SpannedCellsEditor() {
        super(1);
    }

    public void setValue(Object object) {
        if (object == null) {
            return;
        }
        this.tableView.setSpannedCells((SpannedCellsWrapper)object);
        super.setValue(object);
    }

    public Object getValue() {
        return this.tableView.getSpannedCells();
    }

    public String getAsText() {
        return this.tableView.getSpannedCells().toString();
    }

    public String getJavaInitializationString() {
        return this.tableView.getSpannedCells().getJavaInitializationString();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        super.actionPerformed(actionEvent);
        Object object = actionEvent.getSource();
        if (object.equals(this.buttonSpan) || object.equals(this.buttonUnspan)) {
            this.updateSpan(object.equals(this.buttonSpan));
            JCCellRange jCCellRange = this.tableView.getSelectedRange();
            if (jCCellRange != null) {
                this.updatePropertyPanel(jCCellRange);
            }
        }
    }

    protected void updatePropertyPanel(JCCellRange jCCellRange) {
        this.support.firePropertyChange("spanningCells", null, this.getValue());
        if (jCCellRange == null) {
            return;
        }
        this.buttonSpan.setEnabled(this.canSpan(jCCellRange));
        this.buttonUnspan.setEnabled(this.isSpanned(jCCellRange));
    }

    protected JComponent makePropertyPanel() {
        TablePropertyEditor.GroupPanel groupPanel = new TablePropertyEditor.GroupPanel(this, "Spanning cells");
        groupPanel.setLayout(new FlowLayout());
        this.buttonSpan = new JButton("Span");
        this.buttonUnspan = new JButton("Unspan");
        this.buttonSpan.setEnabled(false);
        this.buttonUnspan.setEnabled(false);
        groupPanel.add(this.buttonSpan);
        groupPanel.add(this.buttonUnspan);
        this.buttonSpan.addActionListener(this);
        this.buttonUnspan.addActionListener(this);
        return groupPanel;
    }

    private void updateSpan(boolean bl) {
        JCCellRange jCCellRange = this.tableView.getSelectedRange();
        if (jCCellRange == null) {
            return;
        }
        if (bl) {
            this.tableView.addSpannedRange(jCCellRange);
        } else {
            this.removeSpan(jCCellRange);
        }
    }

    private boolean canSpan(JCCellRange jCCellRange) {
        return !this.isSpanned(jCCellRange) && jCCellRange != null && (jCCellRange.start_row != jCCellRange.end_row || jCCellRange.start_column != jCCellRange.end_column);
    }

    private boolean isSpanned(JCCellRange jCCellRange) {
        if (jCCellRange == null) {
            return false;
        }
        int n2 = jCCellRange.end_row == Integer.MAX_VALUE ? this.tableView.getNumRows() : jCCellRange.end_row;
        int n3 = jCCellRange.end_column == Integer.MAX_VALUE ? this.tableView.getNumColumns() : jCCellRange.end_column;
        for (int i2 = jCCellRange.start_row; i2 <= n2; ++i2) {
            for (int i3 = jCCellRange.start_column; i3 <= n3; ++i3) {
                if (this.tableView.getSpannedRange(i2, i3) == null) continue;
                return true;
            }
        }
        return false;
    }

    private void removeSpan(JCCellRange jCCellRange) {
        if (jCCellRange == null) {
            return;
        }
        int n2 = jCCellRange.end_row == Integer.MAX_VALUE ? this.tableView.getNumRows() : jCCellRange.end_row;
        int n3 = jCCellRange.end_column == Integer.MAX_VALUE ? this.tableView.getNumColumns() : jCCellRange.end_column;
        for (int i2 = jCCellRange.start_row; i2 <= n2; ++i2) {
            for (int i3 = jCCellRange.start_column; i3 <= n3; ++i3) {
                JCCellRange jCCellRange2 = this.tableView.getSpannedRange(i2, i3);
                if (jCCellRange2 == null) continue;
                this.tableView.removeSpannedRange(jCCellRange2);
            }
        }
    }
}

