/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.table.ComponentModel;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCTable;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class SpanHandler
implements Serializable {
    protected JCTable table;
    protected Vector spans;

    public void setTable(JCTable jCTable) {
        this.table = jCTable;
    }

    public void addSpannedRange(JCCellRange jCCellRange) throws IllegalArgumentException {
        if (this.spans == null) {
            this.spans = new Vector();
        }
        this.validateRange(this.spans, jCCellRange);
        ComponentModel componentModel = this.table.getComponentModel();
        if (componentModel != null) {
            componentModel.removeCellComponents();
        }
        this.spans.addElement(jCCellRange);
    }

    protected void validateRange(Vector vector, JCCellRange jCCellRange) throws IllegalArgumentException {
        int n2;
        if (jCCellRange.start_row > jCCellRange.end_row || jCCellRange.start_column > jCCellRange.end_column) {
            String string = "End row/column must be greater than or equal to start row/column. " + jCCellRange;
            throw new IllegalArgumentException(string);
        }
        if (jCCellRange.start_row == -1 && jCCellRange.end_row != -1 || jCCellRange.start_column == -1 && jCCellRange.end_column != -1) {
            throw new IllegalArgumentException("cell range " + jCCellRange + " contains labels and cells");
        }
        int n3 = vector.size();
        for (n2 = 0; n2 < n3; ++n2) {
            JCCellRange jCCellRange2 = (JCCellRange)vector.elementAt(n2);
            if (!jCCellRange2.overlaps(jCCellRange)) continue;
            throw new IllegalArgumentException("cell range " + jCCellRange + " overlaps an existing span");
        }
        n2 = this.table.getFrozenRows();
        n3 = this.table.getFrozenColumns();
        String string = "cell range " + jCCellRange + " contains frozen and non-frozen cells";
        if (n2 > 0 && jCCellRange.start_row < n2 && jCCellRange.end_row >= n2) {
            throw new IllegalArgumentException(string);
        }
        if (n3 > 0 && jCCellRange.start_column < n3 && jCCellRange.end_column >= n3) {
            throw new IllegalArgumentException(string);
        }
    }

    public JCCellRange getCompleteRange(int n2, int n3, int n4, int n5) {
        JCCellRange jCCellRange = new JCCellRange(n2, n3, n4, n5);
        if (this.spans != null && this.spans.size() > 0) {
            JCCellRange jCCellRange2;
            do {
                jCCellRange2 = jCCellRange;
                for (int i2 = 0; i2 < this.spans.size(); ++i2) {
                    JCCellRange jCCellRange3 = (JCCellRange)this.spans.elementAt(i2);
                    if (!jCCellRange.intersects(jCCellRange3)) continue;
                    jCCellRange = jCCellRange.combination(jCCellRange3);
                }
            } while (!jCCellRange2.equals(jCCellRange));
        }
        return jCCellRange;
    }

    public void validateAllRanges() throws IllegalArgumentException {
        if (this.spans == null || this.spans.size() == 0) {
            return;
        }
        boolean bl = true;
        Vector<JCCellRange> vector = new Vector<JCCellRange>();
        for (int i2 = 0; i2 < this.spans.size(); ++i2) {
            JCCellRange jCCellRange = (JCCellRange)this.spans.elementAt(i2);
            try {
                this.validateRange(vector, jCCellRange);
                vector.addElement(jCCellRange);
                continue;
            }
            catch (IllegalArgumentException illegalArgumentException) {
                bl = false;
            }
        }
        this.spans = vector;
        if (!bl) {
            throw new IllegalArgumentException("one or more spanned cell ranges failed validation");
        }
    }

    public void clearSpannedRanges() {
        if (this.spans == null || this.spans.size() == 0) {
            return;
        }
        while (this.spans.size() > 0) {
            this.removeSpannedRange((JCCellRange)this.spans.elementAt(0));
        }
    }

    public Collection getSpannedRanges() {
        if (this.spans == null) {
            return null;
        }
        return (Vector)this.spans.clone();
    }

    public void removeSpannedRange(JCCellRange jCCellRange) {
        if (this.spans == null) {
            return;
        }
        int n2 = this.spans.size();
        for (int i2 = 0; i2 < n2; ++i2) {
            JCCellRange jCCellRange2 = (JCCellRange)this.spans.elementAt(i2);
            if (!jCCellRange2.equals(jCCellRange)) continue;
            this.spans.removeElementAt(i2);
            return;
        }
    }

    public void setSpannedRanges(Collection collection) throws IllegalArgumentException {
        this.spans = null;
        Iterator iterator = collection.iterator();
        while (iterator.hasNext()) {
            this.addSpannedRange((JCCellRange)iterator.next());
        }
    }

    public JCCellRange getSpannedRange(int n2, int n3) {
        if (this.spans == null) {
            return null;
        }
        int n4 = this.spans.size();
        for (int i2 = 0; i2 < n4; ++i2) {
            JCCellRange jCCellRange = (JCCellRange)this.spans.elementAt(i2);
            if (!jCCellRange.inside(n2, n3)) continue;
            return jCCellRange;
        }
        return null;
    }

    public boolean isControllingCell(JCCellRange jCCellRange, int n2, int n3) {
        boolean bl = false;
        if (jCCellRange != null && this.cellIsNotHidden(n2, n3)) {
            bl = true;
            block0: for (int i2 = jCCellRange.start_row; i2 < n2 + 1 && bl; ++i2) {
                for (int i3 = jCCellRange.start_column; i3 < n3 + 1; ++i3) {
                    if (!this.cellIsNotHidden(i2, i3) || i2 >= n2 && i3 >= n3) continue;
                    bl = false;
                    continue block0;
                }
            }
        }
        return bl;
    }

    public JCCellPosition getControllingCell(JCCellRange jCCellRange) {
        if (jCCellRange == null) {
            return null;
        }
        int n2 = -999;
        for (n2 = jCCellRange.start_row; n2 <= jCCellRange.end_row && this.table.isRowHidden(n2); ++n2) {
        }
        int n3 = -999;
        for (n3 = jCCellRange.start_column; n3 <= jCCellRange.end_column && this.table.isColumnHidden(n3); ++n3) {
        }
        if (n2 == -999 || n3 == -999) {
            return null;
        }
        return new JCCellPosition(n2, n3);
    }

    private boolean cellIsNotHidden(int n2, int n3) {
        return !this.table.isRowHidden(n2) && !this.table.isColumnHidden(n3);
    }
}

