/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.table.CellAreaRenderer;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCSelectEvent;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.SelectionModel;
import java.io.Serializable;
import java.util.Collection;
import java.util.Iterator;
import java.util.Vector;

public class JCSelection
implements SelectionModel,
Serializable {
    protected JCTable table;
    protected Vector selected_cells = null;
    protected int policy = 0;
    protected int last_selected_row = -1;
    protected int last_selected_column = -1;

    public JCSelection() {
    }

    public JCSelection(JCTable jCTable) {
        this.table = jCTable;
    }

    public JCTable getTable() {
        return this.table;
    }

    public void setTable(JCTable jCTable) {
        this.table = jCTable;
    }

    public int getSelectionPolicy() {
        return this.policy;
    }

    public void setSelectionPolicy(int n2) {
        if (this.selected_cells != null) {
            this.clearSelection();
        }
        this.policy = n2;
    }

    public boolean addColumnSelection(int n2, int n3) {
        return this.addSelection(-1, n2, Integer.MAX_VALUE, n3);
    }

    public boolean addRowSelection(int n2, int n3) {
        return this.addSelection(n2, -1, n3, Integer.MAX_VALUE);
    }

    public boolean addSelection(int n2, int n3, int n4, int n5) {
        if (n2 == n4 && n2 == -1) {
            n4 = Integer.MAX_VALUE;
        }
        if (n3 == n5 && n3 == -1) {
            n5 = Integer.MAX_VALUE;
        }
        return this.addSelection(new JCCellRange(n2, n3, n4, n5));
    }

    public boolean addSelection(JCCellRange jCCellRange) {
        JCSelectEvent jCSelectEvent;
        if (this.selected_cells == null) {
            return false;
        }
        if (this.policy != 3) {
            return false;
        }
        if (this.table.selectListeners != null) {
            jCSelectEvent = new JCSelectEvent(this.table, 1, jCCellRange.start_row, jCCellRange.start_column, jCCellRange.end_row, jCCellRange.end_column, 1);
            this.table.fireJCSelectEvent(jCSelectEvent);
            if (jCSelectEvent.isCancelled()) {
                return false;
            }
        }
        this.selected_cells.addElement(jCCellRange);
        if (this.table.selectListeners != null) {
            jCSelectEvent = new JCSelectEvent(this.table, 2, jCCellRange.start_row, jCCellRange.start_column, jCCellRange.end_row, jCCellRange.end_column, 1);
            this.table.fireJCSelectEvent(jCSelectEvent);
            if (jCSelectEvent.isCancelled()) {
                this.selected_cells.removeElement(jCCellRange);
                return false;
            }
        }
        this.table.getCellAreaHandler().getCellAreaRenderer().repaintRange(jCCellRange);
        return true;
    }

    public void cleanup() {
        if (this.selected_cells == null) {
            return;
        }
        int n2 = this.selected_cells.size();
        if (n2 < 2) {
            return;
        }
        JCCellRange jCCellRange = (JCCellRange)this.selected_cells.lastElement();
        for (int i2 = n2 - 2; i2 >= 0; --i2) {
            if (!jCCellRange.equals(this.selected_cells.elementAt(i2))) continue;
            this.selected_cells.removeElementAt(i2);
        }
    }

    public void clearSelection() {
        this.clearSelection(true);
    }

    public void clearSelection(boolean bl) {
        JCCellRange jCCellRange;
        int n2;
        if (this.selected_cells == null) {
            return;
        }
        Vector<JCCellRange> vector = new Vector<JCCellRange>();
        Vector vector2 = (Vector)this.selected_cells.clone();
        JCSelectEvent jCSelectEvent = null;
        for (n2 = 0; n2 < vector2.size(); ++n2) {
            jCCellRange = (JCCellRange)vector2.elementAt(n2);
            if (this.table.selectListeners == null) continue;
            jCSelectEvent = new JCSelectEvent(this.table, 1, jCCellRange.start_row, jCCellRange.start_column, jCCellRange.end_row, jCCellRange.end_column, 3);
            if (bl) {
                this.table.fireJCSelectEvent(jCSelectEvent);
                if (jCSelectEvent.isCancelled()) {
                    vector.addElement(jCCellRange);
                    continue;
                }
            }
            jCSelectEvent.type = 2;
            this.table.fireJCSelectEvent(jCSelectEvent);
            if (!jCSelectEvent.isCancelled()) continue;
            vector.addElement(jCCellRange);
        }
        if (vector.size() == 0) {
            this.selected_cells = null;
            for (n2 = 0; n2 < vector2.size(); ++n2) {
                jCCellRange = (JCCellRange)vector2.elementAt(n2);
                CellAreaRenderer cellAreaRenderer = this.table.getCellAreaHandler().getCellAreaRenderer();
                int n3 = Math.min(jCCellRange.start_row, jCCellRange.end_row);
                int n4 = Math.max(jCCellRange.start_row, jCCellRange.end_row);
                int n5 = Math.min(jCCellRange.start_column, jCCellRange.end_column);
                int n6 = Math.max(jCCellRange.start_column, jCCellRange.end_column);
                cellAreaRenderer.repaintRange(n3, n5, n4, n6);
            }
        } else {
            this.selected_cells = (Vector)vector.clone();
            this.table.repaint();
        }
        if (bl && jCSelectEvent != null) {
            jCSelectEvent.type = 3;
            this.table.fireJCSelectEvent(jCSelectEvent);
        }
        vector = null;
        vector2 = null;
        this.last_selected_row = -1;
        this.last_selected_column = -1;
    }

    public boolean extendSelection(int n2, int n3) {
        int n4;
        if (this.selected_cells == null || this.selected_cells.size() == 0) {
            return false;
        }
        switch (this.policy) {
            case 0: 
            case 1: {
                return false;
            }
        }
        JCCellRange jCCellRange = (JCCellRange)this.selected_cells.lastElement();
        if (this.isLabel(jCCellRange.start_row, jCCellRange.start_column) && !this.isLabel(n2, n3)) {
            if (jCCellRange.start_row == -1) {
                n2 = -1;
            } else if (jCCellRange.start_column == -1) {
                n3 = -1;
            } else {
                return false;
            }
        }
        if (this.table.selectListeners != null) {
            JCSelectEvent jCSelectEvent = new JCSelectEvent(this.table, 2, jCCellRange.start_row, jCCellRange.start_column, n2, n3, 2);
            this.table.fireJCSelectEvent(jCSelectEvent);
            if (jCSelectEvent.isCancelled()) {
                return false;
            }
        }
        int n5 = jCCellRange.start_row;
        int n6 = jCCellRange.start_column;
        int n7 = jCCellRange.end_row;
        int n8 = jCCellRange.end_column;
        if (n7 < n5) {
            n4 = n5;
            n5 = n7;
            n7 = n4;
        }
        if (n8 < n6) {
            n4 = n6;
            n6 = n8;
            n8 = n4;
        }
        if (n2 == -1) {
            jCCellRange.end_column = n3;
        } else if (n3 == -1) {
            jCCellRange.end_row = n2;
        } else {
            jCCellRange.end_row = n2;
            jCCellRange.end_column = n3;
        }
        n5 = Math.min(n2, n5);
        n7 = Math.max(n2, n7);
        n6 = Math.min(n3, n6);
        n8 = Math.max(n3, n8);
        this.table.getCellAreaHandler().getCellAreaRenderer().repaintRange(n5, n6, n7, n8);
        return true;
    }

    public Collection getSelectedCells() {
        return this.selected_cells;
    }

    public boolean isSelected(int n2, int n3) {
        if (this.selected_cells == null) {
            return false;
        }
        for (int i2 = 0; i2 < this.selected_cells.size(); ++i2) {
            JCCellRange jCCellRange = (JCCellRange)this.selected_cells.elementAt(i2);
            if (!jCCellRange.inside(n2, n3)) continue;
            return true;
        }
        return false;
    }

    public boolean selectAll() {
        return this.setSelection(-1, -1, Integer.MAX_VALUE, Integer.MAX_VALUE);
    }

    public boolean setColumnSelection(int n2, int n3) {
        return this.setSelection(-1, n2, Integer.MAX_VALUE, n3);
    }

    public boolean setRowSelection(int n2, int n3) {
        return this.setSelection(n2, -1, n3, Integer.MAX_VALUE);
    }

    public boolean setSelection(int n2, int n3, int n4, int n5) {
        if (n2 == n4 && n2 == -1) {
            n4 = Integer.MAX_VALUE;
        }
        if (n3 == n5 && n3 == -1) {
            n5 = Integer.MAX_VALUE;
        }
        return this.setSelection(new JCCellRange(n2, n3, n4, n5));
    }

    public boolean setSelection(Collection collection) {
        if (this.selected_cells != null) {
            this.clearSelection(false);
        }
        boolean bl = true;
        Iterator iterator = collection.iterator();
        boolean bl2 = true;
        while (iterator.hasNext()) {
            JCCellRange jCCellRange = (JCCellRange)iterator.next();
            if (bl2) {
                if (!this.setSelection(jCCellRange)) {
                    bl = false;
                }
                bl2 = false;
                continue;
            }
            if (this.addSelection(jCCellRange)) continue;
            bl = false;
        }
        if (!bl) {
            this.clearWithNoNotification();
        }
        return bl;
    }

    public boolean setSelection(JCCellRange jCCellRange) {
        JCSelectEvent jCSelectEvent;
        switch (this.policy) {
            case 0: {
                return false;
            }
            case 1: {
                if (jCCellRange.start_row == jCCellRange.end_row && jCCellRange.start_column == jCCellRange.end_column) break;
                return false;
            }
        }
        if (this.table.selectListeners != null) {
            jCSelectEvent = new JCSelectEvent(this.table, 1, jCCellRange.start_row, jCCellRange.start_column, jCCellRange.end_row, jCCellRange.end_column, 0);
            this.table.fireJCSelectEvent(jCSelectEvent);
            if (jCSelectEvent.isCancelled()) {
                return false;
            }
        }
        if (this.selected_cells != null) {
            this.clearSelection(false);
            if (this.selected_cells != null) {
                return false;
            }
        }
        this.selected_cells = new Vector();
        this.selected_cells.addElement(jCCellRange);
        if (this.table.selectListeners != null) {
            jCSelectEvent = new JCSelectEvent(this.table, 2, jCCellRange.start_row, jCCellRange.start_column, jCCellRange.end_row, jCCellRange.end_column, 0);
            this.table.fireJCSelectEvent(jCSelectEvent);
            if (jCSelectEvent.isCancelled()) {
                this.selected_cells.removeElement(jCCellRange);
                return false;
            }
        }
        this.table.repaintSelected();
        return true;
    }

    public boolean select(int n2, int n3, int n4) {
        if (this.policy == 0) {
            return false;
        }
        if (n3 == -999 || n4 == -999) {
            return true;
        }
        if (n3 == this.last_selected_row && n4 == this.last_selected_column && n2 != 4) {
            return true;
        }
        if (n3 == -999 || n4 == -999) {
            return true;
        }
        boolean bl = false;
        int n5 = n3;
        int n6 = n4;
        JCCellRange jCCellRange = this.table.getSpanHandler().getSpannedRange(n3, n4);
        if (jCCellRange != null) {
            n3 = jCCellRange.start_row;
            n4 = jCCellRange.start_column;
            n5 = jCCellRange.end_row;
            n6 = jCCellRange.end_column;
        }
        if (n2 == 4) {
            this.last_selected_row = -999;
            this.last_selected_column = -999;
        } else {
            this.last_selected_row = n5;
            this.last_selected_column = n6;
        }
        switch (n2) {
            case 0: {
                bl = this.setSelection(n3, n4, n5, n6);
                break;
            }
            case 2: {
                bl = this.extendSelection(n3, n4);
                break;
            }
            case 1: {
                bl = this.addSelection(n3, n4, n5, n6);
                break;
            }
            case 4: {
                this.cleanup();
                if (this.table.selectListeners != null && this.selected_cells != null) {
                    JCCellRange jCCellRange2 = (JCCellRange)this.selected_cells.lastElement();
                    JCSelectEvent jCSelectEvent = new JCSelectEvent(this.table, 3, jCCellRange2.start_row, jCCellRange2.start_column, n3, n4, 4);
                    this.table.fireJCSelectEvent(jCSelectEvent);
                }
                bl = true;
            }
        }
        if (!bl) {
            this.last_selected_row = -999;
            this.last_selected_column = -999;
        }
        return bl;
    }

    protected void clearWithNoNotification() {
        this.selected_cells = null;
    }

    protected boolean isLabel(int n2, int n3) {
        return n2 == -1 || n3 == -1;
    }

    public void moveColumns(int n2, int n3, int n4) {
    }

    public void moveRows(int n2, int n3, int n4) {
    }

    public void remapColumns(int[] nArray) {
    }

    public void remapRows(int[] nArray) {
    }

    public void shiftColumn(int n2, int n3, int n4) {
    }

    public void shiftRow(int n2, int n3, int n4) {
    }

    public void swapColumns(int n2, int n3) {
    }

    public void swapRows(int n2, int n3) {
    }
}

