/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.table.CellLayoutModel;
import com.klg.jclass.table.JCTable;
import java.awt.Rectangle;
import java.io.Serializable;
import java.util.ConcurrentModificationException;
import java.util.List;
import java.util.ListIterator;
import java.util.Vector;

public class JCCellLayout
implements CellLayoutModel,
Serializable {
    protected JCTable table;
    protected int column_label_height;
    protected int row_label_width;
    protected Chain widths;
    protected Chain heights;

    public JCCellLayout() {
        this.resetRows();
        this.resetColumns();
    }

    public JCTable getTable() {
        return this.table;
    }

    public void setTable(JCTable jCTable) {
        this.table = jCTable;
    }

    public int getHeight(int n2) {
        if (n2 == -1) {
            return this.column_label_height;
        }
        return this.heights.getValue(n2);
    }

    public void setHeight(int n2, int n3) {
        if (n2 == -1) {
            this.column_label_height = n3;
        } else {
            this.heights.setValue(n2, n2, n3);
        }
    }

    public void setHeight(int n2, int n3, int n4) {
        this.heights.setValue(n2, n3, n4);
    }

    public int getWidth(int n2) {
        if (n2 == -1) {
            return this.row_label_width;
        }
        return this.widths.getValue(n2);
    }

    public void setWidth(int n2, int n3) {
        if (n2 == -1) {
            this.row_label_width = n3;
        } else {
            this.widths.setValue(n2, n2, n3);
        }
    }

    public void setWidth(int n2, int n3, int n4) {
        this.widths.setValue(n2, n3, n4);
    }

    public int getColumn(int n2, int n3) {
        if (n2 < this.row_label_width) {
            return -1;
        }
        return this.widths.getIndex(n2 - this.row_label_width);
    }

    public int getRow(int n2, int n3) {
        if (n3 < this.column_label_height) {
            return -1;
        }
        return this.heights.getIndex(n3 - this.column_label_height);
    }

    public int getColumnPosition(int n2) {
        if (n2 == -1) {
            return 0;
        }
        return this.row_label_width + this.widths.getSum(n2);
    }

    public int getRowPosition(int n2) {
        if (n2 == -1) {
            return 0;
        }
        return this.column_label_height + this.heights.getSum(n2);
    }

    public Rectangle getBounds(int n2, int n3) {
        return this.getBounds(n2, n3, new Rectangle());
    }

    public Rectangle getBounds(int n2, int n3, Rectangle rectangle) {
        rectangle.setBounds(this.getColumnPosition(n3), this.getRowPosition(n2), this.getWidth(n3), this.getHeight(n2));
        return rectangle;
    }

    public Rectangle getBounds(int n2, int n3, int n4, int n5) {
        return this.getBounds(n2, n3, n4, n5, new Rectangle());
    }

    public Rectangle getBounds(int n2, int n3, int n4, int n5, Rectangle rectangle) {
        int n6 = this.getColumnPosition(n3);
        int n7 = this.getRowPosition(n2);
        rectangle.setBounds(n6, n7, this.getColumnPosition(n5) + this.getWidth(n5) - n6, this.getRowPosition(n4) + this.getHeight(n4) - n7);
        return rectangle;
    }

    public void moveRows(int n2, int n3, int n4) {
        this.table.requestChange(16);
    }

    public void moveColumns(int n2, int n3, int n4) {
        this.table.requestChange(32);
    }

    public void addRows(int n2, int n3) {
        this.table.requestChange(16);
    }

    public void addColumns(int n2, int n3) {
        this.table.requestChange(32);
    }

    public void deleteRows(int n2, int n3) {
        this.table.requestChange(16);
    }

    public void deleteColumns(int n2, int n3) {
        this.table.requestChange(32);
    }

    public void remapRows(int[] nArray, int[] nArray2) {
        this.resetRows();
        this.table.requestChange(16);
    }

    public void remapColumns(int[] nArray, int[] nArray2) {
        this.resetColumns();
        this.table.requestChange(32);
    }

    public void resetRows() {
        this.heights = new Chain();
    }

    public void resetColumns() {
        this.widths = new Chain();
    }

    public static void main(String[] stringArray) {
        String[] stringArray2 = new String[]{"cellLayout"};
        JCCellLayout jCCellLayout = new JCCellLayout();
        Chain chain = jCCellLayout.widths;
        chain.setValue(0, 9, 97);
        chain.setValue(10, 21, 98);
        System.out.println("layout:" + chain.toString());
        chain.setValue(22, 35, 99);
        System.out.println("layout:" + chain.toString());
        chain.setValue(2, 5, 100);
        System.out.println("layout:" + chain.toString());
        chain.setValue(2, 2, 101);
        System.out.println("layout:" + chain.toString());
        chain.setValue(3, 3, 101);
        System.out.println("layout:" + chain.toString());
        chain.setValue(9, 9, 98);
        System.out.println("layout:" + chain.toString());
        chain.setValue(14, 14, 103);
        System.out.println("layout:" + chain.toString());
        chain.setValue(1, 8, 104);
        System.out.println("layout:" + chain.toString());
        chain.setValue(9, 12, 104);
        System.out.println("layout:" + chain.toString());
        chain.setValue(1, 14, 97);
        System.out.println("layout:" + chain.toString());
        chain.setValue(3, 29, 98);
        System.out.println("layout:" + chain.toString());
        jCCellLayout.resetColumns();
        chain = jCCellLayout.widths;
        chain.setValue(0, 9, 97);
        chain.setValue(2, 5, 100);
        System.out.println("layout:" + chain.toString());
        chain.setValue(10, 21, 98);
        chain.setValue(2, 2, 101);
        chain.setValue(3, 3, 101);
        chain.setValue(9, 9, 98);
        chain.setValue(14, 14, 103);
        System.out.println("layout:" + chain.toString());
        chain.setValue(1, 8, 104);
        System.out.println("layout:" + chain.toString());
        chain.setValue(9, 17, 104);
        System.out.println("layout:" + chain.toString());
        chain.setValue(1, 14, 97);
        System.out.println("layout:" + chain.toString());
        chain.setValue(22, 28, 99);
        System.out.println("layout:" + chain.toString());
        chain.setValue(20, 35, 100);
        System.out.println("layout:" + chain.toString());
        chain.setValue(27, 40, 101);
        System.out.println("layout:" + chain.toString());
        chain.setValue(15, 26, 98);
        System.out.println("layout:" + chain.toString());
        chain.setValue(0, 40, 100);
        System.out.println("layout:" + chain.toString());
    }

    public class Run
    implements Serializable {
        protected int value;
        protected int start;
        protected int end;

        public Run(int n2, int n3, int n4) {
            this.start = n2;
            this.end = n3;
            this.value = n4;
        }

        public String toString() {
            return "Run(start=" + this.start + ", end=" + this.end + ", value=" + this.value + ")";
        }

        public boolean equals(Object object) {
            if (!(object instanceof Run)) {
                return false;
            }
            Run run = (Run)object;
            return this.start == run.start && this.end == run.end && this.value == run.value;
        }

        public int hashCode() {
            int n2 = 17;
            n2 = 37 * n2 + this.start;
            n2 = 37 * n2 + this.end;
            n2 = 37 * n2 + this.value;
            return n2;
        }
    }

    public class Chain
    implements Serializable {
        protected List list = new Vector();
        protected int defaultValue = 0;

        public int getValue(int n2) {
            ListIterator listIterator = this.list.listIterator();
            int n3 = this.defaultValue;
            try {
                while (listIterator.hasNext()) {
                    Run run = (Run)listIterator.next();
                    if (n2 > run.end) continue;
                    n3 = run.value;
                    break;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                return this.defaultValue;
            }
            return n3;
        }

        public int getSum(int n2) {
            int n3 = 0;
            ListIterator listIterator = this.list.listIterator();
            try {
                while (listIterator.hasNext()) {
                    Run run = (Run)listIterator.next();
                    if (n2 > run.end) {
                        n3 += run.value * (run.end - run.start + 1);
                        continue;
                    }
                    n3 += run.value * (n2 - run.start);
                    break;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                return 0;
            }
            return n3;
        }

        public int getIndex(int n2) {
            ListIterator listIterator = this.list.listIterator();
            Run run = null;
            try {
                while (listIterator.hasNext()) {
                    run = (Run)listIterator.next();
                    if (run.value <= 0) continue;
                    int n3 = run.value * (run.end - run.start + 1);
                    if (n3 <= n2) {
                        n2 -= n3;
                        continue;
                    }
                    int n4 = n2 / run.value;
                    int n5 = run.start + n4;
                    return n5;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                return 0;
            }
            if (run != null) {
                return run.end;
            }
            return -1;
        }

        public void setValue(int n2, int n3) {
            this.setValue(n2, n2, n3);
        }

        public void setValue(int n2, int n3, int n4) {
            ListIterator listIterator = this.list.listIterator();
            Run run = null;
            boolean bl = false;
            while (listIterator.hasNext()) {
                boolean bl2;
                boolean bl3;
                run = (Run)listIterator.next();
                if (n2 > run.end) continue;
                if (n3 <= run.end) {
                    boolean bl4;
                    if (n4 == run.value) {
                        bl = true;
                        break;
                    }
                    boolean bl5 = n2 > run.start;
                    boolean bl6 = bl4 = n3 < run.end;
                    if (bl5 && bl4) {
                        this.splitLeftAndRight(listIterator, run, run, n2, n3, n4);
                    } else if (bl5) {
                        this.splitLeft(listIterator, run, run, n2, n3, n4);
                    } else if (bl4) {
                        this.splitRight(listIterator, run, run, n2, n3, n4);
                    } else {
                        run.value = n4;
                    }
                    bl = true;
                    break;
                }
                Run run2 = run;
                boolean bl7 = bl3 = n2 > run2.start;
                while (listIterator.hasNext()) {
                    run = (Run)listIterator.next();
                    if (run.end >= n3) break;
                    listIterator.remove();
                    run = run2;
                }
                boolean bl8 = bl2 = n3 < run.end;
                if (bl3 && bl2) {
                    this.splitLeftAndRight(listIterator, run2, run, n2, n3, n4);
                } else if (bl3) {
                    this.splitLeft(listIterator, run2, run, n2, n3, n4);
                } else if (bl2) {
                    this.splitRight(listIterator, run2, run, n2, n3, n4);
                } else {
                    if (run2 != run) {
                        run2.end = run.start - 1;
                    }
                    run2.value = n4;
                    run.value = n4;
                }
                bl = true;
                break;
            }
            if (!bl) {
                this.list.add(new Run(n2, n3, n4));
            }
            this.mergeRuns();
        }

        protected void splitLeftAndRight(ListIterator listIterator, Run run, Run run2, int n2, int n3, int n4) {
            Run run3 = new Run(n2, n3, n4);
            Run run4 = null;
            if (run == run2) {
                run4 = new Run(n3 + 1, run2.end, run2.value);
            } else {
                run2.start = n3 + 1;
            }
            run.end = n2 - 1;
            if (run4 == null) {
                listIterator.previous();
            }
            listIterator.add(run3);
            if (run4 != null) {
                listIterator.add(run4);
            }
        }

        protected void splitLeft(ListIterator listIterator, Run run, Run run2, int n2, int n3, int n4) {
            Run run3 = null;
            if (run == run2) {
                run3 = new Run(n2, n3, n4);
            } else {
                run2.start = n2;
                run2.value = n4;
            }
            run.end = n2 - 1;
            if (run3 != null) {
                listIterator.add(run3);
            }
        }

        protected void splitRight(ListIterator listIterator, Run run, Run run2, int n2, int n3, int n4) {
            Run run3 = null;
            if (run == run2) {
                run3 = new Run(n3 + 1, run2.end, run2.value);
            } else {
                run2.start = n3 + 1;
            }
            run.end = n3;
            run.value = n4;
            if (run3 != null) {
                listIterator.add(run3);
            }
        }

        protected void mergeRuns() {
            List list = this.list;
            ListIterator listIterator = list.listIterator();
            Run run = null;
            Run run2 = null;
            if (listIterator.hasNext()) {
                run2 = (Run)listIterator.next();
            }
            while (listIterator.hasNext()) {
                run = (Run)listIterator.next();
                if (run2.value == run.value) {
                    run2.end = run.end;
                    listIterator.remove();
                    continue;
                }
                run2 = run;
            }
        }

        public String toString() {
            return this.list.toString();
        }

        public boolean equals(Object object) {
            if (object == this) {
                return true;
            }
            if (!(object instanceof Chain)) {
                return false;
            }
            Chain chain = (Chain)object;
            return ((Object)chain.list).equals(this.list);
        }

        public int hashcode() {
            return ((Object)this.list).hashCode();
        }
    }
}

