/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.cell.JCCellEditor;
import com.klg.jclass.cell.JCCellEditorEvent;
import com.klg.jclass.cell.JCCellEditorListener;
import com.klg.jclass.table.CellArea;
import com.klg.jclass.table.CellAreaHandler;
import com.klg.jclass.table.CellAreaRenderer;
import com.klg.jclass.table.EditTraverseHandler;
import com.klg.jclass.table.FocusModel;
import com.klg.jclass.table.JCCellPosition;
import com.klg.jclass.table.JCCellRange;
import com.klg.jclass.table.JCEditCellEvent;
import com.klg.jclass.table.JCTable;
import com.klg.jclass.table.JCTraverseCellEvent;
import com.klg.jclass.table.TableCellInfoModel;
import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Container;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.KeyEvent;
import java.awt.event.KeyListener;
import java.io.Serializable;
import javax.swing.JComponent;

public abstract class EditTraverseHandlerAbstract
implements EditTraverseHandler,
FocusListener,
JCCellEditorListener,
Serializable {
    protected JCTable table;
    protected JCCellEditor editor;
    protected Component component;
    protected int edit_row;
    protected int edit_column;
    protected boolean outsideTable = false;

    public EditTraverseHandlerAbstract(JCTable jCTable) {
        this.table = jCTable;
    }

    public JCCellEditor getCellEditor() {
        return this.editor;
    }

    protected void addKeyAndFocusListeners(Component component, KeyListener keyListener, FocusListener focusListener) {
        if (component == null) {
            return;
        }
        component.removeKeyListener(keyListener);
        component.addKeyListener(keyListener);
        component.removeFocusListener(focusListener);
        component.addFocusListener(focusListener);
    }

    protected abstract void addListeners(Component var1, KeyListener var2, FocusListener var3);

    public void setCellEditor(JCCellEditor jCCellEditor) {
        if (jCCellEditor != null) {
            this.component = jCCellEditor.getComponent();
            if (this.component != null) {
                this.addListeners(this.component, this.table.keyHandler, this);
            }
            jCCellEditor.addCellEditorListener(this);
        } else {
            if (this.editor != null) {
                this.editor.removeCellEditorListener(this);
            }
            if (this.component != null) {
                this.component.removeKeyListener(this.table.keyHandler);
            }
            this.component = null;
        }
        this.editor = jCCellEditor;
        this.edit_row = this.table.getCurrentRow();
        this.edit_column = this.table.getCurrentColumn();
    }

    public int getEditRow() {
        return this.edit_row;
    }

    public int getEditColumn() {
        return this.edit_column;
    }

    public void initializeEditor(AWTEvent aWTEvent, TableCellInfoModel tableCellInfoModel, Object object) {
        this.editor.initialize(aWTEvent, tableCellInfoModel, object);
    }

    public boolean traverse(int n2, int n3, boolean bl, AWTEvent aWTEvent, int n4, boolean bl2) {
        Serializable serializable;
        if (n2 == -999 || n3 == -999) {
            return false;
        }
        if (aWTEvent != null && aWTEvent instanceof KeyEvent && ((KeyEvent)(serializable = (KeyEvent)aWTEvent)).getKeyCode() == 16) {
            return false;
        }
        serializable = this.table.getSpannedRange(n2, n3);
        if (serializable != null) {
            n2 = ((JCCellRange)serializable).start_row;
            n3 = ((JCCellRange)serializable).start_column;
        }
        if (!this.traverseInitial(n2, n3, bl, n4)) {
            return false;
        }
        n2 = this.table.getCurrentRow();
        Component component = this.table.getComponent(n2, n3 = this.table.getCurrentColumn());
        if (component != null) {
            this.table.getFocusManager().requestFocus(component);
            this.table.setCurrentCell(n2, n3);
            return true;
        }
        if (aWTEvent == null && bl2) {
            this.table.clearSelectedCells();
        }
        if (this.table.auto_edit) {
            bl2 = true;
        }
        if (!this.table.getDataView().isEditable() || !this.table.getCellStyle(n2, n3).isEditable()) {
            bl2 = false;
        }
        if (bl2) {
            JCEditCellEvent jCEditCellEvent = null;
            if (this.table.editCellListeners != null) {
                jCEditCellEvent = new JCEditCellEvent(this.table, 1, n2, n3);
                this.table.fireJCEditCellEvent(jCEditCellEvent);
                if (jCEditCellEvent.isCancelled()) {
                    jCEditCellEvent.type = 3;
                    this.table.fireJCEditCellEvent(jCEditCellEvent);
                    return false;
                }
            }
            JCCellEditor jCCellEditor = this.table.getDataView().getCellEditor(n2, n3);
            if (this.editor != null && this.editor != jCCellEditor) {
                this.cancel();
            }
            Object object = this.table.getDataView().getTableDataItem(n2, n3);
            this.setCellEditor(jCCellEditor);
            CellAreaHandler cellAreaHandler = this.table.getCellAreaHandler();
            TableCellInfoModel tableCellInfoModel = cellAreaHandler.getTableCellInfo();
            tableCellInfoModel.initialize(this.table, object, n2, n3);
            if (this.editor != null) {
                Rectangle rectangle = cellAreaHandler.getBounds(n2, n3);
                this.initializeEditor(aWTEvent, tableCellInfoModel, object);
                if (this.component != null) {
                    this.component.setVisible(false);
                    CellArea cellArea = cellAreaHandler.find(n2, n3);
                    if (this.component.getParent() != this.table) {
                        if (this.component instanceof JComponent) {
                            ((JComponent)this.component).setBorder(null);
                        }
                        cellArea.add(this.component, 0);
                    }
                    if (this.setValues(cellArea, n2, n3, rectangle) && this.component != null) {
                        this.component.setVisible(true);
                        this.setFocusOnEditor(this.component);
                    }
                }
            }
            if (jCEditCellEvent != null) {
                jCEditCellEvent.type = 2;
                jCEditCellEvent.editComponent = this.component;
                this.table.fireJCEditCellEvent(jCEditCellEvent);
            }
        }
        return true;
    }

    public void traverseInitial() {
        int n2 = 0;
        int n3 = 0;
        if (this.table.isTraversable(n2, n3)) {
            this.traverseInitial(n2, n3, false, 11);
        } else {
            JCCellPosition jCCellPosition = this.table.keyHandler.findTraversableCell(4, n2, n3);
            if (jCCellPosition == null) {
                return;
            }
            this.traverseInitial(jCCellPosition.row, jCCellPosition.column, false, 11);
        }
    }

    protected boolean traverseInitial(int n2, int n3, boolean bl, int n4) {
        Serializable serializable;
        if (n2 < 0 || n2 >= this.table.getNumRows() || n3 < 0 || n3 >= this.table.getNumColumns()) {
            return false;
        }
        if (!this.table.getCellStyle(n2, n3).isTraversable()) {
            return false;
        }
        CellAreaRenderer cellAreaRenderer = this.table.getCellAreaHandler().getCellAreaRenderer();
        int n5 = this.table.current_row;
        int n6 = this.table.current_column;
        this.table.current_row = n2;
        this.table.current_column = n3;
        if (this.isValidCell(n5, n6) && (n5 != n2 || n6 != n3)) {
            serializable = this.table.getComponent(n5, n6);
            if (serializable != null) {
                this.table.getFocusManager().requestFocus();
            }
            cellAreaRenderer.repaintCell(n5, n6, true);
        }
        if (bl) {
            this.table.setSelection(n2, n3, n2, n3);
        }
        if (!this.table.makeVisible(n2, n3)) {
            return false;
        }
        serializable = null;
        if (this.table.traverseListeners != null) {
            serializable = new JCTraverseCellEvent(this.table, 1, n5, n6, n2, n3, n4);
            this.table.fireJCTraverseCellEvent((JCTraverseCellEvent)serializable);
            if (((JCTraverseCellEvent)serializable).isCancelled()) {
                ((JCTraverseCellEvent)serializable).next_row = n5;
                ((JCTraverseCellEvent)serializable).next_column = n6;
            }
            n2 = ((JCTraverseCellEvent)serializable).next_row;
            n3 = ((JCTraverseCellEvent)serializable).next_column;
            this.table.current_row = n2;
            this.table.current_column = n3;
        }
        cellAreaRenderer.repaintCell(n2, n3);
        if (serializable != null) {
            ((JCTraverseCellEvent)serializable).type = 2;
            this.table.fireJCTraverseCellEvent((JCTraverseCellEvent)serializable);
        }
        return serializable == null || !((JCTraverseCellEvent)serializable).isCancelled();
    }

    protected boolean isValidCell(int n2, int n3) {
        return n2 >= -1 && n2 < this.table.getNumRows() && n3 >= -1 && n3 < this.table.getNumColumns();
    }

    protected boolean setValues(int n2, int n3, Rectangle rectangle) {
        CellArea cellArea = this.table.getCellAreaHandler().find(n2, n3);
        return this.setValues(cellArea, n2, n3, rectangle);
    }

    protected boolean setValues(CellArea cellArea, int n2, int n3, Rectangle rectangle) {
        int n4;
        if (cellArea == null || this.editor == null) {
            return false;
        }
        if (this.component == null) {
            return true;
        }
        int n5 = this.table.getEditHeightPolicy();
        int n6 = this.table.getEditWidthPolicy();
        int n7 = Math.max(rectangle.width, 10);
        int n8 = Math.max(rectangle.height, 10);
        int n9 = this.table.getCellBorderWidth() > 0 ? 1 : 0;
        int n10 = this.table.cellAreaHandler.determineThinSides(n2, n3);
        boolean bl = (n10 & 0x10) > 0;
        boolean bl2 = (n10 & 0x20) > 0;
        switch (n6) {
            case 1: {
                if (this.component.getMinimumSize().width <= n7) break;
                n7 = this.component.getMinimumSize().width + (bl ? 2 * n9 : n9);
                break;
            }
            case 2: {
                if (this.component.getPreferredSize().width <= n7) break;
                n7 = this.component.getPreferredSize().width + (bl ? 2 * n9 : n9);
            }
        }
        switch (n5) {
            case 1: {
                if (this.component.getMinimumSize().height <= n8) break;
                n8 = this.component.getMinimumSize().height;
                break;
            }
            case 2: {
                if (this.component.getPreferredSize().height <= n8) break;
                n8 = this.component.getPreferredSize().height;
            }
        }
        if (cellArea.isHorizontalScrollable()) {
            rectangle.x += this.table.cellAreaHandler.cellOrigin.x;
        }
        if (cellArea.isVerticalScrollable()) {
            rectangle.y += this.table.cellAreaHandler.cellOrigin.y;
        }
        if (n7 + (n4 = rectangle.x - cellArea.getX()) > cellArea.getWidth()) {
            n7 = cellArea.getWidth() - n4;
        }
        this.component.setBounds(n4 + n9, rectangle.y + n9 - cellArea.getY(), n7 - (bl ? 2 * n9 : n9), n8 - (bl2 ? 2 * n9 : n9));
        return true;
    }

    public void checkAndReparentEditor() {
        CellArea cellArea;
        if (this.component != null && (cellArea = this.table.getCellAreaHandler().find(this.edit_row, this.edit_column)) != this.component.getParent()) {
            cellArea.add(this.component, 0);
        }
    }

    public void setWidth(int n2) {
        Rectangle rectangle = this.table.getCellAreaHandler().getBounds(this.edit_row, this.edit_column);
        rectangle.width = n2;
        this.setValues(this.edit_row, this.edit_column, rectangle);
    }

    public void setHeight(int n2) {
        Rectangle rectangle = this.table.getCellAreaHandler().getBounds(this.edit_row, this.edit_column);
        rectangle.height = n2;
        this.setValues(this.edit_row, this.edit_column, rectangle);
    }

    public void repositionEditor() {
        if (this.editor == null || this.component == null) {
            return;
        }
        Rectangle rectangle = this.table.getCellAreaHandler().getBounds(this.edit_row, this.edit_column);
        this.setValues(this.edit_row, this.edit_column, rectangle);
    }

    public void move(int n2, int n3) {
        if (this.component == null) {
            return;
        }
        CellArea cellArea = this.table.getCellAreaHandler().find(this.edit_row, this.edit_column);
        if (cellArea != null) {
            if (n2 == 0) {
                if (cellArea.getType() == 3) {
                    return;
                }
                if (cellArea.getType() == 4 && this.edit_column < this.table.getFrozenColumns()) {
                    return;
                }
            } else if (n2 == 1) {
                if (cellArea.getType() == 1) {
                    return;
                }
                if (cellArea.getType() == 4 && this.edit_row < this.table.getFrozenRows()) {
                    return;
                }
            }
        }
        switch (n2) {
            case 1: {
                int n4 = this.component.getLocation().x;
                int n5 = this.component.getLocation().y - n3;
                this.component.setLocation(n4, n5);
                break;
            }
            case 0: {
                int n6 = this.component.getLocation().x - n3;
                int n7 = this.component.getLocation().y;
                this.component.setLocation(n6, n7);
            }
        }
    }

    protected void signalError() {
        if (this.component == null || !this.component.isVisible()) {
            Toolkit.getDefaultToolkit().beep();
            return;
        }
        Toolkit.getDefaultToolkit().beep();
    }

    protected boolean cancel() {
        return this.cancel(true);
    }

    public boolean cancel(boolean bl) {
        if (this.editor == null) {
            return true;
        }
        if (this.table.editCellListeners != null) {
            JCEditCellEvent jCEditCellEvent = new JCEditCellEvent(this.table, 3, this.edit_row, this.edit_column);
            this.table.fireJCEditCellEvent(jCEditCellEvent);
        }
        this.editor.cancelCellEditing();
        this.editor.removeCellEditorListener(this);
        if (bl) {
            this.removeEditor();
        }
        return true;
    }

    protected boolean commit() {
        return this.commit(true);
    }

    public boolean commit(boolean bl) {
        return this.commit(bl, true);
    }

    protected boolean commit(boolean bl, boolean bl2) {
        if (this.editor == null) {
            return true;
        }
        if (bl2) {
            boolean bl3 = this.editor.isModified();
            if (!this.editor.stopCellEditing()) {
                this.signalError();
                return false;
            }
            if (!bl3) {
                if (bl) {
                    this.removeEditor();
                    if (this.table.editCellListeners != null) {
                        JCEditCellEvent jCEditCellEvent = new JCEditCellEvent(this.table, 3, this.edit_row, this.edit_column);
                        this.table.fireJCEditCellEvent(jCEditCellEvent);
                    }
                }
                return true;
            }
        }
        Object object = this.editor.getCellEditorValue();
        if (this.table.getDataView().setTableDataItem(object, this.edit_row, this.edit_column)) {
            if (bl) {
                this.removeEditor();
                if (this.table.editCellListeners != null) {
                    JCEditCellEvent jCEditCellEvent = new JCEditCellEvent(this.table, 3, this.edit_row, this.edit_column);
                    this.table.fireJCEditCellEvent(jCEditCellEvent);
                }
            }
            return true;
        }
        this.signalError();
        this.setFocusOnEditor(this.component);
        return false;
    }

    protected void commitAndTraverse(int n2) {
        if (this.commit()) {
            this.table.getFocusManager().requestFocus();
            this.table.keyHandler.traverse(n2);
        }
    }

    protected void removeEditor() {
        if (this.component != null) {
            this.component.setVisible(false);
        }
        this.setCellEditor(null);
        if (!this.outsideTable) {
            this.table.getFocusManager().requestFocus();
        }
    }

    public void editingStopped(JCCellEditorEvent jCCellEditorEvent) {
        AWTEvent aWTEvent;
        AWTEvent aWTEvent2 = aWTEvent = jCCellEditorEvent == null ? null : jCCellEditorEvent.getEvent();
        if (aWTEvent instanceof KeyEvent) {
            ((KeyEvent)aWTEvent).consume();
        }
        if (this.editor != null && this.table.getCurrentRow() == this.edit_row && this.table.getCurrentColumn() == this.edit_column) {
            this.outsideTable = this.isOutsideTable(aWTEvent);
            if (this.commit() && !this.outsideTable) {
                this.table.getFocusManager().requestFocus();
            }
            this.outsideTable = false;
        }
    }

    protected abstract boolean isOutsideTable(AWTEvent var1);

    public void editingCanceled(JCCellEditorEvent jCCellEditorEvent) {
        if (this.editor != null && this.table.getCurrentRow() == this.edit_row && this.table.getCurrentColumn() == this.edit_column) {
            this.outsideTable = this.isOutsideTable(jCCellEditorEvent == null ? null : jCCellEditorEvent.getEvent());
            this.cancel(true);
            if (!this.outsideTable) {
                this.table.getFocusManager().requestFocus();
            }
            this.outsideTable = false;
        }
    }

    public Component getFocusableChild(Component component) {
        if (component != null && !this.table.getFocusManager().isFocusTraversable(component)) {
            Component[] componentArray = ((Container)component).getComponents();
            for (int i2 = 0; i2 < componentArray.length; ++i2) {
                if (!this.table.getFocusManager().isFocusTraversable(componentArray[i2])) continue;
                component = componentArray[i2];
                break;
            }
        }
        return component;
    }

    public void setFocusOnEditor() {
        if (this.component != null) {
            this.setFocusOnEditor(this.component);
        }
    }

    protected void setFocusOnEditor(Component component) {
        if (component == null) {
            return;
        }
        FocusModel focusModel = this.table.getFocusManager();
        if (focusModel.isFocusTraversable(component)) {
            focusModel.requestFocus(component);
        } else {
            Component component2 = this.getFocusableChild(component);
            if (component2 != component) {
                focusModel.requestFocus(component2);
            }
        }
    }

    public abstract void focusGained(FocusEvent var1);

    public abstract void focusLost(FocusEvent var1);
}

