/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.table;

import com.klg.jclass.table.CellArea;
import com.klg.jclass.table.CellAreaHandler;
import com.klg.jclass.table.EditTraverseHandler;
import com.klg.jclass.table.JCScrollEvent;
import com.klg.jclass.table.JCTable;
import java.awt.Adjustable;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.io.Serializable;
import javax.swing.JLabel;
import javax.swing.JScrollBar;

public class AdjustmentHandler
implements AdjustmentListener,
Serializable {
    protected JCTable table;
    protected boolean isTracking = false;
    protected JLabel trackLabel = new JLabel();
    private int vertLastRow = -1;
    private int vertLastValue = -1;
    private int vertLastRealValue = -1;
    private int horLastColumn = -1;
    private int horLastValue = -1;
    private int horLastRealValue = -1;

    public AdjustmentHandler(JCTable jCTable) {
        this.table = jCTable;
        this.trackLabel.setOpaque(true);
        this.trackLabel.setVisible(false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
        if (!this.table.isRepaintEnabled()) {
            this.table.setRecalcRequired(true);
            return;
        }
        Adjustable adjustable = adjustmentEvent.getAdjustable();
        CellAreaHandler cellAreaHandler = this.table.getCellAreaHandler();
        EditTraverseHandler editTraverseHandler = this.table.getEditTraverseHandler();
        int n2 = adjustmentEvent.getValue();
        JCScrollEvent jCScrollEvent = null;
        int n3 = this.table.getJumpScroll();
        if (adjustable.getOrientation() == 1) {
            Rectangle rectangle;
            int n4;
            int n5;
            int n6;
            Serializable serializable;
            int n7 = cellAreaHandler.getCellOrigin().y;
            int n8 = -cellAreaHandler.getCellOrigin().y;
            if (n2 == n8 && !this.isTracking) {
                return;
            }
            boolean bl = false;
            if ((n3 == 2 || n3 == 3) && n2 != this.vertLastValue) {
                serializable = this;
                synchronized (serializable) {
                    n6 = cellAreaHandler.getCellArea().getStandardOffsetY();
                    n5 = this.table.getCellLayout().getRow(0, n2 + n6);
                    if (n5 == this.vertLastRow) {
                        n5 += n2 > this.vertLastValue ? 1 : -1;
                    }
                    if (adjustable instanceof JScrollBar && ((JScrollBar)adjustable).getValueIsAdjusting() && (n2 > this.vertLastRealValue && n5 < this.vertLastRow || n2 < this.vertLastRealValue && n5 > this.vertLastRow)) {
                        n5 = this.vertLastRow;
                    }
                    this.vertLastRealValue = n2;
                    n2 = this.table.getCellLayout().getRowPosition(n5) - n6;
                    if (n2 > (n4 = adjustable.getMaximum() - adjustable.getVisibleAmount())) {
                        n2 = n4;
                    }
                    this.vertLastRow = n5;
                    this.vertLastValue = n2;
                    if (n2 != this.vertLastRealValue) {
                        bl = true;
                    }
                }
            }
            if (this.table.scrollListeners != null && n2 != n8) {
                jCScrollEvent = new JCScrollEvent(this, 1, adjustable, adjustable.getOrientation(), n2, adjustmentEvent);
                this.table.fireJCScrollEvent(jCScrollEvent);
                if (jCScrollEvent.getValue() != n2) {
                    adjustable.setValue(jCScrollEvent.value);
                    return;
                }
            }
            cellAreaHandler.cellOrigin.y = -n2;
            if (bl) {
                adjustable.setValue(n2);
            }
            if (((JScrollBar)(serializable = (JScrollBar)adjustmentEvent.getSource())).getValueIsAdjusting()) {
                if (this.table.getVertSBTrack() != 0) {
                    if (this.isTracking) {
                        n6 = this.table.getVisibleCells().start_row;
                        String string = "";
                        if (this.table.getVertSBTrack() == 1) {
                            string = Integer.toString(n6 + 1);
                        } else {
                            n4 = this.table.getVertSBTrackColumn();
                            Object object = this.table.getDataView().getObject(n6, n4);
                            string = object == null || object.toString() == null ? "" : object.toString();
                        }
                        if (!this.trackLabel.isVisible()) {
                            this.trackLabel.setVisible(true);
                        }
                        this.trackLabel.setText(string);
                    } else {
                        CellArea cellArea = this.getRightCellArea();
                        cellArea.add((Component)this.trackLabel, 0);
                        this.table.getFocusManager().requestFocus(this.trackLabel);
                        n5 = 50;
                        n4 = 20;
                        Dimension dimension = this.table.getTrackSize();
                        if (dimension != null) {
                            n5 = dimension.width;
                            n4 = dimension.height;
                        }
                        this.trackLabel.setBounds(cellArea.getWidth() - n5, (cellArea.getHeight() - n4) / 2, n5, n4);
                        this.trackLabel.setHorizontalAlignment(4);
                        if (this.table.getTrackBackground() != null) {
                            this.trackLabel.setBackground(this.table.getTrackBackground());
                        }
                        if (this.table.getTrackForeground() != null) {
                            this.trackLabel.setForeground(this.table.getTrackForeground());
                        }
                        this.trackLabel.setText("");
                        this.isTracking = true;
                    }
                    jCScrollEvent = new JCScrollEvent(this, 2, adjustable, adjustable.getOrientation(), n2, adjustmentEvent);
                    this.table.fireJCScrollEvent(jCScrollEvent);
                    return;
                }
            } else if (this.isTracking) {
                this.isTracking = false;
                this.trackLabel.setVisible(false);
                editTraverseHandler.setFocusOnEditor();
                JCScrollEvent jCScrollEvent2 = null;
                jCScrollEvent2 = new JCScrollEvent(this, 2, adjustable, adjustable.getOrientation(), n2, adjustmentEvent);
                this.table.fireJCScrollEvent(jCScrollEvent2);
                this.table.layoutAreas();
            }
            if (editTraverseHandler.getCellEditor() != null) {
                editTraverseHandler.move(1, n7 + n2);
            }
            if (!this.table.mouseHandler.isResizing() && (rectangle = this.table.cellAreaHandler.cellRect) != null) {
                this.table.repaint(0, rectangle.y, this.table.getSize().width, rectangle.height);
            }
        } else {
            Rectangle rectangle;
            int n9;
            int n10;
            int n11;
            Serializable serializable;
            int n12 = cellAreaHandler.getCellOrigin().x;
            int n13 = -cellAreaHandler.getCellOrigin().x;
            if (n2 == n13 && !this.isTracking) {
                return;
            }
            boolean bl = false;
            if ((n3 == 1 || n3 == 3) && n2 != this.horLastValue) {
                serializable = this;
                synchronized (serializable) {
                    n11 = cellAreaHandler.getCellArea().getStandardOffsetX();
                    n10 = this.table.getCellLayout().getColumn(n2 + n11, 0);
                    if (n10 == this.horLastColumn) {
                        n10 += n2 > this.horLastValue ? 1 : -1;
                    }
                    if (adjustable instanceof JScrollBar && ((JScrollBar)adjustable).getValueIsAdjusting() && (n2 > this.horLastRealValue && n10 < this.horLastColumn || n2 < this.horLastRealValue && n10 > this.horLastColumn)) {
                        n10 = this.horLastColumn;
                    }
                    this.horLastRealValue = n2;
                    n2 = this.table.getCellLayout().getColumnPosition(n10) - n11;
                    if (n2 > (n9 = adjustable.getMaximum() - adjustable.getVisibleAmount())) {
                        n2 = n9;
                    }
                    this.horLastColumn = n10;
                    this.horLastValue = n2;
                    if (n2 != this.horLastRealValue) {
                        bl = true;
                    }
                }
            }
            if (this.table.scrollListeners != null && n2 != n13) {
                jCScrollEvent = new JCScrollEvent(this, 1, adjustable, adjustable.getOrientation(), n2, adjustmentEvent);
                this.table.fireJCScrollEvent(jCScrollEvent);
                if (jCScrollEvent.getValue() != n2) {
                    adjustable.setValue(jCScrollEvent.value);
                    return;
                }
            }
            cellAreaHandler.cellOrigin.x = -n2;
            if (bl) {
                adjustable.setValue(n2);
            }
            if (((JScrollBar)(serializable = (JScrollBar)adjustmentEvent.getSource())).getValueIsAdjusting()) {
                if (this.table.getHorizSBTrack() != 0) {
                    if (this.isTracking) {
                        n11 = this.table.getVisibleCells().start_column;
                        String string = "";
                        if (this.table.getHorizSBTrack() == 1) {
                            string = Integer.toString(n11 + 1);
                        } else {
                            n9 = this.table.getHorizSBTrackRow();
                            n9 = n9 >= -1 ? n9 : -1;
                            Object object = this.table.getDataView().getObject(n9, n11);
                            string = object == null || object.toString() == null ? "" : object.toString();
                        }
                        if (!this.trackLabel.isVisible()) {
                            this.trackLabel.setVisible(true);
                        }
                        this.trackLabel.setText(string);
                    } else {
                        CellArea cellArea = this.getBottomCellArea();
                        cellArea.add((Component)this.trackLabel, 0);
                        this.table.getFocusManager().requestFocus(this.trackLabel);
                        n10 = 50;
                        n9 = 20;
                        Dimension dimension = this.table.getTrackSize();
                        if (dimension != null) {
                            n10 = dimension.width;
                            n9 = dimension.height;
                        }
                        this.trackLabel.setBounds((cellArea.getWidth() - n10) / 2, cellArea.getHeight() - n9, n10, n9);
                        this.trackLabel.setHorizontalAlignment(0);
                        if (this.table.getTrackBackground() != null) {
                            this.trackLabel.setBackground(this.table.getTrackBackground());
                        }
                        if (this.table.getTrackForeground() != null) {
                            this.trackLabel.setForeground(this.table.getTrackForeground());
                        }
                        this.trackLabel.setText("");
                        this.isTracking = true;
                    }
                    jCScrollEvent = new JCScrollEvent(this, 2, adjustable, adjustable.getOrientation(), n2, adjustmentEvent);
                    this.table.fireJCScrollEvent(jCScrollEvent);
                    return;
                }
            } else if (this.isTracking) {
                this.isTracking = false;
                this.trackLabel.setVisible(false);
                editTraverseHandler.setFocusOnEditor();
                JCScrollEvent jCScrollEvent3 = null;
                jCScrollEvent3 = new JCScrollEvent(this, 2, adjustable, adjustable.getOrientation(), n2, adjustmentEvent);
                this.table.fireJCScrollEvent(jCScrollEvent3);
                this.table.layoutAreas();
            }
            if (editTraverseHandler.getCellEditor() != null) {
                editTraverseHandler.move(0, n12 + n2);
            }
            if (!this.table.mouseHandler.isResizing() && (rectangle = this.table.cellAreaHandler.cellRect) != null) {
                this.table.repaint(rectangle.x, 0, rectangle.width, this.table.getSize().height);
            }
        }
        if (this.table.scrollListeners != null && jCScrollEvent != null) {
            jCScrollEvent = new JCScrollEvent(this, 2, adjustable, adjustable.getOrientation(), n2, adjustmentEvent);
            this.table.fireJCScrollEvent(jCScrollEvent);
        }
    }

    protected void adjustOrigin() {
        Point point = this.table.getCellAreaHandler().getCellOrigin();
        JScrollBar jScrollBar = this.table.getHorizSB();
        if (jScrollBar != null && jScrollBar.isVisible() && jScrollBar.getValue() != -point.x) {
            point.x = -jScrollBar.getValue();
        }
        jScrollBar = null;
        JScrollBar jScrollBar2 = this.table.getVertSB();
        if (jScrollBar2 != null & jScrollBar2.isVisible() && jScrollBar2.getValue() != -point.y) {
            point.y = -jScrollBar2.getValue();
        }
        jScrollBar2 = null;
    }

    protected CellArea getBottomCellArea() {
        if (this.table.isColumnLabelDisplay() && this.table.getColumnLabelPlacement() == 3) {
            return this.table.getCellAreaHandler().findByType(2);
        }
        if (this.table.getFrozenRows() > 0 && this.table.getFrozenRowPlacement() == 3) {
            return this.table.getCellAreaHandler().findByType(1);
        }
        return this.table.getCellAreaHandler().findByType(0);
    }

    protected CellArea getRightCellArea() {
        if (this.table.isRowLabelDisplay() && this.table.getRowLabelPlacement() == 4) {
            return this.table.getCellAreaHandler().findByType(6);
        }
        if (this.table.getFrozenColumns() > 0 && this.table.getFrozenColumnPlacement() == 4) {
            return this.table.getCellAreaHandler().findByType(3);
        }
        return this.table.getCellAreaHandler().findByType(0);
    }

    public boolean isTracking() {
        return this.isTracking;
    }

    public void dispose() {
        this.table = null;
        this.trackLabel = null;
    }
}

