/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.render;

import com.klg.jclass.page.FontMetricsBase;
import com.klg.jclass.page.JCFlow;
import com.klg.jclass.page.JCPage;
import com.klg.jclass.page.JCTextStyle;
import com.klg.jclass.page.JCUnit;
import com.klg.jclass.page.TextMacro;
import com.klg.jclass.page.render.Render;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics2D;
import java.awt.font.TextAttribute;
import java.awt.geom.Rectangle2D;
import java.text.AttributedString;

public class MacroRender
extends Render
implements Cloneable {
    protected TextMacro macro;
    protected String text;
    protected JCTextStyle style;
    protected Graphics2D saved_gc;
    protected int status;

    public MacroRender() {
        this.macro = null;
        this.style = null;
        this.text = null;
        this.saved_gc = null;
        this.status = 1;
        this.origin = new JCUnit.Point(JCUnit.POINTS);
        this.bounds = new JCUnit.Dimension(JCUnit.POINTS);
    }

    public MacroRender(Graphics2D graphics2D, TextMacro textMacro, JCTextStyle jCTextStyle) {
        this.macro = textMacro;
        this.style = jCTextStyle;
        this.saved_gc = graphics2D;
        FontMetrics fontMetrics = graphics2D.getFontMetrics(jCTextStyle.getFont());
        this.text = textMacro.getText();
        this.status = textMacro.getStatus();
        Rectangle2D rectangle2D = FontMetricsBase.getStringBounds(fontMetrics, this.text, graphics2D);
        this.bounds = new JCUnit.Dimension(JCUnit.POINTS, rectangle2D.getWidth(), rectangle2D.getHeight());
    }

    public int getStatus() {
        return this.status;
    }

    public JCTextStyle getStyle() {
        return this.style;
    }

    public void setStyle(JCTextStyle jCTextStyle) {
        this.style = jCTextStyle;
    }

    public String getText() {
        return this.text;
    }

    public int evaluateMacro(JCFlow jCFlow, JCPage jCPage) {
        this.status = this.macro.evaluate(jCFlow, jCPage);
        String string = this.macro.getText();
        if (string.equals(this.text)) {
            this.setLayoutStatus(this.status);
            return this.status;
        }
        this.text = string;
        FontMetrics fontMetrics = this.saved_gc.getFontMetrics(this.style.getFont());
        Rectangle2D rectangle2D = FontMetricsBase.getStringBounds(fontMetrics, this.text, this.saved_gc);
        this.bounds = new JCUnit.Dimension(JCUnit.POINTS, rectangle2D.getWidth(), rectangle2D.getHeight());
        this.setLayoutStatus(this.status);
        return this.status;
    }

    public boolean isAtomic() {
        return true;
    }

    public void draw(Graphics2D graphics2D) {
        if (this.text == null || this.text.length() == 0) {
            return;
        }
        float f2 = (float)JCUnit.getAsPoints(this.origin.units, this.origin.x);
        float f3 = (float)JCUnit.getAsPoints(this.origin.units, this.origin.y);
        AttributedString attributedString = new AttributedString(this.text);
        int n2 = this.text.length();
        Font font = this.style.getFont();
        attributedString.addAttribute(TextAttribute.SIZE, new Float(this.style.getPointSize()), 0, n2);
        if (this.style.getBaselineOffset() == 2) {
            attributedString.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUB, 0, n2);
        } else if (this.style.getBaselineOffset() == 3) {
            attributedString.addAttribute(TextAttribute.SUPERSCRIPT, TextAttribute.SUPERSCRIPT_SUPER, 0, n2);
        }
        attributedString.addAttribute(TextAttribute.FONT, font, 0, n2);
        if (this.style.getUnderlining() == 2) {
            attributedString.addAttribute(TextAttribute.UNDERLINE, TextAttribute.UNDERLINE_ON, 0, n2);
        }
        graphics2D.setColor(this.style.getColor());
        graphics2D.drawString(attributedString.getIterator(), f2, f3);
    }

    public Object clone() {
        MacroRender macroRender = (MacroRender)super.clone();
        return macroRender;
    }
}

