/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.render;

import com.klg.jclass.page.JCDrawStyle;
import com.klg.jclass.page.JCUnit;
import com.klg.jclass.page.render.Render;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Rectangle2D;

public class BoxRender
extends Render
implements Cloneable {
    protected JCUnit.Point lowerLeft;
    protected JCUnit.Point upperRight;
    protected JCDrawStyle style;
    protected boolean fill;

    public BoxRender() {
        this.bounds = new JCUnit.Dimension(JCUnit.POINTS);
        this.origin = new JCUnit.Point(JCUnit.POINTS);
        this.style = null;
    }

    public BoxRender(JCUnit.Point point, JCUnit.Point point2, JCDrawStyle jCDrawStyle) {
        this.style = jCDrawStyle;
        double d2 = point.xInt();
        double d3 = point.yInt();
        double d4 = point2.xInt();
        double d5 = point2.yInt();
        if (d2 <= d4 && d3 <= d5 || d2 >= d4 && d3 >= d5) {
            if (d2 <= d4 && d3 <= d5) {
                this.origin = (JCUnit.Point)point.clone();
                this.lowerLeft = (JCUnit.Point)point.clone();
                this.upperRight = (JCUnit.Point)point2.clone();
            } else {
                this.origin = (JCUnit.Point)point2.clone();
                this.lowerLeft = (JCUnit.Point)point2.clone();
                this.upperRight = (JCUnit.Point)point.clone();
            }
            JCUnit.Measure measure = this.upperRight.getX();
            measure.subtract(this.origin.getX());
            JCUnit.Measure measure2 = this.upperRight.getY();
            measure2.subtract(this.origin.getY());
            this.bounds = new JCUnit.Dimension(this.upperRight.units, measure.distance, measure2.distance);
        } else {
            double d6;
            double d7;
            double d8;
            double d9;
            if (point.units != point2.units) {
                point2.x = JCUnit.getAs(point.units, point2.units, point2.x);
                point2.y = JCUnit.getAs(point.units, point2.units, point2.y);
                point2.units = point.units;
            }
            if (d2 >= d4) {
                d9 = point2.x;
                d8 = point.x;
            } else {
                d9 = point.x;
                d8 = point2.x;
            }
            if (d3 >= d5) {
                d7 = point2.y;
                d6 = point.y;
            } else {
                d7 = point.y;
                d6 = point2.y;
            }
            this.lowerLeft = new JCUnit.Point(point.units, d9, d7);
            this.upperRight = new JCUnit.Point(point.units, d8, d6);
            this.origin = new JCUnit.Point(point.units, d9, d7);
            this.bounds = new JCUnit.Dimension(point.units, d8 - d9, d6 - d7);
        }
    }

    public BoxRender(JCUnit.Point point, JCUnit.Dimension dimension, JCDrawStyle jCDrawStyle) {
        this.style = null;
        this.style = jCDrawStyle;
        this.origin = (JCUnit.Point)point.clone();
        this.bounds = (JCUnit.Dimension)dimension.clone();
        this.lowerLeft = (JCUnit.Point)point.clone();
        JCUnit.Measure measure = this.origin.getX();
        measure.add(this.bounds.getWidth());
        JCUnit.Measure measure2 = this.origin.getY();
        measure2.add(this.bounds.getHeight());
        this.upperRight = new JCUnit.Point(this.origin.units, measure.distance, measure2.distance);
    }

    public JCUnit.Point[] getPoints() {
        JCUnit.Point[] pointArray = new JCUnit.Point[4];
        pointArray[0] = (JCUnit.Point)this.lowerLeft.clone();
        pointArray[1] = (JCUnit.Point)this.lowerLeft.clone();
        pointArray[1].setX(this.upperRight.getX());
        pointArray[2] = (JCUnit.Point)this.upperRight.clone();
        pointArray[3] = (JCUnit.Point)this.upperRight.clone();
        pointArray[3].setX(this.lowerLeft.getX());
        return pointArray;
    }

    public JCUnit.Point getLowerLeft() {
        return this.lowerLeft;
    }

    public JCUnit.Point getUpperRight() {
        return this.upperRight;
    }

    public void setLocation(JCUnit.Point point) {
        this.origin = (JCUnit.Point)point.clone();
        this.lowerLeft = (JCUnit.Point)point.clone();
        JCUnit.Measure measure = this.origin.getX();
        measure.add(this.bounds.getWidth());
        JCUnit.Measure measure2 = this.origin.getY();
        measure2.add(this.bounds.getHeight());
        this.upperRight = new JCUnit.Point(this.origin.units, measure.distance, measure2.distance);
    }

    public void setSize(JCUnit.Dimension dimension) {
        this.bounds = dimension;
        JCUnit.Measure measure = this.origin.getX();
        measure.add(this.bounds.getWidth());
        JCUnit.Measure measure2 = this.origin.getY();
        measure2.add(this.bounds.getHeight());
        this.upperRight = new JCUnit.Point(this.origin.units, measure.distance, measure2.distance);
    }

    public JCDrawStyle getStyle() {
        return this.style;
    }

    public void setStyle(JCDrawStyle jCDrawStyle) {
        this.style = jCDrawStyle;
    }

    public boolean isFilled() {
        return this.fill;
    }

    public void setFilled(boolean bl) {
        this.fill = bl;
    }

    public boolean isAtomic() {
        return true;
    }

    public void draw(Graphics2D graphics2D) {
        Rectangle2D.Double double_;
        BasicStroke basicStroke;
        Color color;
        if (this.fill) {
            color = this.style.getFillForegroundColor();
            if (color == null) {
                color = this.style.getForegroundColor();
            }
        } else {
            color = this.style.getForegroundColor();
        }
        if (color == null) {
            return;
        }
        graphics2D.setColor(color);
        double d2 = this.style.getLineWidth().getAs(JCUnit.POINTS);
        double d3 = JCUnit.getAsPoints(this.origin.units, this.origin.x);
        double d4 = JCUnit.getAsPoints(this.origin.units, this.origin.y);
        double d5 = JCUnit.getAsPoints(this.bounds.units, this.bounds.width);
        double d6 = JCUnit.getAsPoints(this.bounds.units, this.bounds.height);
        int n2 = this.style.getLineType();
        if (n2 == 3) {
            float[] fArray = new float[2];
            double d7 = this.style.getDashLength().getAs(JCUnit.POINTS);
            fArray[0] = (float)d7;
            fArray[1] = (float)d7;
            basicStroke = new BasicStroke((float)d2, 2, 0, 10.0f, fArray, 0.0f);
        } else if (n2 == 4) {
            double d8 = this.style.getLineSpacing().getAs(JCUnit.POINTS);
            basicStroke = new BasicStroke((float)d2, 2, 0);
            graphics2D.setStroke(basicStroke);
            double d9 = d3 + d8;
            double d10 = d4 + d8;
            double d11 = d5 - 2.0 * d8;
            double d12 = d6 - 2.0 * d8;
            double_ = new Rectangle2D.Double(d9, d10, d11, d12);
            graphics2D.draw(double_);
        } else if (n2 == 2 || n2 == 2) {
            basicStroke = new BasicStroke((float)d2, 2, 0);
        } else {
            return;
        }
        graphics2D.setStroke(basicStroke);
        double_ = new Rectangle2D.Double(d3, d4, d5, d6);
        if (this.fill) {
            graphics2D.fill(double_);
        } else {
            graphics2D.draw(double_);
        }
    }

    public Object clone() {
        BoxRender boxRender = (BoxRender)super.clone();
        boxRender.lowerLeft = (JCUnit.Point)this.lowerLeft.clone();
        boxRender.upperRight = (JCUnit.Point)this.upperRight.clone();
        return boxRender;
    }
}

