/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.pcl;

import com.klg.jclass.page.FontParser;
import com.klg.jclass.page.pcl.CharSetEntryPCL;
import com.klg.jclass.page.pcl.CharacterPCL;
import com.klg.jclass.page.pcl.FontPCL;
import com.klg.jclass.page.pcl.KernPairPCL;
import com.klg.jclass.page.pcl.SectorKernPCL;
import com.klg.jclass.page.pcl.SymbolSetDirectoryPCL;
import com.klg.jclass.page.pcl.TrackKernPCL;
import com.klg.jclass.page.pcl.TypeFacePCL;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Vector;

public class TFMParser
implements FontParser {
    public static final int tagBYTE = 1;
    public static final int tagASCII = 2;
    public static final int tagSHORT = 3;
    public static final int tagLONG = 4;
    public static final int tagRATIONAL = 5;
    public static final int tagSIGNEDBYTE = 16;
    public static final int tagSIGNEDSHORT = 17;
    public static final int tagSIGNEDLONG = 18;
    protected boolean Copyright_Flag = false;
    protected boolean Comment_Flag = false;
    protected boolean SymbolMap_Flag = false;
    protected boolean SymbolSetDir_Flag = false;
    protected boolean UniqueAssocID_Flag = false;
    protected boolean Point_Flag = false;
    protected boolean NominalPoint_Flag = false;
    protected boolean DesignUnits_Flag = false;
    protected boolean TypeStruct_Flag = false;
    protected boolean StrokeWt_Flag = false;
    protected boolean Spacing_Flag = false;
    protected boolean Slant_Flag = false;
    protected boolean AppearWidth_Flag = false;
    protected boolean SerifStyle_Flag = false;
    protected boolean TypeStyle_Flag = false;
    protected boolean Typeface_Flag = false;
    protected boolean TFSource_Flag = false;
    protected boolean AverageWd_Flag = false;
    protected boolean MaxWidth_Flag = false;
    protected boolean InterWordSP_Flag = false;
    protected boolean ReclineSP_Flag = false;
    protected boolean CapHeight_Flag = false;
    protected boolean XHeight_Flag = false;
    protected boolean Ascent_Flag = false;
    protected boolean Descent_Flag = false;
    protected boolean LowerAscent_Flag = false;
    protected boolean LowerDescent_Flag = false;
    protected boolean UnderDepth_Flag = false;
    protected boolean UnderThick_Flag = false;
    protected boolean UpperAccent_Flag = false;
    protected boolean LowerAccent_Flag = false;
    protected boolean HorizontalEsc_Flag = false;
    protected boolean VerticalEsc_Flag = false;
    protected boolean LeftExtent_Flag = false;
    protected boolean RightExtent_Flag = false;
    protected boolean CharAscent_Flag = false;
    protected boolean CharDescent_Flag = false;
    protected boolean KernPairs_Flag = false;
    protected boolean SectorKern_Flag = false;
    protected boolean TrackKern_Flag = false;
    protected boolean TFSelectStr_Flag = false;
    protected boolean Panose_Flag = false;
    protected static final int TWO_8 = 256;
    protected static final int TWO_16 = 65536;
    protected static final int TWO_24 = 0x1000000;
    static boolean Intel_byte_order;
    Buffer buffer;
    public int bufferSize = 5000;
    short[] type_size = new short[19];

    public Vector parse(InputStream inputStream) throws IOException {
        int n2;
        short s2 = 0;
        long l2 = 0L;
        Vector<FontPCL> vector = new Vector<FontPCL>(1);
        this.buffer = new Buffer(inputStream);
        this.type_size[1] = 1;
        this.type_size[2] = 1;
        this.type_size[3] = 2;
        this.type_size[4] = 4;
        this.type_size[5] = 8;
        this.type_size[16] = 1;
        this.type_size[17] = 2;
        this.type_size[18] = 4;
        short s3 = this.getShort();
        if (s3 == 18761) {
            Intel_byte_order = true;
            n2 = 73;
        } else if (s3 == 19789) {
            Intel_byte_order = false;
            n2 = 77;
        }
        String string = this.getVersion(inputStream);
        int n3 = this.getNumberTypefaces();
        for (int i2 = 0; i2 < n3; ++i2) {
            TypeFacePCL typeFacePCL = new TypeFacePCL();
            long l3 = this.getLong();
            this.setPos(l3, 0);
            int n4 = this.getShort();
            for (int i3 = 0; i3 < n4; ++i3) {
                long l4;
                long l5;
                short s4 = this.getShort();
                short s5 = this.getShort();
                long l6 = (long)this.type_size[s5] * (l5 = this.getLong());
                if (l6 > 4L) {
                    l4 = this.getLong();
                    l2 = this.getPos();
                    this.setPos(l4, 0);
                } else {
                    l4 = 0L;
                }
                switch (s4) {
                    case 400: {
                        typeFacePCL.general.TFMType = (short)this.getLong();
                        break;
                    }
                    case 401: {
                        this.Copyright_Flag = true;
                        typeFacePCL.general.copyright = this.getString();
                        this.skipBytesInOffsetField(l5, l6);
                        break;
                    }
                    case 402: {
                        this.Comment_Flag = true;
                        typeFacePCL.general.comment = this.getString();
                        this.skipBytesInOffsetField(l5, l6);
                        break;
                    }
                    case 403: {
                        this.SymbolMap_Flag = true;
                        this.readSymbolMap(typeFacePCL, l5);
                        break;
                    }
                    case 404: {
                        this.SymbolSetDir_Flag = true;
                        s2 = (short)(l5 / 14L);
                        this.readSymbolSets(typeFacePCL, s2);
                        break;
                    }
                    case 405: {
                        this.UniqueAssocID_Flag = true;
                        typeFacePCL.general.uniqueAssociationID = this.getString();
                        this.skipBytesInOffsetField(l5, l6);
                        break;
                    }
                    case 406: {
                        this.Point_Flag = true;
                        typeFacePCL.typefaceMetrics.point = this.getRational();
                        break;
                    }
                    case 407: {
                        this.NominalPoint_Flag = true;
                        typeFacePCL.typefaceMetrics.nominalPointSize = this.getRational();
                        break;
                    }
                    case 408: {
                        this.DesignUnits_Flag = true;
                        typeFacePCL.typefaceMetrics.designUnits = this.getRational();
                        break;
                    }
                    case 410: {
                        this.TypeStruct_Flag = true;
                        typeFacePCL.typefaceMetrics.typeStruct = this.getByte();
                        this.skipUnusedBytes(3);
                        break;
                    }
                    case 411: {
                        this.StrokeWt_Flag = true;
                        typeFacePCL.typefaceMetrics.strokeWeight = this.getByte();
                        this.skipUnusedBytes(3);
                        break;
                    }
                    case 412: {
                        this.Spacing_Flag = true;
                        typeFacePCL.typefaceMetrics.spacing = this.getShort();
                        this.skipUnusedBytes(2);
                        break;
                    }
                    case 413: {
                        this.Slant_Flag = true;
                        typeFacePCL.typefaceMetrics.slant = this.getShort();
                        this.skipUnusedBytes(2);
                        break;
                    }
                    case 414: {
                        this.AppearWidth_Flag = true;
                        typeFacePCL.typefaceMetrics.appearanceWidth = this.getByte();
                        this.skipUnusedBytes(3);
                        break;
                    }
                    case 415: {
                        this.SerifStyle_Flag = true;
                        typeFacePCL.typefaceMetrics.serifStyle = this.getByte();
                        this.skipUnusedBytes(3);
                        break;
                    }
                    case 416: {
                        this.TypeStyle_Flag = true;
                        typeFacePCL.typefaceMetrics.typeStyle = this.getByte();
                        this.skipUnusedBytes(3);
                        break;
                    }
                    case 417: {
                        this.Typeface_Flag = true;
                        typeFacePCL.general.typeface = this.getString();
                        this.skipBytesInOffsetField(l5, l6);
                        break;
                    }
                    case 418: {
                        this.TFSource_Flag = true;
                        typeFacePCL.general.typefaceSource = this.getString();
                        this.skipBytesInOffsetField(l5, l6);
                        break;
                    }
                    case 419: {
                        this.AverageWd_Flag = true;
                        typeFacePCL.typefaceMetrics.averageWidth = this.getRational();
                        break;
                    }
                    case 420: {
                        this.MaxWidth_Flag = true;
                        typeFacePCL.typefaceMetrics.maximumWidth = this.getShort();
                        this.skipUnusedBytes(2);
                        break;
                    }
                    case 421: {
                        this.InterWordSP_Flag = true;
                        typeFacePCL.typefaceMetrics.interWordSpacing = this.getShort();
                        this.skipUnusedBytes(2);
                        break;
                    }
                    case 422: {
                        this.ReclineSP_Flag = true;
                        typeFacePCL.typefaceMetrics.recommendedLineSpacing = this.getShort();
                        this.skipUnusedBytes(2);
                        break;
                    }
                    case 423: {
                        this.CapHeight_Flag = true;
                        typeFacePCL.typefaceMetrics.capHeight = this.getShort();
                        this.skipUnusedBytes(2);
                        break;
                    }
                    case 424: {
                        this.XHeight_Flag = true;
                        typeFacePCL.typefaceMetrics.xHeight = this.getShort();
                        this.skipUnusedBytes(2);
                        break;
                    }
                    case 425: {
                        this.Ascent_Flag = true;
                        typeFacePCL.typefaceMetrics.ascent = this.getShort();
                        this.skipUnusedBytes(2);
                        break;
                    }
                    case 426: {
                        this.Descent_Flag = true;
                        typeFacePCL.typefaceMetrics.descent = this.getShort();
                        this.skipUnusedBytes(2);
                        break;
                    }
                    case 427: {
                        this.LowerAscent_Flag = true;
                        typeFacePCL.typefaceMetrics.lowercaseAscent = this.getShort();
                        this.skipUnusedBytes(2);
                        break;
                    }
                    case 428: {
                        this.LowerDescent_Flag = true;
                        typeFacePCL.typefaceMetrics.lowercaseDescent = this.getShort();
                        this.skipUnusedBytes(2);
                        break;
                    }
                    case 429: {
                        this.UnderDepth_Flag = true;
                        typeFacePCL.typefaceMetrics.underscoreDescent = this.getShort();
                        this.skipUnusedBytes(2);
                        break;
                    }
                    case 430: {
                        this.UnderThick_Flag = true;
                        typeFacePCL.typefaceMetrics.underscoreThickness = this.getShort();
                        this.skipUnusedBytes(2);
                        break;
                    }
                    case 431: {
                        this.UpperAccent_Flag = true;
                        typeFacePCL.typefaceMetrics.uppercaseAccentHeight = this.getShort();
                        this.skipUnusedBytes(2);
                        break;
                    }
                    case 432: {
                        this.LowerAccent_Flag = true;
                        typeFacePCL.typefaceMetrics.lowercaseAccentHeight = this.getShort();
                        this.skipUnusedBytes(2);
                        break;
                    }
                    case 433: {
                        this.HorizontalEsc_Flag = true;
                        this.readHorizontalEscapement(typeFacePCL);
                        break;
                    }
                    case 434: {
                        this.VerticalEsc_Flag = true;
                        this.readVerticalEscapement(typeFacePCL);
                        break;
                    }
                    case 435: {
                        this.LeftExtent_Flag = true;
                        this.readLeftExtent(typeFacePCL);
                        break;
                    }
                    case 436: {
                        this.RightExtent_Flag = true;
                        this.readRightExtent(typeFacePCL);
                        break;
                    }
                    case 437: {
                        this.CharAscent_Flag = true;
                        this.readCharAscent(typeFacePCL);
                        break;
                    }
                    case 438: {
                        this.CharDescent_Flag = true;
                        this.readCharDescent(typeFacePCL);
                        break;
                    }
                    case 439: {
                        this.KernPairs_Flag = true;
                        this.readKernPairs(typeFacePCL);
                        break;
                    }
                    case 440: {
                        this.SectorKern_Flag = true;
                        this.readSectorKern(typeFacePCL);
                        break;
                    }
                    case 441: {
                        this.TrackKern_Flag = true;
                        this.readTrackKern(typeFacePCL);
                        break;
                    }
                    case 442: {
                        this.TFSelectStr_Flag = true;
                        typeFacePCL.general.typefaceSelectionString = this.getString();
                        this.skipBytesInOffsetField(l5, l6);
                        break;
                    }
                    case 443: {
                        this.Panose_Flag = true;
                        typeFacePCL.panose.familyType = this.getByte();
                        typeFacePCL.panose.serifStyle = this.getByte();
                        typeFacePCL.panose.weight = this.getByte();
                        typeFacePCL.panose.proportion = this.getByte();
                        typeFacePCL.panose.contrast = this.getByte();
                        typeFacePCL.panose.strokeVariation = this.getByte();
                        typeFacePCL.panose.armStyle = this.getByte();
                        typeFacePCL.panose.letterForm = this.getByte();
                        typeFacePCL.panose.midLine = this.getByte();
                        typeFacePCL.panose.xHeight = this.getByte();
                        break;
                    }
                    default: {
                        this.getLong();
                    }
                }
                if (l4 == 0L) continue;
                this.setPos(l2, 0);
            }
            this.buildCharacterTable(typeFacePCL);
            int n5 = -1;
            String string2 = typeFacePCL.getName();
            int n6 = typeFacePCL.getStyle();
            if (this.Spacing_Flag && typeFacePCL.typefaceMetrics.spacing != 0) {
                typeFacePCL.setStyle(n6 |= 0x40);
            }
            FontPCL fontPCL = new FontPCL(string2, n6, n5, typeFacePCL);
            vector.addElement(fontPCL);
        }
        return vector;
    }

    public double getRational() {
        float f2 = this.getLong();
        float f3 = this.getLong();
        return f2 / f3;
    }

    public long getPos() {
        return this.buffer.offset;
    }

    public int setPos(long l2, int n2) {
        long l3 = n2 == 0 ? l2 : (n2 == 1 ? (long)this.buffer.offset + l2 : (long)this.buffer.max_offset - l2);
        if (l3 < 0L || l3 > (long)this.buffer.max_offset) {
            return -1;
        }
        this.buffer.offset = (int)l3;
        return 0;
    }

    public String getVersion(InputStream inputStream) {
        String string;
        int n2 = this.getByte();
        int n3 = this.getByte();
        short s2 = (short)((n3 & 0xF0) >> 4);
        short s3 = (short)(n3 & 0xF);
        short s4 = (short)(n2 & 0x80);
        if (s4 <= 0) {
            string = n2 + "." + s2 + "." + s3;
        } else {
            n2 = (byte)(n2 & 0x7F);
            string = "-" + n2 + "." + s2 + "." + s3;
        }
        return string;
    }

    public short getNumberTypefaces() {
        boolean bl = false;
        int n2 = 1;
        long l2 = this.getPos();
        long l3 = this.getLong();
        this.setPos(l3, 0);
        while (!bl) {
            short s2 = this.getShort();
            long l4 = (long)(s2 * 12) + l3;
            this.setPos(l4, 0);
            long l5 = this.getLong();
            if (l5 != 0L) {
                this.setPos(l5, 0);
                ++n2;
                continue;
            }
            bl = true;
        }
        this.setPos(l2, 0);
        return (short)n2;
    }

    public void skipBytesInOffsetField(long l2, long l3) {
        if (l3 <= 4L) {
            for (int i2 = (int)l2; i2 < 4; ++i2) {
                this.getByte();
            }
        }
    }

    public void readSymbolMap(TypeFacePCL typeFacePCL, long l2) {
        typeFacePCL.general.numberCharacters = l2;
        typeFacePCL.symbol.symbolMap = new short[(int)l2];
        int n2 = 0;
        while ((long)n2 < l2) {
            CharacterPCL characterPCL = new CharacterPCL();
            typeFacePCL.symbol.symbolMap[n2] = characterPCL.MSLIndex = this.getShort();
            characterPCL.index = n2++;
            typeFacePCL.charMetrics.chars.addElement(characterPCL);
        }
    }

    public void readSymbolSets(TypeFacePCL typeFacePCL, int n2) {
        typeFacePCL.general.numberSymbolSets = n2;
        for (int i2 = 0; i2 < n2; ++i2) {
            SymbolSetDirectoryPCL symbolSetDirectoryPCL = this.readSymbolSetDirectory();
            typeFacePCL.symbol.symbolSets.addElement(symbolSetDirectoryPCL);
        }
    }

    public SymbolSetDirectoryPCL readSymbolSetDirectory() {
        int n2 = 0;
        SymbolSetDirectoryPCL symbolSetDirectoryPCL = new SymbolSetDirectoryPCL();
        long l2 = this.getLong();
        long l3 = this.getPos();
        this.setPos(l2, 0);
        symbolSetDirectoryPCL.symbolName = this.getString();
        this.setPos(l3, 0);
        l2 = this.getLong();
        l3 = this.getPos();
        this.setPos(l2, 0);
        symbolSetDirectoryPCL.selectionName = this.getString();
        this.setPos(l3, 0);
        long l4 = this.getLong();
        long l5 = this.getShort();
        l3 = this.getPos();
        symbolSetDirectoryPCL.symbolLength = (short)l5;
        short[] sArray = new short[(int)l5];
        this.setPos(l4, 0);
        n2 = 0;
        while ((long)n2 < l5) {
            sArray[n2] = this.getShort();
            ++n2;
        }
        symbolSetDirectoryPCL.symbolIndex = sArray;
        this.setPos(l3, 0);
        return symbolSetDirectoryPCL;
    }

    public void readHorizontalEscapement(TypeFacePCL typeFacePCL) {
        int n2 = 0;
        while ((long)n2 < typeFacePCL.general.numberCharacters) {
            CharacterPCL characterPCL = typeFacePCL.getCharacter(n2);
            if (characterPCL != null) {
                characterPCL.horizontalEscapement = this.getShort();
            }
            ++n2;
        }
    }

    public void readVerticalEscapement(TypeFacePCL typeFacePCL) {
        int n2 = 0;
        while ((long)n2 < typeFacePCL.general.numberCharacters) {
            CharacterPCL characterPCL = typeFacePCL.getCharacter(n2);
            if (characterPCL != null) {
                characterPCL.verticalEscapement = this.getShort();
            }
            ++n2;
        }
    }

    public void readLeftExtent(TypeFacePCL typeFacePCL) {
        int n2 = 0;
        while ((long)n2 < typeFacePCL.general.numberCharacters) {
            CharacterPCL characterPCL = typeFacePCL.getCharacter(n2);
            if (characterPCL != null) {
                characterPCL.leftExtent = this.getShort();
            }
            ++n2;
        }
    }

    public void readRightExtent(TypeFacePCL typeFacePCL) {
        int n2 = 0;
        while ((long)n2 < typeFacePCL.general.numberCharacters) {
            CharacterPCL characterPCL = typeFacePCL.getCharacter(n2);
            if (characterPCL != null) {
                characterPCL.rightExtent = this.getShort();
            }
            ++n2;
        }
    }

    public void readCharAscent(TypeFacePCL typeFacePCL) {
        int n2 = 0;
        while ((long)n2 < typeFacePCL.general.numberCharacters) {
            CharacterPCL characterPCL = typeFacePCL.getCharacter(n2);
            if (characterPCL != null) {
                characterPCL.characterAscent = this.getShort();
            }
            ++n2;
        }
    }

    public void readCharDescent(TypeFacePCL typeFacePCL) {
        int n2 = 0;
        while ((long)n2 < typeFacePCL.general.numberCharacters) {
            CharacterPCL characterPCL = typeFacePCL.getCharacter(n2);
            if (characterPCL != null) {
                characterPCL.characterDescent = this.getShort();
            }
            ++n2;
        }
    }

    public void readKernPairs(TypeFacePCL typeFacePCL) {
        int n2 = this.getShort();
        typeFacePCL.kerning.numberPairs = n2;
        for (int i2 = 0; i2 < n2; ++i2) {
            KernPairPCL kernPairPCL = new KernPairPCL();
            kernPairPCL.firstCharIndex = this.getShort();
            kernPairPCL.secondCharIndex = this.getShort();
            kernPairPCL.kernValue = this.getShort();
            typeFacePCL.kerning.kernPairs.addElement(kernPairPCL);
        }
    }

    public void readSectorKern(TypeFacePCL typeFacePCL) {
        int n2 = this.getShort();
        typeFacePCL.kerning.numberKernChars = n2;
        int n3 = this.getShort();
        typeFacePCL.kerning.numberSectors = n3;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n4;
            SectorKernPCL sectorKernPCL = new SectorKernPCL();
            sectorKernPCL.charIndex = this.getShort();
            sectorKernPCL.leftSector = new short[n3];
            sectorKernPCL.rightSector = new short[n3];
            for (n4 = 0; n4 < n3; ++n4) {
                sectorKernPCL.leftSector[n4] = this.getShort();
            }
            for (n4 = 0; n4 < n3; ++n4) {
                sectorKernPCL.rightSector[n4] = this.getShort();
            }
            typeFacePCL.kerning.sectors.addElement(sectorKernPCL);
        }
    }

    public void readTrackKern(TypeFacePCL typeFacePCL) {
        int n2 = this.getShort();
        typeFacePCL.kerning.numberTracks = n2;
        for (int i2 = 0; i2 < n2; ++i2) {
            TrackKernPCL trackKernPCL = new TrackKernPCL();
            trackKernPCL.trackValue = this.getShort();
            trackKernPCL.maxPointSize = this.getShort();
            trackKernPCL.minPointSize = this.getShort();
            trackKernPCL.maxKern = this.getShort();
            trackKernPCL.minKern = this.getShort();
        }
    }

    public void buildCharacterTable(TypeFacePCL typeFacePCL) {
        CharacterPCL characterPCL;
        int n2;
        CharSetEntryPCL charSetEntryPCL = null;
        CharSetEntryPCL charSetEntryPCL2 = null;
        SymbolSetDirectoryPCL symbolSetDirectoryPCL = this.findSymbolSet(typeFacePCL, "11J");
        if (symbolSetDirectoryPCL == null) {
            symbolSetDirectoryPCL = this.findSymbolSet(typeFacePCL, "0N");
        }
        if (symbolSetDirectoryPCL == null) {
            symbolSetDirectoryPCL = this.findSymbolSet(typeFacePCL, "9U");
        }
        if (symbolSetDirectoryPCL == null) {
            symbolSetDirectoryPCL = this.findSymbolSet(typeFacePCL, "19U");
        }
        if (symbolSetDirectoryPCL == null) {
            symbolSetDirectoryPCL = this.findSymbolSet(typeFacePCL, "8U");
        }
        if (symbolSetDirectoryPCL == null) {
            symbolSetDirectoryPCL = this.findSymbolSet(typeFacePCL, "0U");
        }
        if (symbolSetDirectoryPCL == null) {
            symbolSetDirectoryPCL = (SymbolSetDirectoryPCL)typeFacePCL.symbol.symbolSets.elementAt(0);
        }
        typeFacePCL.symbol.latin1Set = symbolSetDirectoryPCL.selectionName;
        for (n2 = 0; n2 < symbolSetDirectoryPCL.symbolLength; ++n2) {
            if (symbolSetDirectoryPCL.symbolIndex[n2] == -1) continue;
            charSetEntryPCL = new CharSetEntryPCL();
            charSetEntryPCL.code = n2;
            charSetEntryPCL.index = symbolSetDirectoryPCL.symbolIndex[n2];
            charSetEntryPCL.metrics = characterPCL = (CharacterPCL)typeFacePCL.charMetrics.chars.elementAt(charSetEntryPCL.index);
            typeFacePCL.charMetrics.charSetEntries.put(new Short(charSetEntryPCL.index), charSetEntryPCL);
        }
        int n3 = typeFacePCL.kerning.kernPairs.size();
        for (n2 = 0; n2 < n3; ++n2) {
            KernPairPCL kernPairPCL = (KernPairPCL)typeFacePCL.kerning.kernPairs.elementAt(n2);
            charSetEntryPCL = typeFacePCL.charMetrics.findEntryByIndex(kernPairPCL.secondCharIndex);
            if (charSetEntryPCL == null || (charSetEntryPCL = typeFacePCL.charMetrics.findEntryByIndex(kernPairPCL.firstCharIndex)) == null) continue;
            charSetEntryPCL.kerns.put(new Integer(kernPairPCL.secondCharIndex), kernPairPCL);
        }
        charSetEntryPCL2 = typeFacePCL.charMetrics.findEntryByCode((short)32);
        if (charSetEntryPCL2 == null) {
            charSetEntryPCL2 = new CharSetEntryPCL();
            charSetEntryPCL2.code = 32;
            typeFacePCL.charMetrics.charSetEntries.put(new Short((short)charSetEntryPCL2.code), charSetEntryPCL2);
            characterPCL = typeFacePCL.charMetrics.findCharByIndex((short)0);
            charSetEntryPCL = typeFacePCL.charMetrics.findEntryByCode((short)33);
            CharacterPCL characterPCL2 = typeFacePCL.charMetrics.findCharByIndex(charSetEntryPCL.index);
            if (characterPCL == null || characterPCL.leftExtent != 0 || characterPCL.characterDescent != 0 || characterPCL.characterAscent != 0 && characterPCL.characterAscent != characterPCL2.characterAscent || characterPCL.horizontalEscapement != characterPCL2.horizontalEscapement) {
                charSetEntryPCL2.metrics = new CharacterPCL();
                charSetEntryPCL2.metrics.MSLIndex = (short)-1;
                charSetEntryPCL2.metrics.index = 0;
                charSetEntryPCL2.metrics.horizontalEscapement = characterPCL2.horizontalEscapement;
                charSetEntryPCL2.metrics.verticalEscapement = 0;
                charSetEntryPCL2.metrics.leftExtent = 0;
                charSetEntryPCL2.metrics.rightExtent = (short)(characterPCL2.horizontalEscapement / 2);
                charSetEntryPCL2.metrics.characterAscent = characterPCL2.characterAscent;
                charSetEntryPCL2.metrics.characterDescent = 0;
                typeFacePCL.charMetrics.chars.addElement(charSetEntryPCL2.metrics);
                charSetEntryPCL2.index = 0;
            } else {
                charSetEntryPCL2.metrics = characterPCL;
                charSetEntryPCL2.index = 0;
            }
        }
    }

    public SymbolSetDirectoryPCL findSymbolSet(TypeFacePCL typeFacePCL, String string) {
        return typeFacePCL.symbol.findSymbolSetDirByName(string);
    }

    public void skipUnusedBytes(int n2) {
        if (n2 >= 2) {
            this.getShort();
        }
        if (n2 == 1 || n2 == 3) {
            this.getByte();
        }
    }

    public int getByte() {
        return this.buffer.data[this.buffer.offset++] & 0xFF;
    }

    public short getShort() {
        int n2 = this.buffer.data[this.buffer.offset++] & 0xFF;
        int n3 = this.buffer.data[this.buffer.offset++] & 0xFF;
        if (Intel_byte_order) {
            return (short)(256 * n3 + n2);
        }
        return (short)(256 * n2 + n3);
    }

    public long getLong() {
        long l2 = this.buffer.data[this.buffer.offset++] & 0xFF;
        long l3 = this.buffer.data[this.buffer.offset++] & 0xFF;
        long l4 = this.buffer.data[this.buffer.offset++] & 0xFF;
        long l5 = this.buffer.data[this.buffer.offset++] & 0xFF;
        if (Intel_byte_order) {
            return 0x1000000L * l5 + 65536L * l4 + 256L * l3 + l2;
        }
        return 0x1000000L * l2 + 65536L * l3 + 256L * l4 + l5;
    }

    public String getString() {
        byte by;
        boolean bl = false;
        Vector<Byte> vector = new Vector<Byte>();
        while ((by = this.buffer.data[this.buffer.offset++]) != 0) {
            vector.addElement(new Byte(by));
        }
        byte[] byArray = new byte[vector.size()];
        for (int i2 = 0; i2 < vector.size(); ++i2) {
            byArray[i2] = (Byte)vector.elementAt(i2);
        }
        return new String(byArray);
    }

    public void setBufferSize(int n2) {
        this.bufferSize = n2;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    class Buffer {
        byte[] data;
        int offset = 0;
        int max_offset = 0;
        int size;

        Buffer(InputStream inputStream) throws IOException {
            this.data = this.buildBuffer(new BufferedInputStream(inputStream));
            this.max_offset = this.data.length;
        }

        public byte[] buildBuffer(InputStream inputStream) throws IOException {
            byte[] byArray = new byte[TFMParser.this.getBufferSize()];
            byte[] byArray2 = new byte[TFMParser.this.getBufferSize()];
            int n2 = 0;
            int n3 = 0;
            while ((n3 = inputStream.read(byArray)) > 0) {
                byte[] byArray3 = byArray2;
                byArray2 = new byte[n2 + n3];
                System.arraycopy(byArray3, 0, byArray2, 0, n2);
                System.arraycopy(byArray, 0, byArray2, n2, n3);
                n2 += n3;
            }
            return byArray2;
        }
    }
}

