/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page.adobe.postscript;

import com.klg.jclass.page.FontParser;
import com.klg.jclass.page.JCPrinter;
import com.klg.jclass.page.adobe.postscript.FontPS;
import com.klg.jclass.page.adobe.postscript.Graphics2DPS;
import java.awt.Graphics;
import java.awt.geom.Rectangle2D;
import java.io.OutputStream;
import java.util.Date;

public class JCEPSPrinter
extends JCPrinter {
    static String std_EPS_headers = "%!PS-Adobe-3.0 EPSF-3.0\n%%Creator: PageLayout 6.x";
    static String std_EPS_prologue_begin = "%%EndComments\n%%BeginProlog\n%\n% This document produced by PageLayout 6.x\n%\n% PageLayout is a trademark of Quest Software Inc.\n% Copyright (c) 2003 by Quest Software Inc.\n% All rights reserved.\n%\n%%BeginResource: procset KlgPfglobals\n\t/PFLevel1\n\t\t/languagelevel where {\n\t\t\tpop languagelevel\n\t\t} {\n\t\t\t1\n\t\t} ifelse\n\t\t2 lt def\n\t/PFBeginEPS {\n\t\t/klgeps save def\n\t\tKlgPfDict begin\n\t} def\n\t/PFEndEPS {\n\t\tend\n\t\tklgeps restore\n\t\tshowpage\n\t} def\n%%EndResource\n%%BeginResource: procset KlgPfDict\n\t/KlgPfDict 100 dict dup begin\n\t\t/bd {\n\t\t\tbind def\n\t\t} bind def\n\t\t/dla {\n\t\t\tnewpath 4 2 roll moveto lineto stroke\n\t\t} bd\n\t\t/st {\n\t\t\tmoveto show\n\t\t} bd\n\t\t/PFrect {\n\t\t\tnewpath\n\t\t\t4 2 roll moveto\n\t\t\t1 index 0 rlineto\n\t\t\t0 exch rlineto\n\t\t\tneg 0 rlineto\n\t\t\tclosepath\n\t\t} bd\n\t\t/rc {\n\t\t\tPFLevel1 {\n\t\t\t\tPFrect\n\t\t\t\tclip\n\t\t\t\tnewpath\n\t\t\t} {\n\t\t\t\trectclip\n\t\t\t} ifelse\n\t\t} bd\n\t\t/rf {\n\t\t\tPFLevel1 {\n\t\t\t\tgsave\n\t\t\t\tPFrect\n\t\t\t\tfill\n\t\t\t\tgrestore\n\t\t\t} {\n\t\t\t\trectfill\n\t\t\t} ifelse\n\t\t} bd\n\t\t/rs {\n\t\t\tPFLevel1 {\n\t\t\t\tgsave\n\t\t\t\tPFrect\n\t\t\t\tstroke\n\t\t\t\tgrestore\n\t\t\t} {\n\t\t\t\trectstroke\n\t\t\t} ifelse\n\t\t} bd\n\t\t/sf {\n\t\t\tPFLevel1 {\n\t\t\t\texch findfont exch scalefont setfont\n\t\t\t} {\n\t\t\t\tselectfont\n\t\t\t} ifelse\n\t\t} bd\n\t\t/iso {\t\t% iso-fontname fontname |- -\n\t\t\tfindfont\n\t\t\tdup length dict begin\n\t\t\t\t{1 index /FID ne {def} {pop pop} ifelse} forall\n\t\t\t\t/Encoding ISOLatin1Encoding def\n\t\t\t\tcurrentdict\n\t\t\tend\n\t\t\tdefinefont pop\n\t\t} bd\n\tend def\n%%EndResource";
    static String std_EPS_prologue_end = "%%EndProlog";

    public JCEPSPrinter(OutputStream outputStream) {
        this.setOutputStream(outputStream);
        FontPS.getAllFonts();
    }

    public JCEPSPrinter(OutputStream outputStream, FontParser fontParser, String string, String string2, String string3) {
        this.os = outputStream;
        FontPS.getAllFonts(fontParser, string, string2, string3);
    }

    public void setup() {
    }

    public boolean isImageScalable() {
        return true;
    }

    public void openDocument(Rectangle2D rectangle2D) {
        super.openDocument(rectangle2D);
        this.output(std_EPS_headers);
        this.output("%%CreationDate: " + new Date().toString());
        this.output("%%BoundingBox: " + (int)rectangle2D.getX() + " " + (int)rectangle2D.getY() + " " + (int)rectangle2D.getWidth() + " " + (int)rectangle2D.getHeight());
        this.output(std_EPS_prologue_begin);
        this.output(std_EPS_prologue_end);
        this.output("PFBeginEPS");
        double d2 = rectangle2D.getX();
        double d3 = rectangle2D.getY();
        double d4 = rectangle2D.getWidth();
        double d5 = rectangle2D.getHeight();
        this.output(d2 + " " + (d5 + d3) + " translate");
        this.output("0.0 0.0 " + d4 + " " + -d5 + " rc");
    }

    public void closeDocument(Rectangle2D rectangle2D) {
        this.output("PFEndEPS");
        this.output("%%EOF");
        super.closeDocument(rectangle2D);
    }

    public void beginPage(Rectangle2D rectangle2D, int n2) {
        super.beginPage(rectangle2D, n2);
    }

    public void endPage(Rectangle2D rectangle2D) {
        super.endPage(rectangle2D);
    }

    public Graphics getGraphics() {
        if (this.graphics == null) {
            this.graphics = new Graphics2DPS(this.os);
        }
        return this.graphics;
    }
}

