/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page;

import com.klg.jclass.cell.JCCellInfo;
import com.klg.jclass.page.JCPageTable;
import java.awt.Color;
import java.awt.Font;
import java.awt.Insets;
import java.awt.Rectangle;

public class PageTableCellInfo
implements JCCellInfo {
    protected JCPageTable table;
    protected int row;
    protected int column;
    protected Rectangle drawingArea = null;

    public PageTableCellInfo(JCPageTable jCPageTable, int n2, int n3) {
        this.table = jCPageTable;
        this.row = n2;
        this.column = n3;
    }

    public Color getBackground() {
        return this.table.getCell(this.row, this.column).getBackgroundColor();
    }

    public Color getForeground() {
        return this.table.getCell(this.row, this.column).getStyle().getColor();
    }

    public Color getSelectedBackground() {
        return this.getBackground();
    }

    public Color getSelectedForeground() {
        return this.getForeground();
    }

    public Font getFont() {
        return this.table.getCell(this.row, this.column).getStyle().getFont();
    }

    public int getHorizontalAlignment() {
        int n2 = this.table.getCell(this.row, this.column).getStyle().getAlignment();
        if (n2 == 2 || n2 == 1) {
            return 2;
        }
        if (n2 == 4 || n2 == 5) {
            return 0;
        }
        return 4;
    }

    public int getVerticalAlignment() {
        int n2 = this.table.getCell(this.row, this.column).getCellAlignment();
        if (n2 == 4) {
            return 3;
        }
        if (n2 == 3) {
            return 0;
        }
        return 1;
    }

    public Insets getMarginInsets() {
        return new Insets(0, 0, 1000, 1000);
    }

    public Insets getBorderInsets() {
        return new Insets(0, 0, 1000, 1000);
    }

    public int getBorderStyle() {
        return 0;
    }

    public Rectangle getDrawingArea() {
        if (this.drawingArea == null) {
            return new Rectangle();
        }
        return this.drawingArea;
    }

    public void setDrawingArea(Rectangle rectangle) {
        this.drawingArea = rectangle;
    }

    public boolean isEditable() {
        return false;
    }

    public boolean isEnabled() {
        return false;
    }

    public boolean getSelectAll() {
        return false;
    }

    public int getClipHints() {
        return 0;
    }

    public Class getDataType() {
        return this.table.getTableData().getTableDataItem(this.row, this.column).getClass();
    }
}

