/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page;

public final class JCUnit {
    public static final JCUnit INCHES = new JCUnit("inches");
    public static final JCUnit CM = new JCUnit("centimetres");
    public static final JCUnit POINTS = new JCUnit("points");
    public static final JCUnit INTERNAL = INCHES;
    private static JCUnit defaultUnit = INCHES;
    public static final double INCHES_TO_CM_FACTOR = 2.54;
    public static final double POINTS_TO_CM_FACTOR = 28.346456692913385;
    public static final JCUnit[] UNITS = new JCUnit[]{INCHES, CM, POINTS};
    protected String name;

    public static final Measure[] doublesToMeasures(JCUnit jCUnit, double[] dArray) {
        Measure[] measureArray = new Measure[dArray.length];
        for (int i2 = 0; i2 < dArray.length; ++i2) {
            measureArray[i2] = new Measure(jCUnit, dArray[i2]);
        }
        return measureArray;
    }

    public JCUnit(String string) {
        this.name = string;
    }

    public String toString() {
        return this.name;
    }

    public int hashCode() {
        return this.name != null ? this.name.hashCode() : 0;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof JCUnit)) {
            return false;
        }
        JCUnit jCUnit = (JCUnit)object;
        return !(this.name != null ? !this.name.equals(jCUnit.name) : jCUnit.name != null);
    }

    protected static int hashMeasure(double d2) {
        int n2 = (int)d2;
        double d3 = d2 - (double)n2;
        return n2 += (int)(d3 * 1.0E8);
    }

    public static boolean areProbablyEqual(double d2, double d3) {
        return Math.abs(d2 - d3) < 1.0E-8;
    }

    public static final JCUnit getDefaultUnits() {
        return defaultUnit;
    }

    public static final void setDefaultUnit(JCUnit jCUnit) {
        defaultUnit = jCUnit;
    }

    public static final double getAsCentimeters(JCUnit jCUnit, double d2) {
        if (jCUnit == CM) {
            return d2;
        }
        if (jCUnit == INCHES) {
            return d2 * 2.54;
        }
        if (jCUnit == POINTS) {
            return d2 / 28.346456692913385;
        }
        throw new IllegalArgumentException("Unrecognised Unit type");
    }

    public static final double getIU(JCUnit jCUnit, double d2) {
        if (jCUnit == CM) {
            return d2 / 2.54;
        }
        if (jCUnit == INCHES) {
            return d2;
        }
        if (jCUnit == POINTS) {
            return d2 / 72.0;
        }
        throw new IllegalArgumentException("Unrecognised Unit type");
    }

    public static final double getAsInches(JCUnit jCUnit, double d2) {
        return JCUnit.getIU(jCUnit, d2);
    }

    public static final double getAsPoints(JCUnit jCUnit, double d2) {
        if (jCUnit == CM) {
            return d2 * 28.346456692913385;
        }
        if (jCUnit == INCHES) {
            return d2 * 72.0;
        }
        if (jCUnit == POINTS) {
            return d2;
        }
        throw new IllegalArgumentException("Unrecognised Unit type");
    }

    public static final double getAs(JCUnit jCUnit, JCUnit jCUnit2, double d2) {
        if (jCUnit == jCUnit2) {
            return d2;
        }
        if (jCUnit == CM) {
            return JCUnit.getAsCentimeters(jCUnit2, d2);
        }
        if (jCUnit == INCHES) {
            return JCUnit.getAsInches(jCUnit2, d2);
        }
        if (jCUnit == POINTS) {
            return JCUnit.getAsPoints(jCUnit2, d2);
        }
        throw new IllegalArgumentException("Unrecognised Unit type");
    }

    public static class Margins
    implements Cloneable {
        public JCUnit units;
        public double top;
        public double bottom;
        public double left;
        public double right;

        public Margins() {
            this.units = JCUnit.getDefaultUnits();
        }

        public Margins(JCUnit jCUnit) {
            this.units = jCUnit;
        }

        public Margins(double d2, double d3, double d4, double d5) {
            this.units = JCUnit.getDefaultUnits();
            this.top = d2;
            this.bottom = d3;
            this.left = d4;
            this.right = d5;
        }

        public Margins(JCUnit jCUnit, double d2, double d3, double d4, double d5) {
            this.units = jCUnit;
            this.top = d2;
            this.bottom = d3;
            this.left = d4;
            this.right = d5;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public Measure getTop() {
            return new Measure(this.units, this.top);
        }

        public void setTop(Measure measure) {
            this.top = measure.getAs(this.units);
        }

        public Measure getBottom() {
            return new Measure(this.units, this.bottom);
        }

        public void setBottom(Measure measure) {
            this.bottom = measure.getAs(this.units);
        }

        public Measure getLeft() {
            return new Measure(this.units, this.left);
        }

        public void setLeft(Measure measure) {
            this.left = measure.getAs(this.units);
        }

        public Measure getRight() {
            return new Measure(this.units, this.right);
        }

        public void setRight(Measure measure) {
            this.right = measure.getAs(this.units);
        }

        public void assign(Margins margins) {
            this.units = margins.units;
            this.left = margins.left;
            this.right = margins.right;
            this.top = margins.top;
            this.bottom = margins.bottom;
        }

        public int hashCode() {
            int n2 = JCUnit.hashMeasure(JCUnit.getAsPoints(this.units, this.left));
            int n3 = JCUnit.hashMeasure(JCUnit.getAsPoints(this.units, this.right));
            int n4 = JCUnit.hashMeasure(JCUnit.getAsPoints(this.units, this.top));
            int n5 = JCUnit.hashMeasure(JCUnit.getAsPoints(this.units, this.bottom));
            int n6 = n2 + n5;
            int n7 = n3 + n4;
            int n8 = n6 * (n6 + 1) / 2 + n2;
            int n9 = n7 * (n7 + 1) / 2 + n4;
            int n10 = n8 + n9;
            return n10 * (n10 + 1) / 2 + n9;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Margins)) {
                return false;
            }
            Margins margins = (Margins)object;
            return JCUnit.areProbablyEqual(JCUnit.getAsPoints(this.units, this.left), JCUnit.getAsPoints(margins.units, margins.left)) && JCUnit.areProbablyEqual(JCUnit.getAsPoints(this.units, this.right), JCUnit.getAsPoints(margins.units, margins.right)) && JCUnit.areProbablyEqual(JCUnit.getAsPoints(this.units, this.top), JCUnit.getAsPoints(margins.units, margins.top)) && JCUnit.areProbablyEqual(JCUnit.getAsPoints(this.units, this.bottom), JCUnit.getAsPoints(margins.units, margins.bottom));
        }

        public String toString() {
            return "(l, r, t, b) = (" + this.left + ", " + this.right + ", " + this.top + ", " + this.bottom + ") " + this.units;
        }
    }

    public static class Dimension
    implements Cloneable {
        public JCUnit units;
        public double width;
        public double height;

        public Dimension() {
            this.units = JCUnit.getDefaultUnits();
        }

        public Dimension(JCUnit jCUnit) {
            this.units = jCUnit;
        }

        public Dimension(double d2, double d3) {
            this.units = JCUnit.getDefaultUnits();
            this.width = d2;
            this.height = d3;
        }

        public Dimension(JCUnit jCUnit, double d2, double d3) {
            this.units = jCUnit;
            this.width = d2;
            this.height = d3;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public Measure getWidth() {
            return new Measure(this.units, this.width);
        }

        public void setWidth(Measure measure) {
            this.width = measure.getAs(this.units);
        }

        public double widthInt() {
            return JCUnit.getIU(this.units, this.width);
        }

        public Measure getHeight() {
            return new Measure(this.units, this.height);
        }

        public void setHeight(Measure measure) {
            this.height = measure.getAs(this.units);
        }

        public double heightInt() {
            return JCUnit.getIU(this.units, this.height);
        }

        public void assign(Dimension dimension) {
            this.units = dimension.units;
            this.width = dimension.width;
            this.height = dimension.height;
        }

        public int hashCode() {
            int n2 = JCUnit.hashMeasure(JCUnit.getAsPoints(this.units, this.width));
            int n3 = JCUnit.hashMeasure(JCUnit.getAsPoints(this.units, this.height));
            int n4 = n2 + n3;
            return n4 * (n4 + 1) / 2 + n2;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Dimension)) {
                return false;
            }
            Dimension dimension = (Dimension)object;
            return JCUnit.areProbablyEqual(JCUnit.getAsPoints(this.units, this.width), JCUnit.getAsPoints(dimension.units, dimension.width)) && JCUnit.areProbablyEqual(JCUnit.getAsPoints(this.units, this.height), JCUnit.getAsPoints(dimension.units, dimension.height));
        }

        public String toString() {
            return this.width + "x" + this.height + " " + this.units;
        }
    }

    public static class Point
    implements Cloneable {
        public JCUnit units;
        public double x;
        public double y;

        public Point() {
            this.units = JCUnit.getDefaultUnits();
        }

        public Point(JCUnit jCUnit) {
            this.units = jCUnit;
        }

        public Point(double d2, double d3) {
            this.units = JCUnit.getDefaultUnits();
            this.x = d2;
            this.y = d3;
        }

        public Point(JCUnit jCUnit, double d2, double d3) {
            this.units = jCUnit;
            this.x = d2;
            this.y = d3;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public Measure getX() {
            return new Measure(this.units, this.x);
        }

        public void setX(Measure measure) {
            this.x = measure.getAs(this.units);
        }

        public double xInt() {
            return JCUnit.getIU(this.units, this.x);
        }

        public Measure getY() {
            return new Measure(this.units, this.y);
        }

        public void setY(Measure measure) {
            this.y = measure.getAs(this.units);
        }

        public double yInt() {
            return JCUnit.getIU(this.units, this.y);
        }

        public void assign(Point point) {
            this.units = point.units;
            this.x = point.x;
            this.y = point.y;
        }

        public int hashCode() {
            int n2 = JCUnit.hashMeasure(JCUnit.getAsPoints(this.units, this.x));
            int n3 = JCUnit.hashMeasure(JCUnit.getAsPoints(this.units, this.y));
            long l2 = Double.doubleToLongBits(n2);
            return (int)(l2 ^= Double.doubleToLongBits(n3) * 31L) ^ (int)(l2 >> 32);
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Point)) {
                return false;
            }
            Point point = (Point)object;
            return JCUnit.areProbablyEqual(JCUnit.getAsPoints(this.units, this.x), JCUnit.getAsPoints(point.units, point.x)) && JCUnit.areProbablyEqual(JCUnit.getAsPoints(this.units, this.y), JCUnit.getAsPoints(point.units, point.y));
        }

        public String toString() {
            return "(" + this.x + ", " + this.y + ") " + this.units;
        }
    }

    public static class Measure
    implements Cloneable {
        public JCUnit units;
        public double distance;

        public Measure() {
            this.units = JCUnit.getDefaultUnits();
        }

        public Measure(JCUnit jCUnit) {
            this.units = jCUnit;
        }

        public Measure(double d2) {
            this.units = JCUnit.getDefaultUnits();
            this.distance = d2;
        }

        public Measure(JCUnit jCUnit, double d2) {
            this.units = jCUnit;
            this.distance = d2;
        }

        public String toString() {
            return this.distance + " " + this.units;
        }

        public Object clone() {
            try {
                return super.clone();
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                return null;
            }
        }

        public double getAs(JCUnit jCUnit) {
            if (jCUnit == this.units) {
                return this.distance;
            }
            if (jCUnit == CM) {
                return JCUnit.getAsCentimeters(this.units, this.distance);
            }
            if (jCUnit == INCHES) {
                return JCUnit.getAsInches(this.units, this.distance);
            }
            if (jCUnit == POINTS) {
                return JCUnit.getAsPoints(this.units, this.distance);
            }
            throw new IllegalArgumentException("Unrecognised Unit type.");
        }

        public double internal() {
            return JCUnit.getIU(this.units, this.distance);
        }

        public void assign(Measure measure) {
            this.units = measure.units;
            this.distance = measure.distance;
        }

        public void add(Measure measure) {
            this.distance += measure.getAs(this.units);
        }

        public void subtract(Measure measure) {
            this.distance -= measure.getAs(this.units);
        }

        public void multiply(double d2) {
            this.distance *= d2;
        }

        public void divide(double d2) {
            this.distance /= d2;
        }

        public int hashCode() {
            return JCUnit.hashMeasure(JCUnit.getAsPoints(this.units, this.distance));
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (!(object instanceof Measure)) {
                return false;
            }
            Measure measure = (Measure)object;
            return JCUnit.areProbablyEqual(JCUnit.getAsPoints(this.units, this.distance), JCUnit.getAsPoints(measure.units, measure.distance));
        }

        public boolean greaterThan(Measure measure) {
            if (JCUnit.areProbablyEqual(JCUnit.getAsPoints(this.units, this.distance), JCUnit.getAsPoints(measure.units, measure.distance))) {
                return false;
            }
            return JCUnit.getAsPoints(this.units, this.distance) > JCUnit.getAsPoints(measure.units, measure.distance);
        }

        public boolean lessThan(Measure measure) {
            if (JCUnit.areProbablyEqual(JCUnit.getAsPoints(this.units, this.distance), JCUnit.getAsPoints(measure.units, measure.distance))) {
                return false;
            }
            return JCUnit.getAsPoints(this.units, this.distance) < JCUnit.getAsPoints(measure.units, measure.distance);
        }

        public boolean isZero() {
            return JCUnit.areProbablyEqual(this.distance, 0.0);
        }

        public boolean isNegative() {
            if (JCUnit.areProbablyEqual(this.distance, 0.0)) {
                return false;
            }
            return this.distance < 0.0;
        }
    }
}

