/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.page;

import com.klg.jclass.page.ttf.TTFFontNames;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.List;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.ResourceBundle;
import java.util.Vector;

public class FontFileLookup {
    public static final int NONE = -1;
    public static final int FILE_FULL = 0;
    public static final int URL_FILE = 1;
    public static final int URL_STREAM = 2;
    public static final int FILE_REL_CLASSPATH = 3;
    public static final int AFM_FILE = 0;
    public static final int TTF_FILE = 1;
    public static final int PROPERTIES_FILE = 2;
    public int lookupType = -1;
    public String location = null;
    public String propertiesFileName = null;
    public URL fileURL = null;
    public int fileType = -1;
    protected long fileLength = -1L;
    protected TTFFontNames ttfFontNames = null;

    public FontFileLookup() {
    }

    public FontFileLookup(int n2, String string, int n3) {
        if (n2 != 0 && n2 != 3) {
            throw new IllegalArgumentException("this constructor may only be used for lookup types of FILE_FULL and FILE_REL_CLASSPATH");
        }
        if (n3 != 0 && n3 != 1) {
            throw new IllegalArgumentException("this constructor may only be used for file types of AFM_FILE and TTF_FILE");
        }
        this.lookupType = n2;
        this.location = string;
        this.fileType = n3;
    }

    public FontFileLookup(int n2, URL uRL, int n3) {
        if (n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("this constructor may only be used for lookup types of URL_FILE and URL_STREAM");
        }
        if (n3 != 0 && n3 != 1) {
            throw new IllegalArgumentException("this constructor may only be used for file types of AFM_FILE and TTF_FILE");
        }
        this.lookupType = n2;
        this.fileURL = uRL;
        this.fileType = n3;
    }

    public FontFileLookup(int n2, String string, String string2, int n3) {
        if (n2 != 0 && n2 != 3) {
            throw new IllegalArgumentException("this constructor may only be used for lookup types of FILE_FULL and FILE_REL_CLASSPATH");
        }
        if (n3 != 2) {
            throw new IllegalArgumentException("this constructor may only be used for file types of PROPERTIES_FILE");
        }
        this.lookupType = n2;
        this.location = string;
        this.propertiesFileName = string2;
        this.fileType = n3;
    }

    public FontFileLookup(int n2, URL uRL, String string, int n3) {
        if (n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("this constructor may only be used for lookup types of URL_FILE and URL_STREAM");
        }
        if (n3 != 2) {
            throw new IllegalArgumentException("this constructor may only be used for file types of PROPERTIES_FILE");
        }
        this.lookupType = n2;
        this.fileURL = uRL;
        this.propertiesFileName = string;
        this.fileType = n3;
    }

    public void setTTFFontNames(TTFFontNames tTFFontNames) {
        this.ttfFontNames = tTFFontNames;
    }

    public TTFFontNames getTTFFontNames() {
        return this.ttfFontNames;
    }

    public InputStream openInputStream() throws IOException {
        InputStream inputStream = null;
        if (this.lookupType == 0) {
            File file = new File(this.location);
            this.fileLength = file.length();
            inputStream = new FileInputStream(file);
        } else if (this.lookupType == 1 || this.lookupType == 2) {
            URLConnection uRLConnection = this.fileURL.openConnection();
            this.fileLength = uRLConnection.getContentLength();
            inputStream = uRLConnection.getInputStream();
        } else if (this.lookupType == 3) {
            String string = (this.location.charAt(0) != '/' ? "/" : "") + this.location;
            URL uRL = this.getClass().getResource(string);
            URLConnection uRLConnection = uRL.openConnection();
            this.fileLength = uRLConnection.getContentLength();
            inputStream = uRLConnection.getInputStream();
        }
        return inputStream;
    }

    public long getFileLength() {
        return this.fileLength;
    }

    public ResourceBundle getResourceBundle() throws IOException {
        if (this.fileType != 2) {
            return null;
        }
        PropertyResourceBundle propertyResourceBundle = null;
        if (this.lookupType == 0) {
            File file = new File(this.location);
            File[] fileArray = file.listFiles(new FilenameFilter(){

                public boolean accept(File file, String string) {
                    return string.trim().endsWith(".properties");
                }
            });
            List list = FontFileLookup.calculateBundleSuffixes(this.propertiesFileName);
            File file2 = null;
            for (int i2 = list.size() - 1; i2 >= 0; --i2) {
                for (int i3 = 0; fileArray != null && i3 < fileArray.length; ++i3) {
                    if (!fileArray[i3].getName().equals((String)list.get(i2) + ".properties")) continue;
                    file2 = fileArray[i3];
                    break;
                }
                if (file2 != null) break;
            }
            if (file2 != null) {
                FileInputStream fileInputStream = null;
                try {
                    fileInputStream = new FileInputStream(file2);
                }
                catch (FileNotFoundException fileNotFoundException) {
                    fileNotFoundException.printStackTrace();
                }
                if (fileInputStream != null) {
                    propertyResourceBundle = new PropertyResourceBundle(fileInputStream);
                    fileInputStream.close();
                }
            }
        } else if (this.lookupType == 2) {
            InputStream inputStream = this.fileURL.openStream();
            propertyResourceBundle = new PropertyResourceBundle(inputStream);
            inputStream.close();
        } else if (this.lookupType == 3 || this.lookupType == 1) {
            String string = null;
            if (this.lookupType == 3) {
                string = (this.location.charAt(0) != '/' ? "/" : "") + this.location;
            } else if (this.lookupType == 1) {
                string = this.fileURL.toString();
            }
            string = string.endsWith("/") || string.endsWith("\\") ? string : string + "/";
            List list = FontFileLookup.calculateBundleSuffixes(this.propertiesFileName);
            InputStream inputStream = null;
            for (int i4 = list.size() - 1; i4 >= 0; --i4) {
                String string2 = string + (String)list.get(i4) + ".properties";
                if (this.lookupType == 3) {
                    inputStream = this.getClass().getResourceAsStream(string2);
                } else if (this.lookupType == 1) {
                    try {
                        URL uRL = new URL(string2);
                        inputStream = uRL.openStream();
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
                if (inputStream != null) break;
            }
            if (inputStream != null) {
                propertyResourceBundle = new PropertyResourceBundle(inputStream);
                inputStream.close();
            }
        }
        return propertyResourceBundle;
    }

    protected static List calculateBundleSuffixes(String string) {
        Vector<String> vector = new Vector<String>();
        Locale locale = Locale.getDefault();
        String string2 = locale.getLanguage();
        int n2 = string2.length();
        String string3 = locale.getCountry();
        int n3 = string3.length();
        String string4 = locale.getVariant();
        int n4 = string4.length();
        vector.addElement(string);
        if (n2 + n3 + n4 == 0) {
            return vector;
        }
        StringBuffer stringBuffer = new StringBuffer(string);
        stringBuffer.append('_');
        stringBuffer.append(string2);
        vector.addElement(stringBuffer.toString());
        if (n3 + n4 == 0) {
            return vector;
        }
        stringBuffer.append('_');
        stringBuffer.append(string3);
        vector.addElement(stringBuffer.toString());
        if (n4 == 0) {
            return vector;
        }
        stringBuffer.append('_');
        stringBuffer.append(string4);
        vector.addElement(stringBuffer.toString());
        return vector;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        if (this.fileType == 0) {
            stringBuffer.append("AFM ");
        } else if (this.fileType == 1) {
            stringBuffer.append("TTF ");
        } else if (this.fileType == 2) {
            stringBuffer.append("PROP ");
        } else {
            stringBuffer.append("Unknown ");
        }
        if (this.lookupType == 0) {
            stringBuffer.append("File: ");
            stringBuffer.append(this.location);
        } else if (this.lookupType == 1 || this.lookupType == 2) {
            stringBuffer.append("URL: ");
            stringBuffer.append(this.fileURL);
        } else if (this.lookupType == 3) {
            stringBuffer.append("Rel (CP) File: ");
            stringBuffer.append(this.location);
        }
        if (this.fileType == 2) {
            stringBuffer.append(" ");
            stringBuffer.append(this.propertiesFileName);
        }
        return stringBuffer.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object object) {
        boolean bl = false;
        if (!(object instanceof FontFileLookup)) return bl;
        FontFileLookup fontFileLookup = (FontFileLookup)object;
        if (fontFileLookup.fileType != this.fileType) {
            return false;
        }
        if (fontFileLookup.lookupType != this.lookupType) {
            return false;
        }
        if (fontFileLookup.lookupType == -1) {
            bl = true;
        } else if (fontFileLookup.lookupType == 0) {
            if (fontFileLookup.location != null || this.location != null) {
                if (!fontFileLookup.location.equals(this.location)) return false;
            }
            bl = true;
        } else if (fontFileLookup.lookupType == 1) {
            if (fontFileLookup.fileURL != null || this.fileURL != null) {
                if (!fontFileLookup.fileURL.equals(this.fileURL)) return false;
            }
            bl = true;
        } else if (fontFileLookup.lookupType == 2) {
            if (fontFileLookup.fileURL != null || this.fileURL != null) {
                if (!fontFileLookup.fileURL.equals(this.fileURL)) return false;
            }
            bl = true;
        } else if (fontFileLookup.lookupType == 3) {
            if (fontFileLookup.location != null || this.location != null) {
                if (!fontFileLookup.location.equals(this.location)) return false;
            }
            bl = true;
        }
        if (fontFileLookup.fileType != 2) return bl;
        if (fontFileLookup.propertiesFileName == null) {
            if (this.propertiesFileName == null) return true;
        }
        if (!fontFileLookup.propertiesFileName.equals(this.propertiesFileName)) return false;
        return true;
    }
}

