/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid.customizer;

import com.klg.jclass.higrid.LocaleBundle;
import com.klg.jclass.util.JCTypeConverter;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JPanel;

public class FontEditor
extends JPanel {
    static final int MIXED_STYLE = -1;
    static final int MIXED_SIZE = -1;
    JComboBox familyChoser;
    JComboBox styleChoser;
    JComboBox sizeChoser;
    private String[] fonts;
    private String[] style_names = new String[]{"plain", "bold", "italic", "bold and italic"};
    private int[] styles = new int[]{0, 1, 2, 3};
    private int[] point_sizes = new int[]{3, 5, 8, 10, 12, 14, 18, 24, 28, 30, 32, 36, 48};
    boolean levelFont;

    public FontEditor(ItemListener itemListener) {
        this(itemListener, false);
    }

    public FontEditor(ItemListener itemListener, boolean bl) {
        super(new FlowLayout());
        this.fonts = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        this.levelFont = bl;
        this.familyChoser = new JComboBox();
        this.styleChoser = new JComboBox();
        this.sizeChoser = new JComboBox();
        if (bl) {
            this.familyChoser.addItem(LocaleBundle.string("MixedCellFonts"));
            this.styleChoser.addItem(LocaleBundle.string("MixedCellFonts"));
            this.sizeChoser.addItem(LocaleBundle.string("MixedCellFonts"));
        }
        int n2 = 0;
        while (n2 < this.fonts.length) {
            this.familyChoser.addItem(this.fonts[n2]);
            ++n2;
        }
        this.familyChoser.addItemListener(itemListener);
        this.add(this.familyChoser);
        int n3 = 0;
        while (n3 < this.style_names.length) {
            this.styleChoser.addItem(this.style_names[n3]);
            ++n3;
        }
        this.styleChoser.addItemListener(itemListener);
        this.add(this.styleChoser);
        int n4 = 0;
        while (n4 < this.point_sizes.length) {
            this.sizeChoser.addItem("" + this.point_sizes[n4]);
            ++n4;
        }
        this.sizeChoser.addItemListener(itemListener);
        this.add(this.sizeChoser);
    }

    void selectFontName(String string) {
        int n2;
        int n3 = n2 = this.levelFont ? 0 : 1;
        if (this.levelFont && string == null) {
            n2 = 0;
        } else {
            int n4 = 0;
            while (n4 < this.fonts.length) {
                if (string.equals(this.fonts[n4])) {
                    n2 = this.levelFont ? n4 + 1 : n4;
                    break;
                }
                ++n4;
            }
        }
    }

    void selectFontStyle(int n2) {
        int n3;
        int n4 = n3 = this.levelFont ? 0 : 1;
        if (this.levelFont && n2 == -1) {
            n3 = 0;
        } else {
            int n5 = 0;
            while (n5 < this.styles.length) {
                if (n2 == this.styles[n5]) {
                    n3 = this.levelFont ? n5 + 1 : n5;
                    break;
                }
                ++n5;
            }
        }
        this.styleChoser.setSelectedIndex(n3);
    }

    void selectFontSize(int n2) {
        int n3;
        int n4 = n3 = this.levelFont ? 0 : 4;
        if (this.levelFont && n2 == -1) {
            n3 = 0;
        } else {
            int n5 = 0;
            while (n5 < this.point_sizes.length) {
                if (n2 == this.point_sizes[n5]) {
                    n3 = this.levelFont ? n5 + 1 : n5;
                    break;
                }
                ++n5;
            }
        }
        this.sizeChoser.setSelectedIndex(n3);
    }

    void selectFont(Font font) {
        if (font == null) {
            return;
        }
        this.selectFontName(font.getName());
        this.selectFontStyle(font.getStyle());
        this.selectFontSize(font.getSize());
    }

    void selectFont(String string, int n2, int n3) {
        this.selectFontName(string);
        this.selectFontStyle(n2);
        this.selectFontSize(n3);
    }

    Font getSelectedFont() {
        String string = this.getFontName();
        int n2 = this.getFontStyle();
        int n3 = this.getFontSize();
        return new Font(string, n2, n3);
    }

    String getFontName() {
        String string = (String)this.familyChoser.getSelectedItem();
        if (string == null) {
            string = "Serif";
        } else if (string.equals(LocaleBundle.string("MixedCellFonts"))) {
            string = null;
        }
        return string;
    }

    int getFontStyle() {
        JCTypeConverter jCTypeConverter = new JCTypeConverter();
        String string = (String)this.styleChoser.getSelectedItem();
        int n2 = -1;
        if (!string.equals(LocaleBundle.string("MixedCellFonts"))) {
            n2 = JCTypeConverter.toEnum(string, "cellFontStyle", this.style_names, this.styles, 0);
        }
        return n2;
    }

    int getFontSize() {
        JCTypeConverter jCTypeConverter = new JCTypeConverter();
        String string = (String)this.sizeChoser.getSelectedItem();
        int n2 = -1;
        if (!string.equals(LocaleBundle.string("MixedCellFonts"))) {
            n2 = 12;
            try {
                n2 = new Integer(string);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return n2;
    }
}

