/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid.customizer;

import com.klg.jclass.higrid.LocaleBundle;
import com.klg.jclass.util.swing.JCGridLayout;
import com.klg.jclass.util.swing.JCSwingTypeConverter;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionListener;
import java.awt.event.FocusListener;
import java.awt.event.ItemListener;
import java.util.StringTokenizer;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class ColorEditor
extends JPanel {
    static String[] colorNames = new String[]{"  ", "Black", "Blue", "Cyan", "DarkGray", "Gray", "Green", "LightGray", "LightBlue", "Magenta", "Orange", "Pink", "Red", "Yellow", "White"};
    static int[] colorRed = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static int[] colorGreen = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static int[] colorBlue = new int[]{0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0};
    static boolean colorSet = false;
    JRadioButton selectCannedColor;
    JRadioButton selectCustomColor;
    JComboBox cannedColor;
    JTextField customColor;
    ItemListener itemListener;
    boolean levelColor;

    public ColorEditor(ItemListener itemListener, ActionListener actionListener, FocusListener focusListener, String string, boolean bl) {
        super(new GridLayout(1, 1));
        this.itemListener = itemListener;
        if (!colorSet) {
            this.setCannedColors();
            colorSet = true;
        }
        this.levelColor = bl;
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(string));
        jPanel.setLayout(new JCGridLayout(0, 3, 5, 5));
        ButtonGroup buttonGroup = new ButtonGroup();
        this.selectCannedColor = new JRadioButton("", true);
        this.cannedColor = new JComboBox();
        this.selectCustomColor = new JRadioButton("", false);
        this.customColor = new JTextField("", 10);
        buttonGroup.add(this.selectCannedColor);
        buttonGroup.add(this.selectCustomColor);
        this.selectCannedColor.addItemListener(itemListener);
        int n2 = 0;
        while (n2 < colorNames.length) {
            this.cannedColor.addItem(colorNames[n2]);
            ++n2;
        }
        this.cannedColor.addItemListener(itemListener);
        this.selectCustomColor.addItemListener(itemListener);
        this.customColor.addActionListener(actionListener);
        if (focusListener != null) {
            this.customColor.addFocusListener(focusListener);
        }
        jPanel.add(this.selectCannedColor);
        jPanel.add(this.cannedColor);
        jPanel.add(new JLabel());
        jPanel.add(this.selectCustomColor);
        jPanel.add(this.customColor);
        jPanel.add(new JLabel(LocaleBundle.string("ColorEditorRGB")));
        this.add(jPanel);
    }

    public ColorEditor(ItemListener itemListener, ActionListener actionListener, String string, boolean bl) {
        this(itemListener, actionListener, null, string, bl);
    }

    public ColorEditor(ItemListener itemListener, ActionListener actionListener, String string) {
        this(itemListener, actionListener, string, false);
    }

    public void setEnabled(boolean bl) {
        super.setEnabled(bl);
        this.selectCannedColor.setEnabled(bl);
        this.selectCustomColor.setEnabled(bl);
        this.cannedColor.setEnabled(bl);
        this.customColor.setEnabled(bl);
    }

    Color getCannedColor(String string) {
        Color color = null;
        color = string.equals("Black") ? Color.black : (string.equals("Blue") ? Color.blue : (string.equals("Cyan") ? Color.cyan : (string.equals("DarkGray") ? Color.darkGray : (string.equals("Gray") ? Color.gray : (string.equals("Green") ? Color.green : (string.equals("LightBlue") ? JCSwingTypeConverter.lightBlue : (string.equals("LightGray") ? Color.lightGray : (string.equals("Magenta") ? Color.magenta : (string.equals("Orange") ? Color.orange : (string.equals("Pink") ? Color.pink : (string.equals("Red") ? Color.red : (string.equals("White") ? Color.white : (string.equals("Yellow") ? Color.yellow : Color.black)))))))))))));
        return color;
    }

    void setCannedColors() {
        Color color = null;
        int n2 = 0;
        while (n2 < colorNames.length) {
            String string = colorNames[n2];
            color = this.getCannedColor(string);
            if (color != null) {
                ColorEditor.colorRed[n2] = color.getRed();
                ColorEditor.colorGreen[n2] = color.getGreen();
                ColorEditor.colorBlue[n2] = color.getBlue();
            }
            ++n2;
        }
    }

    void selectColor(Color color) {
        if (color == null) {
            if (this.levelColor) {
                this.customColor.setText(new String(LocaleBundle.string("MixedCellColors")));
                if (this.cannedColor.getSelectedIndex() != 0) {
                    this.cannedColor.setSelectedIndex(0);
                }
                if (!this.selectCustomColor.isSelected()) {
                    this.selectCustomColor.setSelected(true);
                }
            }
            return;
        }
        int n2 = color.getRed();
        int n3 = color.getGreen();
        int n4 = color.getBlue();
        this.customColor.setText(new String(n2 + "," + n3 + "," + n4));
        int n5 = -1;
        int n6 = 1;
        while (n6 < colorNames.length) {
            if (colorRed[n6] == n2 && colorGreen[n6] == n3 && colorBlue[n6] == n4) {
                n5 = n6;
                break;
            }
            ++n6;
        }
        n5 = Math.max(0, n5);
        if (this.cannedColor.getSelectedIndex() != n5) {
            this.cannedColor.setSelectedIndex(n5);
        }
        if (n5 == 0) {
            if (!this.selectCustomColor.isSelected()) {
                this.selectCustomColor.setSelected(true);
            }
        } else if (!this.selectCannedColor.isSelected()) {
            this.selectCannedColor.setSelected(true);
        }
    }

    Color getColor() {
        Color color = null;
        String string = (String)this.cannedColor.getSelectedItem();
        if (this.selectCustomColor.isSelected() || string.equals(colorNames[0])) {
            boolean bl = true;
            String string2 = this.customColor.getText();
            if (this.levelColor && string2.equals(LocaleBundle.string("MixedCellColors"))) {
                return null;
            }
            StringTokenizer stringTokenizer = new StringTokenizer(string2, ",");
            int[] nArray = new int[]{0, 0, 0};
            int n2 = 0;
            while (n2 < 3) {
                if (stringTokenizer.hasMoreTokens()) {
                    try {
                        nArray[n2] = new Integer(stringTokenizer.nextToken());
                    }
                    catch (Exception exception) {
                        bl = false;
                    }
                }
                ++n2;
            }
            if (bl) {
                color = new Color(nArray[0], nArray[1], nArray[2]);
            }
            if (this.cannedColor.getSelectedIndex() != 0) {
                this.cannedColor.setSelectedIndex(0);
            }
        } else {
            color = this.getCannedColor(string);
            this.selectColor(color);
        }
        return color;
    }

    boolean checkColorSource(Object object) {
        if (object.equals(this.cannedColor)) {
            if (!this.selectCannedColor.isSelected()) {
                this.selectCannedColor.setSelected(true);
            }
            return true;
        }
        if (object.equals(this.customColor)) {
            if (!this.selectCustomColor.isSelected()) {
                this.selectCustomColor.setSelected(true);
            }
            return true;
        }
        return false;
    }
}

