/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid.customizer;

import com.klg.jclass.higrid.CellFormat;
import com.klg.jclass.higrid.EditStatusCellFormat;
import com.klg.jclass.higrid.LocaleBundle;
import com.klg.jclass.higrid.beans.JCHiGridConverter;
import com.klg.jclass.higrid.beans.JCHiGridEvent;
import com.klg.jclass.higrid.beans.JCHiGridNode;
import com.klg.jclass.higrid.customizer.ColorEditor;
import com.klg.jclass.higrid.customizer.FormatPage;
import com.klg.jclass.util.JCTypeConverter;
import com.klg.jclass.util.swing.JCGridLayout;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Enumeration;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class BaseEditStatusPage
extends FormatPage
implements ActionListener,
ItemListener {
    protected int section;
    EditStatusCellFormat editStatusCell;
    ColorEditor cellBackgroundColor;
    JTextField borderInsets;
    JComboBox borderStyle;

    public BaseEditStatusPage(int n2) {
        super(LocaleBundle.string("EditStatusIndicator"));
        this.init();
        this.section = n2;
    }

    public void init() {
        this.setLayout(new BorderLayout());
        JPanel jPanel = new JPanel();
        jPanel.setBorder(new TitledBorder(LocaleBundle.string("Border")));
        this.borderStyle = new JComboBox();
        this.borderInsets = new JTextField("", 15);
        JLabel jLabel = new JLabel(LocaleBundle.string("Style"));
        JLabel jLabel2 = new JLabel(LocaleBundle.string("Insets"));
        FocusAdapter focusAdapter = new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                BaseEditStatusPage.this.cellBackgroundColor.checkColorSource(focusEvent.getSource());
                BaseEditStatusPage.this.valueChanged();
            }
        };
        this.cellBackgroundColor = new ColorEditor(this, this, focusAdapter, LocaleBundle.string("BackgroundColor"), false);
        this.add((Component)this.cellBackgroundColor, "North");
        jPanel.setLayout(new JCGridLayout(0, 2, 5, 5));
        String[] stringArray = JCHiGridConverter.getRowFormatBorderStyleStrings();
        int n2 = 0;
        while (n2 < stringArray.length - 1) {
            this.borderStyle.addItem(stringArray[n2]);
            ++n2;
        }
        this.borderStyle.addItemListener(this);
        this.borderInsets.addActionListener(this);
        this.borderInsets.addFocusListener(focusAdapter);
        jPanel.add(jLabel);
        jPanel.add(this.borderStyle);
        jPanel.add(jLabel2);
        jPanel.add(this.borderInsets);
        this.add((Component)jPanel, "Center");
    }

    public void setSection(int n2) {
        this.section = n2;
    }

    public void valueChanged() {
        if (this.editStatusCell == null) {
            return;
        }
        boolean bl = false;
        Color color = this.cellBackgroundColor.getColor();
        if (color != null && !color.equals(this.editStatusCell.getBackground())) {
            this.editStatusCell.setBackground(color);
            bl = true;
        }
        String string = this.borderInsets.getText();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
        int[] nArray = new int[]{2, 2, 2, 2};
        boolean bl2 = true;
        int n2 = 0;
        while (n2 < 4) {
            if (stringTokenizer.hasMoreTokens()) {
                try {
                    nArray[n2] = new Integer(stringTokenizer.nextToken());
                }
                catch (Exception exception) {
                    bl2 = false;
                }
            }
            ++n2;
        }
        if (bl2) {
            this.editStatusCell.setBorderInsets(new Insets(nArray[0], nArray[1], nArray[2], nArray[3]));
            bl = true;
        }
        string = (String)this.borderStyle.getSelectedItem();
        JCTypeConverter jCTypeConverter = new JCTypeConverter();
        int n3 = JCHiGridConverter.toRowFormatBorderStyle(jCTypeConverter, string, 1);
        if (this.editStatusCell.getBorderStyle() != n3) {
            this.editStatusCell.setBorderStyle(n3);
            bl = true;
        }
        if (bl) {
            this.getJCHiGridNode().setChanged();
            this.getJCHiGridNode().getGridProperties().fireJCHiGridEvent(new JCHiGridEvent((Object)this.getJCHiGridNode().getGridProperties(), this.getJCHiGridNode()));
        }
    }

    public void showValue() {
        if (this.editStatusCell == null) {
            return;
        }
        this.cellBackgroundColor.selectColor(this.editStatusCell.getBackground());
        Insets insets = this.editStatusCell.getBorderInsets();
        this.borderInsets.setText(new String(insets.top + "," + insets.left + "," + insets.bottom + "," + insets.right));
        int n2 = this.editStatusCell.getBorderStyle();
        int n3 = -1;
        int n4 = 0;
        int n5 = 0;
        while (n5 < JCHiGridConverter.rowFormatBorderStyleValues.length - 1) {
            if (JCHiGridConverter.rowFormatBorderStyleValues[n5] == 1) {
                n4 = JCHiGridConverter.rowFormatBorderStyleValues[n5];
            }
            if (n2 == JCHiGridConverter.rowFormatBorderStyleValues[n5]) {
                n3 = n5;
                break;
            }
            ++n5;
        }
        if (n3 == -1) {
            n3 = n4;
        }
        this.borderStyle.setSelectedIndex(n3);
    }

    public void setJCHiGridNode(JCHiGridNode jCHiGridNode) {
        this.editStatusCell = this.getEditStatusCellFormat(jCHiGridNode);
        this.showValue();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isInitializing()) {
            return;
        }
        this.cellBackgroundColor.checkColorSource(actionEvent.getSource());
        this.valueChanged();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (this.isInitializing()) {
            return;
        }
        this.cellBackgroundColor.checkColorSource(itemEvent.getSource());
        this.valueChanged();
    }

    EditStatusCellFormat getEditStatusCellFormat(JCHiGridNode jCHiGridNode) {
        EditStatusCellFormat editStatusCellFormat = null;
        if (jCHiGridNode == null) {
            return editStatusCellFormat;
        }
        Vector vector = jCHiGridNode.getRowFormat(this.section).getIndicatorFormats();
        if (vector == null) {
            return editStatusCellFormat;
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            CellFormat cellFormat = (CellFormat)enumeration.nextElement();
            if (!(cellFormat instanceof EditStatusCellFormat)) continue;
            editStatusCellFormat = (EditStatusCellFormat)cellFormat;
            break;
        }
        return editStatusCellFormat;
    }
}

