/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid.beans;

import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.datasource.DataSourceTreeModel;
import com.klg.jclass.datasource.DataSourceTreeNode;
import com.klg.jclass.datasource.ErrorDialog;
import com.klg.jclass.datasource.TreeIterator;
import com.klg.jclass.datasource.beans.SerializedProperties;
import com.klg.jclass.higrid.JCVersion;
import com.klg.jclass.higrid.LocaleBundle;
import com.klg.jclass.higrid.beans.JCHiGridEvent;
import com.klg.jclass.higrid.beans.JCHiGridListener;
import com.klg.jclass.util.JCListenerList;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.Enumeration;

public class GridProperties
extends SerializedProperties
implements JCHiGridListener {
    static final long serialVersionUID = -8818261247530958236L;
    protected int dataSourceType = 1;
    private DataSourceTreeModel tree;
    private transient Object[] dataSources;
    private transient String[] dataSourceNames;
    private String modelName;
    private String dataBinding;
    private transient JCListenerList JCHiGridListeners = null;
    private transient boolean isFiringJCHiGridEvent = false;
    private static transient String serializedVersion = new String("");
    private static final String base = "jchigrid";
    private static final boolean TRACE = false;
    private static int counter = 0;
    private static int counterModelName = 1;
    protected boolean externalDS;

    public GridProperties() {
        this(1, false);
    }

    public GridProperties(boolean bl) {
        this(1, bl);
    }

    public GridProperties(int n2, boolean bl) {
        this.dataSourceType = n2;
        this.externalDS = bl;
        this.tree = new DataSourceTreeModel(DataSourceTreeModel.NullRoot);
        this.setDefaultSerializationFileBase(this.getBase());
        this.serializationFile = SerializedProperties.getDefaultSerializationFile(this.getBase(), this.getCounter());
        try {
            String string = this.serializationFile.substring(this.serializationFile.indexOf(this.getBase()) + this.getBase().length());
            string = string.substring(0, string.indexOf(".ser"));
            this.setCounter(Integer.parseInt(string));
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.modelName = "HiGridData" + counterModelName++;
    }

    public GridProperties(String string, ClassLoader classLoader) throws DataModelException {
        this(string, classLoader, null, null);
    }

    public GridProperties(String string, Class clazz, String string2) throws DataModelException {
        this(string, clazz, string2, null, null);
    }

    public GridProperties(String string, Class clazz, String string2, String[] stringArray, Object[] objectArray) throws DataModelException {
        this(string, clazz, string2, stringArray, objectArray, false);
    }

    public GridProperties(String string, Class clazz, String string2, String[] stringArray, Object[] objectArray, boolean bl) throws DataModelException {
        try {
            this.tree = new DataSourceTreeModel(DataSourceTreeModel.NullRoot);
            if (string != null) {
                GridProperties gridProperties = (GridProperties)GridProperties.fromResource(clazz, string);
                this.copyProperties(gridProperties);
            } else {
                int n2 = this.getCounter();
                this.serializationFile = this.getBase() + n2++ + ".ser";
                this.setCounter(n2);
                this.resourceName = this.serializationFile;
                this.externalDS = bl;
            }
            this.dataSources = objectArray;
            this.dataSourceNames = stringArray;
            if (this.externalDS != bl) {
                ErrorDialog.showError(null, LocaleBundle.string("WrongDataSourceType"));
            }
        }
        catch (Exception exception) {
            throw new DataModelException(107, exception);
        }
    }

    public GridProperties(String string, Class clazz) throws DataModelException {
        this(string, clazz, null, null);
    }

    public GridProperties(String string, Class clazz, String[] stringArray, Object[] objectArray) throws DataModelException {
        this(string, clazz, stringArray, objectArray, false);
    }

    public GridProperties(String string, Class clazz, String[] stringArray, Object[] objectArray, boolean bl) throws DataModelException {
        try {
            this.tree = new DataSourceTreeModel(DataSourceTreeModel.NullRoot);
            if (string != null) {
                GridProperties gridProperties = (GridProperties)GridProperties.fromResource(clazz, string);
                this.copyProperties(gridProperties);
            } else {
                int n2 = this.getCounter();
                this.serializationFile = this.getBase() + n2++ + ".ser";
                this.setCounter(n2);
                this.resourceName = this.serializationFile;
                this.externalDS = bl;
            }
            this.dataSources = objectArray;
            this.dataSourceNames = stringArray;
            if (this.externalDS != bl) {
                ErrorDialog.showError(null, LocaleBundle.string("WrongDataSourceType"));
            }
        }
        catch (Exception exception) {
            throw new DataModelException(107, exception);
        }
    }

    public GridProperties(String string, ClassLoader classLoader, String[] stringArray, Object[] objectArray) throws DataModelException {
        this(string, classLoader, stringArray, objectArray, false);
    }

    public GridProperties(String string, ClassLoader classLoader, String[] stringArray, Object[] objectArray, boolean bl) throws DataModelException {
        try {
            this.tree = new DataSourceTreeModel(DataSourceTreeModel.NullRoot);
            if (string != null) {
                GridProperties gridProperties = (GridProperties)GridProperties.fromResource(classLoader, string);
                this.copyProperties(gridProperties);
            } else {
                int n2 = this.getCounter();
                this.serializationFile = this.getBase() + n2++ + ".ser";
                this.setCounter(n2);
                this.resourceName = this.serializationFile;
                this.externalDS = bl;
            }
            this.dataSources = objectArray;
            this.dataSourceNames = stringArray;
            if (this.externalDS != bl) {
                ErrorDialog.showError(null, LocaleBundle.string("WrongDataSourceType"));
            }
        }
        catch (Exception exception) {
            throw new DataModelException(107, exception);
        }
    }

    private void copyProperties(GridProperties gridProperties) {
        this.setRoot(gridProperties.getRoot());
        this.setSerializationFile(gridProperties.getSerializationFile());
        this.setResourceName(gridProperties.getResourceName());
        this.setDataSourceType(gridProperties.getDataSourceType());
        this.setModelName(gridProperties.getModelName());
        this.setDataBinding(gridProperties.getDataBinding());
        this.setExternalDS(gridProperties.isExternalDS());
    }

    protected String getBase() {
        return base;
    }

    protected int getCounter() {
        return counter;
    }

    protected void setCounter(int n2) {
        counter = n2;
    }

    public void setDataSourceType(int n2) {
        if (this.dataSourceType == n2) {
            return;
        }
        this.dataSourceType = n2;
        this.setChanged();
    }

    public int getDataSourceType() {
        return this.dataSourceType;
    }

    public String[] getDataSourceNames() {
        return this.dataSourceNames;
    }

    public Object[] getDataSources() {
        return this.dataSources;
    }

    public void setModelName(String string) {
        if (this.isSameString(this.modelName, string)) {
            return;
        }
        this.modelName = string;
        this.setChanged();
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setExternalDS(boolean bl) {
        this.externalDS = bl;
    }

    public boolean isExternalDS() {
        return this.externalDS;
    }

    public void setDataBinding(String string) {
        if (this.isSameString(this.dataBinding, string)) {
            return;
        }
        this.dataBinding = string;
        this.setChanged();
    }

    public String getDataBinding() {
        return this.dataBinding;
    }

    public static SerializedProperties fromResource(ClassLoader classLoader, String string) throws ClassNotFoundException, IOException {
        GridProperties gridProperties = (GridProperties)SerializedProperties.fromResource(classLoader, string);
        return gridProperties;
    }

    public static String getVersion() {
        return JCVersion.getVersionNumber();
    }

    public static synchronized String getSerializedVersion() {
        return serializedVersion;
    }

    public DataSourceTreeNode getRoot() {
        return (DataSourceTreeNode)this.tree.getRoot();
    }

    public void setRoot(DataSourceTreeNode dataSourceTreeNode) {
        this.tree.setRoot(dataSourceTreeNode);
        this.setChanged();
    }

    public void removeAll() {
        this.tree.setRoot(null);
        this.setChanged();
    }

    public void remove(DataSourceTreeNode dataSourceTreeNode) {
        DataSourceTreeNode dataSourceTreeNode2 = (DataSourceTreeNode)dataSourceTreeNode.getParent();
        if (dataSourceTreeNode2 == null) {
            this.removeAll();
        } else {
            dataSourceTreeNode2.remove(dataSourceTreeNode);
        }
        this.setChanged();
    }

    protected void setChanged() {
        super.setChanged();
    }

    public synchronized void addJCHiGridListener(JCHiGridListener jCHiGridListener) {
        this.JCHiGridListeners = JCListenerList.add(this.JCHiGridListeners, jCHiGridListener);
    }

    public synchronized void removeJCHiGridListener(JCHiGridListener jCHiGridListener) {
        this.JCHiGridListeners = JCListenerList.remove(this.JCHiGridListeners, jCHiGridListener);
    }

    public void fireJCHiGridEvent(JCHiGridEvent jCHiGridEvent) {
        boolean bl;
        boolean bl2 = bl = jCHiGridEvent.getValue() != 3;
        if (bl) {
            if (this.isFiringJCHiGridEvent) {
                return;
            }
            this.isFiringJCHiGridEvent = true;
        }
        Enumeration<Object> enumeration = JCListenerList.elements(this.JCHiGridListeners);
        while (enumeration.hasMoreElements()) {
            JCHiGridListener jCHiGridListener = (JCHiGridListener)enumeration.nextElement();
            jCHiGridListener.JCHiGridValueChanged(jCHiGridEvent);
        }
        if (bl) {
            this.isFiringJCHiGridEvent = false;
        }
    }

    private void buildTree(StringBuffer stringBuffer, DataSourceTreeNode dataSourceTreeNode, int n2) {
        if (dataSourceTreeNode == null) {
            return;
        }
        stringBuffer.append("\n\tLEVEL: " + n2++);
        stringBuffer.append("\n");
        stringBuffer.append(dataSourceTreeNode);
        stringBuffer.append("\n");
        stringBuffer.append(dataSourceTreeNode.getUserObject());
        stringBuffer.append("\n");
        TreeIterator treeIterator = dataSourceTreeNode.getIterator();
        while (treeIterator.hasMoreElements()) {
            DataSourceTreeNode dataSourceTreeNode2 = (DataSourceTreeNode)treeIterator.nextElement();
            this.buildTree(stringBuffer, dataSourceTreeNode2, n2);
        }
    }

    public String toString() {
        String string = super.toString();
        String string2 = System.getProperty("line.separator");
        return string;
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        objectOutputStream.writeObject(GridProperties.getVersion());
        try {
            objectOutputStream.defaultWriteObject();
        }
        catch (Exception exception) {
            exception.printStackTrace(System.out);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void readObject(ObjectInputStream objectInputStream) throws IOException {
        String string = serializedVersion;
        synchronized (string) {
            try {
                serializedVersion = (String)objectInputStream.readObject();
                objectInputStream.defaultReadObject();
            }
            catch (Exception exception) {
                exception.printStackTrace(System.out);
            }
        }
    }

    public void JCHiGridValueChanged(JCHiGridEvent jCHiGridEvent) {
        this.setChanged();
        if (jCHiGridEvent.getJCHiGridNode() != null && jCHiGridEvent.getValue() == 2) {
            jCHiGridEvent.getJCHiGridNode().setDoRetrieveAllFields(true);
        }
        this.fireJCHiGridEvent(new JCHiGridEvent(this, jCHiGridEvent.getValue(), jCHiGridEvent.getJCHiGridNode(), jCHiGridEvent.getNodeProperties()));
    }
}

