/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid;

import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.datasource.DataSourceTreeModel;
import com.klg.jclass.datasource.DataSourceTreeNode;
import com.klg.jclass.datasource.DataTableModel;
import com.klg.jclass.datasource.TreeIterator;
import com.klg.jclass.higrid.FormatNode;
import com.klg.jclass.higrid.FormatTree;
import com.klg.jclass.higrid.HeaderFormat;
import com.klg.jclass.higrid.HiGrid;
import com.klg.jclass.higrid.HiGridData;
import com.klg.jclass.higrid.HiGridErrorEvent;
import com.klg.jclass.higrid.HiGridExpansionEvent;
import com.klg.jclass.higrid.HiGridInternalData;
import com.klg.jclass.higrid.HiGridUpdateEvent;
import com.klg.jclass.higrid.LastRowWalk;
import com.klg.jclass.higrid.LastVisibleRowWalk;
import com.klg.jclass.higrid.PageDownWalk;
import com.klg.jclass.higrid.PageUpWalk;
import com.klg.jclass.higrid.RecordFormat;
import com.klg.jclass.higrid.RowFormat;
import com.klg.jclass.higrid.RowNode;
import com.klg.jclass.higrid.RowNodeWalk;
import com.klg.jclass.higrid.RowValueWalk;
import com.klg.jclass.higrid.RowWalk;
import com.klg.jclass.higrid.SortData;
import com.klg.jclass.higrid.SortGrid;
import com.klg.jclass.higrid.Walkable;
import java.awt.Graphics;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.MutableTreeNode;

public class RowTree
extends DataSourceTreeModel {
    static final long serialVersionUID = -1732819294164988029L;
    private HiGrid grid;
    private boolean runtime;
    private RowNode topRowNode = null;
    private int gridAreaWidth = 0;
    private int gridAreaRows = 0;
    private int totalNumberOfScrollableRows = 0;
    private int scrollableRowsHeight = 0;
    private int lastPageTopRow = 0;
    private RowNode lastPageTopRowNode = null;
    private int[] metaIDArray = null;
    private int firstLevelGridAreaWidth = 0;
    private FormatNode lastHeaderFormatNode;
    private boolean sortTable = true;

    public RowTree(HiGrid hiGrid, boolean bl) {
        super(DataSourceTreeModel.NullRoot);
        RowNode rowNode = this.createRowNode(null, null, null, 0L);
        this.setRoot(rowNode);
        this.grid = hiGrid;
        this.runtime = bl;
    }

    public RowTree(HiGrid hiGrid) {
        this(hiGrid, true);
    }

    protected void setSortTable(boolean bl) {
        this.sortTable = bl;
    }

    protected void createRuntimeTree(FormatTree formatTree) {
        if (formatTree == null || this.grid.getDataModel() == null) {
            return;
        }
        FormatNode formatNode = (FormatNode)formatTree.getRoot();
        if (formatNode == null) {
            return;
        }
        RowNode rowNode = this.createRowNode(formatNode, null, null, 0L);
        this.setRoot(rowNode);
        this.lastHeaderFormatNode = null;
        if (this.grid.getDataModel() == null) {
            return;
        }
        DataTableModel dataTableModel = (DataTableModel)this.grid.getDataModel().getDataTableTree().getRoot();
        if (this.runtime) {
            ((HiGridData)this.grid.getDataModel()).setSummaryDataRoot(this.grid, dataTableModel);
        }
        this.sortTable = true;
        this.createRuntimeChildren(rowNode, formatNode, dataTableModel, false, null);
        this.scrollableRowsHeight = 0;
        this.setTotalNumberOfScrollableRows(0);
        this.addTotalNumberOfScrollableRows(this.getNumberOfScrollableRows(rowNode, true));
        if (this.runtime) {
            this.updateGridState();
        }
        ((HiGridData)this.grid.getDataModel()).resetSummaryDataTables(this.grid, true);
        if (this.runtime) {
            this.grid.fireHiGridUpdateEvent(new HiGridUpdateEvent(this.grid, 2));
        }
    }

    protected void createPrintTimeTree(FormatTree formatTree, int[] nArray) {
        if (nArray == null) {
            return;
        }
        this.metaIDArray = nArray;
        this.createRuntimeTree(formatTree);
    }

    protected int createRuntimeChildren(RowNode rowNode, FormatNode formatNode, DataTableModel dataTableModel, boolean bl, RowNode rowNode2) {
        int n2 = 0;
        try {
            n2 = dataTableModel.getRowCount();
        }
        catch (Exception exception) {
            this.grid.fireHiGridErrorEvent(new HiGridErrorEvent(this.grid, exception));
        }
        if (n2 == 0) {
            return 0;
        }
        RowNode rowNode3 = null;
        FormatNode formatNode2 = rowNode.getFormatNode();
        if (bl && formatNode2.getBeforeDetailsFormat().isShowing()) {
            rowNode3 = this.createRowNode(formatNode, formatNode2.getBeforeDetailsFormat(), rowNode.getDataTableModel(), 0L);
            this.addRowNode(rowNode, rowNode3, rowNode2);
        }
        long l2 = 0L;
        HeaderFormat headerFormat = formatNode.getHeaderFormat();
        int n3 = 0;
        while (n3 < n2) {
            if (headerFormat.isShowing() && (n3 == 0 || headerFormat.isRepeatHeader() && this.lastHeaderFormatNode != formatNode)) {
                rowNode3 = this.createRowNode(formatNode, headerFormat, dataTableModel, 0L);
                this.addRowNode(rowNode, rowNode3, rowNode2);
                this.lastHeaderFormatNode = formatNode;
            }
            l2 = dataTableModel.getRowIdentifier(n3);
            rowNode3 = this.createRowNode(formatNode, formatNode.getRecordFormat(), dataTableModel, l2);
            this.addRowNode(rowNode, rowNode3, rowNode2);
            if (formatNode.hasChildren()) {
                boolean bl2 = false;
                int n4 = formatNode.getAutoTraverse();
                if (this.runtime) {
                    switch (n4) {
                        case 0: {
                            break;
                        }
                        case 2: {
                            bl2 = true;
                            break;
                        }
                        case 1: {
                            bl2 = this.grid.fireHiGridExpansionEvent(new HiGridExpansionEvent(this.grid, 1, rowNode3));
                            break;
                        }
                        case 3: {
                            if (this.grid.getAutoTraverseCallback() == null) break;
                            byte by = this.grid.getAutoTraverseCallback().getState(this.grid, rowNode3);
                            if (by == 1) {
                                bl2 = this.grid.fireHiGridExpansionEvent(new HiGridExpansionEvent(this.grid, 1, rowNode3));
                                break;
                            }
                            rowNode3.setState(by);
                            bl2 = false;
                        }
                    }
                } else {
                    bl2 = true;
                }
                if (bl2) {
                    rowNode3.setState((byte)0);
                    this.openFolder(rowNode3);
                    if (rowNode3.hasChildren() && this.runtime && n4 == 2) {
                        this.closeFolder(rowNode3);
                        this.lastHeaderFormatNode = formatNode;
                    }
                }
            } else {
                rowNode3.setState((byte)2);
            }
            ++n3;
        }
        if (formatNode.getFooterFormat().isShowing()) {
            rowNode3 = this.createRowNode(formatNode, formatNode.getFooterFormat(), dataTableModel, 0L);
            this.addRowNode(rowNode, rowNode3, rowNode2);
        }
        if (this.sortTable && dataTableModel != null) {
            SortData sortData = formatNode.getDefaultSortData();
            if (sortData != null) {
                SortGrid sortGrid = new SortGrid(this.grid, false);
                sortGrid.sortColumn(formatNode, this.findFirstRowNode(rowNode, dataTableModel), sortData);
            } else {
                sortData = new SortData("");
                sortData.setDirection(0);
                formatNode.setDefaultSortData(sortData);
            }
        }
        return n2;
    }

    protected RowNode createRowNode(FormatNode formatNode, RowFormat rowFormat, DataTableModel dataTableModel, long l2) {
        RowNode rowNode = new RowNode(formatNode, rowFormat, dataTableModel, l2);
        if (this.runtime) {
            this.grid.fireHiGridUpdateEvent(new HiGridUpdateEvent(this.grid, 3, rowNode));
        }
        return rowNode;
    }

    protected void addRowNode(RowNode rowNode, RowNode rowNode2, RowNode rowNode3) {
        if (rowNode3 == null) {
            rowNode.add(rowNode2);
        } else {
            rowNode.insert(rowNode3, rowNode2);
        }
    }

    protected boolean isPrintNode(FormatNode formatNode) {
        if (this.grid.getPrintFormat() == 2) {
            return true;
        }
        int n2 = 0;
        while (n2 < this.metaIDArray.length) {
            if (this.metaIDArray[n2] == formatNode.getRecordFormat().getMetaData().getMetaID()) {
                return true;
            }
            ++n2;
        }
        return false;
    }

    protected void createRuntimeChildren(RowNode rowNode) throws DataModelException {
        Serializable serializable;
        Object object;
        int n2 = 0;
        TreeIterator treeIterator = rowNode.getFormatNode().getIterator();
        FormatNode formatNode = null;
        boolean bl = false;
        while (treeIterator.hasMoreElements()) {
            formatNode = (FormatNode)treeIterator.get();
            if (!this.runtime && !this.isPrintNode(formatNode)) {
                treeIterator.nextElement();
                continue;
            }
            bl = false;
            object = rowNode.getDataTableModel().getTable(rowNode.getBookmark(), (DataSourceTreeNode)((Object)formatNode.getRecordFormat().getMetaData()));
            if (object == null) {
                try {
                    object = rowNode.getDataTableModel().createTable(this.grid.getDataModelListener(), rowNode.getBookmark(), (DataSourceTreeNode)((Object)formatNode.getRecordFormat().getMetaData()));
                }
                catch (Exception exception) {
                    if (exception instanceof DataModelException) {
                        throw (DataModelException)exception;
                    }
                    this.grid.fireHiGridErrorEvent(new HiGridErrorEvent(this.grid, exception));
                }
            }
            if (object == null) {
                treeIterator.nextElement();
                continue;
            }
            serializable = (HiGridInternalData)object.getInternalData(this.grid);
            if (serializable == null || ((HiGridInternalData)serializable).getDataTable() == null) {
                ((HiGridData)this.grid.getDataModel()).createSummaryDataTable(this.grid, (DataTableModel)object, formatNode);
            }
            n2 += this.createRuntimeChildren(rowNode, formatNode, (DataTableModel)object, n2 == 0, null);
            treeIterator.nextElement();
        }
        object = rowNode.getFormatNode();
        if (n2 > 0 && ((FormatNode)object).getAfterDetailsFormat().isShowing()) {
            serializable = this.createRowNode(formatNode, ((FormatNode)object).getAfterDetailsFormat(), rowNode.getDataTableModel(), 0L);
            rowNode.add((MutableTreeNode)((Object)serializable));
        }
    }

    protected FormatNode createRuntimeChildren(RowNode rowNode, DataTableModel dataTableModel) {
        int n2 = 0;
        FormatNode formatNode = null;
        TreeIterator treeIterator = rowNode.getFormatNode().getIterator();
        FormatNode formatNode2 = null;
        while (treeIterator.hasMoreElements()) {
            formatNode2 = (FormatNode)treeIterator.get();
            DataTableModel dataTableModel2 = rowNode.getDataTableModel().getTable(rowNode.getBookmark(), (DataSourceTreeNode)((Object)formatNode2.getRecordFormat().getMetaData()));
            if (dataTableModel2 == null) {
                treeIterator.nextElement();
                continue;
            }
            if (dataTableModel2 == dataTableModel) {
                formatNode = formatNode2;
                RowNode rowNode2 = null;
                treeIterator.nextElement();
                if (treeIterator.hasMoreElements()) {
                    FormatNode formatNode3 = (FormatNode)treeIterator.get();
                    rowNode2 = this.findInsertBeforeFormatNode(rowNode, formatNode3);
                }
                n2 += this.createRuntimeChildren(rowNode, formatNode2, dataTableModel2, n2 == 0, rowNode2);
                continue;
            }
            try {
                n2 += dataTableModel2.getRowCount();
            }
            catch (Exception exception) {
                this.grid.fireHiGridErrorEvent(new HiGridErrorEvent(this.grid, exception));
            }
            treeIterator.nextElement();
        }
        return formatNode;
    }

    protected void addRepeatHeader(RowNode rowNode) {
        RowNode rowNode2;
        FormatNode formatNode = rowNode.getFormatNode();
        HeaderFormat headerFormat = formatNode.getHeaderFormat();
        if (headerFormat.isShowing() && headerFormat.isRepeatHeader() && (rowNode2 = this.findNextNode(rowNode, formatNode)) != null && rowNode2.getRowFormat() instanceof RecordFormat) {
            RowNode rowNode3 = this.createRowNode(formatNode, headerFormat, rowNode2.getDataTableModel(), 0L);
            ((RowNode)rowNode.getParent()).insert(rowNode2, rowNode3);
            this.addTotalNumberOfScrollableRows(rowNode3, formatNode);
        }
    }

    protected void removeRepeatHeader(RowNode rowNode) {
        RowNode rowNode2;
        FormatNode formatNode = rowNode.getFormatNode();
        HeaderFormat headerFormat = formatNode.getHeaderFormat();
        if (headerFormat.isShowing() && headerFormat.isRepeatHeader() && (rowNode2 = this.findNextNode(rowNode, formatNode)) != null && rowNode2.getRowFormat() instanceof HeaderFormat) {
            this.subtractTotalNumberOfScrollableRows(rowNode2, formatNode);
            ((RowNode)rowNode.getParent()).remove(rowNode2);
        }
    }

    public int getTotalNumberOfScrollableRows() {
        return this.totalNumberOfScrollableRows;
    }

    protected void setTotalNumberOfScrollableRows(int n2) {
        this.totalNumberOfScrollableRows = n2;
        if (this.totalNumberOfScrollableRows < 0) {
            this.totalNumberOfScrollableRows = 0;
        }
    }

    protected void addTotalNumberOfScrollableRows(int n2) {
        this.setTotalNumberOfScrollableRows(this.totalNumberOfScrollableRows + n2);
    }

    protected void subtractTotalNumberOfScrollableRows(int n2) {
        this.setTotalNumberOfScrollableRows(this.totalNumberOfScrollableRows - n2);
    }

    protected void addTotalNumberOfScrollableRows(RowNode rowNode, FormatNode formatNode) {
        this.addTotalNumberOfScrollableRows(1);
        formatNode.addNumberOfScrollableRows(1);
        this.scrollableRowsHeight += rowNode.getHeight();
    }

    protected void subtractTotalNumberOfScrollableRows(RowNode rowNode, FormatNode formatNode) {
        this.subtractTotalNumberOfScrollableRows(1);
        formatNode.subtractNumberOfScrollableRows(1);
        this.scrollableRowsHeight -= rowNode.getHeight();
        if (this.scrollableRowsHeight < 0) {
            this.scrollableRowsHeight = 0;
            System.out.println("scrollableRowsHeight less than zero");
        }
    }

    protected int getNumberOfScrollableRows(RowNode rowNode, boolean bl) {
        if (rowNode == null) {
            return 0;
        }
        int n2 = 0;
        TreeIterator treeIterator = rowNode.getIterator();
        while (treeIterator.hasMoreElements()) {
            RowNode rowNode2 = (RowNode)treeIterator.get();
            if (rowNode2.getState() == 1) {
                n2 += this.getNumberOfScrollableRows(rowNode2, bl);
            }
            ++n2;
            FormatNode formatNode = rowNode2.getFormatNode();
            if (formatNode != null) {
                if (bl) {
                    formatNode.addNumberOfScrollableRows(1);
                    this.scrollableRowsHeight += rowNode2.getHeight();
                } else {
                    formatNode.subtractNumberOfScrollableRows(1);
                    this.scrollableRowsHeight -= rowNode2.getHeight();
                    if (this.scrollableRowsHeight < 0) {
                        this.scrollableRowsHeight = 0;
                        System.out.println("scrollableRowsHeight less than zero");
                    }
                }
            }
            treeIterator.nextElement();
        }
        return n2;
    }

    protected int getNumberOfScrollableRows(RowNode rowNode, FormatNode formatNode, boolean bl) {
        if (rowNode == null) {
            return 0;
        }
        int n2 = 0;
        TreeIterator treeIterator = rowNode.getIterator();
        while (treeIterator.hasMoreElements()) {
            RowNode rowNode2 = (RowNode)treeIterator.get();
            FormatNode formatNode2 = rowNode2.getFormatNode();
            if (formatNode2 != formatNode) {
                treeIterator.nextElement();
                continue;
            }
            ++n2;
            if (bl) {
                formatNode2.addNumberOfScrollableRows(1);
                this.scrollableRowsHeight += rowNode2.getHeight();
            } else {
                formatNode2.subtractNumberOfScrollableRows(1);
                this.scrollableRowsHeight -= rowNode2.getHeight();
                if (this.scrollableRowsHeight < 0) {
                    this.scrollableRowsHeight = 0;
                    System.out.println("scrollableRowsHeight less than zero");
                }
            }
            treeIterator.nextElement();
        }
        return n2;
    }

    protected int getScrollableRowsHeight() {
        return this.scrollableRowsHeight;
    }

    protected void setScrollableRowsHeight(int n2) {
        this.scrollableRowsHeight = n2;
    }

    public int getGridAreaWidth() {
        return this.gridAreaWidth;
    }

    protected void setGridAreaWidth(int n2) {
        this.gridAreaWidth = n2 + this.grid.getExtraWidth();
    }

    protected int getFirstLevelGridAreaWidth() {
        return this.firstLevelGridAreaWidth;
    }

    protected void setFirstLevelGridAreaWidth(int n2) {
        this.firstLevelGridAreaWidth = n2 + this.grid.getExtraWidth();
    }

    protected int getGridAreaRows() {
        return this.gridAreaRows;
    }

    protected int setGridAreaRows() {
        if (this.grid.getDataModel() == null) {
            return 0;
        }
        this.findLastPageTopRow();
        RowNode rowNode = this.getTopRowNode();
        int n2 = this.grid.getVerticalScrollbar().getValue();
        if (rowNode == null) {
            rowNode = (RowNode)this.getRootNode().getFirstChild();
            RowWalk rowWalk = new RowWalk(n2, true);
            this.walk(rowNode, rowWalk);
            rowNode = rowWalk.getFoundNode();
        }
        return this.setGridAreaRows(n2, rowNode);
    }

    protected int setGridAreaRows(int n2, RowNode rowNode) {
        if (n2 > this.lastPageTopRow) {
            n2 = this.lastPageTopRow;
            rowNode = this.lastPageTopRowNode;
        }
        PageDownWalk pageDownWalk = new PageDownWalk(n2, this.grid.getGridArea().getSize().height);
        this.walk(rowNode, pageDownWalk);
        this.gridAreaRows = pageDownWalk.getRowIndex() - n2 + 1;
        this.setTopRowNode(rowNode);
        this.grid.getVerticalScrollbar().setValue(n2);
        return n2;
    }

    protected int updateGridArea(int n2, RowNode rowNode) {
        n2 = this.setGridAreaRows(n2, rowNode);
        this.grid.layoutGrid();
        return n2;
    }

    protected void updateGridArea() {
        this.updateGridState();
        this.grid.layoutGrid();
    }

    protected void computeTotalWidth() {
        this.setGridAreaWidth(this.computeTotalWidth((FormatNode)this.grid.getFormatTree().getRoot(), true));
    }

    protected int computeTotalWidth(FormatNode formatNode, boolean bl) {
        if (formatNode == null) {
            return 0;
        }
        int n2 = formatNode.getTotalWidth(this.grid);
        if (bl) {
            this.setFirstLevelGridAreaWidth(n2);
        }
        TreeIterator treeIterator = formatNode.getIterator();
        while (treeIterator.hasMoreElements()) {
            FormatNode formatNode2 = (FormatNode)treeIterator.get();
            n2 = Math.max(n2, this.computeTotalWidth(formatNode2, false));
            treeIterator.nextElement();
        }
        return n2;
    }

    protected void updateGridState() {
        this.computeTotalWidth();
        this.setGridAreaRows();
    }

    protected void displayRuntimeTree(Graphics graphics) {
        if (this.grid.getDataModel() == null) {
            return;
        }
        this.grid.createDefaultTrees();
        this.displayThisRowAndBelow(graphics, this.getTopRowNode());
    }

    protected boolean displayThisRowAndBelow(Graphics graphics, RowNode rowNode) {
        boolean bl = true;
        while (rowNode != null && rowNode.getParent() != null) {
            if (bl && !this.displayRowChildren(graphics, rowNode)) {
                return false;
            }
            RowNode rowNode2 = this.getNextUncle(rowNode);
            bl = rowNode2 != null;
            RowNode rowNode3 = rowNode = bl ? rowNode2 : (RowNode)rowNode.getParent();
        }
        return true;
    }

    protected boolean displayRowChildren(Graphics graphics, RowNode rowNode) {
        if (rowNode == null) {
            return true;
        }
        TreeIterator treeIterator = ((DataSourceTreeNode)rowNode.getParent()).getIterator(rowNode);
        while (treeIterator.hasMoreElements()) {
            RowNode rowNode2 = (RowNode)treeIterator.get();
            if (!rowNode2.draw(graphics, this.grid)) {
                return false;
            }
            if (rowNode2.getState() == 1 && !this.displayRowChildren(graphics, (RowNode)rowNode2.getFirstChild())) {
                return false;
            }
            treeIterator.nextElement();
        }
        return true;
    }

    protected RowNode getNextUncle(RowNode rowNode) {
        RowNode rowNode2 = (RowNode)rowNode.getParent();
        if (rowNode2 != null) {
            return (RowNode)rowNode2.getNextSibling();
        }
        return null;
    }

    protected RowNode getPreviousUncle(RowNode rowNode) {
        RowNode rowNode2 = (RowNode)rowNode.getParent();
        if (rowNode2 != null) {
            return (RowNode)rowNode2.getPreviousSibling();
        }
        return null;
    }

    protected void openFolder(RowNode rowNode) {
        if (rowNode == null || rowNode.getState() == 1) {
            return;
        }
        rowNode.setState((byte)1);
        if (!rowNode.hasChildren()) {
            try {
                this.createRuntimeChildren(rowNode);
            }
            catch (Exception exception) {
                this.grid.fireHiGridErrorEvent(new HiGridErrorEvent(this.grid, exception));
            }
        }
        if (!rowNode.hasChildren()) {
            rowNode.setState((byte)2);
        } else {
            this.addTotalNumberOfScrollableRows(this.getNumberOfScrollableRows(rowNode, true));
            this.addRepeatHeader(rowNode);
        }
        this.updateGridArea();
    }

    protected void closeFolder(RowNode rowNode) {
        this.closeFolder(rowNode, true);
    }

    protected void closeFolder(RowNode rowNode, boolean bl) {
        if (rowNode == null || rowNode.getState() != 1) {
            return;
        }
        rowNode.setState((byte)0);
        if (bl) {
            this.subtractTotalNumberOfScrollableRows(this.getNumberOfScrollableRows(rowNode, false));
        }
        this.removeRepeatHeader(rowNode);
        if (!rowNode.getFormatNode().getRecordFormat().getMetaData().getCacheChildren()) {
            Vector vector = this.getDataTableChildren(rowNode);
            try {
                Enumeration enumeration = vector.elements();
                while (enumeration.hasMoreElements()) {
                    DataTableModel dataTableModel = (DataTableModel)enumeration.nextElement();
                    dataTableModel.deleteCacheChildren(this.grid.getDataModelListener());
                }
            }
            catch (Exception exception) {
                this.grid.fireHiGridErrorEvent(new HiGridErrorEvent(this.grid, exception));
            }
            rowNode.removeAllChildren();
        }
        this.updateGridArea();
    }

    protected static void addUnique(Vector vector, Object object) {
        if (!vector.contains(object)) {
            vector.addElement(object);
        }
    }

    protected Vector getDataTableChildren(RowNode rowNode) {
        Vector vector = new Vector();
        TreeIterator treeIterator = rowNode.getIterator();
        while (treeIterator.hasMoreElements()) {
            RowNode rowNode2 = (RowNode)treeIterator.get();
            if (rowNode2.getDataTableModel() != null) {
                RowTree.addUnique(vector, rowNode2.getDataTableModel());
            }
            treeIterator.nextElement();
        }
        return vector;
    }

    protected RowNode getRowNode(int n2) {
        RowNodeWalk rowNodeWalk = new RowNodeWalk(n2);
        this.walk((RowNode)this.getRootNode().getFirstChild(), rowNodeWalk);
        return rowNodeWalk.getFoundNode();
    }

    protected int getRowIndex(RowNode rowNode) {
        RowValueWalk rowValueWalk = new RowValueWalk(rowNode);
        this.walk((RowNode)this.getRootNode().getFirstChild(), rowValueWalk);
        return rowValueWalk.getCount();
    }

    protected RowNode getTopRowNode() {
        return this.topRowNode;
    }

    protected void setTopRowNode(RowNode rowNode) {
        this.topRowNode = rowNode;
    }

    protected void setTopRow(RowNode rowNode) {
        if (this.getRoot() == null) {
            return;
        }
        RowValueWalk rowValueWalk = new RowValueWalk(rowNode);
        this.walk((RowNode)this.getRootNode().getFirstChild(), rowValueWalk);
        this.setTopRowNode(rowNode);
        int n2 = this.updateGridArea(rowValueWalk.getCount(), rowNode);
        this.grid.getVerticalScrollbar().setValue(n2);
    }

    protected void setTopRow(int n2) {
        if (this.getRoot() == null) {
            return;
        }
        RowNodeWalk rowNodeWalk = new RowNodeWalk(n2);
        this.walk((RowNode)this.getRootNode().getFirstChild(), rowNodeWalk);
        this.setTopRowNode(rowNodeWalk.getFoundNode());
        int n3 = this.updateGridArea(n2, rowNodeWalk.getFoundNode());
        this.grid.getVerticalScrollbar().setValue(n3);
    }

    protected RowNode getTopRowNodeFromLastFullyVisibleRow(RowNode rowNode) {
        LastVisibleRowWalk lastVisibleRowWalk = new LastVisibleRowWalk(this.grid.getGridArea().getSize().height - rowNode.getHeight());
        this.walk(rowNode, lastVisibleRowWalk);
        return lastVisibleRowWalk.getFoundNode();
    }

    protected RowNode getFirstRecordRowNode() {
        if (this.getRoot() == null) {
            return null;
        }
        RowNode rowNode = (RowNode)this.getRootNode().getFirstChild();
        if (rowNode == null) {
            return null;
        }
        if (rowNode.getRowFormat() instanceof RecordFormat) {
            return rowNode;
        }
        if ((rowNode = (RowNode)rowNode.getNextSibling()) == null) {
            return null;
        }
        if (rowNode.getRowFormat() instanceof RecordFormat) {
            return rowNode;
        }
        return null;
    }

    protected int doPageUp(int n2) {
        RowNode rowNode = this.getTopRowNode();
        PageUpWalk pageUpWalk = new PageUpWalk(n2, this.grid.getGridArea().getSize().height, rowNode);
        this.walk(rowNode, pageUpWalk);
        int n3 = this.updateGridArea(pageUpWalk.getRowIndex(), pageUpWalk.getFoundNode());
        return n3;
    }

    protected int doPageDown(int n2) {
        RowNode rowNode = this.getTopRowNode();
        if (n2 > this.lastPageTopRow) {
            n2 = this.lastPageTopRow;
            rowNode = this.lastPageTopRowNode;
        } else {
            PageDownWalk pageDownWalk = new PageDownWalk(n2, this.grid.getGridArea().getSize().height);
            this.walk(rowNode, pageDownWalk);
            RowWalk rowWalk = new RowWalk(1, true);
            this.walk(pageDownWalk.getFoundNode(), rowWalk);
            rowNode = rowWalk.getFoundNode();
            n2 = pageDownWalk.getRowIndex() + 1;
        }
        int n3 = this.updateGridArea(n2, rowNode);
        return n3;
    }

    protected void findLastPageTopRow() {
        LastRowWalk lastRowWalk = new LastRowWalk();
        RowNode rowNode = (RowNode)this.grid.getRowTree().getRootNode().getLastChild();
        this.walk(rowNode, lastRowWalk);
        int n2 = this.getTotalNumberOfScrollableRows() - 1;
        RowNode rowNode2 = lastRowWalk.getFoundNode();
        if (rowNode2 != null) {
            PageUpWalk pageUpWalk = new PageUpWalk(n2, this.grid.getGridArea().getSize().height - lastRowWalk.getFoundNode().getHeight(), rowNode2);
            this.walk(rowNode2, pageUpWalk);
            n2 = pageUpWalk.getRowIndex();
            rowNode2 = pageUpWalk.getFoundNode();
        }
        this.lastPageTopRow = n2;
        this.lastPageTopRowNode = rowNode2;
    }

    protected Vector getNodeLevelList(RowNode rowNode) {
        Vector<FormatNode> vector = new Vector<FormatNode>();
        FormatNode formatNode = null;
        if (rowNode == null) {
            formatNode = (FormatNode)this.grid.getFormatTree().getRoot();
            if (formatNode != null) {
                vector.addElement(formatNode);
            }
            return vector;
        }
        vector.addElement(rowNode.getFormatNode());
        TreeIterator treeIterator = rowNode.getFormatNode().getIterator();
        while (treeIterator.hasMoreElements()) {
            formatNode = (FormatNode)treeIterator.get();
            vector.addElement(formatNode);
            treeIterator.nextElement();
        }
        return vector;
    }

    protected DataTableModel getDataTableModel(FormatNode formatNode, RowNode rowNode) {
        DataTableModel dataTableModel = null;
        TreeIterator treeIterator = rowNode.getIterator();
        while (treeIterator.hasMoreElements()) {
            RowNode rowNode2 = (RowNode)treeIterator.get();
            if (rowNode2.getFormatNode() == formatNode && rowNode2.getRowFormat() instanceof RecordFormat) {
                dataTableModel = rowNode2.getDataTableModel();
                break;
            }
            treeIterator.nextElement();
        }
        return dataTableModel;
    }

    public RowNode findRecordRowNode(RowNode rowNode, long l2) {
        if (l2 == -1L) {
            return null;
        }
        if (rowNode == null) {
            rowNode = (RowNode)this.getRoot();
        }
        TreeIterator treeIterator = rowNode.getIterator();
        while (treeIterator.hasMoreElements()) {
            RowNode rowNode2 = (RowNode)treeIterator.get();
            if (rowNode2.getRowFormat() instanceof RecordFormat) {
                if (l2 == rowNode2.getBookmark()) {
                    return rowNode2;
                }
                RowNode rowNode3 = this.findRecordRowNode(rowNode2, l2);
                if (rowNode3 != null) {
                    return rowNode3;
                }
            }
            treeIterator.nextElement();
        }
        return null;
    }

    public RowNode findRecordRowNode(RowNode rowNode, FormatNode formatNode) {
        if (rowNode == null) {
            rowNode = (RowNode)this.getRoot();
        }
        TreeIterator treeIterator = rowNode.getIterator();
        while (treeIterator.hasMoreElements()) {
            RowNode rowNode2 = (RowNode)treeIterator.get();
            if (rowNode2.getFormatNode() == formatNode && rowNode2.getRowFormat() instanceof RecordFormat) {
                return rowNode2;
            }
            treeIterator.nextElement();
        }
        return null;
    }

    public RowNode findHeaderRowNode(RowNode rowNode, FormatNode formatNode) {
        if (rowNode == null) {
            rowNode = (RowNode)this.getRoot();
        }
        TreeIterator treeIterator = rowNode.getIterator();
        while (treeIterator.hasMoreElements()) {
            RowNode rowNode2 = (RowNode)treeIterator.get();
            if (rowNode2.getFormatNode() == formatNode && rowNode2.getRowFormat() instanceof HeaderFormat) {
                return rowNode2;
            }
            treeIterator.nextElement();
        }
        return null;
    }

    public RowNode findRowNode(RowNode rowNode, FormatNode formatNode, int n2) {
        if (rowNode == null) {
            rowNode = (RowNode)this.getRoot();
        }
        TreeIterator treeIterator = rowNode.getIterator();
        while (treeIterator.hasMoreElements()) {
            RowNode rowNode2 = (RowNode)treeIterator.get();
            if (rowNode2.getFormatNode() == formatNode && rowNode2.getRowFormat() instanceof HeaderFormat) {
                return rowNode2;
            }
            treeIterator.nextElement();
        }
        return null;
    }

    protected boolean parentFolderClosed(DataTableModel dataTableModel) {
        RowNode rowNode = this.findFirstRowNode(null, dataTableModel);
        if (rowNode == null) {
            return true;
        }
        RowNode rowNode2 = (RowNode)this.getRoot();
        RowNode rowNode3 = (RowNode)rowNode.getParent();
        while (rowNode3 != null && rowNode3 != rowNode2) {
            if (rowNode3.getState() == 0) {
                return true;
            }
            rowNode3 = (RowNode)rowNode3.getParent();
        }
        return false;
    }

    public RowNode findFirstRowNode(RowNode rowNode, DataTableModel dataTableModel) {
        if (rowNode == null) {
            rowNode = (RowNode)this.getRoot();
        }
        TreeIterator treeIterator = rowNode.getIterator();
        while (treeIterator.hasMoreElements()) {
            RowNode rowNode2 = (RowNode)treeIterator.get();
            if (dataTableModel == rowNode2.getDataTableModel()) {
                return rowNode2;
            }
            RowNode rowNode3 = this.findFirstRowNode(rowNode2, dataTableModel);
            if (rowNode3 != null) {
                return rowNode3;
            }
            treeIterator.nextElement();
        }
        return null;
    }

    protected RowNode findPreviousRecordRowNode(RowNode rowNode, FormatNode formatNode) {
        RowNode rowNode2 = (RowNode)rowNode.getParent();
        RowNode rowNode3 = (RowNode)rowNode2.getPreviousChild(rowNode);
        while (rowNode3 != null) {
            if (formatNode != null && rowNode3.getFormatNode() != formatNode) {
                return null;
            }
            if (rowNode3.getRowFormat() instanceof RecordFormat) {
                return rowNode3;
            }
            rowNode3 = (RowNode)rowNode2.getPreviousChild(rowNode3);
        }
        return null;
    }

    protected RowNode findNextRecordRowNode(RowNode rowNode, FormatNode formatNode) {
        RowNode rowNode2 = (RowNode)rowNode.getParent();
        RowNode rowNode3 = (RowNode)rowNode2.getNextChild(rowNode);
        while (rowNode3 != null) {
            if (formatNode != null && rowNode3.getFormatNode() != formatNode) {
                return null;
            }
            if (rowNode3.getRowFormat() instanceof RecordFormat) {
                return rowNode3;
            }
            rowNode3 = (RowNode)rowNode2.getNextChild(rowNode3);
        }
        return null;
    }

    protected RowNode findNextNode(RowNode rowNode, FormatNode formatNode) {
        RowNode rowNode2 = (RowNode)rowNode.getNextSibling();
        if (rowNode2 != null && formatNode != null && rowNode2.getFormatNode() != formatNode) {
            return null;
        }
        return rowNode2;
    }

    protected RowNode findInsertBeforeNode(RowNode rowNode, FormatNode formatNode) {
        RowNode rowNode2 = (RowNode)rowNode.getLastChild();
        RowNode rowNode3 = null;
        while (rowNode2 != null) {
            if (rowNode2.getFormatNode() == formatNode && (rowNode2.getRowFormat() instanceof RecordFormat || rowNode2.getRowFormat() instanceof HeaderFormat)) break;
            rowNode3 = rowNode2;
            rowNode2 = (RowNode)rowNode.getPreviousChild(rowNode3);
        }
        return rowNode3;
    }

    protected RowNode findInsertBeforeFormatNode(RowNode rowNode, FormatNode formatNode) {
        RowNode rowNode2 = (RowNode)rowNode.getLastChild();
        RowNode rowNode3 = null;
        while (rowNode2 != null) {
            if (rowNode2.getFormatNode() == formatNode) {
                rowNode3 = rowNode2;
            } else if (rowNode3 != null) break;
            rowNode2 = (RowNode)rowNode.getPreviousChild(rowNode2);
        }
        return rowNode3;
    }

    public void walk(RowNode rowNode, Walkable walkable) {
        if (walkable.getDownward()) {
            this.walkDown(rowNode, walkable);
        } else {
            this.walkUp(rowNode, walkable);
        }
    }

    private void walkDown(RowNode rowNode, Walkable walkable) {
        walkable.previous(rowNode);
        boolean bl = true;
        while (rowNode != null && rowNode.getParent() != null) {
            RowNode rowNode2;
            if (bl) {
                this.walkDownMore(rowNode, walkable);
                if (walkable.done()) {
                    return;
                }
            }
            bl = (rowNode2 = this.getNextUncle(rowNode)) != null;
            RowNode rowNode3 = rowNode = bl ? rowNode2 : (RowNode)rowNode.getParent();
        }
    }

    private void walkDownMore(RowNode rowNode, Walkable walkable) {
        if (rowNode == null) {
            return;
        }
        TreeIterator treeIterator = ((DataSourceTreeNode)rowNode.getParent()).getIterator(rowNode);
        while (treeIterator.hasMoreElements()) {
            RowNode rowNode2 = (RowNode)treeIterator.get();
            walkable.next(rowNode2);
            if (walkable.find(rowNode2)) {
                return;
            }
            if (rowNode2.getState() == 1) {
                this.walkDownMore((RowNode)rowNode2.getFirstChild(), walkable);
                if (walkable.done()) {
                    return;
                }
            }
            treeIterator.nextElement();
        }
    }

    private void walkUp(RowNode rowNode, Walkable walkable) {
        while (rowNode != null && rowNode.getParent() != null) {
            this.walkUpMore((RowNode)rowNode.getPreviousSibling(), walkable);
            if (walkable.done()) {
                return;
            }
            RowNode rowNode2 = (RowNode)rowNode.getParent();
            if (rowNode2.getParent() == null) {
                return;
            }
            walkable.next(rowNode2);
            if (walkable.find(rowNode2)) {
                return;
            }
            RowNode rowNode3 = rowNode = rowNode2 != null ? rowNode2 : (RowNode)rowNode.getParent();
        }
    }

    private void walkUpMore(RowNode rowNode, Walkable walkable) {
        if (rowNode == null) {
            return;
        }
        TreeIterator treeIterator = ((DataSourceTreeNode)rowNode.getParent()).getIterator(rowNode, false);
        while (treeIterator.hasMoreElements()) {
            RowNode rowNode2 = (RowNode)treeIterator.get();
            if (rowNode2.getState() == 1) {
                this.walkUpMore((RowNode)rowNode2.getLastChild(), walkable);
                if (walkable.done()) {
                    return;
                }
            }
            walkable.next(rowNode2);
            if (walkable.find(rowNode2)) {
                return;
            }
            treeIterator.nextElement();
        }
    }
}

