/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid;

import com.klg.jclass.higrid.HiGrid;
import com.klg.jclass.higrid.RecordFormat;
import com.klg.jclass.higrid.RowNode;
import com.klg.jclass.higrid.Walkable;
import java.util.Vector;

class LevelSelectWalk
implements Walkable {
    static final long serialVersionUID = -2122003129413483709L;
    private HiGrid grid;
    private RowNode firstSelectedRowNode;
    private int metaID;
    private int found;
    private Vector selectedRows = null;

    public LevelSelectWalk(HiGrid hiGrid, RowNode rowNode) {
        this.grid = hiGrid;
        this.firstSelectedRowNode = null;
        this.metaID = rowNode.getFormatNode().getRecordFormat().getMetaData().getMetaID();
        this.found = 0;
        this.selectedRows = new Vector();
    }

    public boolean getDownward() {
        return true;
    }

    public boolean done() {
        return false;
    }

    public void next(RowNode rowNode) {
        if (rowNode != null) {
            this.selectRow(rowNode);
        }
    }

    public void previous(RowNode rowNode) {
    }

    public boolean find(RowNode rowNode) {
        return false;
    }

    public RowNode first() {
        return this.firstSelectedRowNode;
    }

    protected void selectRow(RowNode rowNode) {
        if (rowNode.getRowFormat() instanceof RecordFormat && this.metaID == rowNode.getFormatNode().getRecordFormat().getMetaData().getMetaID()) {
            this.selectedRows.addElement(rowNode);
            if (this.firstSelectedRowNode == null) {
                this.firstSelectedRowNode = rowNode;
            }
        }
    }

    public Vector getSelectedRows() {
        return this.selectedRows;
    }
}

