/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid;

import com.klg.jclass.higrid.FocusModel;
import com.klg.jclass.higrid.HiGrid;
import com.klg.jclass.higrid.HiGridTip;
import com.klg.jclass.util.JCEnvironment;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import javax.swing.JToolTip;

public class GridArea
extends JComponent
implements FocusListener {
    static final long serialVersionUID = 8474639562992639548L;
    protected static final int MINIMUM_WIDTH = 200;
    protected static final int MINIMUM_HEIGHT = 200;
    private HiGrid grid = null;
    protected transient HiGridTip toolTip = null;
    protected boolean isDoubleBuffer = true;
    private transient Image doubleBufferImage;
    protected FocusModel focusManager = null;

    public GridArea(HiGrid hiGrid) {
        this.grid = hiGrid;
        this.setLayout(null);
        this.setOpaque(true);
        this.setDoubleBuffered(true);
        this.recreateToolTip();
        boolean bl = JCEnvironment.getJavaVersion() >= 140;
        String string = bl ? "com.klg.jclass.higrid.FocusManagerNew" : "com.klg.jclass.higrid.FocusManagerOld";
        try {
            Class<?> clazz = Class.forName(string);
            this.focusManager = (FocusModel)clazz.newInstance();
            this.focusManager.setGridArea(this);
        }
        catch (Exception exception) {
            System.out.println("FocusManager initialization error:" + exception.getMessage());
        }
        if (bl) {
            this.setFocusTraversalKeysEnabled(false);
        }
    }

    public Point getToolTipLocation(MouseEvent mouseEvent) {
        this.recreateToolTip();
        if (this.grid.isHeaderTipVisible()) {
            return this.toolTip.getTip(new Point(mouseEvent.getX(), mouseEvent.getY()));
        }
        return super.getToolTipLocation(mouseEvent);
    }

    public JToolTip createToolTip() {
        this.recreateToolTip();
        if (this.grid.isHeaderTipVisible()) {
            return this.toolTip;
        }
        return super.createToolTip();
    }

    protected void recreateToolTip() {
        if (this.toolTip == null) {
            this.toolTip = new HiGridTip(this.grid);
            this.toolTip.setComponent(this);
        }
    }

    protected Object getAWTLock() {
        return this.getTreeLock();
    }

    protected Image getDoubleBufferImage() {
        return this.doubleBufferImage;
    }

    protected Image setDoubleBufferImage(Image image) {
        if (this.doubleBufferImage != null) {
            this.doubleBufferImage.flush();
        }
        this.doubleBufferImage = image;
        return this.doubleBufferImage;
    }

    protected boolean doubleBufferSizeChanged() {
        int n2 = Math.max(this.grid.getRowTree().getGridAreaWidth(), this.getSize().width);
        int n3 = this.getSize().height;
        if (n2 <= 0 || n3 <= 0) {
            this.setDoubleBufferImage(null);
            return false;
        }
        Image image = this.getDoubleBufferImage();
        return (image == null || image.getWidth(null) != n2 || image.getHeight(null) != this.getSize().height) && (image = this.setDoubleBufferImage(this.createImage(n2, this.getSize().height))) != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Graphics getDoubleBufferGraphics() {
        Object object = this.getAWTLock();
        synchronized (object) {
            Image image = this.getDoubleBufferImage();
            Graphics graphics = image == null ? null : image.getGraphics();
            Graphics graphics2 = graphics;
            return graphics2;
        }
    }

    protected void paintGrid(Graphics graphics) {
        this.grid.draw(graphics);
    }

    protected void refresh() {
        this.refresh(0, 0, Math.max(this.grid.getRowTree().getGridAreaWidth(), this.getSize().width), this.getSize().height);
    }

    protected void refresh(int n2, int n3, int n4, int n5) {
        if (this.isDoubleBuffer) {
            if (this.doubleBufferSizeChanged()) {
                this.refresh();
                return;
            }
            Graphics graphics = this.getDoubleBufferGraphics();
            if (graphics == null) {
                return;
            }
            graphics.setClip(n2, n3, n4, n5);
            this.paintGrid(graphics);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void refresh(int n2) {
        Object object = this.getAWTLock();
        synchronized (object) {
            if (n2 == 0) {
                return;
            }
            if (Math.abs(n2) >= this.getSize().height) {
                this.refresh();
                return;
            }
            if (this.isDoubleBuffer && this.getDoubleBufferImage() != null) {
                if (this.doubleBufferSizeChanged()) {
                    this.refresh();
                    return;
                }
                Graphics graphics = this.getDoubleBufferGraphics();
                Rectangle rectangle = new Rectangle();
                rectangle.setBounds(0, 0, Math.max(this.grid.getRowTree().getGridAreaWidth(), this.getSize().width), this.getSize().height);
                graphics.setClip(rectangle);
                graphics.copyArea(0, n2 > 0 ? n2 : 0, this.grid.getRowTree().getGridAreaWidth(), this.getSize().height - Math.abs(n2), 0, -n2);
                rectangle.setBounds(0, n2 > 0 ? this.getSize().height - n2 : 0, Math.max(this.grid.getRowTree().getGridAreaWidth(), this.getSize().width), Math.abs(n2));
                graphics.setClip(rectangle);
                this.paintGrid(graphics);
                graphics.dispose();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void paintComponent(Graphics graphics) {
        Object object = this.getAWTLock();
        synchronized (object) {
            if (this.isDoubleBuffer) {
                if (this.doubleBufferSizeChanged()) {
                    this.refresh();
                }
                if (this.getDoubleBufferImage() != null) {
                    graphics.drawImage(this.getDoubleBufferImage(), -this.grid.getHorizontalScrollbar().getValue(), 0, null);
                    Rectangle rectangle = graphics.getClipBounds();
                    graphics.setColor(this.getBackground());
                    int n2 = this.getDoubleBufferImage().getWidth(null) - this.grid.getHorizontalScrollbar().getValue();
                    graphics.fillRect(n2, rectangle.y, this.getSize().width - n2, rectangle.height);
                }
            } else {
                graphics.translate(-this.grid.getHorizontalScrollbar().getValue(), 0);
                this.paintGrid(graphics);
                graphics.translate(this.grid.getHorizontalScrollbar().getValue(), 0);
            }
        }
        super.paintComponent(graphics);
    }

    public Dimension getPreferredSize() {
        int n2 = this.grid.getRowTree().getFirstLevelGridAreaWidth();
        return new Dimension(n2 <= 0 ? 200 : n2, 200);
    }

    public void setBounds(int n2, int n3, int n4, int n5) {
        Rectangle rectangle = this.getBounds();
        super.setBounds(n2, n3, n4, n5);
        if (rectangle.isEmpty() && n4 > 0 && n5 > 0) {
            this.grid.refresh();
        }
    }

    public void dispose() {
        this.setDoubleBufferImage(null);
    }

    public FocusModel getFocusManager() {
        return this.focusManager;
    }

    public void setFocusManager(FocusModel focusModel) {
        if (focusModel != null) {
            this.focusManager = focusModel;
        }
    }

    public void focusGained(FocusEvent focusEvent) {
    }

    public void focusLost(FocusEvent focusEvent) {
    }
}

