/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid;

import com.klg.jclass.datasource.DataSourceTreeNode;
import com.klg.jclass.higrid.AfterDetailsFormat;
import com.klg.jclass.higrid.BeforeDetailsFormat;
import com.klg.jclass.higrid.FooterFormat;
import com.klg.jclass.higrid.HeaderFormat;
import com.klg.jclass.higrid.HiGrid;
import com.klg.jclass.higrid.LocaleBundle;
import com.klg.jclass.higrid.RecordFormat;
import com.klg.jclass.higrid.RowFormat;
import com.klg.jclass.higrid.SortData;

public class FormatNode
extends DataSourceTreeNode {
    static final long serialVersionUID = -6170167103182514528L;
    public static final int ANY_FORMAT = 0;
    public static final int RECORD_FORMAT = 1;
    public static final int HEADER_FORMAT = 2;
    public static final int FOOTER_FORMAT = 3;
    public static final int BEFORE_DETAILS_FORMAT = 4;
    public static final int AFTER_DETAILS_FORMAT = 5;
    public static final int FIRST_FORMAT = 1;
    public static final int LAST_FORMAT = 5;
    public static final int AUTO_TRAVERSE_NONE = 0;
    public static final int AUTO_TRAVERSE_EXPAND = 1;
    public static final int AUTO_TRAVERSE_DETECT_CHILDREN = 2;
    public static final int AUTO_TRAVERSE_CALLBACK = 3;
    private RecordFormat recordFormat = null;
    private HeaderFormat headerFormat = null;
    private FooterFormat footerFormat = null;
    private BeforeDetailsFormat beforeDetailsFormat = null;
    private AfterDetailsFormat afterDetailsFormat = null;
    private int autoTraverse = 0;
    private SortData defaultSortData = null;
    private int indent = 0;
    private transient int numberOfScrollableRows = 0;

    public FormatNode() {
        super(null);
    }

    public FormatNode(int n2) {
        super(null);
        this.setIndent(n2);
    }

    public RowFormat getRowFormat(int n2) {
        RowFormat rowFormat;
        switch (n2) {
            case 1: {
                rowFormat = this.getRecordFormat();
                break;
            }
            case 2: {
                rowFormat = this.getHeaderFormat();
                break;
            }
            case 3: {
                rowFormat = this.getFooterFormat();
                break;
            }
            case 4: {
                rowFormat = this.getBeforeDetailsFormat();
                break;
            }
            case 5: {
                rowFormat = this.getAfterDetailsFormat();
                break;
            }
            default: {
                rowFormat = null;
            }
        }
        return rowFormat;
    }

    public void setRowFormat(RowFormat rowFormat, int n2) {
        switch (n2) {
            case 1: {
                this.setRecordFormat((RecordFormat)rowFormat);
                break;
            }
            case 2: {
                this.setHeaderFormat((HeaderFormat)rowFormat);
                break;
            }
            case 3: {
                this.setFooterFormat((FooterFormat)rowFormat);
                break;
            }
            case 4: {
                this.setBeforeDetailsFormat((BeforeDetailsFormat)rowFormat);
                break;
            }
            case 5: {
                this.setAfterDetailsFormat((AfterDetailsFormat)rowFormat);
                break;
            }
        }
    }

    public RecordFormat getRecordFormat() {
        return this.recordFormat;
    }

    public void setRecordFormat(RecordFormat recordFormat) {
        this.recordFormat = recordFormat;
        this.recordFormat.setParent(this);
    }

    public HeaderFormat getHeaderFormat() {
        return this.headerFormat;
    }

    public void setHeaderFormat(HeaderFormat headerFormat) {
        this.headerFormat = headerFormat;
        this.headerFormat.setParent(this);
    }

    public FooterFormat getFooterFormat() {
        return this.footerFormat;
    }

    public void setFooterFormat(FooterFormat footerFormat) {
        this.footerFormat = footerFormat;
        this.footerFormat.setParent(this);
    }

    public BeforeDetailsFormat getBeforeDetailsFormat() {
        return this.beforeDetailsFormat;
    }

    public void setBeforeDetailsFormat(BeforeDetailsFormat beforeDetailsFormat) {
        this.beforeDetailsFormat = beforeDetailsFormat;
        this.beforeDetailsFormat.setParent(this);
    }

    public AfterDetailsFormat getAfterDetailsFormat() {
        return this.afterDetailsFormat;
    }

    public void setAfterDetailsFormat(AfterDetailsFormat afterDetailsFormat) {
        this.afterDetailsFormat = afterDetailsFormat;
        this.afterDetailsFormat.setParent(this);
    }

    public String getName() {
        if (this.getRecordFormat() == null) {
            return null;
        }
        String string = this.getRecordFormat().getMetaData().getDescription();
        if (string == null || string.length() == 0) {
            int n2 = this.getRecordFormat().getMetaData().getMetaID() + 1;
            string = new String(LocaleBundle.string("Level") + " " + n2);
        }
        return string;
    }

    protected String makeLevelName(int n2) {
        return new String(LocaleBundle.string("Level") + " " + n2);
    }

    public int getAutoTraverse() {
        return this.autoTraverse;
    }

    public void setAutoTraverse(int n2) {
        switch (n2) {
            case 0: 
            case 1: 
            case 2: 
            case 3: {
                this.autoTraverse = n2;
            }
        }
    }

    public int getIndent() {
        return this.indent;
    }

    public void setIndent(int n2) {
        this.indent = n2;
    }

    public SortData getDefaultSortData() {
        return this.defaultSortData;
    }

    public void setDefaultSortData(SortData sortData) {
        this.defaultSortData = sortData;
    }

    protected int getNumberOfScrollableRows() {
        return this.numberOfScrollableRows;
    }

    protected void setNumberOfScrollableRows(int n2) {
        this.numberOfScrollableRows = n2;
        if (this.numberOfScrollableRows < 0) {
            this.numberOfScrollableRows = 0;
        }
    }

    protected void addNumberOfScrollableRows(int n2) {
        this.setNumberOfScrollableRows(this.numberOfScrollableRows + n2);
    }

    protected void subtractNumberOfScrollableRows(int n2) {
        this.setNumberOfScrollableRows(this.numberOfScrollableRows - n2);
    }

    protected void resetRuntimeInfo() {
        this.numberOfScrollableRows = 0;
    }

    protected int getTotalWidth(HiGrid hiGrid) {
        FormatNode formatNode;
        int n2 = 0;
        if (this.getNumberOfScrollableRows() == 0) {
            return n2;
        }
        if (this.recordFormat != null) {
            n2 = Math.max(n2, this.recordFormat.getTotalWidth(hiGrid, this));
        }
        if (this.headerFormat != null) {
            n2 = Math.max(n2, this.headerFormat.getTotalWidth(hiGrid, this));
        }
        if (this.footerFormat != null) {
            n2 = Math.max(n2, this.footerFormat.getTotalWidth(hiGrid, this));
        }
        if ((formatNode = (FormatNode)this.getParent()) != null) {
            if (formatNode.getBeforeDetailsFormat() != null) {
                n2 = Math.max(n2, formatNode.getBeforeDetailsFormat().getTotalWidth(hiGrid, this));
            }
            if (formatNode.getAfterDetailsFormat() != null) {
                n2 = Math.max(n2, formatNode.getAfterDetailsFormat().getTotalWidth(hiGrid, this));
            }
        }
        return n2;
    }
}

