/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.higrid;

import com.klg.jclass.higrid.CellFormat;
import com.klg.jclass.higrid.RowNode;
import java.awt.Point;
import java.io.Serializable;
import java.util.Vector;

public class CellPosition
implements Serializable {
    static final long serialVersionUID = -3658209448685342823L;
    protected RowNode row = null;
    protected CellFormat format = null;
    protected Point point = null;
    protected int columnIndex = 0;
    protected boolean isIndicator;

    public CellPosition(RowNode rowNode, int n2, boolean bl) {
        this();
        this.row = rowNode;
        this.columnIndex = n2;
        this.isIndicator = bl;
        this.setColumnIndex(n2);
        this.point = new Point(0, 0);
    }

    public CellPosition(RowNode rowNode, int n2) {
        this(rowNode, n2, false);
    }

    public CellPosition(int n2, int n3) {
        this();
        this.point = new Point(n2, n3);
    }

    public CellPosition() {
    }

    public void setColumnIndex(int n2) {
        this.columnIndex = n2;
        Vector vector = this.isIndicator ? this.row.getRowFormat().getIndicatorFormats() : this.row.getRowFormat().getDataFormats();
        this.format = n2 >= 0 && n2 < vector.size() ? (CellFormat)vector.elementAt(n2) : null;
    }

    public boolean isSameAs(CellPosition cellPosition) {
        return this.row == cellPosition.row && this.format == cellPosition.format && this.columnIndex == cellPosition.columnIndex && this.isIndicator == cellPosition.isIndicator;
    }

    public RowNode getRowNode() {
        return this.row;
    }

    public CellFormat getCellFormat() {
        return this.format;
    }

    public int getColumnIndex() {
        return this.columnIndex;
    }

    public boolean isIndicator() {
        return this.isIndicator;
    }

    protected Object clone() {
        CellPosition cellPosition = new CellPosition();
        cellPosition.row = this.row;
        cellPosition.columnIndex = this.columnIndex;
        cellPosition.format = this.format;
        cellPosition.isIndicator = this.isIndicator;
        cellPosition.point = new Point(this.point.x, this.point.y);
        return cellPosition;
    }

    public String toString() {
        return "" + this.row + " CellFormat=" + this.format + " Column=" + this.columnIndex + " Indicator=" + this.isIndicator + " Point=" + this.point;
    }
}

