/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.field.validate;

import com.klg.jclass.field.validate.FieldParseException;
import com.klg.jclass.field.validate.JCIntegerValidator;
import com.klg.jclass.field.validate.JCStringValidator;
import com.klg.jclass.field.validate.TextEvent;
import com.klg.jclass.util.JCIPAddress;
import java.util.Locale;
import java.util.StringTokenizer;
import javax.swing.ListModel;

public class JCIPAddressValidator
extends JCStringValidator {
    protected int increment_field = 0;
    protected JCIntegerValidator[] validators = null;

    public JCIPAddressValidator() {
        super.setMask("@@@.@@@.@@@.@@@");
        this.setDefaultValue(new JCIPAddress("0.0.0.0"));
        super.setSpinPolicy(1);
        this.setIncrement(new Integer(1));
    }

    public JCIPAddressValidator(Locale locale, Number number, Number number2, Number number3, Number number4, Number number5, Number number6, Number number7, Number number8, ListModel listModel, boolean bl, Integer n2, boolean bl2, Object object) {
        this();
        this.setLocale(locale);
        JCIntegerValidator[] jCIntegerValidatorArray = new JCIntegerValidator[4];
        if (number != null || number2 != null) {
            jCIntegerValidatorArray[0] = new JCIntegerValidator();
            jCIntegerValidatorArray[0].setMin(number);
            jCIntegerValidatorArray[0].setMax(number2);
        }
        if (number3 != null || number4 != null) {
            jCIntegerValidatorArray[1] = new JCIntegerValidator();
            jCIntegerValidatorArray[1].setMin(number3);
            jCIntegerValidatorArray[1].setMax(number4);
        }
        if (number5 != null || number6 != null) {
            jCIntegerValidatorArray[2] = new JCIntegerValidator();
            jCIntegerValidatorArray[2].setMin(number5);
            jCIntegerValidatorArray[2].setMax(number6);
        }
        if (number7 != null || number8 != null) {
            jCIntegerValidatorArray[3] = new JCIntegerValidator();
            jCIntegerValidatorArray[3].setMin(number7);
            jCIntegerValidatorArray[3].setMax(number8);
        }
        this.setIPValidators(jCIntegerValidatorArray);
        this.setPickList(listModel);
        this.setMatchPickList(bl);
        this.setIncrement(n2);
        this.setAllowNull(bl2);
        this.setDefaultValue(object);
    }

    protected Class[] getSupportedClasses() {
        Class[] classArray = new Class[]{JCIPAddress.class};
        return classArray;
    }

    private String padString(String string, int n2) {
        String string2 = string;
        for (int i2 = 0; i2 < n2; ++i2) {
            string2 = string2 + " ";
        }
        return string2;
    }

    public String format(Object object) {
        if (object == null || !this.isClassSupported(object.getClass())) {
            return this.getParsedMask();
        }
        JCIPAddress jCIPAddress = (JCIPAddress)this.convertToSupported(object);
        String string = jCIPAddress.toString();
        StringTokenizer stringTokenizer = new StringTokenizer(string, ".");
        String string2 = stringTokenizer.nextToken();
        String string3 = this.padString(string2, 3 - string2.length());
        for (int i2 = 1; i2 < 4; ++i2) {
            string2 = stringTokenizer.nextToken();
            string3 = string3 + "." + this.padString(string2, 3 - string2.length());
        }
        return string3;
    }

    public Object parse(Class clazz, String string) {
        StringTokenizer stringTokenizer = new StringTokenizer(string, ". ");
        if (stringTokenizer.countTokens() != 4) {
            throw new FieldParseException("Cannot convert into valid ip address");
        }
        String string2 = stringTokenizer.nextToken();
        while (stringTokenizer.hasMoreTokens()) {
            string2 = string2 + "." + stringTokenizer.nextToken();
        }
        JCIPAddress jCIPAddress = new JCIPAddress(string2);
        return jCIPAddress;
    }

    public void changeText(TextEvent textEvent) {
        String string = textEvent.getOriginalText();
        if (textEvent.getText().equals(".")) {
            int n2 = textEvent.getStartPosition();
            String string2 = this.getParsedMask().substring(n2);
            int n3 = string2.indexOf(".");
            if (n3 >= 0) {
                String string3 = n2 >= 0 && n2 <= 2 ? string.substring(0, 3) : (n2 >= 4 && n2 <= 6 ? string.substring(4, 7) : (n2 >= 8 && n2 <= 10 ? string.substring(8, 11) : string.substring(12)));
                if (string3.trim().length() == 0) {
                    textEvent.setAllowChange(false);
                } else {
                    textEvent.setText("");
                    textEvent.setStartPosition(n3 + n2);
                }
            } else {
                textEvent.setAllowChange(false);
            }
        } else {
            super.changeText(textEvent);
        }
    }

    public Object copyValue(Object object) {
        return object;
    }

    public void setMask(String string) {
    }

    public void setIPValidators(JCIntegerValidator[] jCIntegerValidatorArray) {
        this.validators = jCIntegerValidatorArray;
    }

    public JCIntegerValidator[] getValidators() {
        return this.validators;
    }

    public boolean validate(Object object) {
        boolean bl = true;
        JCIPAddress jCIPAddress = (JCIPAddress)this.convertToSupported(object);
        if (jCIPAddress == null) {
            return this.getAllowNull();
        }
        int[] nArray = jCIPAddress.getIPAddress();
        if (nArray == null) {
            return false;
        }
        for (int i2 = 0; i2 < nArray.length; ++i2) {
            int n2 = nArray[i2];
            if (this.validators != null && i2 < this.validators.length && this.validators[i2] != null && (n2 < ((Number)this.validators[i2].getMin()).intValue() || n2 > ((Number)this.validators[i2].getMax()).intValue())) {
                bl = false;
                continue;
            }
            if (n2 >= JCIPAddress.MIN_VALUE && n2 <= JCIPAddress.MAX_VALUE) continue;
            bl = false;
        }
        return bl;
    }

    public void setSpinPolicy(int n2) {
    }

    private JCIPAddress spinSubField(JCIPAddress jCIPAddress, int n2) {
        int n3 = this.increment_field;
        int[] nArray = jCIPAddress.getIPAddress();
        int n4 = nArray[n3];
        n4 += n2;
        if (this.validators != null && n3 < this.validators.length && this.validators[n3] != null) {
            if (n4 < ((Number)this.validators[n3].getMin()).intValue() || n4 > ((Number)this.validators[n3].getMax()).intValue()) {
                return jCIPAddress;
            }
            if (n4 > JCIPAddress.MAX_VALUE || n4 < JCIPAddress.MIN_VALUE) {
                return jCIPAddress;
            }
        }
        nArray[n3] = n4;
        JCIPAddress jCIPAddress2 = new JCIPAddress(nArray);
        return jCIPAddress2;
    }

    protected Object addIncrement(Object object) {
        if (object == null || this.increment == null) {
            return null;
        }
        int n2 = (Integer)this.increment;
        if (n2 == 0) {
            return object;
        }
        JCIPAddress jCIPAddress = (JCIPAddress)object;
        if (this.spin_policy == 1) {
            jCIPAddress = this.spinSubField(jCIPAddress, n2);
        }
        return jCIPAddress;
    }

    protected Object subtractIncrement(Object object) {
        if (object == null || this.increment == null) {
            return null;
        }
        int n2 = (Integer)this.increment;
        if (n2 == 0) {
            return object;
        }
        JCIPAddress jCIPAddress = (JCIPAddress)object;
        if (this.spin_policy == 1) {
            jCIPAddress = this.spinSubField(jCIPAddress, -n2);
        }
        return jCIPAddress;
    }

    public void inferSubField(int n2, int n3) {
        if (n2 >= 0 && n2 <= 3) {
            this.setIncrementField(0);
        } else if (n2 >= 4 && n2 <= 6) {
            this.setIncrementField(1);
        } else if (n2 >= 8 && n2 <= 10) {
            this.setIncrementField(2);
        } else if (n2 >= 12 && n2 <= 14) {
            this.setIncrementField(3);
        }
    }

    public void setIncrement(Integer n2) {
        if (n2 == null) {
            return;
        }
        this.increment = n2;
    }

    public Integer getIncrement() {
        return (Integer)this.increment;
    }

    public int getIncrementField() {
        return this.increment_field;
    }

    public void setIncrementField(int n2) {
        if (n2 < 0 && n2 >= 4) {
            throw new IllegalArgumentException("invalid value for incrementField");
        }
        this.increment_field = n2;
    }

    public Object convertToSupported(Object object) {
        if (object instanceof JCIPAddress) {
            return object;
        }
        return null;
    }

    public Object convertFromSupported(Object object, Class clazz) {
        if (object == null || clazz == null) {
            return null;
        }
        String string = clazz.getName();
        if (string.equals("com.klg.jclass.util.JCIPAddress")) {
            return object;
        }
        return null;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object object) {
        this.defaultValue = object;
    }
}

