/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.field.validate;

import com.klg.jclass.field.validate.FieldParseException;
import com.klg.jclass.field.validate.JCNumberValidator;
import com.klg.jclass.field.validate.TextCursorEvent;
import com.klg.jclass.field.validate.TextEvent;
import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParsePosition;
import java.util.Locale;

public class JCBigDecimalValidator
extends JCNumberValidator {
    protected Object defaultValue = new BigDecimal(0.0);
    protected boolean useFormatting = false;

    public JCBigDecimalValidator() {
        super.setMax(new BigDecimal(Double.MAX_VALUE));
        super.setMin(new BigDecimal(-1.7976931348623157E308));
        this.setIncrement(new BigDecimal(1.0));
        this.supportedClasses = this.getSupportedClasses();
    }

    public JCBigDecimalValidator(Locale locale, Number number, Number number2, Number number3, String string, boolean bl, boolean bl2, boolean bl3, Locale locale2, Object object) {
        this();
        this.setLocale(locale);
        this.setCurrencyLocale(locale2);
        this.setUseIntlCurrencySymbol(bl3);
        this.setMax(this.getBigDecimal(number2));
        this.setMin(this.getBigDecimal(number));
        this.setIncrement(this.getBigDecimal(number3));
        if (string != null) {
            this.setDisplayPattern(string);
        }
        this.setAllowNull(bl);
        this.setCurrency(bl2);
        this.setDefaultValue(object);
    }

    protected Class[] getSupportedClasses() {
        Class[] classArray = new Class[]{Double.class, Float.class, BigDecimal.class};
        return classArray;
    }

    protected BigDecimal getBigDecimal(Object object) {
        if (object == null || !(object instanceof Number)) {
            return null;
        }
        if (object instanceof BigDecimal) {
            return (BigDecimal)object;
        }
        double d2 = ((Number)object).doubleValue();
        BigDecimal bigDecimal = null;
        try {
            bigDecimal = new BigDecimal(d2);
        }
        catch (NumberFormatException numberFormatException) {
            bigDecimal = new BigDecimal(Double.MAX_VALUE);
        }
        return bigDecimal;
    }

    protected DecimalFormat createDisplayFormat(Locale locale) {
        return (DecimalFormat)NumberFormat.getNumberInstance(locale);
    }

    protected DecimalFormat createEditFormat(Locale locale) {
        return (DecimalFormat)NumberFormat.getNumberInstance(locale);
    }

    protected void setPatterns() {
        String[] stringArray = this.li.getStringArray("NumberPatterns");
        if (this.isCurrency) {
            this.display_pattern = stringArray[1];
            this.edit_pattern = "0.##";
        } else {
            this.display_pattern = stringArray[0];
            this.edit_pattern = "0.###";
        }
    }

    public void setCursor(TextCursorEvent textCursorEvent) {
        textCursorEvent.getNewPosition();
    }

    protected Object addIncrement(Object object) {
        if (this.increment == null || object == null) {
            return null;
        }
        BigDecimal bigDecimal = this.getBigDecimal(object).add(this.getBigDecimal(this.increment));
        if (bigDecimal.compareTo(this.getBigDecimal(this.getMax())) == 1) {
            return null;
        }
        return bigDecimal;
    }

    protected Object subtractIncrement(Object object) {
        if (this.increment == null || object == null) {
            return null;
        }
        BigDecimal bigDecimal = this.getBigDecimal(object).subtract(this.getBigDecimal(this.increment));
        if (bigDecimal.compareTo(this.getBigDecimal(this.getMin())) == -1) {
            return null;
        }
        return bigDecimal;
    }

    public Number getIncrement() {
        return (Number)this.increment;
    }

    public void setIncrement(Number number) {
        BigDecimal bigDecimal = this.getBigDecimal(number);
        if (number == null) {
            return;
        }
        if (bigDecimal.compareTo(new BigDecimal(0.0)) == -1) {
            throw new IllegalArgumentException("increment <= 0.0");
        }
        this.increment = number;
    }

    public boolean inRange(BigDecimal bigDecimal) {
        return bigDecimal.compareTo(this.getBigDecimal(this.getMin())) != -1 && bigDecimal.compareTo(this.getBigDecimal(this.getMax())) != 1;
    }

    public boolean inRange(Object object) {
        if (object instanceof Number) {
            return this.inRange(this.getBigDecimal(object));
        }
        return false;
    }

    public void changeText(TextEvent textEvent) {
        String string;
        int n2;
        if (textEvent == null) {
            return;
        }
        StringBuffer stringBuffer = null;
        StringBuffer stringBuffer2 = new StringBuffer(50);
        boolean bl = false;
        boolean bl2 = false;
        int n3 = textEvent.getStartPosition();
        int n4 = textEvent.getEndPosition();
        String string2 = textEvent.getOriginalText();
        if (string2.indexOf(this.symbols.getDecimalSeparator()) != -1) {
            bl2 = true;
            if (textEvent.isDeletion() && (n2 = (string = string2.substring(n3, n4)).indexOf(this.symbols.getDecimalSeparator())) != -1) {
                bl2 = false;
            }
        }
        if (string2.indexOf(this.exponentialChar) != -1) {
            bl = true;
            if (textEvent.isDeletion() && (string = string2.substring(n3, n4)).indexOf(this.exponentialChar) != -1) {
                bl = false;
            }
        }
        boolean bl3 = false;
        n2 = 0;
        boolean bl4 = false;
        boolean bl5 = false;
        if (n3 == 0) {
            bl4 = true;
        } else if (string2 != null && string2.length() > 1) {
            char c2 = string2.charAt(string2.length() - 1);
            if (c2 == this.symbols.getMinusSign() && !bl) {
                bl5 = true;
            } else if (c2 == '+') {
                bl5 = true;
            } else if (c2 == ')') {
                bl5 = true;
            }
        }
        if (string2.indexOf(this.symbols.getMinusSign()) != -1) {
            bl3 = true;
        } else if (string2.indexOf(43) != -1) {
            bl3 = true;
        } else if (string2.indexOf(40) != -1) {
            bl3 = true;
            n2 = 1;
        }
        String string3 = textEvent.getText();
        if (string3 != null && string3.length() != 0) {
            stringBuffer = this.checkValidInvalid(string3);
            if (stringBuffer != null && stringBuffer.length() != 0) {
                for (int i2 = 0; i2 < stringBuffer.length(); ++i2) {
                    char c3 = stringBuffer.charAt(i2);
                    if (bl5) continue;
                    if (Character.isDigit(c3)) {
                        stringBuffer2.append(c3);
                        continue;
                    }
                    if (!bl2 && !bl && c3 == this.symbols.getDecimalSeparator()) {
                        stringBuffer2.append(c3);
                        continue;
                    }
                    if (!bl && !bl4 && this.exponentialChar.equalsIgnoreCase(String.valueOf(c3)) && string2.indexOf(this.symbols.getMinusSign()) + 1 != n3) {
                        stringBuffer2.append(this.exponentialChar);
                        continue;
                    }
                    if (c3 == this.symbols.getMinusSign() && (!bl3 && !bl || bl && string2.indexOf(this.exponentialChar) + this.exponentialChar.length() == n3)) {
                        stringBuffer2.append(c3);
                        continue;
                    }
                    if (c3 != '(' && c3 != ')' || this.edit_pattern.indexOf("(") == -1) continue;
                    if (c3 == '(' && bl4) {
                        stringBuffer2.append(c3);
                        continue;
                    }
                    if (c3 != ')' || n2 == 0) continue;
                    stringBuffer2.append(c3);
                }
            }
            textEvent.setText(stringBuffer2.toString());
            if (stringBuffer2.length() == 0) {
                textEvent.setAllowChange(false);
            }
        }
    }

    public Object parse(Class clazz, String string) {
        Object object = null;
        if ((string == null || string.length() == 0) && this.getAllowNull()) {
            return null;
        }
        if (this.useFormatting) {
            ParsePosition parsePosition = new ParsePosition(0);
            Number number = this.editFormat.parse(string, parsePosition);
            if (parsePosition.getIndex() == 0) {
                if (!this.getAllowNull()) {
                    throw new FieldParseException("null values not allowed");
                }
                return null;
            }
            object = new BigDecimal(number.doubleValue());
        } else {
            try {
                object = new BigDecimal(string);
            }
            catch (NumberFormatException numberFormatException) {
                if (!this.getAllowNull()) {
                    throw new FieldParseException("cannot create BigDecimal from text");
                }
                return null;
            }
        }
        object = this.convertFromSupported(object, clazz);
        return object;
    }

    public boolean validate(Object object) {
        boolean bl = super.validate(object);
        if (!bl) {
            return false;
        }
        Object object2 = object;
        if (object != null && this.isClassSupported(object.getClass())) {
            object2 = this.convertToSupported(object2);
        }
        return object2 == null || this.inRange(object);
    }

    public String format(Object object) {
        String string = "";
        if (this.useFormatting) {
            string = super.format(object);
        } else if (object != null) {
            string = object.toString();
        }
        return string;
    }

    public String formatForEdit(Object object) {
        if (object == null) {
            return "";
        }
        String string = null;
        string = this.useFormatting ? this.editFormat.format(object) : object.toString();
        return string;
    }

    public boolean hasEditFormat() {
        return true;
    }

    public Object convertToSupported(Object object) {
        if (object instanceof Number) {
            return this.getBigDecimal(object);
        }
        return null;
    }

    public Object convertFromSupported(Object object, Class clazz) {
        if (object == null || clazz == null) {
            return null;
        }
        String string = clazz.getName();
        BigDecimal bigDecimal = (BigDecimal)object;
        if (string.equals("java.lang.Float")) {
            return new Float(bigDecimal.floatValue());
        }
        if (string.equals("java.lang.Double")) {
            return new Double(bigDecimal.doubleValue());
        }
        if (string.equals("java.math.BigDecimal")) {
            return bigDecimal;
        }
        return null;
    }

    public Object getDefaultValue() {
        return this.defaultValue;
    }

    public void setDefaultValue(Object object) {
        this.defaultValue = object;
    }

    public void setUseFormatting(boolean bl) {
        this.useFormatting = bl;
    }

    public boolean getUseFormatting() {
        return this.useFormatting;
    }
}

