/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.field.validate;

import com.klg.jclass.field.validate.FieldParseException;
import com.klg.jclass.field.validate.JCValidator;
import com.klg.jclass.field.validate.PopupFieldEditor;
import com.klg.jclass.field.validate.TextCursorEvent;
import com.klg.jclass.field.validate.TextEvent;
import java.io.Serializable;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.ListModel;

public abstract class AbstractValidator
implements JCValidator,
Serializable {
    public static final int AS_IS = 0;
    public static final int UPPERCASE = 1;
    public static final int LOWERCASE = 2;
    public static final int SPIN_FIELD = 0;
    public static final int SPIN_SUBFIELD = 1;
    public static final int SPIN_WRAP = 2;
    public static final int NOT_FOUND = -1;
    protected Object max;
    protected Object min;
    protected Locale locale;
    protected Object increment;
    protected boolean allow_null = false;
    protected int case_policy = 0;
    protected String invalid_chars = null;
    protected boolean match_picklist = true;
    protected String valid_chars = null;
    protected ListModel picklist = null;
    protected int spin_policy = 0;
    protected boolean abstractInitializing = true;
    protected Class[] supportedClasses;
    protected ResourceBundle li;

    public AbstractValidator() {
        this.setLocale(Locale.getDefault());
        this.abstractInitializing = false;
    }

    public void changeText(TextEvent textEvent) {
        String string = textEvent.getText();
        if (string == null || string.length() == 0) {
            return;
        }
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i2 = 0; i2 < string.length(); ++i2) {
            stringBuffer.append(this.convertCase(string.charAt(i2)));
        }
        textEvent.setText(stringBuffer.toString());
    }

    public abstract void setCursor(TextCursorEvent var1);

    public abstract Object parse(Class var1, String var2) throws FieldParseException;

    public abstract Object convertToSupported(Object var1);

    public abstract Object convertFromSupported(Object var1, Class var2);

    public boolean validate(Object object) {
        boolean bl = true;
        if (this.picklist != null && this.picklist.getSize() > 0 && this.match_picklist) {
            int n2 = this.getPickListIndex(object);
            bl = n2 != -1;
        }
        if (!this.allow_null && object == null) {
            bl = false;
        }
        return bl;
    }

    public abstract Object copyValue(Object var1);

    public boolean compareValues(Object object, Object object2) {
        if (object == object2) {
            return true;
        }
        if (object == null) {
            return false;
        }
        return object.equals(object2);
    }

    public abstract String format(Object var1);

    public abstract String formatForEdit(Object var1);

    public abstract boolean hasEditFormat();

    public abstract int getFirstValidCursorPosition();

    public boolean getAllowNull() {
        return this.allow_null;
    }

    public void setAllowNull(boolean bl) {
        this.allow_null = bl;
    }

    public int getSpinPolicy() {
        return this.spin_policy;
    }

    public void setSpinPolicy(int n2) {
        if (n2 != 1 && n2 != 0 && n2 != 2) {
            throw new IllegalArgumentException("invalid value for spinPolicy");
        }
        this.spin_policy = n2;
    }

    public void inferSubField(int n2, int n3) {
    }

    public Locale getLocale() {
        return this.locale;
    }

    public void setLocale(Locale locale) {
        if (this.locale == locale) {
            return;
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        String string = "com.klg.jclass.field.resources.LocaleInfo";
        try {
            this.li = ResourceBundle.getBundle(string, locale);
        }
        catch (MissingResourceException missingResourceException) {
            locale = new Locale(locale.getLanguage(), locale.getCountry());
            try {
                this.li = ResourceBundle.getBundle(string, locale);
            }
            catch (MissingResourceException missingResourceException2) {
                locale = new Locale(locale.getLanguage(), "");
                try {
                    this.li = ResourceBundle.getBundle(string, locale);
                }
                catch (MissingResourceException missingResourceException3) {
                    locale = null;
                    try {
                        this.li = ResourceBundle.getBundle(string, locale);
                    }
                    catch (MissingResourceException missingResourceException4) {
                        throw missingResourceException;
                    }
                }
            }
        }
        this.locale = locale;
    }

    public int getCasePolicy() {
        return this.case_policy;
    }

    public void setCasePolicy(int n2) {
        if (n2 != 0 && n2 != 1 && n2 != 2) {
            throw new IllegalArgumentException("invalid value for casePolicy");
        }
        this.case_policy = n2;
    }

    public char convertCase(char c2) {
        switch (this.case_policy) {
            case 0: {
                break;
            }
            case 1: {
                c2 = Character.toUpperCase(c2);
                break;
            }
            case 2: {
                c2 = Character.toLowerCase(c2);
            }
        }
        return c2;
    }

    public ListModel getPickList() {
        return this.picklist;
    }

    public void setPickList(ListModel listModel) {
        this.picklist = listModel;
    }

    public int getPickListIndex(Object object) {
        if (this.picklist == null || object == null) {
            return -1;
        }
        for (int i2 = 0; i2 < this.picklist.getSize(); ++i2) {
            if (!object.equals(this.picklist.getElementAt(i2))) continue;
            return i2;
        }
        return -1;
    }

    public boolean getMatchPickList() {
        return this.match_picklist;
    }

    public void setMatchPickList(boolean bl) {
        this.match_picklist = bl;
    }

    protected Object getNextValue(int n2) {
        if (n2 + 1 >= 0 && n2 + 1 >= this.picklist.getSize()) {
            return null;
        }
        return this.picklist.getElementAt(n2 + 1);
    }

    protected Object getPreviousValue(int n2) {
        if (n2 - 1 < 0) {
            return null;
        }
        return this.picklist.getElementAt(n2 - 1);
    }

    public String getValidChars() {
        return this.valid_chars;
    }

    public void setValidChars(String string) {
        this.valid_chars = string;
    }

    public String getInvalidChars() {
        return this.invalid_chars;
    }

    public void setInvalidChars(String string) {
        this.invalid_chars = string;
    }

    public boolean isValidChar(char c2) {
        int n2;
        if (this.invalid_chars != null) {
            for (n2 = 0; n2 < this.invalid_chars.length(); ++n2) {
                if (c2 != this.invalid_chars.charAt(n2)) continue;
                return false;
            }
        }
        if (this.valid_chars == null || this.valid_chars.length() == 0) {
            return true;
        }
        for (n2 = 0; n2 < this.valid_chars.length(); ++n2) {
            if (c2 != this.valid_chars.charAt(n2)) continue;
            return true;
        }
        return false;
    }

    public Object getMax() {
        return this.max;
    }

    public void setMax(Object object) {
        this.max = object;
    }

    public Object getMin() {
        return this.min;
    }

    public void setMin(Object object) {
        this.min = object;
    }

    public void setRange(Object object, Object object2) {
        this.min = object;
        this.max = object2;
    }

    protected abstract boolean inRange(Object var1);

    protected String getItem(int n2) {
        return this.picklist.getElementAt(n2).toString();
    }

    protected abstract Object addIncrement(Object var1);

    protected abstract Object subtractIncrement(Object var1);

    public Object spinUp(Object object) {
        if (this.picklist != null && this.picklist.getSize() > 0) {
            int n2 = this.getPickListIndex(object);
            if (n2 + 1 < this.picklist.getSize()) {
                return this.picklist.getElementAt(n2 + 1);
            }
            if (this.spin_policy == 2) {
                return this.picklist.getElementAt(0);
            }
            return null;
        }
        if (this.increment != null) {
            Object object2 = this.addIncrement(object);
            if (object2 != null) {
                return object2;
            }
            if (this.spin_policy == 2) {
                return this.min;
            }
        }
        return null;
    }

    public Object spinDown(Object object) {
        if (this.picklist != null && this.picklist.getSize() > 0) {
            int n2 = this.getPickListIndex(object);
            if (n2 > 0) {
                return this.picklist.getElementAt(n2 - 1);
            }
            if (n2 == -1) {
                return this.picklist.getElementAt(this.picklist.getSize() - 1);
            }
            if (this.spin_policy == 2) {
                return this.picklist.getElementAt(this.picklist.getSize() - 1);
            }
            return null;
        }
        if (this.increment != null) {
            Object object2 = this.subtractIncrement(object);
            if (object2 != null) {
                return object2;
            }
            if (this.spin_policy == 2) {
                return this.max;
            }
        }
        return null;
    }

    public int calculateSpinability(Object object) {
        if (object != null && !this.isClassSupported(object.getClass())) {
            return 0;
        }
        int n2 = 0;
        if (this.picklist != null && this.picklist.getSize() > 0) {
            int n3 = this.getPickListIndex(object);
            if (this.spin_policy == 2) {
                n2 |= 2;
                n2 |= 1;
            } else {
                if (n3 > 0 || n3 == -1) {
                    n2 |= 2;
                }
                if (n3 < this.picklist.getSize() - 1) {
                    n2 |= 1;
                }
            }
            return n2;
        }
        if (this.increment != null) {
            Object object2 = this.subtractIncrement(object);
            if (this.spin_policy == 2) {
                n2 |= 2;
                n2 |= 1;
            } else {
                if (object2 != null && !object2.equals(object)) {
                    n2 |= 2;
                }
                if ((object2 = this.addIncrement(object)) != null && !object2.equals(object)) {
                    n2 |= 1;
                }
            }
            return n2;
        }
        return 0;
    }

    protected StringBuffer checkValidInvalid(String string) {
        StringBuffer stringBuffer = new StringBuffer(string.length());
        for (int i2 = 0; i2 < string.length(); ++i2) {
            char c2 = string.charAt(i2);
            if (!this.isValidChar(c2)) continue;
            stringBuffer.append(c2);
        }
        return stringBuffer;
    }

    public boolean isClassSupported(Class clazz) {
        if (this.supportedClasses == null) {
            return false;
        }
        for (int i2 = 0; i2 < this.supportedClasses.length; ++i2) {
            if (clazz != this.supportedClasses[i2]) continue;
            return true;
        }
        return false;
    }

    public PopupFieldEditor createPopupComponent() {
        return null;
    }
}

