/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.field;

import com.klg.jclass.field.JCFieldComponent;
import com.klg.jclass.field.JCInvalidInfo;
import java.awt.Component;
import java.awt.Container;
import java.util.HashSet;
import java.util.Set;

public class JCFormUtil {
    private static void addFieldChildrenToSet(Container container, Set set) {
        Component[] componentArray = container.getComponents();
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            if (componentArray[i2] instanceof JCFieldComponent) {
                set.add(componentArray[i2]);
                continue;
            }
            if (!(componentArray[i2] instanceof Container)) continue;
            JCFormUtil.addFieldChildrenToSet((Container)componentArray[i2], set);
        }
    }

    public static Set getFieldComponents(Container container) {
        HashSet hashSet = new HashSet();
        JCFormUtil.addFieldChildrenToSet(container, hashSet);
        return hashSet;
    }

    public static boolean isFieldComponentContainerComplete(Container container) {
        Set set = JCFormUtil.getInvalidRequiredFieldComponents(container);
        return set == null || set.size() == 0;
    }

    private static void addRequiredFieldChildrenToSet(Container container, Set set) {
        Component[] componentArray = container.getComponents();
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            if (componentArray[i2] instanceof JCFieldComponent) {
                JCFieldComponent jCFieldComponent = (JCFieldComponent)((Object)componentArray[i2]);
                if (!jCFieldComponent.isRequired()) continue;
                set.add(componentArray[i2]);
                continue;
            }
            if (!(componentArray[i2] instanceof Container)) continue;
            JCFormUtil.addRequiredFieldChildrenToSet((Container)componentArray[i2], set);
        }
    }

    public static Set getRequiredFieldComponents(Container container) {
        HashSet hashSet = new HashSet();
        JCFormUtil.addRequiredFieldChildrenToSet(container, hashSet);
        return hashSet;
    }

    private static void addInvalidRequiredFieldChildrenToSet(Container container, Set set) {
        Component[] componentArray = container.getComponents();
        for (int i2 = 0; i2 < componentArray.length; ++i2) {
            if (componentArray[i2] instanceof JCFieldComponent) {
                JCFieldComponent jCFieldComponent = (JCFieldComponent)((Object)componentArray[i2]);
                if (!jCFieldComponent.isRequired()) continue;
                if (jCFieldComponent.getState() == 2) {
                    jCFieldComponent.commitEdit();
                }
                if (jCFieldComponent.getState() == 1) continue;
                set.add(componentArray[i2]);
                continue;
            }
            if (!(componentArray[i2] instanceof Container)) continue;
            JCFormUtil.addInvalidRequiredFieldChildrenToSet((Container)componentArray[i2], set);
        }
    }

    public static Set getInvalidRequiredFieldComponents(Container container) {
        HashSet hashSet = new HashSet();
        JCFormUtil.addInvalidRequiredFieldChildrenToSet(container, hashSet);
        return hashSet;
    }

    public static void clearFieldComponents(Container container) {
        Set set = JCFormUtil.getFieldComponents(container);
        for (JCFieldComponent jCFieldComponent : set) {
            JCInvalidInfo jCInvalidInfo = jCFieldComponent.getInvalidInfo();
            jCInvalidInfo.setBeepOnInvalid(false);
            jCFieldComponent.setInvalidInfo(jCInvalidInfo);
            jCFieldComponent.setValue(null);
            jCInvalidInfo.setBeepOnInvalid(true);
            jCFieldComponent.setInvalidInfo(jCInvalidInfo);
        }
    }

    public static void resetFieldComponents(Container container) {
        Set set = JCFormUtil.getFieldComponents(container);
        for (JCFieldComponent jCFieldComponent : set) {
            JCInvalidInfo jCInvalidInfo = jCFieldComponent.getInvalidInfo();
            jCInvalidInfo.setBeepOnInvalid(false);
            jCFieldComponent.setInvalidInfo(jCInvalidInfo);
            jCFieldComponent.setValue(jCFieldComponent.getValidator().getDefaultValue());
            jCInvalidInfo.setBeepOnInvalid(true);
            jCFieldComponent.setInvalidInfo(jCInvalidInfo);
        }
    }
}

