/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource.util;

import com.klg.jclass.datasource.util.ColumnMap;
import com.klg.jclass.datasource.util.SqlParser;
import com.klg.jclass.datasource.util.SqlStatementColumn;
import com.klg.jclass.datasource.util.SqlStatementTable;
import java.io.Serializable;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Observable;
import java.util.Vector;

public class SqlStatement
extends Observable
implements Serializable {
    static final long serialVersionUID = -4759648418780454669L;
    private Vector columnPositions = new Vector();
    private Hashtable columns = new Hashtable();
    private int columnAliasCounter = 0;
    private Hashtable tables = new Hashtable();
    private Hashtable tableAliasCounter = new Hashtable();
    private Hashtable joins = new Hashtable();
    private Vector parameterColumns = new Vector();
    private String statement;
    private String[] userDefinedClauses = new String[4];
    private SqlParser parser = null;
    private boolean expertMode = false;
    private static final boolean TRACE = false;

    public SqlStatement() {
    }

    public SqlStatement(String string) {
        this.setText(string);
    }

    public void addColumn(String string) {
        this.addColumn(string, null);
    }

    public SqlStatementColumn addColumn(String string, String string2) {
        String string3 = null;
        if (string.lastIndexOf(".") > -1) {
            string3 = string.substring(0, string.lastIndexOf("."));
            string = string.substring(string.lastIndexOf(".") + 1);
        }
        return this.addColumn(string, string2, string3, null);
    }

    public SqlStatementColumn addColumn(String string, String string2, String string3) {
        return this.addColumn(string, null, string2, string3);
    }

    public SqlStatementColumn addColumn(String string, String string2, String string3, String string4) {
        if (string == null) {
            return null;
        }
        String string5 = string2 == null ? string : new String(string + " AS " + string2);
        SqlStatementColumn sqlStatementColumn = SqlParser.parseColumn(string5);
        if (string4 == null) {
            string4 = string3;
        }
        if (string4 != null && sqlStatementColumn.getQualifier() == null) {
            sqlStatementColumn.setQualifier(string4);
        }
        if (this.columns.containsKey(sqlStatementColumn.getAlias())) {
            sqlStatementColumn.setAlias(sqlStatementColumn.getAlias() + this.getNextColumnAliasCounter(sqlStatementColumn.getColumnName()));
        }
        this.columns.put(sqlStatementColumn.getAlias(), sqlStatementColumn);
        this.columnPositions.addElement(sqlStatementColumn);
        if (string4 != null && !this.tables.containsKey(string4)) {
            this.addTable(string3, string4);
        } else {
            this.refreshText();
        }
        return sqlStatementColumn;
    }

    public void removeColumn(String string) {
        if (this.columns.get(string) != null) {
            this.columnPositions.removeElement(this.columns.get(string));
            this.columns.remove(string);
            this.refreshText();
        }
    }

    public SqlStatementTable addTable(String string) {
        return this.addTable(string, null);
    }

    public SqlStatementTable addTable(String string, String string2) {
        if (string == null) {
            return null;
        }
        String string3 = string2 == null ? string : new String(string + " " + string2);
        SqlStatementTable sqlStatementTable = SqlParser.parseTable(string3);
        return this.addTable(sqlStatementTable);
    }

    public SqlStatementTable addTable(SqlStatementTable sqlStatementTable) {
        if (!this.tables.containsKey(sqlStatementTable.getAlias())) {
            this.tableAliasCounter.put(sqlStatementTable.getQualifiedName(), new Integer(0));
        } else if (sqlStatementTable.getAlias().equals(sqlStatementTable.getTableName())) {
            sqlStatementTable.setAlias(sqlStatementTable.getTableName() + this.getNextTableAliasCounter(sqlStatementTable.getQualifiedName()));
        } else {
            sqlStatementTable = null;
        }
        if (sqlStatementTable != null) {
            this.tables.put(sqlStatementTable.getAlias(), sqlStatementTable);
            this.refreshText();
        }
        return sqlStatementTable;
    }

    public void removeTable(String string) {
        Object object;
        Object object2;
        SqlStatementTable sqlStatementTable = (SqlStatementTable)this.tables.get(string);
        if (sqlStatementTable == null) {
            return;
        }
        Hashtable hashtable = (Hashtable)this.columns.clone();
        Hashtable hashtable2 = (Hashtable)this.joins.clone();
        Vector vector = (Vector)this.parameterColumns.clone();
        Enumeration enumeration = hashtable.elements();
        while (enumeration.hasMoreElements()) {
            object2 = (SqlStatementColumn)enumeration.nextElement();
            if (((SqlStatementColumn)object2).getQualifier() == null || !((SqlStatementColumn)object2).getQualifier().endsWith(string)) continue;
            this.columns.remove(((SqlStatementColumn)object2).getAlias());
            this.columnPositions.removeElement(object2);
        }
        object2 = vector.elements();
        while (object2.hasMoreElements()) {
            object = (String)object2.nextElement();
            if (!((String)object).startsWith(string)) continue;
            this.parameterColumns.removeElement(object);
        }
        object = hashtable2.keys();
        while (object.hasMoreElements()) {
            String string2 = (String)object.nextElement();
            ColumnMap columnMap = (ColumnMap)this.joins.get(string2);
            if (!columnMap.getParentColumn().startsWith(string + ".") && !columnMap.getChildColumn().startsWith(string + ".")) continue;
            this.joins.remove(string2);
        }
        this.tables.remove(string);
        this.refreshText();
    }

    public void addJoin(String string, String string2) {
        String string3 = string + " = " + string2;
        String string4 = string2 + " = " + string;
        if (!this.joins.containsKey(string3) && !this.joins.containsKey(string4)) {
            this.joins.put(string3, new ColumnMap(string, string2));
            this.refreshText();
        }
    }

    public void removeJoin(String string, String string2) {
        String string3 = string + " = " + string2;
        String string4 = string2 + " = " + string;
        if (this.joins.containsKey(string3)) {
            this.joins.remove(string3);
            this.refreshText();
        } else if (this.joins.containsKey(string4)) {
            this.joins.remove(string4);
            this.refreshText();
        }
    }

    public void removeJoin(String string) {
        boolean bl = false;
        Enumeration enumeration = this.joins.elements();
        while (enumeration.hasMoreElements()) {
            ColumnMap columnMap = (ColumnMap)enumeration.nextElement();
            if (!columnMap.getParentColumn().startsWith(string + ".") && !columnMap.getChildColumn().startsWith(string + ".")) continue;
            this.joins.remove(columnMap.getParentColumn() + " = " + columnMap.getChildColumn());
            bl = true;
        }
        if (bl) {
            this.refreshText();
        }
    }

    public void addParameterColumn(String string) {
        this.parameterColumns.addElement(string);
        this.refreshText();
    }

    public void removeParameterColumn(String string) {
        if (this.parameterColumns.contains(string)) {
            this.parameterColumns.removeElement(string);
            this.refreshText();
        }
    }

    public void removeAllParameterColumns() {
        if (this.parameterColumns.size() > 0) {
            this.parameterColumns.removeAllElements();
            this.refreshText();
        }
    }

    public void refreshText() {
        String string;
        Object object;
        Object object2;
        Object object3;
        if (this.isExpertMode()) {
            this.setChanged();
            return;
        }
        int n2 = 0;
        String string2 = System.getProperty("line.separator");
        String string3 = new String("");
        String string4 = new String("");
        String string5 = new String("");
        this.statement = "SELECT\t";
        Enumeration enumeration = this.columnPositions.elements();
        while (enumeration.hasMoreElements()) {
            string3 = string3 + (n2++ == 0 ? "" : "," + string2 + "\t");
            object3 = (SqlStatementColumn)enumeration.nextElement();
            if (((SqlStatementColumn)object3).isTableColumn()) {
                string3 = string3 + ((SqlStatementColumn)object3).getQualifiedName();
                if (((SqlStatementColumn)object3).getAlias() == null || ((SqlStatementColumn)object3).getAlias().equals(((SqlStatementColumn)object3).getQualifiedName())) continue;
                string3 = string3 + " AS \"" + ((SqlStatementColumn)object3).getAlias() + "\"";
                continue;
            }
            string3 = string3 + ((SqlStatementColumn)object3).getText();
        }
        if (n2 > 0) {
            string3 = "SELECT\t" + string3;
        }
        n2 = 0;
        object3 = this.tables.elements();
        while (object3.hasMoreElements()) {
            string4 = string4 + (n2++ == 0 ? "" : "," + string2 + "\t");
            object2 = (SqlStatementTable)object3.nextElement();
            if (!((SqlStatementTable)object2).isSubQuery()) {
                string4 = string4 + ((SqlStatementTable)object2).getQualifiedName();
                if (((SqlStatementTable)object2).getAlias() == null || ((SqlStatementTable)object2).getAlias().equals(((SqlStatementTable)object2).getQualifiedName())) continue;
                string4 = string4 + " " + ((SqlStatementTable)object2).getAlias();
                continue;
            }
            string4 = string4 + ((SqlStatementTable)object2).getSubQuery();
        }
        if (n2 > 0) {
            string4 = "FROM\t" + string4;
        }
        n2 = 0;
        object2 = this.joins.elements();
        while (object2.hasMoreElements()) {
            string5 = string5 + (n2++ == 0 ? "" : string2 + "AND\t");
            object = (ColumnMap)object2.nextElement();
            string5 = string5 + ((ColumnMap)object).getParentColumn() + " = " + ((ColumnMap)object).getChildColumn();
        }
        object = this.parameterColumns.elements();
        while (object.hasMoreElements()) {
            string5 = string5 + (n2++ == 0 ? "" : string2 + "AND\t");
            string = (String)object.nextElement();
            string5 = string5 + string + " = ?";
        }
        if (n2 > 0) {
            string5 = "WHERE\t" + string5;
            if (this.userDefinedClauses[2].length() > 0) {
                string5 = string5 + string2 + "AND\t" + this.userDefinedClauses[2];
            }
        } else if (this.userDefinedClauses[2].length() > 0) {
            string5 = "WHERE\t" + this.userDefinedClauses[2];
        }
        this.statement = string3 + string2 + string4 + string2 + string5 + string2 + this.userDefinedClauses[3];
        string = this.statement.trim();
        if (string.length() == 0) {
            this.statement = string;
        }
        this.setChanged();
    }

    public String getText() {
        return this.statement;
    }

    public void setText(String string) {
        if (this.isExpertMode()) {
            this.statement = string;
            this.setChanged();
            return;
        }
        this.clear();
        if (string != null) {
            Object object;
            Object object2;
            Object object3;
            this.parser = new SqlParser(string);
            String string2 = this.parser.getClause(2, false);
            this.userDefinedClauses[3] = this.parser.getClause(3);
            Enumeration enumeration = this.parser.getTables().elements();
            while (enumeration.hasMoreElements()) {
                object3 = (SqlStatementTable)enumeration.nextElement();
                this.addTable((SqlStatementTable)object3);
            }
            object3 = this.parser.getColumns().elements();
            while (object3.hasMoreElements()) {
                object2 = (SqlStatementColumn)object3.nextElement();
                this.columns.put(((SqlStatementColumn)object2).getAlias(), object2);
                this.columnPositions.addElement(object2);
            }
            object2 = this.parser.getJoins().elements();
            while (object2.hasMoreElements()) {
                object = (ColumnMap)object2.nextElement();
                this.addJoin(((ColumnMap)object).getParentColumn(), ((ColumnMap)object).getChildColumn());
            }
            object = this.parser.getParameterColumns().elements();
            while (object.hasMoreElements()) {
                String string3 = (String)object.nextElement();
                this.addParameterColumn(string3);
            }
            this.userDefinedClauses[2] = this.parser.getNonJoinWhereClause();
            this.refreshText();
        }
    }

    public Enumeration getTables() {
        return this.tables.elements();
    }

    public Enumeration getColumns() {
        return this.columns.elements();
    }

    public Enumeration getJoins() {
        return this.joins.elements();
    }

    public void clear() {
        this.columns = new Hashtable();
        this.columnPositions = new Vector();
        this.tables = new Hashtable();
        this.joins = new Hashtable();
        this.parameterColumns = new Vector();
        this.columnAliasCounter = 0;
        this.tableAliasCounter = new Hashtable();
        this.userDefinedClauses = new String[]{"", "", "", ""};
        this.refreshText();
    }

    public boolean isExpertMode() {
        return this.expertMode;
    }

    public void setExpertMode(boolean bl) {
        if (this.expertMode == bl) {
            return;
        }
        this.expertMode = bl;
        this.setChanged();
    }

    private int getNextColumnAliasCounter(String string) {
        Enumeration enumeration = this.columns.keys();
        while (enumeration.hasMoreElements()) {
            String string2 = (String)enumeration.nextElement();
            if (!string2.startsWith(string)) continue;
            String string3 = string2.substring(string2.indexOf(string) + string.length());
            try {
                int n2 = string3.length() == 0 ? 0 : new Integer(string3);
                this.columnAliasCounter = Math.max(n2, this.columnAliasCounter);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ++this.columnAliasCounter;
    }

    private int getNextTableAliasCounter(String string) {
        Integer n2 = (Integer)this.tableAliasCounter.get(string);
        this.tableAliasCounter.put(string, new Integer(n2 + 1));
        return n2 + 1;
    }
}

