/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource.swing;

import com.klg.jclass.datasource.BindingModel;
import com.klg.jclass.datasource.DataModel;
import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.datasource.MetaDataModel;
import com.klg.jclass.datasource.swing.NavigatorButton;
import com.klg.jclass.datasource.util.LocaleBundle;
import com.klg.jclass.datasource.util.NavigatorDataBinding;
import com.klg.jclass.datasource.util.NavigatorPopupMenu;
import com.klg.jclass.util.swing.GotoRowDialog;
import com.klg.jclass.util.swing.JCBorder;
import com.klg.jclass.util.swing.JCWordWrap;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.LayoutManager;
import java.awt.Point;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import java.text.MessageFormat;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class DSdbJNavigator
extends JPanel
implements ActionListener,
Serializable {
    protected Color statusBackground = new Color(SystemColor.window.getRGB());
    protected Color statusForeground = new Color(SystemColor.windowText.getRGB());
    protected boolean statusVisible = true;
    protected Color buttonBackground = new Color(SystemColor.control.getRGB());
    protected Color buttonForeground = new Color(SystemColor.controlText.getRGB());
    protected int buttons = 7;
    protected int leftButtons = 4;
    protected NavigatorButton first;
    protected NavigatorButton previous;
    protected NavigatorButton insert;
    protected NavigatorButton delete;
    protected NavigatorButton next;
    protected NavigatorButton last;
    protected NavigatorButton menu;
    protected String rowLabel = "";
    protected int border = 1;
    protected NavigatorPopupMenu popupMenu = null;
    protected DSNavigatorDataBinding dataBinding = new DSNavigatorDataBinding();
    private transient Image buffer = null;
    private transient Dimension lastDimension = null;
    private static String base = "datanavigator";
    private static int nameCounter = 0;
    private static final boolean TRACE = true;

    public DSdbJNavigator() {
        this.setName(base + nameCounter++);
        this.first = this.initButton(new NavigatorButton(0), LocaleBundle.string("Go to first record"));
        this.previous = this.initButton(new NavigatorButton(1), LocaleBundle.string("Go to previous record"));
        this.insert = this.initButton(new NavigatorButton(2), LocaleBundle.string("Insert record"));
        this.delete = this.initButton(new NavigatorButton(3), LocaleBundle.string("Delete current record"));
        this.next = this.initButton(new NavigatorButton(4), LocaleBundle.string("Go to next record"));
        this.last = this.initButton(new NavigatorButton(5), LocaleBundle.string("Go to last record"));
        this.menu = this.initButton(new NavigatorButton(6), LocaleBundle.string("Show pop-up menu"));
        this.popupMenu = new NavigatorPopupMenu(this);
        if (this.popupMenu != null) {
            this.add(this.popupMenu);
        }
        this.setBtnBackground(this.buttonBackground);
        this.setBtnForeground(this.buttonForeground);
        this.reset();
        this.setLayout(null);
    }

    protected NavigatorButton initButton(NavigatorButton navigatorButton, String string) {
        if (navigatorButton != null) {
            this.add(navigatorButton);
            navigatorButton.addActionListener(this);
            navigatorButton.setToolTipText(string);
        }
        return navigatorButton;
    }

    public void setCurrentRow() {
        this.refresh();
    }

    public void setDataBinding(BindingModel bindingModel, boolean bl) {
        this.dataBinding.setDataBinding(bindingModel);
    }

    public void setDataBinding(DataModel dataModel, MetaDataModel metaDataModel) {
        this.dataBinding.setDataBinding(dataModel, metaDataModel);
    }

    public void setDataBinding(DataModel dataModel, String string) {
        this.dataBinding.setDataBinding(dataModel, string);
    }

    public void setDataBinding(String string) {
        this.dataBinding.setDataBinding(string);
    }

    public String getDataBinding() {
        return this.dataBinding.getDataBinding();
    }

    public Color getStatusBackground() {
        return this.statusBackground;
    }

    public void setStatusBackground(Color color) {
        this.statusBackground = color;
    }

    public Color getStatusForeground() {
        return this.statusForeground;
    }

    public void setStatusForeground(Color color) {
        this.statusForeground = color;
    }

    public boolean getStatusVisible() {
        return this.statusVisible;
    }

    public void setStatusVisible(boolean bl) {
        this.statusVisible = bl;
        this.doLayout();
    }

    public Color getButtonBackground() {
        return this.buttonBackground;
    }

    public void setButtonBackground(Color color) {
        this.buttonBackground = color;
        this.setBtnBackground(this.buttonBackground);
    }

    public Color getButtonForeground() {
        return this.buttonForeground;
    }

    public void setButtonForeground(Color color) {
        this.buttonForeground = color;
        this.setBtnForeground(this.buttonForeground);
    }

    public boolean getFirstVisible() {
        return this.first.isVisible();
    }

    public void setFirstVisible(boolean bl) {
        this.first.setVisible(bl);
        this.doLayout();
    }

    public boolean getPreviousVisible() {
        return this.previous.isVisible();
    }

    public void setPreviousVisible(boolean bl) {
        this.previous.setVisible(bl);
        this.doLayout();
    }

    public boolean getCommandVisible() {
        return this.menu.isVisible();
    }

    public void setCommandVisible(boolean bl) {
        this.menu.setVisible(bl);
        this.doLayout();
    }

    public boolean getNextVisible() {
        return this.next.isVisible();
    }

    public void setNextVisible(boolean bl) {
        this.next.setVisible(bl);
        this.doLayout();
    }

    public boolean getLastVisible() {
        return this.last.isVisible();
    }

    public void setLastVisible(boolean bl) {
        this.last.setVisible(bl);
        this.doLayout();
    }

    public boolean getInsertVisible() {
        return this.insert.isVisible();
    }

    public void setInsertVisible(boolean bl) {
        this.insert.setVisible(bl);
        this.popupMenu.enableMenuItem("Insert Record", bl);
        this.doLayout();
    }

    public boolean getDeleteVisible() {
        return this.delete.isVisible();
    }

    public void setDeleteVisible(boolean bl) {
        this.delete.setVisible(bl);
        this.popupMenu.enableMenuItem("Delete Record", bl);
        this.doLayout();
    }

    protected int preferredWidth() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        int n2 = fontMetrics.stringWidth(this.rowLabel);
        n2 = this.statusVisible ? (this.dataBinding.isEnabled() ? n2 + 6 : n2 * 2 + 6) : 0;
        return 2 * this.border + n2 + this.first.getPreferredSize().width * 7;
    }

    protected int minimumWidth() {
        return 2 * this.border + this.first.getPreferredSize().width * 7 + 1;
    }

    protected int preferredHeight() {
        FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
        return this.border * 2 + fontMetrics.getHeight();
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.preferredWidth(), this.preferredHeight());
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.minimumWidth(), this.preferredHeight());
    }

    public Dimension getMaximumSize() {
        return new Dimension(600, this.preferredHeight());
    }

    public void doLayout() {
        Dimension dimension = this.getSize();
        if (dimension == null || dimension.height <= 0 || dimension.width <= 0) {
            return;
        }
        int n2 = dimension.height - this.border * 2;
        int n3 = dimension.width - this.border * 2;
        int n4 = this.first.getPreferredSize().width;
        int n5 = this.border;
        this.leftButtons = 0;
        if (this.first.isVisible()) {
            this.first.setBounds(n5, this.border, n4, n2);
            n5 += n4;
            ++this.leftButtons;
        }
        if (this.previous.isVisible()) {
            this.previous.setBounds(n5, this.border, n4, n2);
            n5 += n4;
            ++this.leftButtons;
        }
        if (this.delete.isVisible()) {
            this.delete.setBounds(n5, this.border, n4, n2);
            n5 += n4;
            ++this.leftButtons;
        }
        if (this.menu.isVisible()) {
            this.menu.setBounds(n5, this.border, n4, n2);
            ++this.leftButtons;
        }
        this.buttons = this.leftButtons;
        n5 = this.border + n3 - n4;
        if (this.insert.isVisible()) {
            this.insert.setBounds(n5, this.border, n4, n2);
            n5 -= n4;
            ++this.buttons;
        }
        if (this.last.isVisible()) {
            this.last.setBounds(n5, this.border, n4, n2);
            n5 -= n4;
            ++this.buttons;
        }
        if (this.next.isVisible()) {
            this.next.setBounds(n5, this.border, n4, n2);
            ++this.buttons;
        }
        this.refresh();
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        if (this.buffer == null || !dimension.equals(this.lastDimension)) {
            this.buffer = this.createImage(dimension.width, dimension.height);
            this.lastDimension = dimension;
            super.invalidate();
        }
        Graphics graphics2 = this.buffer.getGraphics();
        graphics2.setClip(0, 0, dimension.width, dimension.height);
        super.paint(graphics2);
        JCBorder.draw(graphics2, 1, this.border, 0, 0, this.getSize().width, this.getSize().height, Color.black, Color.black);
        FontMetrics fontMetrics = graphics2.getFontMetrics();
        int n2 = this.first.getPreferredSize().width;
        int n3 = this.getSize().height - this.border * 2;
        int n4 = (n3 - fontMetrics.getAscent()) / 2;
        int n5 = this.getSize().width - this.border * 2 - n2 * this.buttons;
        graphics2.setColor(this.statusBackground);
        graphics2.fillRect(this.border + n2 * this.leftButtons, this.border, n5, n3);
        if (this.statusVisible) {
            String string;
            int n6;
            string = fontMetrics.stringWidth(this.rowLabel) > n5 ? ((n6 = (string = JCWordWrap.wrapText(this.rowLabel, fontMetrics, n5, "\n", true)).indexOf(10)) > 0 ? string.substring(0, n6 - 1) : "") : this.rowLabel;
            n6 = this.border + n2 * this.leftButtons + (n5 - fontMetrics.stringWidth(string)) / 2;
            graphics2.setColor(this.statusForeground);
            graphics2.drawString(string, n6, n3 - n4);
        }
        graphics.drawImage(this.buffer, 0, 0, this);
    }

    protected void reset() {
        if (this.dataBinding == null) {
            return;
        }
        int n2 = this.dataBinding.getCurrentRowIndex();
        boolean bl = this.dataBinding.isEnabled();
        boolean bl2 = false;
        if (this.dataBinding.getBinding() != null) {
            try {
                bl2 = this.dataBinding.getBinding().getCurrentDataTableModel(this.dataBinding) != null;
            }
            catch (DataModelException dataModelException) {
                // empty catch block
            }
        }
        boolean bl3 = bl && bl2;
        int n3 = bl3 ? this.dataBinding.getNumRows() : 0;
        boolean bl4 = bl3 && n3 > 0 && n2 >= 0;
        this.first.setEnabled(bl4 && n2 > 0);
        this.previous.setEnabled(bl4 && n2 > 0);
        this.next.setEnabled(bl4 && n2 < n3 - 1);
        this.last.setEnabled(bl4 && n2 < n3 - 1);
        this.insert.setEnabled(bl3);
        this.delete.setEnabled(bl4);
        this.menu.setEnabled(bl);
        this.popupMenu.enableMenuItem("Insert Record", bl3);
        this.popupMenu.enableMenuItem("Delete Record", bl4);
        this.popupMenu.enableMenuItem("Cancel Record", bl4);
        this.popupMenu.enableMenuItem("Cancel All", bl);
        this.popupMenu.enableMenuItem("Requery Record and Details", bl4);
        this.popupMenu.enableMenuItem("Requery All", bl);
        this.popupMenu.enableMenuItem("Save Record", bl4);
        this.popupMenu.enableMenuItem("Save All", bl);
        this.popupMenu.enableMenuItem("Go To...", bl3);
        if (!bl) {
            this.rowLabel = LocaleBundle.string("Not bound");
        } else {
            if (bl4) {
                Object[] objectArray = new Object[]{new Integer(n2 + 1), new Integer(n3)};
                this.rowLabel = MessageFormat.format(this.dataBinding.isRowModified(n2) ? LocaleBundle.string("{0,number,integer}* of {1,number,integer}") : LocaleBundle.string("{0,number,integer} of {1,number,integer}"), objectArray);
            } else {
                this.rowLabel = n3 > 0 ? n3 + LocaleBundle.string(" records") : (bl3 ? LocaleBundle.string("no records") : LocaleBundle.string("not available"));
            }
            this.rowLabel = this.dataBinding.getDescription() + ": " + this.rowLabel;
        }
    }

    public void refresh() {
        this.reset();
        this.repaint();
    }

    public final void setLayout(LayoutManager layoutManager) {
        super.setLayout(null);
    }

    protected void setBtnBackground(Color color) {
        this.first.setBackground(this.buttonBackground);
        this.previous.setBackground(this.buttonBackground);
        this.insert.setBackground(this.buttonBackground);
        this.delete.setBackground(this.buttonBackground);
        this.next.setBackground(this.buttonBackground);
        this.last.setBackground(this.buttonBackground);
        this.menu.setBackground(this.buttonBackground);
    }

    protected void setBtnForeground(Color color) {
        this.first.setForeground(this.buttonForeground);
        this.previous.setForeground(this.buttonForeground);
        this.insert.setForeground(this.buttonForeground);
        this.delete.setForeground(this.buttonForeground);
        this.next.setForeground(this.buttonForeground);
        this.last.setForeground(this.buttonForeground);
        this.menu.setForeground(this.buttonForeground);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getSource() instanceof NavigatorButton) {
            try {
                if (this.dataBinding.getBinding() == null || this.dataBinding.getBinding().getCurrentDataTableModel(this.dataBinding) == null) {
                    return;
                }
            }
            catch (DataModelException dataModelException) {
                return;
            }
            int n2 = this.dataBinding.getCurrentRowIndex();
            NavigatorButton navigatorButton = (NavigatorButton)actionEvent.getSource();
            if (navigatorButton.equals(this.first)) {
                n2 = 0;
            } else if (navigatorButton.equals(this.previous)) {
                --n2;
            } else if (navigatorButton.equals(this.next)) {
                ++n2;
            } else if (navigatorButton.equals(this.last)) {
                n2 = this.dataBinding.getNumRows() - 1;
            } else {
                if (navigatorButton.equals(this.menu)) {
                    Point point = navigatorButton.getLocation();
                    point.y += navigatorButton.getHeight();
                    this.showPopupMenu(point.x, point.y);
                    return;
                }
                if (navigatorButton.equals(this.delete)) {
                    this.delete();
                    return;
                }
                if (navigatorButton.equals(this.insert)) {
                    this.insert();
                    return;
                }
            }
            this.dataBinding.moveToRowIndex(n2);
        } else {
            String string = actionEvent.getActionCommand();
            if (string.equals(NavigatorPopupMenu.commands[0])) {
                this.insert();
            } else if (string.equals(NavigatorPopupMenu.commands[1])) {
                this.delete();
            } else if (string.equals(NavigatorPopupMenu.commands[2])) {
                this.cancelCurrent();
            } else if (string.equals(NavigatorPopupMenu.commands[3])) {
                this.cancelAll();
            } else if (string.equals(NavigatorPopupMenu.commands[4])) {
                this.requeryCurrent();
            } else if (string.equals(NavigatorPopupMenu.commands[5])) {
                this.requeryAll();
            } else if (string.equals(NavigatorPopupMenu.commands[6])) {
                this.commitCurrent();
            } else if (string.equals(NavigatorPopupMenu.commands[7])) {
                this.commitAll();
            } else if (string.equals(NavigatorPopupMenu.commands[8])) {
                this.goToRow();
            }
        }
    }

    protected boolean showPopupMenu(int n2, int n3) {
        this.popupMenu.show(this, n2, n3);
        return true;
    }

    protected void insert() {
        this.dataBinding.addRow();
    }

    protected void delete() {
        this.dataBinding.deleteRow();
    }

    protected void cancelCurrent() {
        this.dataBinding.cancelRow();
    }

    protected void cancelAll() {
        this.dataBinding.cancelAll();
    }

    protected void requeryCurrent() {
        this.dataBinding.requeryRowAndDetails();
    }

    protected void requeryAll() {
        this.dataBinding.requeryAll();
    }

    protected void commitCurrent() {
        this.dataBinding.commitRow();
    }

    protected void commitAll() {
        this.dataBinding.commitAll();
    }

    protected void goToRow() {
        int n2 = this.dataBinding.getCurrentRowIndex();
        GotoRowDialog gotoRowDialog = new GotoRowDialog((Frame)new JFrame(), n2 + 1);
        gotoRowDialog.open();
        int n3 = gotoRowDialog.getRow() - 1;
        int n4 = this.dataBinding.getNumRows();
        this.dataBinding.moveToRowIndex(n3 < 0 ? 0 : (n3 >= n4 ? n4 - 1 : n3));
    }

    class DSNavigatorDataBinding
    extends NavigatorDataBinding {
        protected DSNavigatorDataBinding() {
            super(DSdbJNavigator.this);
        }

        protected void currentRowChanged(int n2) {
            DSdbJNavigator.this.setCurrentRow();
        }

        protected boolean beforeCurrentRowChange() {
            return true;
        }

        protected void tableChanged() {
            DSdbJNavigator.this.refresh();
        }

        protected void rowDataChanged(int n2) {
        }

        protected void cellDataChanged(int n2, String string) {
        }

        protected void rowInserted() {
            DSdbJNavigator.this.setCurrentRow();
        }

        protected void rowDeleted() {
            DSdbJNavigator.this.setCurrentRow();
        }

        protected boolean moveToRowIndex(int n2) {
            return super.moveToRowIndex(n2);
        }

        protected String getDescription() {
            return this.binding.getMetaDataModel().getDescription();
        }
    }
}

