/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource.swing;

import com.klg.jclass.datasource.BindingModel;
import com.klg.jclass.datasource.DataModel;
import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.datasource.DataModelListener;
import com.klg.jclass.datasource.MetaDataModel;
import com.klg.jclass.datasource.util.ExceptionManager;
import java.awt.Dimension;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.util.Vector;
import javax.swing.JList;
import javax.swing.ListModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class DSdbJList
extends JList
implements ListSelectionListener {
    protected ColumnDataBinding columnBinding;
    protected boolean shouldMove = true;
    protected static final String nullDatabindingText = "DSdbJList";
    protected int textMargin = 2;

    public DSdbJList() {
        this.setSelectionMode(0);
        this.columnBinding = new ColumnDataBinding();
        this.addListSelectionListener(this);
    }

    public DSdbJList(DataModel dataModel, MetaDataModel metaDataModel, String string) {
        this();
        this.columnBinding.setDataBinding(dataModel, metaDataModel, string);
    }

    public DSdbJList(BindingModel bindingModel, String string) {
        this();
        this.setDataBinding(bindingModel, string);
    }

    public void setSelectionMode(int n2) {
        super.setSelectionMode(0);
    }

    public void setDataBinding(DataModel dataModel, MetaDataModel metaDataModel, String string) {
        this.columnBinding.setDataBinding(dataModel, metaDataModel, string);
    }

    public void setDataBinding(DataModel dataModel, String string) {
        this.columnBinding.setDataBinding(dataModel, string);
    }

    public void setDataBinding(BindingModel bindingModel, String string) {
        this.columnBinding.setDataBinding(bindingModel, string);
    }

    public void setDataBinding(String string) {
        this.columnBinding.setDataBinding(string);
    }

    public String getDataBinding() {
        return this.columnBinding.getDataBinding();
    }

    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        if (listSelectionEvent.getValueIsAdjusting()) {
            return;
        }
        if (!this.columnBinding.checkBindingSelected()) {
            return;
        }
        if (this.columnBinding.isDataAvailable() && this.shouldMove) {
            this.columnBinding.moveToRow(this.getSelectedIndex());
        }
        this.shouldMove = true;
    }

    public void paint(Graphics graphics) {
        if (this.columnBinding.isBindingSelected()) {
            super.paint(graphics);
        } else {
            FontMetrics fontMetrics = graphics.getFontMetrics();
            Rectangle rectangle = graphics.getClipBounds();
            Dimension dimension = this.getPreferredSize();
            graphics.setColor(this.getBackground());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(this.getForeground());
            graphics.drawString(nullDatabindingText, this.textMargin + (rectangle.width - dimension.width) / 2, this.textMargin + fontMetrics.getLeading() + fontMetrics.getAscent() + (rectangle.height - dimension.height) / 2);
        }
    }

    public int getFixedCellWidth() {
        if (!this.columnBinding.isBindingSelected()) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            return fontMetrics.stringWidth(nullDatabindingText) + this.textMargin * 2;
        }
        return super.getFixedCellWidth();
    }

    public int getFixedCellHeight() {
        if (!this.columnBinding.isBindingSelected()) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            return fontMetrics.getHeight() + this.textMargin * 2;
        }
        return super.getFixedCellHeight();
    }

    public int getVisibleRowCount() {
        if (!this.columnBinding.isBindingSelected()) {
            return 1;
        }
        return super.getVisibleRowCount();
    }

    public Dimension getPreferredSize() {
        Dimension dimension = super.getPreferredSize();
        if (!this.columnBinding.isBindingSelected()) {
            FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
            dimension = new Dimension(fontMetrics.stringWidth(nullDatabindingText) + this.textMargin * 2, fontMetrics.getHeight() + this.textMargin * 2);
        }
        return dimension;
    }

    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    class ColumnDataBinding
    extends com.klg.jclass.datasource.util.ColumnDataBinding {
        public ColumnDataBinding() {
            super(DSdbJList.this);
            this.checkBindingSelected();
        }

        protected void moveToRow(int n2) {
            this.moveToRowIndex(n2);
        }

        protected void tableChanged() {
            this.readCurrentData();
        }

        protected void rowDataChanged(int n2) {
            this.cellDataChanged(n2, this.column_name);
        }

        protected void cellDataChanged(int n2, String string) {
            if (!string.equals(this.column_name)) {
                return;
            }
            this.readCurrentData();
        }

        protected void currentRowChanged(int n2) {
            if (DSdbJList.this.getSelectedIndex() != n2) {
                DSdbJList.this.shouldMove = false;
                DSdbJList.this.setSelectedIndex(n2);
            }
        }

        protected boolean beforeCurrentRowChange() {
            return true;
        }

        protected void rowInserted() {
            this.readCurrentData();
        }

        protected void rowDeleted() {
            this.readCurrentData();
        }

        protected void readCurrentData() {
            if (!this.checkBindingSelected()) {
                return;
            }
            try {
                ListModel listModel = DSdbJList.this.getModel();
                Vector<String> vector = new Vector<String>();
                boolean bl = false;
                int n2 = 0;
                while (n2 < this.getNumRows()) {
                    Object object = this.binding.getCell((DataModelListener)DSdbJList.this.columnBinding, n2, this.column_name);
                    if (n2 >= listModel.getSize()) {
                        bl = true;
                    } else {
                        Object e2 = listModel.getElementAt(n2);
                        if (object == null) {
                            object = "";
                        }
                        if (!object.toString().equals(e2)) {
                            bl = true;
                        }
                    }
                    if (bl) {
                        vector.addElement(object == null ? " " : object.toString());
                    }
                    ++n2;
                }
                if (bl) {
                    DSdbJList.this.setListData(vector);
                }
            }
            catch (DataModelException dataModelException) {
                ExceptionManager.getHandler().processException(this.getComponent(), dataModelException);
            }
        }

        protected boolean checkBindingSelected() {
            if (!this.isBindingSelected()) {
                Vector<String> vector = new Vector<String>();
                vector.addElement(DSdbJList.nullDatabindingText);
                DSdbJList.this.setListData(vector);
                return false;
            }
            return true;
        }

        protected void setDataAvailable(boolean bl) {
            DSdbJList.this.setEnabled(bl);
        }

        protected boolean isBindingSelected() {
            String string = this.getDataBinding();
            return this.isDataAvailable() && string != null && string.length() > 0;
        }
    }
}

