/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource.jdbc;

import com.klg.jclass.datasource.BaseDataTable;
import com.klg.jclass.datasource.ColumnModel;
import com.klg.jclass.datasource.DataModelEvent;
import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.datasource.DataModelListener;
import com.klg.jclass.datasource.DataTableModel;
import com.klg.jclass.datasource.LocaleBundle;
import com.klg.jclass.datasource.jdbc.MetaData;
import com.klg.jclass.datasource.jdbc.PersistorModel;
import com.klg.jclass.datasource.util.ColumnMap;
import com.klg.jclass.datasource.util.SqlStatementTable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class DataTable
extends BaseDataTable {
    static final long serialVersionUID = 6356453874717375331L;
    protected static final int NO_ROWS_CHANGED = 0;
    protected static final int ONE_ROW_CHANGED = 1;
    protected int columns = 0;
    protected transient PreparedStatement statement = null;
    protected MetaData metaData;

    DataTable(int n2, MetaData metaData) {
        super(metaData);
        this.metaData = metaData;
        this.columns = n2;
    }

    DataTable(int n2, MetaData metaData, long l2) {
        super(metaData, l2);
        this.metaData = metaData;
        this.columns = n2;
    }

    public Object getCell(long l2, String string) throws DataModelException {
        int n2 = this.metaData.getColumnIndex(string);
        Object[] objectArray = (Object[])this.getRowFromCache(l2);
        if (objectArray != null) {
            return objectArray[n2];
        }
        return null;
    }

    public DataTableModel materializeTable(DataModelListener dataModelListener, long l2, TreeNode treeNode) throws DataModelException {
        MetaData metaData = (MetaData)treeNode;
        if (!metaData.isOpen()) {
            String string = LocaleBundle.string("MetaData is not open.  Call MetaData.open() before calling: ");
            string = string + this.metaData.getDescription() + ".createTable() or getTable()";
            throw new DataModelException(107, new Exception(string));
        }
        DataTable dataTable = null;
        try {
            Enumeration enumeration = metaData.join_columns.elements();
            int n2 = 1;
            while (enumeration.hasMoreElements()) {
                ColumnMap columnMap = (ColumnMap)enumeration.nextElement();
                ColumnModel columnModel = this.getMetaData().getColumnObject(columnMap.getParentColumn());
                int n3 = columnModel == null ? 12 : columnModel.getColumnType();
                metaData.setParameter(n2++, this.getResultData(l2, columnMap.getParentColumn()), n3);
            }
            dataTable = metaData.executeQuery(l2);
        }
        catch (Exception exception) {
            throw new DataModelException(l2, "", this, 107, exception);
        }
        return dataTable;
    }

    public Object createNewRow() {
        Object[] objectArray = new Object[this.columns];
        int n2 = 0;
        while (n2 < this.columns) {
            objectArray[n2] = null;
            ++n2;
        }
        return objectArray;
    }

    public void saveRow(long l2) throws DataModelException {
        PersistorModel persistorModel = this.metaData.getPersistor();
        if (persistorModel != null) {
            persistorModel.saveRow(l2, this.metaData, this);
        }
    }

    public DataTableModel requeryLevel() throws DataModelException {
        this.store.clear();
        this.cursor = 0;
        if (this.parentRow < 0L) {
            return this.metaData.executeQuery();
        }
        Exception exception = new Exception(LocaleBundle.string("requeryLevel() can only be called on root"));
        throw new DataModelException(107, exception);
    }

    public void restoreRow(long l2) {
        Object[] objectArray = (Object[])this.getOriginalRow(l2);
        int n2 = 0;
        int n3 = 0;
        while (n3 < objectArray.length) {
            try {
                this.setValueAt(l2, this.metaData.getColumnIdentifier(n2++), objectArray[n3]);
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n3;
        }
    }

    public void refreshRow(long l2) throws DataModelException {
        Object[] objectArray;
        boolean bl = false;
        String string = this.metaData.getParser().getClause(0);
        string = string + " " + this.metaData.getParser().getClause(1);
        string = string + " " + this.metaData.getParser().getClause(2);
        string = this.metaData.getParser().getClause(2).equals("") ? string + " WHERE " : string + " AND ";
        String string2 = (String)this.metaData.getTables().elementAt(this.metaData.getDriverTableIndex());
        Vector vector = this.metaData.getPrimaryKeys(string2);
        SqlStatementTable sqlStatementTable = this.metaData.getParser().getSqlStatementTable(string2);
        if (sqlStatementTable == null) {
            Exception exception = new Exception(LocaleBundle.string("Cannot requery row for table. Is case correct? Table: ") + string2);
            throw new DataModelException(l2, "", this, 107, exception);
        }
        if (vector.size() == 0) {
            String string3 = "\n" + LocaleBundle.string("Cannot requery this row. The primary key for the table is unknown. Table: ");
            string3 = string3 + "\"" + string2 + "\"";
            Exception exception = new Exception(string3);
            throw new DataModelException(109, exception);
        }
        Enumeration enumeration = vector.elements();
        while (enumeration.hasMoreElements()) {
            objectArray = (Object[])enumeration.nextElement();
            objectArray = objectArray.substring(objectArray.lastIndexOf(".") + 1, objectArray.length());
            string = string + (bl ? " AND " : " ");
            bl = true;
            String string4 = sqlStatementTable.getAlias() != null ? sqlStatementTable.getAlias() : sqlStatementTable.getTableName();
            string = string + string4 + "." + (String)objectArray + " = ? ";
        }
        string = string + " " + this.metaData.getParser().getClause(3);
        objectArray = this.getRowFromServer(string2, string, l2);
        int n2 = this.store.getIndex(l2);
        this.store.removeRow(l2);
        this.store.addRow(l2, objectArray, n2);
    }

    public void requeryTable(DataModelListener dataModelListener) throws DataModelException {
        DataTable dataTable = (DataTable)this.getParent();
        if (dataTable == null) {
            this.metaData.getDataModel().requeryAll(dataModelListener);
            return;
        }
        if (!this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, this.getParentBookmark(), "", 3))) {
            return;
        }
        this.removeAllChildren();
        this.metaData.getDataModel().clearCurrentPath(this.metaData);
        try {
            DataTable dataTable2 = (DataTable)dataTable.materializeTable(dataModelListener, this.getParentBookmark(), this.getMetaData());
            this.store = dataTable2.store;
            this.cursor = 0;
        }
        catch (Exception exception) {
            throw new DataModelException(110, exception);
        }
        this.fireDataModelEvent(new DataModelEvent(this.metaData.getDataModel(), dataModelListener, this, this.getParentBookmark(), "", 110));
    }

    protected Object[] getRowFromServer(String string, String string2, long l2) throws DataModelException {
        Object[] objectArray;
        try {
            Object object;
            Object object2;
            if (this.statement == null) {
                this.statement = this.metaData.getDataTableConnection().getConnection().prepareStatement(string2);
            } else {
                this.statement.clearParameters();
            }
            int n2 = 1;
            Enumeration enumeration = this.getCombinedKeys(string).elements();
            while (enumeration.hasMoreElements()) {
                object2 = (String)enumeration.nextElement();
                object = this.metaData.getParser().getSqlStatementColumn(string, (String)object2);
                Object object3 = null;
                if (object != null) {
                    object3 = this.metaData.getParser().getSqlStatementColumn(string, (String)object2).getAlias();
                }
                object2 = object3 != null ? object3 : object2;
                ColumnModel columnModel = this.getMetaData().getColumnObject((String)object2);
                int n3 = columnModel == null ? 12 : columnModel.getColumnType();
                this.setParameter(n2++, this.getResultData(l2, (String)object2), n3);
            }
            object2 = this.statement.executeQuery();
            if (!object2.next()) {
                object2.close();
                object = LocaleBundle.string("Requery row failed. Query: ") + string2;
                throw new DataModelException(107, new Exception((String)object));
            }
            objectArray = this.metaData.createRowFromResultSet((ResultSet)object2);
            object2.close();
        }
        catch (SQLException sQLException) {
            throw new DataModelException(107, sQLException);
        }
        return objectArray;
    }

    protected void setParameter(int n2, Object object, int n3) throws DataModelException {
        try {
            if (object == null) {
                this.statement.setNull(n2, n3);
            } else {
                this.statement.setObject(n2, object);
            }
        }
        catch (SQLException sQLException) {
            throw new DataModelException(107, sQLException);
        }
    }

    Vector getCombinedKeys(String string) throws DataModelException {
        String string2;
        Object object;
        Vector<String> vector = new Vector<String>();
        Enumeration enumeration = this.metaData.join_columns.elements();
        while (enumeration.hasMoreElements()) {
            object = (ColumnMap)enumeration.nextElement();
            string2 = ((ColumnMap)object).getChildColumn();
            string2 = string2.substring(string2.lastIndexOf(".") + 1, string2.length());
            vector.addElement(string2);
        }
        object = this.metaData.getPrimaryKeys(string).elements();
        while (object.hasMoreElements()) {
            string2 = (String)object.nextElement();
            string2 = string2.substring(string2.lastIndexOf(".") + 1, string2.length());
            vector.addElement(string2);
        }
        return vector;
    }

    protected void finalize() {
        if (this.statement != null) {
            try {
                this.statement.close();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
    }
}

