/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource.customizer;

import com.klg.jclass.datasource.LocaleBundle;
import com.klg.jclass.datasource.util.SqlStatement;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.util.Observable;
import java.util.Observer;
import javax.swing.JCheckBox;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.border.TitledBorder;

class SqlStatementView
extends JPanel
implements Observer,
ItemListener {
    JTextArea statementBox;
    JCheckBox expertMode;
    SqlStatement sqlStatement;

    SqlStatementView(SqlStatement sqlStatement) {
        this.setBorder(new TitledBorder(LocaleBundle.string("SQL Statement")));
        this.statementBox = new JTextArea("", 2, 40);
        this.setLayout(new BorderLayout());
        this.add((Component)new JScrollPane(this.statementBox), "Center");
        this.statementBox.setEditable(true);
        this.expertMode = new JCheckBox(LocaleBundle.string("Expert Mode"), false);
        JPanel jPanel = new JPanel();
        jPanel.setLayout(new BorderLayout());
        this.expertMode.addItemListener(this);
        this.add((Component)jPanel, "South");
        jPanel.add((Component)this.expertMode, "West");
        this.setSqlStatement(sqlStatement);
    }

    void setSqlStatement(SqlStatement sqlStatement) {
        this.sqlStatement = sqlStatement;
        this.sqlStatement.addObserver(this);
        this.refresh();
    }

    void clear() {
        this.sqlStatement.clear();
        this.sqlStatement.notifyObservers(this);
    }

    void refresh() {
        this.statementBox.setText(this.sqlStatement.getText());
        this.expertMode.setSelected(this.sqlStatement.isExpertMode());
    }

    public void update(Observable observable, Object object) {
        if (object == null || !this.equals(object)) {
            this.refresh();
        }
    }

    String getText() {
        return this.statementBox.getText();
    }

    void setText(String string) {
        if (this.sqlStatement.getText() == null || !this.sqlStatement.getText().equals(string)) {
            this.sqlStatement.setText(string);
            this.sqlStatement.notifyObservers(this);
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.sqlStatement.setExpertMode(this.expertMode.isSelected());
        this.sqlStatement.notifyObservers(this);
    }
}

