/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource.customizer;

import com.klg.jclass.datasource.ErrorDialog;
import com.klg.jclass.datasource.LocaleBundle;
import com.klg.jclass.datasource.beans.SerializedProperties;
import com.klg.jclass.datasource.customizer.SerializationPageParent;
import com.klg.jclass.util.JCEnvironment;
import com.klg.jclass.util.swing.JCAlignLayout;
import com.klg.jclass.util.swing.JCFileFilter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileNotFoundException;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EtchedBorder;

public class SerializationPage
extends JPanel
implements ActionListener {
    JButton btnLoad;
    JButton btnSave;
    JTextField resourceName;
    SerializedProperties comp;
    SerializationPageParent editor;
    private boolean initializing = false;
    private static final boolean TRACE = false;

    public SerializationPage(SerializationPageParent serializationPageParent) {
        this.editor = serializationPageParent;
        this.init();
    }

    public void init() {
        this.setLayout(new BorderLayout());
        this.resourceName = new JTextField("", 40);
        this.btnLoad = new JButton(LocaleBundle.string("Open3"));
        this.btnSave = new JButton(LocaleBundle.string("Save As..."));
        JPanel jPanel = new JPanel();
        JLabel jLabel = new JLabel(LocaleBundle.string("Resource Name"));
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        JPanel jPanel4 = new JPanel();
        jPanel4.setBorder(new EtchedBorder());
        this.resourceName.setEditable(false);
        jPanel4.setLayout(new GridLayout(2, 1));
        jPanel3.setLayout(new JCAlignLayout());
        jPanel3.add(jLabel);
        jPanel3.add(this.resourceName);
        jPanel.add(this.btnLoad);
        jPanel.add(this.btnSave);
        jPanel4.add(jPanel3);
        jPanel4.add(jPanel);
        jPanel2.setLayout(new GridLayout(1, 1));
        jPanel2.add(jPanel4);
        this.add((Component)jPanel2, "North");
        this.btnLoad.addActionListener(this);
        this.btnSave.addActionListener(this);
    }

    public void setSerializedProperties(SerializedProperties serializedProperties) {
        this.comp = serializedProperties;
        this.initializing = true;
        this.resourceName.setText(serializedProperties.getResourceName());
        this.initializing = false;
    }

    public SerializedProperties getSerializedProperties() {
        return this.comp;
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.initializing) {
            return;
        }
        if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton.equals(this.btnLoad)) {
                this.loadFromFile();
            } else if (jButton.equals(this.btnSave)) {
                this.saveToFile();
                if (JCEnvironment.isDesignTime()) {
                    this.reloadFromFile();
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void reloadFromFile() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            try {
                this.editor.loadFromFile(this.getSerializedProperties().getSerializationFile());
            }
            catch (Exception exception) {
                Object var3_2 = null;
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            Object var3_1 = null;
        }
        catch (Throwable throwable) {
            Object var3_3 = null;
            this.setCursor(Cursor.getPredefinedCursor(0));
            throw throwable;
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void loadFromFile() {
        int n2;
        JFileChooser jFileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileSelectionMode(2);
        JCFileFilter jCFileFilter = new JCFileFilter(".ser", LocaleBundle.string("Serialization Files"));
        jFileChooser.addChoosableFileFilter(jCFileFilter);
        jFileChooser.setFileFilter(jCFileFilter);
        String string = this.getSerializedProperties().getDefaultSerializationFileToOpen();
        if (string != null) {
            File file = new File(string);
            jFileChooser.setSelectedFile(file);
            jFileChooser.ensureFileIsVisible(file);
        }
        if ((n2 = jFileChooser.showOpenDialog(this)) != 0) return;
        String string2 = jFileChooser.getSelectedFile().getAbsolutePath();
        if (string2 != null && string2.length() > 0 && !string2.toLowerCase().endsWith(".ser")) {
            string2 = string2 + ".ser";
        }
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            try {
                this.editor.loadFromFile(string2);
            }
            catch (Exception exception) {
                Object var8_8 = null;
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            Object var8_7 = null;
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            this.setCursor(Cursor.getPredefinedCursor(0));
            throw throwable;
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void saveToFile() {
        Object var9_9;
        int n3;
        String string;
        JFileChooser jFileChooser = new JFileChooser(new File(System.getProperty("user.dir")));
        jFileChooser.setMultiSelectionEnabled(false);
        jFileChooser.setFileSelectionMode(2);
        JCFileFilter jCFileFilter = new JCFileFilter(".ser", LocaleBundle.string("Serialization Files"));
        jFileChooser.addChoosableFileFilter(jCFileFilter);
        jFileChooser.setFileFilter(jCFileFilter);
        jFileChooser.setSelectedFile(new File(this.getSerializedProperties().getSerializationFile()));
        boolean bl = true;
        do {
            if (!bl) {
                return;
            }
            int n2 = jFileChooser.showSaveDialog(this);
            if (n2 != 0) return;
        } while (new File(string = jFileChooser.getSelectedFile().getAbsolutePath()).exists() && (n3 = JOptionPane.showConfirmDialog(jFileChooser, string + LocaleBundle.string(" already exists.\nDo you want to replace it?"), LocaleBundle.string("Save As..."), 0)) != 0);
        if (string != null && string.length() > 0 && !string.toLowerCase().endsWith(".ser")) {
            string = string + ".ser";
        }
        this.getSerializedProperties().setSerializationFile(string);
        File file = new File(string);
        this.getSerializedProperties().setResourceName(file.getName());
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            try {
                SerializedProperties.toFile(this.getSerializedProperties(), string);
            }
            catch (Exception exception) {
                if (exception instanceof FileNotFoundException) {
                    ErrorDialog.showError(this, exception + System.getProperty("line.separator") + LocaleBundle.string("Failed to save because file not found"));
                } else {
                    ErrorDialog.showError(this, exception + System.getProperty("line.separator") + LocaleBundle.string("Failed to serialize"));
                }
                var9_9 = null;
                this.setCursor(Cursor.getPredefinedCursor(0));
                return;
            }
            var9_9 = null;
        }
        catch (Throwable throwable) {
            var9_9 = null;
            this.setCursor(Cursor.getPredefinedCursor(0));
            throw throwable;
        }
        this.setCursor(Cursor.getPredefinedCursor(0));
    }

    public String getResourceName() {
        return this.resourceName.getText();
    }

    public Insets getInsets() {
        return new Insets(5, 5, 5, 5);
    }

    public void removeNotify() {
        try {
            this.editor.saveToFile();
        }
        catch (Exception exception) {
            ErrorDialog.showError(this, exception + System.getProperty("line.separator") + LocaleBundle.string("Failed to serialize"));
        }
        super.removeNotify();
    }
}

