/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource.customizer;

import com.klg.jclass.datasource.ErrorDialog;
import com.klg.jclass.datasource.LocaleBundle;
import com.klg.jclass.datasource.TreeData;
import com.klg.jclass.datasource.beans.DataSourceBeanInstance;
import com.klg.jclass.datasource.beans.JCDataEvent;
import com.klg.jclass.datasource.beans.NodeProperties;
import com.klg.jclass.datasource.customizer.ConnectionPanel;
import com.klg.jclass.datasource.customizer.DataModelPage;
import com.klg.jclass.datasource.customizer.DriverTablePage;
import com.klg.jclass.datasource.customizer.JoinDialog;
import com.klg.jclass.datasource.customizer.SqlBuilderPanel;
import com.klg.jclass.datasource.customizer.SqlStatementView;
import com.klg.jclass.datasource.jdbc.DataTableConnection;
import com.klg.jclass.datasource.jdbc.MetaData;
import com.klg.jclass.datasource.util.SqlParser;
import com.klg.jclass.datasource.util.SqlStatement;
import com.klg.jclass.datasource.util.SqlStatementTable;
import com.klg.jclass.util.swing.JCAlignLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusAdapter;
import java.awt.event.FocusEvent;
import java.sql.Connection;
import java.util.Enumeration;
import java.util.Observable;
import java.util.Observer;
import java.util.Vector;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JTextField;

public class JDBCPage
extends DataModelPage
implements Observer,
ActionListener {
    SqlBuilderPanel sp;
    ConnectionPanel cp;
    JTabbedPane tab;
    Component btnSp;
    Component btnDriverTable;
    JButton btnModify;
    JButton btnRestore;
    JButton btnClear;
    JButton btnAddTable;
    JButton btnAddColumn;
    JButton btnAddJoin;
    JButton btnJoinToParent;
    JTextField designTimeMaxRows;
    SqlStatementView view = null;
    DriverTablePage driverTablePage = null;

    public JDBCPage() {
        super(LocaleBundle.string("JDBC"));
        this.setLayout(new GridLayout(1, 1));
        this.sp = new SqlBuilderPanel(null);
        this.view = new SqlStatementView(this.sp.sqlStatement);
        this.view.sqlStatement.addObserver(this);
        JPanel jPanel = new JPanel();
        JPanel jPanel2 = new JPanel();
        JPanel jPanel3 = new JPanel();
        this.btnModify = new JButton(LocaleBundle.string("Set"));
        this.btnRestore = new JButton(LocaleBundle.string("Restore"));
        this.btnClear = new JButton(LocaleBundle.string("Clear"));
        this.btnJoinToParent = new JButton(LocaleBundle.string("Join To Parent"));
        this.btnAddTable = new JButton(LocaleBundle.string("Add Table..."));
        this.btnAddColumn = new JButton(LocaleBundle.string("Add Selected Columns"));
        this.btnAddJoin = new JButton(LocaleBundle.string("Add Join..."));
        JPanel jPanel4 = new JPanel();
        JPanel jPanel5 = new JPanel();
        JLabel jLabel = new JLabel(LocaleBundle.string("Design-time Maximum Number of Rows"));
        this.designTimeMaxRows = new JTextField("", 5);
        JDBCPageScrollPane jDBCPageScrollPane = new JDBCPageScrollPane(this.sp);
        JSplitPane jSplitPane = new JSplitPane(0);
        jSplitPane.setOneTouchExpandable(true);
        jSplitPane.add(jDBCPageScrollPane);
        jSplitPane.add(this.view);
        jPanel.setLayout(new GridLayout(2, 1));
        jPanel2.setLayout(new GridBagLayout());
        jPanel3.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.fill = 0;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        jPanel2.add((Component)this.btnAddTable, gridBagConstraints);
        jPanel2.add((Component)this.btnAddColumn, gridBagConstraints);
        jPanel2.add((Component)this.btnAddJoin, gridBagConstraints);
        gridBagConstraints.weightx = 5.0;
        jPanel2.add((Component)this.btnJoinToParent, gridBagConstraints);
        gridBagConstraints.gridy = 2;
        gridBagConstraints.weightx = 0.0;
        jPanel3.add((Component)this.btnModify, gridBagConstraints);
        gridBagConstraints.weightx = 5.0;
        jPanel3.add((Component)this.btnClear, gridBagConstraints);
        jPanel.add(jPanel2);
        jPanel.add(jPanel3);
        jPanel4.setLayout(new BorderLayout(5, 5));
        jPanel4.add((Component)jSplitPane, "Center");
        jPanel4.add((Component)jPanel, "South");
        this.btnModify.addActionListener(this);
        this.btnRestore.addActionListener(this);
        this.btnClear.addActionListener(this);
        this.btnAddTable.addActionListener(this);
        this.btnAddColumn.addActionListener(this);
        this.btnAddJoin.addActionListener(this);
        this.btnJoinToParent.addActionListener(this);
        this.cp = new ConnectionPanel(this);
        this.driverTablePage = new DriverTablePage();
        this.tab = new JTabbedPane();
        this.tab.addTab(this.cp.getPageName(), this.cp);
        this.tab.addTab(this.sp.getPageName(), jPanel4);
        int n2 = this.tab.indexOfComponent(jPanel4);
        this.btnSp = this.tab.getComponentAt(n2);
        this.tab.addTab(this.driverTablePage.getPageName(), this.driverTablePage);
        n2 = this.tab.indexOfComponent(this.driverTablePage);
        this.btnDriverTable = this.tab.getComponentAt(n2);
        this.tab.setEnabledAt(this.tab.indexOfComponent(this.btnSp), false);
        this.tab.setEnabledAt(this.tab.indexOfComponent(this.btnDriverTable), false);
        jPanel5.setLayout(new JCAlignLayout());
        jPanel5.add(jLabel);
        jPanel5.add(this.designTimeMaxRows);
        this.designTimeMaxRows.addActionListener(this);
        this.designTimeMaxRows.addFocusListener(new FocusAdapter(){

            public void focusLost(FocusEvent focusEvent) {
                if (JDBCPage.this.isInitializing()) {
                    return;
                }
                JDBCPage.this.setDesignTimeMaxRows();
            }
        });
        this.setLayout(new BorderLayout());
        this.add((Component)jPanel5, "South");
        this.add((Component)this.tab, "Center");
    }

    public void setUseInHierarchy(boolean bl) {
        this.cp.setUseInHierarchy(bl);
    }

    public void setNodeProperties(NodeProperties nodeProperties) {
        if (nodeProperties.getDataSourceType() != 1) {
            return;
        }
        this.cp.useParentConnection.setEnabled(nodeProperties.getParentNodeProperties() != null);
        this.updateTabs();
        this.cp.init(nodeProperties);
        this.sp.init(nodeProperties);
        this.driverTablePage.init(nodeProperties);
        this.view.setSqlStatement(this.sp.sqlStatement);
        this.designTimeMaxRows.setText("" + MetaData.getDesignTimeMaxRows());
    }

    void updateTabs() {
        DataTableConnection dataTableConnection = null;
        NodeProperties nodeProperties = this.getNodeProperties();
        try {
            dataTableConnection = nodeProperties.getConnection();
        }
        catch (Exception exception) {
            // empty catch block
        }
        Connection connection = null;
        if (dataTableConnection != null) {
            connection = dataTableConnection.getConnection();
        }
        this.sp.setConnection(connection);
        this.tab.setEnabledAt(this.tab.indexOfComponent(this.btnSp), connection != null);
        this.tab.setEnabledAt(this.tab.indexOfComponent(this.btnDriverTable), connection != null);
        this.btnJoinToParent.setEnabled(connection != null && nodeProperties.getParentNodeProperties() != null);
        if (connection == null) {
            this.tab.setSelectedIndex(0);
        }
    }

    private void setDesignTimeMaxRows() {
        int n2 = 10;
        try {
            n2 = Integer.valueOf(this.designTimeMaxRows.getText());
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (MetaData.getDesignTimeMaxRows() != n2) {
            MetaData.setDesignTimeMaxRows(n2);
            Enumeration enumeration = DataSourceBeanInstance.getInstances().elements();
            while (enumeration.hasMoreElements()) {
                Object e2 = enumeration.nextElement();
                if (!(e2 instanceof TreeData)) continue;
                try {
                    ((TreeData)e2).requeryAll(null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    void refreshView() {
        this.view.setText(this.getNodeProperties().getStatement());
        this.sp.setNodeProperties(this.getNodeProperties());
        this.view.setSqlStatement(this.sp.sqlStatement);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (this.isInitializing()) {
            return;
        }
        if (actionEvent.getSource() instanceof JTextField) {
            this.setDesignTimeMaxRows();
        } else if (actionEvent.getSource() instanceof JButton) {
            JButton jButton = (JButton)actionEvent.getSource();
            if (jButton.equals(this.btnModify)) {
                this.modify();
            } else if (jButton.equals(this.btnRestore)) {
                this.refreshView();
            } else if (jButton.equals(this.btnClear)) {
                this.clear();
                this.refreshView();
            } else if (jButton.equals(this.btnAddTable)) {
                this.sp.showTableChooser();
            } else if (jButton.equals(this.btnAddColumn)) {
                this.sp.addColumn();
                this.modify();
            } else if (jButton.equals(this.btnAddJoin)) {
                this.sp.addJoin();
                this.modify();
            } else if (jButton.equals(this.btnJoinToParent)) {
                this.joinToParent();
                this.modify();
            }
        }
    }

    void clear() {
        try {
            this.getNodeProperties().setStatement("");
            this.getNodeProperties().setDriverTable(null);
            this.getNodeProperties().removeAllJoins();
            this.getNodeProperties().fireJCDataEvent(new JCDataEvent(this.getNodeProperties()));
            this.view.setText(this.getNodeProperties().getStatement());
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void modify() {
        String string = this.view.getText();
        SqlParser sqlParser = new SqlParser(string);
        if (this.getNodeProperties().getJoins().length != sqlParser.getParameterColumns().size()) {
            ErrorDialog.showError(this, LocaleBundle.string("The number of join columns and the number of question mark place holders do not match: "));
            this.joinToParent();
            return;
        }
        try {
            this.getNodeProperties().setExpertMode(this.view.sqlStatement.isExpertMode());
            this.getNodeProperties().setStatement(this.view.getText());
            if (this.getNodeProperties().getDriverTable() == null || this.getNodeProperties().getDriverTable().trim().length() == 0) {
                String string2 = null;
                Enumeration enumeration = this.view.sqlStatement.getTables();
                if (enumeration.hasMoreElements()) {
                    SqlStatementTable sqlStatementTable = (SqlStatementTable)enumeration.nextElement();
                    string2 = sqlStatementTable.getAlias();
                }
                this.getNodeProperties().setDriverTable(string2);
            }
            this.getNodeProperties().fireJCDataEvent(new JCDataEvent(this.getNodeProperties()));
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    void joinToParent() {
        if (this.getNodeProperties().getParentNodeProperties() == null) {
            return;
        }
        String[][] stringArray = this.getNodeProperties().getJoins();
        Vector<String> vector = new Vector<String>();
        int n2 = 0;
        while (n2 < stringArray.length) {
            vector.addElement(stringArray[n2][0] + " = " + stringArray[n2][1]);
            ++n2;
        }
        SqlStatement sqlStatement = new SqlStatement(this.getNodeProperties().getParentNodeProperties().getStatement());
        SqlStatement sqlStatement2 = new SqlStatement(this.view.sqlStatement.getText());
        JoinDialog joinDialog = new JoinDialog(null, vector, sqlStatement, this.getNodeProperties().getParentNodeProperties(), sqlStatement2, this.getNodeProperties(), true, true);
        joinDialog.setTitle(LocaleBundle.string("Join To Parent"));
        joinDialog.lblParent.setText(LocaleBundle.string("Parent"));
        joinDialog.lblChild.setText(LocaleBundle.string("Child"));
        joinDialog.pack();
        joinDialog.show();
        this.view.sqlStatement.removeAllParameterColumns();
        this.getNodeProperties().removeAllJoins();
        if (this.getNodeProperties().isExpertMode()) {
            ErrorDialog.showWarning(this, LocaleBundle.string("Enter Parameter Columns"));
        }
        Enumeration enumeration = joinDialog.getJoinStrings().elements();
        while (enumeration.hasMoreElements()) {
            String string = (String)enumeration.nextElement();
            String string2 = string.substring(0, string.indexOf(" = "));
            String string3 = string.substring(string.indexOf(" = ") + 3);
            this.getNodeProperties().addJoin(string2, string3);
            if (this.getNodeProperties().isExpertMode()) continue;
            this.view.sqlStatement.addParameterColumn(string3);
        }
        this.view.sqlStatement.notifyObservers(this);
    }

    public void update(Observable observable, Object object) {
        this.btnAddTable.setEnabled(!this.view.sqlStatement.isExpertMode());
        this.btnAddColumn.setEnabled(!this.view.sqlStatement.isExpertMode());
        this.btnAddJoin.setEnabled(!this.view.sqlStatement.isExpertMode());
        if (this.getNodeProperties().isExpertMode() != this.view.sqlStatement.isExpertMode()) {
            this.modify();
        }
    }

    class JDBCPageScrollPane
    extends JScrollPane {
        public JDBCPageScrollPane(Component component) {
            super(component);
        }

        public Dimension getMinimumSize() {
            return new Dimension(400, 150);
        }

        public Dimension getPreferredSize() {
            return this.getMinimumSize();
        }
    }
}

