/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource;

import com.klg.jclass.datasource.BaseDataTable;
import com.klg.jclass.datasource.BaseMetaData;
import com.klg.jclass.datasource.DataModel;
import com.klg.jclass.datasource.DataModelAdapter;
import com.klg.jclass.datasource.DataModelEvent;
import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.datasource.DataModelListener;
import com.klg.jclass.datasource.DataTableModel;
import com.klg.jclass.datasource.IdeDataTableModel;
import com.klg.jclass.datasource.IdeMetaDataModel;
import com.klg.jclass.datasource.LocaleBundle;
import com.klg.jclass.datasource.MetaDataModel;
import java.util.Enumeration;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreeNode;

public abstract class IdeMetaData
extends BaseMetaData
implements IdeMetaDataModel {
    static final long serialVersionUID = 7967981952927611609L;
    public static long globalBookmarkBeforeLastMove = -1L;
    public static DataTableModel globalDataTableBeforeLastMove = null;

    public IdeMetaData(DataModel dataModel) {
        super(dataModel);
    }

    public void navigated(int n2) {
        if (!this.getDataModel().getEventsEnabled()) {
            return;
        }
        globalBookmarkBeforeLastMove = this.getDataModel().getCurrentGlobalBookmark();
        globalDataTableBeforeLastMove = this.getDataModel().getCurrentGlobalTable();
        try {
            MetaDataModel metaDataModel = (MetaDataModel)this.getParent();
            DataTableModel dataTableModel = null;
            if (metaDataModel == null) {
                dataTableModel = (DataTableModel)this.getDataModel().getDataTableTree().getRoot();
            } else {
                DataTableModel dataTableModel2 = metaDataModel.getCurrentDataTable();
                if (dataTableModel2 != null) {
                    dataTableModel = dataTableModel2.getTable(metaDataModel.getCurrentBookmark(), this);
                }
            }
            if (dataTableModel == null) {
                return;
            }
            long l2 = dataTableModel.getRowIdentifier(n2);
            this.setCurrentBookmark(l2);
            this.setCurrentDataTable(dataTableModel);
            if (dataTableModel.getMetaData().getDataModel().getCurrentGlobalBookmark() != l2 || this.getCurrentBookmark() != l2) {
                this.getDataModel().moveToRow((DataModelListener)((Object)dataTableModel), dataTableModel, l2, false);
            }
        }
        catch (Exception exception) {
            System.out.println("navigated: " + exception.toString());
        }
    }

    public void requeryCurrentRowAndBelow(DataModelListener dataModelListener, DataTableModel dataTableModel) {
        try {
            if (dataTableModel == null) {
                return;
            }
            long l2 = dataTableModel.getParentBookmark();
            MetaDataModel metaDataModel = (MetaDataModel)dataTableModel.getMetaData().getParent();
            DataTableModel dataTableModel2 = null;
            int n2 = 109;
            if (metaDataModel == null) {
                dataTableModel2 = dataTableModel;
                n2 = 103;
            } else {
                dataTableModel2 = this.getDataModel().getCurrentDataTable(dataModelListener, metaDataModel);
            }
            if (dataTableModel2 != null) {
                if (n2 == 103) {
                    ((IdeDataTableModel)dataTableModel2).requeryFromIdeDataSource();
                    this.getDataModel().clearCurrentPath(this);
                    this.setCurrentBookmark(-1L);
                } else {
                    ((MutableTreeNode)((Object)dataTableModel)).setParent(null);
                    this.getDataModel().clearCurrentPath(metaDataModel);
                    dataTableModel2.deleteCacheChildren(dataModelListener);
                }
            }
            DataModelEvent dataModelEvent = new DataModelEvent(this.getDataModel(), dataModelListener, dataTableModel2, l2, "", n2);
            this.getDataModel().fireDataModelEvent(dataModelEvent);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
        }
    }

    public void handleIDEUpdateCellRequest(IdeDataTableModel ideDataTableModel, long l2) {
        Object object;
        Object object2;
        try {
            String string = null;
            int n2 = 0;
            while (n2 < this.getColumnCount()) {
                object2 = this.getColumnIdentifier(n2);
                object = ideDataTableModel.getCell2(l2, (String)object2);
                Object object3 = ideDataTableModel.getResultData(l2, this.getColumnIdentifier(n2));
                if (object == null && object3 != null || object3 == null && object != null || object3 != null && object != null && !object.equals(object3)) {
                    string = object2;
                    break;
                }
                ++n2;
            }
            if (string == null) {
                string = this.getColumnIdentifier(this.getColumnCount() - 1);
            }
            if (!((BaseDataTable)((Object)ideDataTableModel)).prepareCellUpdate((DataModelListener)((Object)ideDataTableModel), l2, string)) {
                return;
            }
            ((BaseDataTable)((Object)ideDataTableModel)).setRowDirty(l2);
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            return;
        }
        this.turnOffDataModelEvents();
        try {
            int n3 = 0;
            while (n3 < this.getColumnCount()) {
                String string = this.getColumnIdentifier(n3);
                object2 = ideDataTableModel.getCell2(l2, string);
                object = ideDataTableModel.getResultData(l2, this.getColumnIdentifier(n3));
                if (object2 == null && object != null || object == null && object2 != null || object != null && object2 != null && !object2.equals(object)) {
                    ideDataTableModel.setValueAt2(l2, string, object2);
                }
                ++n3;
            }
        }
        catch (Exception exception) {
            System.out.println(exception.toString());
            try {
                DataModelEvent dataModelEvent = new DataModelEvent(this.getDataModel(), (DataModelListener)((Object)ideDataTableModel), ideDataTableModel, l2, "", 100);
                this.getDataModel().fireDataModelEvent(dataModelEvent);
            }
            catch (DataModelException dataModelException) {
                // empty catch block
            }
        }
        this.turnOnDataModelEvents();
        try {
            DataModelEvent dataModelEvent = new DataModelEvent(this.getDataModel(), (DataModelListener)((Object)ideDataTableModel), ideDataTableModel, l2, "", 100);
            this.getDataModel().fireDataModelEvent(dataModelEvent);
        }
        catch (DataModelException dataModelException) {
            // empty catch block
        }
    }

    public void turnOffDataModelEvents() {
        this.getDataModel().enableDataModelEvents(false);
    }

    public void turnOnDataModelEvents() {
        this.getDataModel().enableDataModelEvents(true);
    }

    public void cleanChildDataSets() throws DataModelException {
        Enumeration<TreeNode> enumeration = this.children();
        while (enumeration.hasMoreElements()) {
            this.cleanChildDataSets((IdeMetaData)enumeration.nextElement());
        }
    }

    protected void cleanChildDataSets(IdeMetaData ideMetaData) throws DataModelException {
        ideMetaData.refreshDataSet();
        Enumeration<TreeNode> enumeration = ideMetaData.children();
        while (enumeration.hasMoreElements()) {
            this.cleanChildDataSets((IdeMetaData)enumeration.nextElement());
        }
    }

    public void setCommitPolicy(int n2) throws DataModelException {
        if (n2 != 1) {
            Exception exception = new Exception(LocaleBundle.string("Only COMMIT_LEAVING_RECORD is currently supported in ide environments"));
            throw new DataModelException(107, exception);
        }
        super.setCommitPolicy(n2);
    }

    protected boolean handledAsSingleLevelBindingMove() throws Exception {
        try {
            TreeNode treeNode = (TreeNode)this.getDataModel().getMetaDataTree().getRoot();
            if (treeNode.getChildCount() == 0) {
                this.turnOffDataModelEvents();
                this.getDataModel().requeryAll(new DataModelAdapter());
                this.turnOnDataModelEvents();
                return true;
            }
        }
        catch (Exception exception) {
            this.turnOnDataModelEvents();
        }
        return false;
    }
}

