/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource;

import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.datasource.DataModelListener;
import com.klg.jclass.datasource.DataTableModel;
import com.klg.jclass.datasource.LocaleBundle;
import java.util.EventObject;
import java.util.Vector;

public class DataModelEvent
extends EventObject {
    static final long serialVersionUID = -1946917255406654889L;
    public static final int BEFORE_INSERT_ROW = 1;
    public static final int BEFORE_RESET = 2;
    public static final int BEFORE_REQUERY = 3;
    public static final int BEFORE_EDIT_CELL = 4;
    public static final int BEFORE_DELETE_ROW = 5;
    public static final int BEFORE_COMMIT_ALL = 6;
    public static final int BEFORE_CANCEL_ALL = 7;
    public static final int BEFORE_CANCEL_ROW_CHANGES = 8;
    public static final int BEFORE_COMMIT_CONDITIONAL = 9;
    public static final int BEFORE_COMMIT_ROW = 10;
    public static final int BEFORE_MOVE_TO_CURRENT_ROW = 11;
    public static final int BEFORE_DELETE_TABLE = 12;
    public static final int AFTER_CHANGE_OF_ROW_DATA = 100;
    public static final int AFTER_INSERT_ROW = 101;
    public static final int AFTER_DELETE_ROW = 102;
    public static final int AFTER_RESET = 103;
    public static final int BEGIN_EVENTS = 104;
    public static final int END_EVENTS = 105;
    public static final int AFTER_MOVE_TO_CURRENT_ROW = 106;
    public static final int INITIALIZE = 107;
    public static final int ORIGINATOR_NAVIGATE_ROW = 108;
    public static final int AFTER_REQUERY_ROW_AND_DETAILS = 109;
    public static final int AFTER_REQUERY_TABLE = 110;
    public static final int NOT_APPLICABLE = -2;
    protected int rowIndex;
    protected int command;
    protected long bookmark;
    protected String column;
    protected Vector ancestors = new Vector();
    protected boolean cancelled = false;
    protected DataTableModel table;
    protected DataModelListener originator;

    public DataModelEvent(Object object, DataModelListener dataModelListener, DataTableModel dataTableModel, long l2, String string, int n2) throws DataModelException {
        super(object);
        if (dataModelListener == null) {
            Exception exception = new Exception(LocaleBundle.string("NullOriginator"));
            throw new DataModelException(l2, string, dataTableModel, n2, exception);
        }
        this.table = dataTableModel;
        this.originator = dataModelListener;
        this.column = string;
        this.command = n2;
        this.bookmark = l2;
        this.rowIndex = dataTableModel != null ? dataTableModel.getRowIndex(l2) : -2;
    }

    public DataTableModel getTable() {
        return this.table;
    }

    public int getRowIndex() {
        return this.rowIndex;
    }

    public long getBookmark() {
        return this.bookmark;
    }

    public String getColumn() {
        return this.column == null ? "" : this.column;
    }

    public int getCommand() {
        return this.command;
    }

    public Vector getAncestorBookmarks() {
        if (this.ancestors.size() > 0) {
            return this.ancestors;
        }
        if (this.getTable() != null && this.getTable() instanceof DataTableModel) {
            DataTableModel dataTableModel = this.getTable();
            dataTableModel.getAncestors(this.ancestors);
            this.ancestors.addElement(new Long(this.getBookmark()));
        }
        return this.ancestors;
    }

    public void cancelProposedAction() {
        if (this.isCancelable()) {
            this.cancelled = true;
        }
    }

    public boolean getCancelled() {
        return this.cancelled;
    }

    public boolean isCancelable() {
        return this.getCommand() < 100;
    }

    public DataModelListener getOriginator() {
        return this.originator;
    }
}

