/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource;

import com.klg.jclass.datasource.BaseColumn;
import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.datasource.DataTableModel;
import com.klg.jclass.datasource.VirtualColumnModel;
import java.math.BigDecimal;

public class BaseVirtualColumn
extends BaseColumn
implements VirtualColumnModel {
    static final long serialVersionUID = 2448569635266074965L;
    public static final int MIN = 0;
    public static final int MAX = 1;
    public static final int AVERAGE = 2;
    public static final int SUM = 3;
    public static final int DIFFERENCE = 4;
    public static final int PRODUCT = 5;
    public static final int QUOTIENT = 6;
    protected int operation;
    protected String[] columns;
    protected int scale = 5;
    protected int roundMode = 2;

    public BaseVirtualColumn(String string, int n2, int n3, String[] stringArray) {
        this.setColumnName(string);
        this.setIdentifier(this.getColumnName());
        this.columns = stringArray;
        this.setColumnType(n2);
        this.operation = n3;
        this.setMetaColumnTypeFromSqlType(n2);
    }

    public Object getResultData(DataTableModel dataTableModel, long l2) throws DataModelException {
        BigDecimal bigDecimal = new BigDecimal("0.0");
        switch (this.operation) {
            case 0: {
                bigDecimal = this.getMinimum(dataTableModel, l2);
                break;
            }
            case 1: {
                bigDecimal = this.getMaximum(dataTableModel, l2);
                break;
            }
            case 2: {
                bigDecimal = this.getAverage(dataTableModel, l2);
                break;
            }
            case 3: {
                bigDecimal = this.getSum(dataTableModel, l2);
                break;
            }
            case 4: {
                bigDecimal = this.getDifference(dataTableModel, l2);
                break;
            }
            case 5: {
                bigDecimal = this.getProduct(dataTableModel, l2);
                break;
            }
            case 6: {
                bigDecimal = this.getQuotient(dataTableModel, l2);
            }
        }
        return this.convertToTargetType(bigDecimal);
    }

    private Object convertToTargetType(BigDecimal bigDecimal) {
        switch (this.getMetaColumnType()) {
            case 1002: 
            case 1003: {
                return new Double(bigDecimal.doubleValue());
            }
            case 1006: {
                return bigDecimal;
            }
            case 1004: 
            case 1011: {
                return new Integer(bigDecimal.intValue());
            }
            case 1007: {
                return new Long(bigDecimal.intValue());
            }
            case 1012: {
                return new Short(bigDecimal.shortValue());
            }
        }
        return bigDecimal;
    }

    private BigDecimal getMinimum(DataTableModel dataTableModel, long l2) throws DataModelException {
        BigDecimal bigDecimal = new BigDecimal(Double.MAX_VALUE);
        int n2 = 0;
        while (n2 < this.columns.length) {
            BigDecimal bigDecimal2 = this.getBigDecimalValue(dataTableModel.getResultData(l2, this.columns[n2]));
            bigDecimal = bigDecimal2.min(bigDecimal);
            ++n2;
        }
        return bigDecimal;
    }

    private BigDecimal getMaximum(DataTableModel dataTableModel, long l2) throws DataModelException {
        BigDecimal bigDecimal = new BigDecimal(Double.MIN_VALUE);
        int n2 = 0;
        while (n2 < this.columns.length) {
            BigDecimal bigDecimal2 = this.getBigDecimalValue(dataTableModel.getResultData(l2, this.columns[n2]));
            bigDecimal = bigDecimal2.max(bigDecimal);
            ++n2;
        }
        return bigDecimal;
    }

    private BigDecimal getAverage(DataTableModel dataTableModel, long l2) throws DataModelException {
        return this.getSum(dataTableModel, l2).divide(new BigDecimal((double)this.columns.length), this.scale, this.roundMode);
    }

    private BigDecimal getSum(DataTableModel dataTableModel, long l2) throws DataModelException {
        BigDecimal bigDecimal = new BigDecimal("0.0");
        int n2 = 0;
        while (n2 < this.columns.length) {
            bigDecimal = bigDecimal.add(this.getBigDecimalValue(dataTableModel.getResultData(l2, this.columns[n2])));
            ++n2;
        }
        return bigDecimal;
    }

    private BigDecimal getDifference(DataTableModel dataTableModel, long l2) throws DataModelException {
        BigDecimal bigDecimal = new BigDecimal("0.0");
        boolean bl = true;
        int n2 = 0;
        while (n2 < this.columns.length) {
            if (bl) {
                bigDecimal = this.getBigDecimalValue(dataTableModel.getResultData(l2, this.columns[n2]));
                bl = false;
            } else {
                bigDecimal = bigDecimal.subtract(this.getBigDecimalValue(dataTableModel.getResultData(l2, this.columns[n2])));
            }
            ++n2;
        }
        return bigDecimal;
    }

    private BigDecimal getProduct(DataTableModel dataTableModel, long l2) throws DataModelException {
        BigDecimal bigDecimal = new BigDecimal("0.0");
        boolean bl = true;
        int n2 = 0;
        while (n2 < this.columns.length) {
            if (bl) {
                bigDecimal = this.getBigDecimalValue(dataTableModel.getResultData(l2, this.columns[n2]));
                bl = false;
            } else {
                bigDecimal = bigDecimal.multiply(this.getBigDecimalValue(dataTableModel.getResultData(l2, this.columns[n2])));
            }
            ++n2;
        }
        return bigDecimal;
    }

    private BigDecimal getQuotient(DataTableModel dataTableModel, long l2) throws DataModelException {
        BigDecimal bigDecimal = new BigDecimal("0.0");
        boolean bl = true;
        int n2 = 0;
        while (n2 < this.columns.length) {
            if (bl) {
                bigDecimal = this.getBigDecimalValue(dataTableModel.getResultData(l2, this.columns[n2]));
                bl = false;
            } else {
                bigDecimal = bigDecimal.divide(this.getBigDecimalValue(dataTableModel.getResultData(l2, this.columns[n2])), this.scale, this.roundMode);
            }
            ++n2;
        }
        return bigDecimal;
    }

    private BigDecimal getBigDecimalValue(Object object) {
        if (object == null) {
            return new BigDecimal("0.0");
        }
        return new BigDecimal(object.toString());
    }

    public void setScale(int n2) {
        this.scale = n2;
    }

    public int getScale(int n2) {
        return n2;
    }

    public void setRoundMode(int n2) {
        this.roundMode = n2;
    }

    public int getRoundMode() {
        return this.roundMode;
    }

    public int getOperation() {
        return this.operation;
    }

    public String[] getColumns() {
        return this.columns;
    }

    public boolean isReadOnly() {
        return true;
    }

    public void setReadOnly(boolean bl) {
    }
}

