/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.datasource;

import com.klg.jclass.datasource.BaseDataTable;
import com.klg.jclass.datasource.Binding;
import com.klg.jclass.datasource.BindingModel;
import com.klg.jclass.datasource.ColumnModel;
import com.klg.jclass.datasource.DataModel;
import com.klg.jclass.datasource.DataModelException;
import com.klg.jclass.datasource.DataSourceTreeModel;
import com.klg.jclass.datasource.DataSourceTreeNode;
import com.klg.jclass.datasource.DataTableModel;
import com.klg.jclass.datasource.LocaleBundle;
import com.klg.jclass.datasource.MetaDataModel;
import com.klg.jclass.datasource.ProviderModel;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.swing.tree.TreeNode;

public class BaseMetaData
extends DataSourceTreeNode
implements MetaDataModel {
    static final long serialVersionUID = -5410672693378221172L;
    protected DataModel dataModel;
    protected String description = "";
    protected Hashtable insertPermissions;
    protected Hashtable updatePermissions;
    protected Hashtable deletePermissions;
    protected Hashtable idxToColumnMap;
    protected Vector columns = new Vector();
    protected int commitPolicy = 1;
    protected Class storeClass = null;
    protected int initialHashtableSize = 5;
    protected int metaDataID;
    protected static int counter = 0;
    protected int maxRows = 0;
    protected boolean cacheChildren = false;
    protected boolean showDeletedRows = true;
    protected transient DataTableModel currentDataTable;
    protected long currentBookmark = -1L;
    protected int bufferSize = 5000;
    protected BindingModel binding;
    protected ProviderModel provider;

    public BaseMetaData(DataModel dataModel) {
        this.dataModel = dataModel;
        this.metaDataID = counter++;
        this.insertPermissions = new Hashtable(this.initialHashtableSize);
        this.updatePermissions = new Hashtable(this.initialHashtableSize);
        this.deletePermissions = new Hashtable(this.initialHashtableSize);
        this.idxToColumnMap = new Hashtable(this.initialHashtableSize);
    }

    public void setInsertAllowed(String string, boolean bl) {
        if (this.insertPermissions.containsKey(string)) {
            this.insertPermissions.remove(string);
        }
        this.insertPermissions.put(string, new Boolean(bl));
    }

    public void setUpdateAllowed(String string, boolean bl) {
        if (this.updatePermissions.containsKey(string)) {
            this.updatePermissions.remove(string);
        }
        this.updatePermissions.put(string, new Boolean(bl));
    }

    public void setDeleteAllowed(String string, boolean bl) {
        if (this.deletePermissions.containsKey(string)) {
            this.deletePermissions.remove(string);
        }
        this.deletePermissions.put(string, new Boolean(bl));
    }

    public boolean getInsertAllowed(String string) {
        if (string == null) {
            return true;
        }
        return this.insertPermissions.get(string) != null ? (Boolean)this.insertPermissions.get(string) : true;
    }

    public boolean getUpdateAllowed(String string) {
        if (string == null) {
            return true;
        }
        return this.updatePermissions.get(string) != null ? (Boolean)this.updatePermissions.get(string) : true;
    }

    public boolean getDeleteAllowed(String string) {
        if (string == null) {
            return true;
        }
        return this.deletePermissions.get(string) != null ? (Boolean)this.deletePermissions.get(string) : true;
    }

    public DataModel getDataModel() {
        return this.dataModel;
    }

    public int getMetaID() {
        return this.metaDataID;
    }

    public void setMetaID(int n2) {
        this.metaDataID = n2;
        counter = n2 + 1;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String string) {
        this.description = string;
    }

    public boolean getAutoCommit() throws DataModelException {
        return true;
    }

    public void setAutoCommit(boolean bl) throws DataModelException {
    }

    public void rollbackTransaction() throws DataModelException {
    }

    public void commitTransaction() throws DataModelException {
    }

    public void setCommitPolicy(int n2) throws DataModelException {
        if (!this.getShowDeletedRows() && n2 == 1) {
            Exception exception = new Exception(LocaleBundle.string("setShowDeletedRows cannot be false if commit policy is COMMIT_LEAVING_RECORD"));
            throw new DataModelException(107, exception);
        }
        this.commitPolicy = n2;
    }

    public int getCommitPolicy() {
        return this.commitPolicy;
    }

    public Vector getColumnObjects() {
        return this.columns;
    }

    public int getColumnCount() {
        return this.columns.size();
    }

    public void addColumn(ColumnModel columnModel) throws DataModelException {
        Enumeration enumeration = this.columns.elements();
        while (enumeration.hasMoreElements()) {
            ColumnModel columnModel2 = (ColumnModel)enumeration.nextElement();
            if (columnModel2.getIdentifier() == null || !columnModel2.getIdentifier().equals(columnModel.getIdentifier())) continue;
            String string = LocaleBundle.string("Duplicate columns not allowed. Use aliasing. Column: ") + columnModel2.getIdentifier();
            throw new DataModelException(107, new Exception(string));
        }
        this.columns.addElement(columnModel);
        this.getColumnMap().put(columnModel.getIdentifier(), new Integer(this.columns.size() - 1));
    }

    public String getColumnIdentifier(int n2) throws DataModelException {
        return ((ColumnModel)this.columns.elementAt(n2)).getIdentifier();
    }

    public int getJavaColumnType(String string) throws DataModelException {
        return this.getColumnObject(string).getMetaColumnType();
    }

    public ColumnModel getColumnObject(String string) throws DataModelException {
        return (ColumnModel)this.getColumnObjects().elementAt(this.getColumnIndex(string));
    }

    public int getColumnIndex(String string) throws DataModelException {
        if (!this.getColumnMap().containsKey(string)) {
            Exception exception = new Exception(LocaleBundle.string("Column not found: ") + string);
            throw new DataModelException(107, exception);
        }
        return (Integer)this.idxToColumnMap.get(string);
    }

    public Hashtable getColumnMap() {
        return this.idxToColumnMap;
    }

    public Object getNativeMetaData() {
        return null;
    }

    public boolean isUpdateAllowedOnColumn(String string) throws DataModelException {
        ColumnModel columnModel = this.getColumnObject(string);
        if (columnModel == null || columnModel.getTableName() == null || columnModel.getTableName().equals("")) {
            return true;
        }
        return this.getUpdateAllowed(columnModel.getTableName());
    }

    public void clear() {
        this.idxToColumnMap.clear();
        this.columns.removeAllElements();
        this.setCurrentBookmark(-1L);
    }

    public void setShowDeletedRows(boolean bl) throws DataModelException {
        if (!bl && this.getCommitPolicy() == 1) {
            Exception exception = new Exception(LocaleBundle.string("setShowDeletedRows cannot be false if commit policy is COMMIT_LEAVING_RECORD"));
            throw new DataModelException(107, exception);
        }
        this.showDeletedRows = bl;
    }

    public boolean getShowDeletedRows() {
        return this.showDeletedRows;
    }

    public void setMaxRows(int n2) {
        this.maxRows = n2;
    }

    public int getMaxRows() {
        return this.maxRows;
    }

    public void setCacheChildren(boolean bl) {
        this.cacheChildren = bl;
    }

    public boolean getCacheChildren() {
        return this.cacheChildren;
    }

    public DataTableModel getCurrentDataTable() {
        return this.currentDataTable;
    }

    public long getCurrentBookmark() {
        try {
            DataTableModel dataTableModel;
            if (this.currentBookmark == -1L && (dataTableModel = this.getCurrentDataTable()) != null && dataTableModel.getRowCount() > 0) {
                dataTableModel.first();
                this.setCurrentBookmark(dataTableModel.getCurrentBookmark());
            }
        }
        catch (DataModelException dataModelException) {
            dataModelException.printStackTrace();
        }
        return this.currentBookmark;
    }

    public void setCurrentDataTable(DataTableModel dataTableModel) {
        this.currentDataTable = dataTableModel;
    }

    public void setCurrentBookmark(long l2) {
        this.currentBookmark = l2;
    }

    public byte[] createByteArrayFromBinaryStream(InputStream inputStream) throws DataModelException {
        if (inputStream == null) {
            return null;
        }
        byte[] byArray = new byte[this.getBufferSize()];
        byte[] byArray2 = new byte[this.getBufferSize()];
        int n2 = 0;
        int n3 = 0;
        try {
            if (inputStream.markSupported()) {
                inputStream.reset();
            }
            while ((n3 = inputStream.read(byArray)) > 0) {
                byte[] byArray3 = byArray2;
                byArray2 = new byte[n2 + n3];
                System.arraycopy(byArray3, 0, byArray2, 0, n2);
                System.arraycopy(byArray, 0, byArray2, n2, n3);
                n2 += n3;
            }
        }
        catch (IOException iOException) {
            throw new DataModelException(107, iOException);
        }
        return byArray2;
    }

    public void setBufferSize(int n2) {
        this.bufferSize = n2;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public void setStoreClass(String string) throws DataModelException {
        try {
            this.storeClass = Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new DataModelException(107, classNotFoundException);
        }
    }

    public Class getStoreClass() throws DataModelException {
        if (this.storeClass == null) {
            this.setStoreClass("com.klg.jclass.datasource.Store");
        }
        return this.storeClass;
    }

    public void setBinding(BindingModel bindingModel) {
        this.binding = bindingModel;
    }

    public BindingModel getBinding() {
        if (this.binding == null) {
            this.binding = new Binding(this.dataModel);
            this.binding.setMetaDataModel(this);
        }
        return this.binding;
    }

    public ProviderModel getProvider() {
        return this.provider;
    }

    public void setProviderClassName(String string) throws DataModelException {
        if (string != null && !string.equals("")) {
            ReflectiveOperationException reflectiveOperationException = null;
            try {
                this.provider = (ProviderModel)Class.forName(string).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                reflectiveOperationException = classNotFoundException;
            }
            catch (IllegalAccessException illegalAccessException) {
                reflectiveOperationException = illegalAccessException;
            }
            catch (InstantiationException instantiationException) {
                reflectiveOperationException = instantiationException;
            }
            if (reflectiveOperationException != null) {
                throw new DataModelException(107, reflectiveOperationException);
            }
            if (this.getParent() == null) {
                Object[][] objectArray = this.provider.getData(null, -1L, this);
                DataTableModel dataTableModel = BaseDataTable.createDataTableModelFromProviderData(this, -1L, objectArray);
                ((DataSourceTreeModel)this.dataModel.getDataTableTree()).setRoot((TreeNode)((Object)dataTableModel));
            }
        }
    }
}

