/*
 * Decompiled with CFR 0.152.
 */
package com.klg.jclass.cell.swing;

import com.klg.jclass.cell.JCCellEditor;
import com.klg.jclass.cell.JCCellEditorEvent;
import com.klg.jclass.cell.JCCellEditorListener;
import com.klg.jclass.cell.swing.AbstractEditorToComponent;
import java.awt.AWTEvent;
import java.awt.Color;
import java.awt.Component;
import java.awt.Insets;
import java.util.Enumeration;
import java.util.EventObject;
import java.util.Vector;
import javax.swing.JTable;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;

public class JCCellEditorToJTable
extends AbstractEditorToComponent
implements TableCellEditor {
    protected Vector cellListeners = new Vector();
    protected Vector jcCellListeners = new Vector();
    protected transient ChangeEvent changeEvent = null;
    protected transient EventObject lastEvent = null;

    public JCCellEditorToJTable() {
    }

    public JCCellEditorToJTable(JCCellEditor jCCellEditor) {
        super(jCCellEditor);
    }

    public Component getTableCellEditorComponent(JTable jTable, Object object, boolean bl, int n2, int n3) {
        this.setComponent(jTable);
        this.editor.initialize((AWTEvent)this.lastEvent, this, object);
        return this.editor.getComponent();
    }

    public Object getCellEditorValue() {
        return this.editor.getCellEditorValue();
    }

    public boolean isCellEditable(EventObject eventObject) {
        this.lastEvent = eventObject;
        return true;
    }

    public boolean shouldSelectCell(EventObject eventObject) {
        this.lastEvent = eventObject;
        return true;
    }

    public boolean stopCellEditing() {
        if (this.editor.stopCellEditing()) {
            Enumeration enumeration = this.cellListeners.elements();
            while (enumeration.hasMoreElements()) {
                if (this.changeEvent == null) {
                    this.changeEvent = new ChangeEvent(this);
                }
                CellEditorListener cellEditorListener = (CellEditorListener)enumeration.nextElement();
                cellEditorListener.editingStopped(this.changeEvent);
            }
            return true;
        }
        return false;
    }

    public void cancelCellEditing() {
        this.editor.cancelCellEditing();
        Enumeration enumeration = this.cellListeners.elements();
        while (enumeration.hasMoreElements()) {
            if (this.changeEvent == null) {
                this.changeEvent = new ChangeEvent(this);
            }
            CellEditorListener cellEditorListener = (CellEditorListener)enumeration.nextElement();
            cellEditorListener.editingStopped(this.changeEvent);
        }
    }

    public void addCellEditorListener(CellEditorListener cellEditorListener) {
        JCCellEditorToCellEditorListener jCCellEditorToCellEditorListener = new JCCellEditorToCellEditorListener(cellEditorListener);
        this.cellListeners.add(cellEditorListener);
        this.jcCellListeners.add(jCCellEditorToCellEditorListener);
        this.editor.addCellEditorListener(jCCellEditorToCellEditorListener);
    }

    public void removeCellEditorListener(CellEditorListener cellEditorListener) {
        for (int i2 = 0; i2 < this.cellListeners.size(); ++i2) {
            if (cellEditorListener != this.cellListeners.elementAt(i2)) continue;
            this.cellListeners.remove(i2);
            JCCellEditorListener jCCellEditorListener = (JCCellEditorListener)this.jcCellListeners.remove(i2);
            this.editor.removeCellEditorListener(jCCellEditorListener);
            --i2;
        }
    }

    public Color getSelectedBackground() {
        return ((JTable)this.component).getSelectionBackground();
    }

    public Color getSelectedForeground() {
        return ((JTable)this.component).getSelectionForeground();
    }

    public Insets getMarginInsets() {
        return this.component.getInsets();
    }

    public Insets getBorderInsets() {
        return this.component.getInsets();
    }

    public class JCCellEditorToCellEditorListener
    implements JCCellEditorListener {
        protected CellEditorListener cellListener;

        public JCCellEditorToCellEditorListener(CellEditorListener cellEditorListener) {
            this.cellListener = cellEditorListener;
        }

        public void editingStopped(JCCellEditorEvent jCCellEditorEvent) {
            this.cellListener.editingStopped(new ChangeEvent(jCCellEditorEvent.getSource()));
        }

        public void editingCanceled(JCCellEditorEvent jCCellEditorEvent) {
            this.cellListener.editingCanceled(new ChangeEvent(jCCellEditorEvent.getSource()));
        }
    }
}

