/*
 * Decompiled with CFR 0.152.
 */
package com.google.googlejavaformat.java.filer;

import com.google.common.base.Preconditions;
import com.google.common.io.CharSink;
import com.google.common.io.CharSource;
import com.google.googlejavaformat.java.Formatter;
import com.google.googlejavaformat.java.FormatterException;
import java.io.IOException;
import java.io.Writer;
import javax.annotation.processing.Messager;
import javax.tools.Diagnostic;
import javax.tools.ForwardingJavaFileObject;
import javax.tools.JavaFileObject;
import org.checkerframework.checker.nullness.qual.Nullable;

final class FormattingJavaFileObject
extends ForwardingJavaFileObject<JavaFileObject> {
    private static final int DEFAULT_FILE_SIZE = 40000;
    private final Formatter formatter;
    private final Messager messager;

    FormattingJavaFileObject(JavaFileObject delegate, Formatter formatter, @Nullable Messager messager) {
        super(Preconditions.checkNotNull(delegate));
        this.formatter = Preconditions.checkNotNull(formatter);
        this.messager = messager;
    }

    @Override
    public Writer openWriter() throws IOException {
        final StringBuilder stringBuilder = new StringBuilder(40000);
        return new Writer(){

            @Override
            public void write(char[] chars, int start, int end) throws IOException {
                stringBuilder.append(chars, start, end - start);
            }

            @Override
            public void write(String string) throws IOException {
                stringBuilder.append(string);
            }

            @Override
            public void flush() throws IOException {
            }

            @Override
            public void close() throws IOException {
                block9: {
                    try {
                        FormattingJavaFileObject.this.formatter.formatSource(CharSource.wrap(stringBuilder), new CharSink(){

                            @Override
                            public Writer openStream() throws IOException {
                                return ((JavaFileObject)FormattingJavaFileObject.this.fileObject).openWriter();
                            }
                        });
                    }
                    catch (FormatterException e2) {
                        try (Writer writer = ((JavaFileObject)FormattingJavaFileObject.this.fileObject).openWriter();){
                            writer.append(stringBuilder.toString());
                        }
                        if (FormattingJavaFileObject.this.messager == null) break block9;
                        FormattingJavaFileObject.this.messager.printMessage(Diagnostic.Kind.NOTE, "Error formatting " + FormattingJavaFileObject.this.getName());
                    }
                }
            }
        };
    }
}

